/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineLayout;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextLayoutCache
implements PrioritizedDocumentListener,
Disposable {
    private final EditorView myView;
    private final Document myDocument;
    private final ArrayList<LineLayout> myLines = new ArrayList();
    private int myDocumentChangeOldEndLine;

    TextLayoutCache(EditorView view) {
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        this.myDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
    }

    @Override
    public int getPriority() {
        return 70;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangeOldEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getOldLength());
    }

    public void documentChanged(DocumentEvent event) {
        int startLine = this.myDocument.getLineNumber(event.getOffset());
        int newEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getNewLength());
        this.invalidateLines(startLine, this.myDocumentChangeOldEndLine, newEndLine);
    }

    public void dispose() {
    }

    private int getAdjustedLineNumber(int offset) {
        return this.myDocument.getTextLength() == 0 ? -1 : this.myDocument.getLineNumber(offset);
    }

    void resetToDocumentSize() {
        this.invalidateLines(0, this.myLines.size() - 1, this.myDocument.getLineCount() - 1);
    }

    void invalidateLines(int startLine, int oldEndLine, int newEndLine) {
        int endLine = Math.min(oldEndLine, newEndLine);
        for (int line = startLine; line <= endLine; ++line) {
            this.myLines.set(line, null);
        }
        if (oldEndLine < newEndLine) {
            this.myLines.addAll(oldEndLine + 1, Collections.nCopies(newEndLine - oldEndLine, null));
        } else if (oldEndLine > newEndLine) {
            this.myLines.subList(newEndLine + 1, oldEndLine + 1).clear();
        }
    }

    @NotNull
    LineLayout getLineLayout(int line) {
        LineLayout result = this.getCachedLineLayout(line);
        if (result == null) {
            int lineStart = this.myDocument.getLineStartOffset(line);
            int lineEnd = this.myDocument.getLineEndOffset(line);
            result = new LineLayout(this.myView, lineStart, lineEnd, this.myView.getFontRenderContext());
            this.myLines.set(line, result);
        }
        LineLayout lineLayout = result;
        if (lineLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextLayoutCache", "getLineLayout"));
        }
        return lineLayout;
    }

    @Nullable
    LineLayout getCachedLineLayout(int line) {
        return this.myLines.get(line);
    }
}

