/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483645)
public abstract class AbstractDependencyDataService<E extends AbstractDependencyData<?>, I extends ExportableOrderEntry>
extends AbstractProjectDataService<E, I> {
    @NotNull
    public Computable<Collection<I>> computeOrphanData(final @NotNull Collection<DataNode<E>> toImport, final @NotNull ProjectData projectData, final @NotNull Project project, final @NotNull PlatformFacade platformFacade) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "computeOrphanData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "computeOrphanData"));
        }
        Computable computable = new Computable<Collection<I>>(){

            public Collection<I> compute() {
                MultiMap byModuleName = MultiMap.create();
                for (DataNode node : toImport) {
                    AbstractDependencyData data2 = (AbstractDependencyData)node.getData();
                    byModuleName.putValue((Object)data2.getOwnerModule().getInternalName(), (Object)data2.getInternalName());
                }
                List orphanEntries = ContainerUtil.newSmartList();
                for (Module module : platformFacade.getModules(project, projectData)) {
                    for (OrderEntry entry : platformFacade.getOrderEntries(module)) {
                        if (!AbstractDependencyDataService.this.getOrderEntryType().isInstance(entry) || byModuleName.get((Object)entry.getOwnerModule().getName()).contains(AbstractDependencyDataService.this.getOrderEntryName((ExportableOrderEntry)entry))) continue;
                        orphanEntries.add((ExportableOrderEntry)entry);
                    }
                }
                return orphanEntries;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "computeOrphanData"));
        }
        return computable;
    }

    @NotNull
    public abstract Class<I> getOrderEntryType();

    protected String getOrderEntryName(@NotNull I orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "getOrderEntryName"));
        }
        return orderEntry.getPresentableName();
    }

    public void removeData(@NotNull Computable<Collection<I>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toRemoveComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveComputable", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "removeData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "removeData"));
        }
        ArrayList models = ContainerUtilRt.newArrayList();
        try {
            Map<Module, Collection<ExportableOrderEntry>> byModule = AbstractDependencyDataService.groupByModule((Collection)toRemoveComputable.compute());
            for (Map.Entry<Module, Collection<ExportableOrderEntry>> entry : byModule.entrySet()) {
                Module module = entry.getKey();
                Collection<ExportableOrderEntry> depsToRemove = entry.getValue();
                ModifiableRootModel model = platformFacade.getModuleModifiableModel(module);
                this.removeData(depsToRemove, model);
                models.add(model);
            }
            ExternalSystemApiUtil.commitModels((boolean)synchronous, (Project)project, (List)models);
        }
        catch (Throwable t) {
            ExternalSystemApiUtil.disposeModels((Collection)models);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    @NotNull
    private static Map<Module, Collection<ExportableOrderEntry>> groupByModule(@NotNull Collection<? extends ExportableOrderEntry> data2) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "groupByModule"));
        }
        HashMap result = ContainerUtilRt.newHashMap();
        for (ExportableOrderEntry exportableOrderEntry : data2) {
            Collection entries = (Collection)result.get(exportableOrderEntry.getOwnerModule());
            if (entries == null) {
                entries = ContainerUtilRt.newArrayList();
                result.put(exportableOrderEntry.getOwnerModule(), entries);
            }
            entries.add(exportableOrderEntry);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "groupByModule"));
        }
        return hashMap;
    }

    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove, @NotNull ModifiableRootModel moduleRootModel) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "removeData"));
        }
        if (moduleRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootModel", "com/intellij/openapi/externalSystem/service/project/manage/AbstractDependencyDataService", "removeData"));
        }
        block0: for (ExportableOrderEntry exportableOrderEntry : toRemove) {
            for (OrderEntry entry : moduleRootModel.getOrderEntries()) {
                if (entry instanceof ExportableOrderEntry) {
                    ExportableOrderEntry orderEntry = (ExportableOrderEntry)entry;
                    if (!orderEntry.getPresentableName().equals(exportableOrderEntry.getPresentableName()) || !orderEntry.getScope().equals((Object)exportableOrderEntry.getScope())) continue;
                    moduleRootModel.removeOrderEntry(entry);
                    continue block0;
                }
                if (!entry.getPresentableName().equals(exportableOrderEntry.getPresentableName())) continue;
                moduleRootModel.removeOrderEntry(entry);
                continue block0;
            }
        }
    }
}

