/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483646)
public class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance((String)("#" + LibraryDataService.class.getName()));
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = new NotNullFunction<String, File>(){

        @NotNull
        public File fun(String path) {
            File file = new File(path);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "fun"));
            }
            return file;
        }
    };
    @NotNull
    private final ExternalLibraryPathTypeMapper myLibraryPathTypeMapper;

    public LibraryDataService(@NotNull ExternalLibraryPathTypeMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "<init>"));
        }
        this.myLibraryPathTypeMapper = mapper;
    }

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        for (DataNode<LibraryData> dataNode : toImport) {
            this.importLibrary((LibraryData)dataNode.getData(), project, platformFacade, synchronous);
        }
    }

    private void importLibrary(@NotNull LibraryData toImport, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        Map<OrderRootType, Collection<File>> libraryFiles = this.prepareLibraryFiles(toImport);
        Library library = platformFacade.findIdeLibrary(toImport, project);
        if (library != null) {
            this.syncPaths(toImport, library, platformFacade);
            return;
        }
        this.importLibrary(toImport.getInternalName(), libraryFiles, project, platformFacade);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data2) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "prepareLibraryFiles"));
        }
        HashMap result = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set paths = data2.getPaths(pathType);
            if (paths.isEmpty()) continue;
            result.put(this.myLibraryPathTypeMapper.map(pathType), ContainerUtil.map((Collection)paths, PATH_TO_FILE));
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "prepareLibraryFiles"));
        }
        return hashMap;
    }

    private void importLibrary(final @NotNull String libraryName, final @NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Project project, @NotNull PlatformFacade platformFacade) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        final Library[] intellijLibrary = new Library[1];
        platformFacade.updateLibraryTable(project, (Consumer)new Consumer<LibraryTable.ModifiableModel>(){

            public void consume(LibraryTable.ModifiableModel model) {
                intellijLibrary[0] = model.createLibrary(libraryName);
            }
        });
        platformFacade.updateLibrary(intellijLibrary[0], (Consumer)new Consumer<Library.ModifiableModel>(){

            public void consume(Library.ModifiableModel libraryModel) {
                LibraryDataService.this.registerPaths(libraryFiles, libraryModel, libraryName);
            }
        });
    }

    public void registerPaths(@NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Library.ModifiableModel model, @NotNull String libraryName) {
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file : entry.getValue()) {
                VirtualFile virtualFile = ExternalSystemUtil.refreshAndFindFileByIoFile(file);
                if (virtualFile == null) {
                    String[] urls;
                    String url;
                    if (ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(url = VfsUtil.getUrlForLibraryRoot((File)file)), (String[])(urls = model.getUrls(entry.getKey())))) continue;
                    model.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    Object[] files = model.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])files)) continue;
                    model.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                VirtualFile root = virtualFile;
                if (virtualFile.getFileType() instanceof ArchiveFileType && (root = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile)) == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file.getAbsolutePath(), libraryName));
                    continue;
                }
                Object[] files = model.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)root, (Object[])files)) continue;
                model.addRoot(root, entry.getKey());
            }
        }
    }

    public void removeData(@NotNull Computable<Collection<Library>> toRemoveComputable, @NotNull Collection<DataNode<LibraryData>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toRemoveComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemoveComputable", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        final Collection toRemove = (Collection)toRemoveComputable.compute();
        if (toRemove.isEmpty()) {
            return;
        }
        platformFacade.updateLibraryTable(project, (Consumer)new Consumer<LibraryTable.ModifiableModel>(){

            public void consume(LibraryTable.ModifiableModel model) {
                for (Library library : toRemove) {
                    Library libraryToRemove;
                    String libraryName = library.getName();
                    if (libraryName == null || (libraryToRemove = model.getLibraryByName(libraryName)) == null) continue;
                    model.removeLibrary(libraryToRemove);
                }
            }
        });
    }

    private void syncPaths(final @NotNull LibraryData externalLibrary, @NotNull Library ideLibrary, @NotNull PlatformFacade platformFacade) {
        if (externalLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalLibrary", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (ideLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideLibrary", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (externalLibrary.isUnresolved()) {
            return;
        }
        final HashMap toRemove = ContainerUtilRt.newHashMap();
        final HashMap toAdd = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            OrderRootType ideType = this.myLibraryPathTypeMapper.map(pathType);
            HashSet toAddPerType = ContainerUtilRt.newHashSet((Iterable)externalLibrary.getPaths(pathType));
            toAdd.put(ideType, toAddPerType);
            HashSet toRemovePerType = ContainerUtilRt.newHashSet();
            toRemove.put(ideType, toRemovePerType);
            for (VirtualFile ideFile : ideLibrary.getFiles(ideType)) {
                String idePath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)ideFile);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(ideFile.getUrl());
            }
        }
        if (toRemove.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        platformFacade.updateLibrary(ideLibrary, (Consumer)new Consumer<Library.ModifiableModel>(){

            public void consume(Library.ModifiableModel model) {
                for (Map.Entry entry : toRemove.entrySet()) {
                    for (String path : (Set)entry.getValue()) {
                        model.removeRoot(path, (OrderRootType)entry.getKey());
                    }
                }
                for (Map.Entry entry : toAdd.entrySet()) {
                    HashMap roots = ContainerUtilRt.newHashMap();
                    roots.put(entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), PATH_TO_FILE));
                    LibraryDataService.this.registerPaths(roots, model, externalLibrary.getInternalName());
                }
            }
        });
    }
}

