/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483645)
public class LibraryDependencyDataService
extends AbstractDependencyDataService<LibraryDependencyData, LibraryOrderEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + LibraryDependencyDataService.class.getName()));
    @NotNull
    private final LibraryDataService myLibraryManager;

    public LibraryDependencyDataService(@NotNull LibraryDataService libraryManager) {
        if (libraryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryManager", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "<init>"));
        }
        this.myLibraryManager = libraryManager;
    }

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryDependencyData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        MyImporter importer = new MyImporter(platformFacade);
        try {
            MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.MODULE);
            for (Map.Entry entry : byModule.entrySet()) {
                Module module = platformFacade.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData(), project);
                Collection libraryDependency = (Collection)entry.getValue();
                if (module == null) {
                    LOG.warn(String.format("Can't import library dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", libraryDependency, entry.getKey()));
                    continue;
                }
                importer.importData(module, libraryDependency);
            }
            ExternalSystemApiUtil.commitChangedModels((boolean)synchronous, (Project)project, importer.getLibraryModels());
            ExternalSystemApiUtil.commitModels((boolean)synchronous, (Project)project, importer.getModels());
        }
        catch (Throwable t) {
            ExternalSystemApiUtil.disposeModels(importer.getModels());
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    @Override
    @NotNull
    public Class<LibraryOrderEntry> getOrderEntryType() {
        if (LibraryOrderEntry.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "getOrderEntryType"));
        }
        return LibraryOrderEntry.class;
    }

    @Override
    protected String getOrderEntryName(@NotNull LibraryOrderEntry orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "getOrderEntryName"));
        }
        return orderEntry.getLibraryName();
    }

    private class MyImporter {
        private final PlatformFacade myPlatformFacade;
        private final List<ModifiableRootModel> myModels = ContainerUtilRt.newArrayList();
        private final List<Library.ModifiableModel> myLibraryModels = ContainerUtilRt.newArrayList();

        private MyImporter(PlatformFacade platformFacade) {
            this.myPlatformFacade = platformFacade;
        }

        public List<ModifiableRootModel> getModels() {
            return ContainerUtil.newUnmodifiableList(this.myModels);
        }

        public List<Library.ModifiableModel> getLibraryModels() {
            return ContainerUtil.newUnmodifiableList(this.myLibraryModels);
        }

        public void importData(@NotNull Module module, @NotNull Collection<DataNode<LibraryDependencyData>> nodesToImport) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "importData"));
            }
            if (nodesToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodesToImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "importData"));
            }
            HashMap moduleLibrariesToImport = ContainerUtilRt.newHashMap();
            HashMap projectLibrariesToImport = ContainerUtilRt.newHashMap();
            LinkedHashSet toImport = ContainerUtilRt.newLinkedHashSet();
            boolean hasUnresolved = false;
            for (DataNode<LibraryDependencyData> dependencyNode : nodesToImport) {
                LibraryDependencyData dependencyData = (LibraryDependencyData)dependencyNode.getData();
                LibraryData libraryData = (LibraryData)dependencyData.getTarget();
                hasUnresolved |= libraryData.isUnresolved();
                switch (dependencyData.getLevel()) {
                    case MODULE: {
                        if (libraryData.isUnresolved()) break;
                        HashSet paths = ContainerUtilRt.newHashSet();
                        for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
                            paths.add(ExternalSystemApiUtil.toCanonicalPath((String)path) + dependencyData.getScope().name());
                        }
                        moduleLibrariesToImport.put(paths, dependencyData);
                        toImport.add(dependencyData);
                        break;
                    }
                    case PROJECT: {
                        projectLibrariesToImport.put(libraryData.getInternalName() + dependencyData.getScope().name(), dependencyData);
                        toImport.add(dependencyData);
                    }
                }
            }
            ModifiableRootModel moduleRootModel = this.myPlatformFacade.getModuleModifiableModel(module);
            LibraryTable moduleLibraryTable = moduleRootModel.getModuleLibraryTable();
            LibraryTable libraryTable = this.myPlatformFacade.getProjectLibraryTable(module.getProject());
            this.syncExistingAndRemoveObsolete(moduleLibrariesToImport, projectLibrariesToImport, toImport, moduleRootModel, hasUnresolved);
            if (!toImport.isEmpty()) {
                this.importMissing(toImport, moduleRootModel, moduleLibraryTable, libraryTable, module);
            }
            this.myModels.add(moduleRootModel);
        }

        private void importMissing(@NotNull Set<LibraryDependencyData> toImport, @NotNull ModifiableRootModel moduleRootModel, @NotNull LibraryTable moduleLibraryTable, @NotNull LibraryTable libraryTable, @NotNull Module module) {
            if (toImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "importMissing"));
            }
            if (moduleRootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootModel", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "importMissing"));
            }
            if (moduleLibraryTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleLibraryTable", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "importMissing"));
            }
            if (libraryTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTable", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "importMissing"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "importMissing"));
            }
            for (LibraryDependencyData dependencyData : toImport) {
                LibraryData libraryData = (LibraryData)dependencyData.getTarget();
                String libraryName = libraryData.getInternalName();
                switch (dependencyData.getLevel()) {
                    case MODULE: {
                        Library moduleLib = moduleLibraryTable.createLibrary(libraryName);
                        this.syncExistingLibraryDependency(dependencyData, moduleLib, moduleRootModel, module);
                        break;
                    }
                    case PROJECT: {
                        Library projectLib = libraryTable.getLibraryByName(libraryName);
                        if (projectLib == null) {
                            this.syncExistingLibraryDependency(dependencyData, moduleLibraryTable.createLibrary(libraryName), moduleRootModel, module);
                            break;
                        }
                        LibraryOrderEntry orderEntry = moduleRootModel.addLibraryEntry(projectLib);
                        this.setLibraryScope(orderEntry, projectLib, module, dependencyData);
                    }
                }
            }
        }

        private void setLibraryScope(@NotNull LibraryOrderEntry orderEntry, @NotNull Library lib, @NotNull Module module, @NotNull LibraryDependencyData dependencyData) {
            if (orderEntry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "setLibraryScope"));
            }
            if (lib == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lib", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "setLibraryScope"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "setLibraryScope"));
            }
            if (dependencyData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyData", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "setLibraryScope"));
            }
            LOG.debug(String.format("Adding library dependency '%s' to module '%s'", lib.getName(), module.getName()));
            orderEntry.setExported(dependencyData.isExported());
            orderEntry.setScope(dependencyData.getScope());
            LOG.debug(String.format("Configuring library dependency '%s' of module '%s' to be%s exported and have scope %s", lib.getName(), module.getName(), dependencyData.isExported() ? " not" : "", dependencyData.getScope()));
        }

        private void syncExistingAndRemoveObsolete(@NotNull Map<Set<String>, LibraryDependencyData> moduleLibrariesToImport, @NotNull Map<String, LibraryDependencyData> projectLibrariesToImport, @NotNull Set<LibraryDependencyData> toImport, @NotNull ModifiableRootModel moduleRootModel, boolean hasUnresolvedLibraries) {
            if (moduleLibrariesToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleLibrariesToImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingAndRemoveObsolete"));
            }
            if (projectLibrariesToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLibrariesToImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingAndRemoveObsolete"));
            }
            if (toImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingAndRemoveObsolete"));
            }
            if (moduleRootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootModel", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingAndRemoveObsolete"));
            }
            HashSet moduleLibraryKey = ContainerUtilRt.newHashSet();
            for (OrderEntry entry : moduleRootModel.getOrderEntries()) {
                LibraryDependencyData existing;
                if (entry instanceof ModuleLibraryOrderEntryImpl) {
                    ModuleLibraryOrderEntryImpl moduleLibraryOrderEntry = (ModuleLibraryOrderEntryImpl)entry;
                    Library library = moduleLibraryOrderEntry.getLibrary();
                    if (library == null) {
                        LOG.warn("Skipping module-level library entry because it doesn't have backing Library object. Entry: " + entry);
                        continue;
                    }
                    moduleLibraryKey.clear();
                    for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                        moduleLibraryKey.add(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file) + moduleLibraryOrderEntry.getScope().name());
                    }
                    existing = moduleLibrariesToImport.remove(moduleLibraryKey);
                    if (existing == null) {
                        moduleRootModel.removeOrderEntry(entry);
                        continue;
                    }
                    this.syncExistingLibraryDependency(existing, library, moduleRootModel, moduleLibraryOrderEntry.getOwnerModule());
                    toImport.remove(existing);
                    continue;
                }
                if (!(entry instanceof LibraryOrderEntry)) continue;
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                String libraryName = libraryOrderEntry.getLibraryName();
                existing = projectLibrariesToImport.remove(libraryName + libraryOrderEntry.getScope().name());
                if (existing != null) {
                    toImport.remove(existing);
                    continue;
                }
                if (hasUnresolvedLibraries) continue;
                moduleRootModel.removeOrderEntry(entry);
            }
        }

        private void syncExistingLibraryDependency(@NotNull LibraryDependencyData libraryDependencyData, @NotNull Library library, @NotNull ModifiableRootModel moduleRootModel, @NotNull Module module) {
            if (libraryDependencyData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDependencyData", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingLibraryDependency"));
            }
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingLibraryDependency"));
            }
            if (moduleRootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootModel", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingLibraryDependency"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService$MyImporter", "syncExistingLibraryDependency"));
            }
            Library.ModifiableModel libModel = library.getModifiableModel();
            String libraryName = libraryDependencyData.getInternalName();
            Map<OrderRootType, Collection<File>> files = LibraryDependencyDataService.this.myLibraryManager.prepareLibraryFiles((LibraryData)libraryDependencyData.getTarget());
            LibraryDependencyDataService.this.myLibraryManager.registerPaths(files, libModel, libraryName);
            LibraryOrderEntry orderEntry = moduleRootModel.findLibraryOrderEntry(library);
            assert (orderEntry != null);
            this.setLibraryScope(orderEntry, library, module, libraryDependencyData);
            this.myLibraryModels.add(libModel);
        }
    }
}

