/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483645)
public class ModuleDependencyDataService
extends AbstractDependencyDataService<ModuleDependencyData, ModuleOrderEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ModuleDependencyDataService.class.getName()));

    @NotNull
    public Key<ModuleDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ModuleDependencyData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        ArrayList models = ContainerUtilRt.newArrayList();
        try {
            MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.MODULE);
            for (Map.Entry entry : byModule.entrySet()) {
                Module ideModule = platformFacade.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData(), project);
                if (ideModule == null) {
                    LOG.warn(String.format("Can't import module dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry.getValue(), entry.getKey()));
                    continue;
                }
                models.add(this.importData((Collection)entry.getValue(), ideModule, platformFacade));
            }
            ExternalSystemApiUtil.commitModels((boolean)synchronous, (Project)project, (List)models);
        }
        catch (Throwable t) {
            ExternalSystemApiUtil.disposeModels((Collection)models);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    @Override
    @NotNull
    public Class<ModuleOrderEntry> getOrderEntryType() {
        if (ModuleOrderEntry.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getOrderEntryType"));
        }
        return ModuleOrderEntry.class;
    }

    @Override
    protected String getOrderEntryName(@NotNull ModuleOrderEntry orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getOrderEntryName"));
        }
        return orderEntry.getModuleName();
    }

    @NotNull
    private ModifiableRootModel importData(@NotNull Collection<DataNode<ModuleDependencyData>> toImport, @NotNull Module module, @NotNull PlatformFacade platformFacade) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        HashMap toRemove = ContainerUtilRt.newHashMap();
        for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry e = (ModuleOrderEntry)entry;
            toRemove.put(Pair.create((Object)e.getModuleName(), (Object)e.getScope()), e);
        }
        ModifiableRootModel moduleRootModel = platformFacade.getModuleModifiableModel(module);
        for (DataNode<ModuleDependencyData> dependencyNode : toImport) {
            ModuleOrderEntry orderEntry;
            ModuleDependencyData dependencyData = (ModuleDependencyData)dependencyNode.getData();
            toRemove.remove(Pair.create((Object)dependencyData.getInternalName(), (Object)dependencyData.getScope()));
            String moduleName = dependencyData.getInternalName();
            Module ideDependencyModule = platformFacade.findIdeModule(moduleName, module.getProject());
            if (module.equals(ideDependencyModule)) continue;
            if (ideDependencyModule == null) {
                LOG.warn(String.format("Can't import module dependency for '%s' module. Reason: target module (%s) is not found at the ide", module.getName(), dependencyData));
            }
            if ((orderEntry = platformFacade.findIdeModuleDependency(dependencyData, moduleRootModel)) == null) {
                orderEntry = ideDependencyModule == null ? moduleRootModel.addInvalidModuleEntry(moduleName) : moduleRootModel.addModuleOrderEntry(ideDependencyModule);
            }
            orderEntry.setScope(dependencyData.getScope());
            orderEntry.setExported(dependencyData.isExported());
        }
        if (!toRemove.isEmpty()) {
            this.removeData(toRemove.values(), moduleRootModel);
        }
        ModifiableRootModel modifiableRootModel = moduleRootModel;
        if (modifiableRootModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        return modifiableRootModel;
    }
}

