/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ProjectModelModificationService;
import com.intellij.openapi.roots.ProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class ProjectModelModificationServiceImpl
extends ProjectModelModificationService {
    private final Project myProject;

    public ProjectModelModificationServiceImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        for (ProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise = modifier.addModuleDependency(from, to, scope);
            if (promise == null) continue;
            return promise;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Collection<Module> from, @NotNull ExternalLibraryDescriptor libraryDescriptor, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        if (libraryDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescriptor", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        for (ProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise = modifier.addExternalLibraryDependency(from, libraryDescriptor, scope);
            if (promise == null) continue;
            return promise;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "addDependency"));
        }
        for (ProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise = modifier.addLibraryDependency(from, library, scope);
            if (promise == null) continue;
            return promise;
        }
        return Promise.REJECTED;
    }

    @NotNull
    private ProjectModelModifier[] getModelModifiers() {
        ProjectModelModifier[] projectModelModifierArray = (ProjectModelModifier[])ProjectModelModifier.EP_NAME.getExtensions((AreaInstance)this.myProject);
        if (projectModelModifierArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectModelModificationServiceImpl", "getModelModifiers"));
        }
        return projectModelModifierArray;
    }
}

