/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFilePath
implements FilePath {
    private static final TObjectHashingStrategy<String> CASE_SENSITIVE_STRATEGY = FilePathHashingStrategy.create((boolean)true);
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public RemoteFilePath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/RemoteFilePath", "<init>"));
        }
        this.myPath = path;
        this.myIsDirectory = isDirectory;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        return null;
    }

    @NotNull
    public File getIOFile() {
        File file = new File(this.myPath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/RemoteFilePath", "getIOFile"));
        }
        return file;
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.myPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/RemoteFilePath", "getName"));
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/RemoteFilePath", "getPresentableUrl"));
        }
        return string;
    }

    @Nullable
    public Document getDocument() {
        return null;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/RemoteFilePath", "getCharset"));
        }
        return charset;
    }

    @NotNull
    public Charset getCharset(@Nullable Project project) {
        EncodingManager em = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        Charset charset = em.getDefaultCharset();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/RemoteFilePath", "getCharset"));
        }
        return charset;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/RemoteFilePath", "getFileType"));
        }
        return fileType;
    }

    public void refresh() {
    }

    public void hardRefresh() {
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/RemoteFilePath", "getPath"));
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vcs/RemoteFilePath", "isUnder"));
        }
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new RemoteFilePath(parent, true);
    }

    public boolean isNonLocal() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteFilePath other = (RemoteFilePath)o;
        if (this.myIsDirectory != other.myIsDirectory) {
            return false;
        }
        return CASE_SENSITIVE_STRATEGY.equals((Object)this.myPath, (Object)other.myPath);
    }

    public int hashCode() {
        int result = CASE_SENSITIVE_STRATEGY.computeHashCode((Object)this.myPath);
        result = 31 * result + (this.myIsDirectory ? 1 : 0);
        return result;
    }
}

