/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangelistMoveOfferDialog;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.ConfirmationDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitHelper {
    public static final Key<Object> DOCUMENT_BEING_COMMITTED_KEY = new Key("DOCUMENT_BEING_COMMITTED");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ui.CommitHelper");
    private final Project myProject;
    private final ChangeList myChangeList;
    private final List<Change> myIncludedChanges;
    private final String myActionName;
    private final String myCommitMessage;
    private final List<CheckinHandler> myHandlers;
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    private final boolean myForceSyncCommit;
    private final NullableFunction<Object, Object> myAdditionalData;
    @Nullable
    private final CommitResultHandler myCustomResultHandler;
    private final List<Document> myCommittingDocuments = new ArrayList<Document>();
    private final VcsConfiguration myConfiguration;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final HashSet<String> myFeedback;

    public CommitHelper(Project project, ChangeList changeList, List<Change> includedChanges, String actionName, String commitMessage, List<CheckinHandler> handlers, boolean allOfDefaultChangeListChangesIncluded, boolean synchronously, NullableFunction<Object, Object> additionalDataHolder, @Nullable CommitResultHandler customResultHandler) {
        this.myProject = project;
        this.myChangeList = changeList;
        this.myIncludedChanges = includedChanges;
        this.myActionName = actionName;
        this.myCommitMessage = commitMessage;
        this.myHandlers = handlers;
        this.myAllOfDefaultChangeListChangesIncluded = allOfDefaultChangeListChangesIncluded;
        this.myForceSyncCommit = synchronously;
        this.myAdditionalData = additionalDataHolder;
        this.myCustomResultHandler = customResultHandler;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myFeedback = new HashSet();
    }

    public boolean doCommit() {
        return this.doCommit((AbstractVcs)null);
    }

    public boolean doCommit(@Nullable AbstractVcs vcs) {
        return this.doCommit(new CommitProcessor(vcs));
    }

    public boolean doAlienCommit(AbstractVcs vcs) {
        return this.doCommit(new AlienCommitProcessor(vcs));
    }

    private boolean doCommit(final GeneralCommitProcessor processor) {
        final Runnable action = new Runnable(){

            @Override
            public void run() {
                CommitHelper.this.delegateCommitToVcsThread(processor);
            }
        };
        if (this.myForceSyncCommit) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(action, this.myActionName, true, this.myProject);
            boolean success = CommitHelper.doesntContainErrors(processor.getVcsExceptions());
            if (success) {
                this.reportResult(processor);
            }
            return success;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, this.myActionName, true, this.myConfiguration.getCommitOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/CommitHelper$2", "run"));
                }
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
                vcsManager.startBackgroundVcsOperation();
                try {
                    action.run();
                }
                finally {
                    vcsManager.stopBackgroundVcsOperation();
                }
            }

            public Task.NotificationInfo notifyFinished() {
                if (CommitHelper.this.myCustomResultHandler == null) {
                    String text = CommitHelper.this.reportResult(processor);
                    return new Task.NotificationInfo("VCS Commit", "VCS Commit Finished", text, true);
                }
                return null;
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return false;
    }

    private void delegateCommitToVcsThread(GeneralCommitProcessor processor) {
        DelegatingProgressIndicator indicator = new DelegatingProgressIndicator();
        Semaphore endSemaphore = new Semaphore();
        endSemaphore.down();
        ChangeListManagerImpl.getInstanceImpl(this.myProject).executeOnUpdaterThread(new Runnable((ProgressIndicator)indicator, processor, endSemaphore){
            final /* synthetic */ ProgressIndicator val$indicator;
            final /* synthetic */ GeneralCommitProcessor val$processor;
            final /* synthetic */ Semaphore val$endSemaphore;
            {
                this.val$indicator = progressIndicator;
                this.val$processor = generalCommitProcessor;
                this.val$endSemaphore = semaphore;
            }

            @Override
            public void run() {
                this.val$indicator.setText("Performing VCS commit...");
                try {
                    ProgressManager.getInstance().runProcess(new Runnable(){

                        @Override
                        public void run() {
                            val$indicator.checkCanceled();
                            CommitHelper.this.generalCommit(val$processor);
                        }
                    }, this.val$indicator);
                }
                finally {
                    this.val$endSemaphore.up();
                }
            }
        });
        indicator.setText("Waiting for VCS background tasks to finish...");
        while (!endSemaphore.waitFor(20L)) {
            indicator.checkCanceled();
        }
    }

    private String reportResult(GeneralCommitProcessor processor) {
        List<Change> changesFailedToCommit = processor.getChangesFailedToCommit();
        int failed = changesFailedToCommit.size();
        int committed = this.myIncludedChanges.size() - failed;
        String text = committed + " " + StringUtil.pluralize((String)"file", (int)committed) + " committed";
        if (failed > 0) {
            text = text + ", " + failed + " " + StringUtil.pluralize((String)"file", (int)failed) + " failed to commit";
        }
        StringBuilder content = new StringBuilder(StringUtil.isEmpty((String)this.myCommitMessage) ? text : text + ": " + CommitHelper.escape(this.myCommitMessage));
        for (String s : this.myFeedback) {
            content.append("\n");
            content.append(s);
        }
        NotificationType notificationType = CommitHelper.resolveNotificationType(processor);
        VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification(content.toString(), notificationType).notify(this.myProject);
        return text;
    }

    private static NotificationType resolveNotificationType(@NotNull GeneralCommitProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "resolveNotificationType"));
        }
        boolean hasExceptions = !processor.getVcsExceptions().isEmpty();
        boolean hasOnlyWarnings = CommitHelper.doesntContainErrors(processor.getVcsExceptions());
        return hasExceptions ? (hasOnlyWarnings ? NotificationType.WARNING : NotificationType.ERROR) : NotificationType.INFORMATION;
    }

    private static String escape(String s) {
        String[] FROM = new String[]{"<", ">"};
        String[] TO = new String[]{"&lt;", "&gt;"};
        return StringUtil.replace((String)s, (String[])FROM, (String[])TO);
    }

    private static boolean doesntContainErrors(List<VcsException> vcsExceptions) {
        for (VcsException vcsException : vcsExceptions) {
            if (vcsException.isWarning()) continue;
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generalCommit(GeneralCommitProcessor processor) {
        try {
            Application appManager = ApplicationManager.getApplication();
            appManager.runReadAction(new Runnable(){

                @Override
                public void run() {
                    CommitHelper.this.markCommittingDocuments();
                }
            });
            try {
                processor.callSelf();
            }
            catch (Throwable throwable) {
                appManager.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        CommitHelper.this.unmarkCommittingDocuments();
                    }
                });
                throw throwable;
            }
            appManager.runReadAction(new /* invalid duplicate definition of identical inner class */);
            processor.doBeforeRefresh();
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(processor.getVcsExceptions(), this.myActionName);
        }
        catch (RuntimeException e) {
            try {
                LOG.error((Throwable)e);
                processor.myVcsExceptions.add(new VcsException((Throwable)e));
                throw e;
                catch (Throwable e2) {
                    LOG.error(e2);
                    processor.myVcsExceptions.add(new VcsException(e2));
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                this.commitCompleted(processor.getVcsExceptions(), processor);
                processor.customRefresh();
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(processor){
                    final /* synthetic */ GeneralCommitProcessor val$processor;
                    {
                        this.val$processor = generalCommitProcessor;
                    }

                    @Override
                    public void run() {
                        Runnable runnable = this.val$processor.postRefresh();
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                }, null, (Project)this.myProject);
                throw throwable;
            }
        }
        this.commitCompleted(processor.getVcsExceptions(), processor);
        processor.customRefresh();
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new /* invalid duplicate definition of identical inner class */, null, (Project)this.myProject);
    }

    private void markCommittingDocuments() {
        this.myCommittingDocuments.addAll(CommitHelper.markCommittingDocuments(this.myProject, this.myIncludedChanges));
    }

    private void unmarkCommittingDocuments() {
        CommitHelper.unmarkCommittingDocuments(this.myCommittingDocuments);
        this.myCommittingDocuments.clear();
    }

    @NotNull
    public static Collection<Document> markCommittingDocuments(@NotNull Project project, @NotNull List<Change> changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "markCommittingDocuments"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "markCommittingDocuments"));
        }
        ArrayList<Document> committingDocs = new ArrayList<Document>();
        for (Change change : changes) {
            Document doc;
            VirtualFile virtualFile = ChangesUtil.getFilePath((Change)change).getVirtualFile();
            if (virtualFile == null || virtualFile.getFileType().isBinary() || (doc = FileDocumentManager.getInstance().getDocument(virtualFile)) == null) continue;
            doc.putUserData(DOCUMENT_BEING_COMMITTED_KEY, (Object)project);
            committingDocs.add(doc);
        }
        ArrayList<Document> arrayList = committingDocs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "markCommittingDocuments"));
        }
        return arrayList;
    }

    public static void unmarkCommittingDocuments(@NotNull Collection<Document> committingDocs) {
        if (committingDocs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committingDocs", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "unmarkCommittingDocuments"));
        }
        for (Document doc : committingDocs) {
            doc.putUserData(DOCUMENT_BEING_COMMITTED_KEY, null);
        }
    }

    private void commitCompleted(List<VcsException> allExceptions, GeneralCommitProcessor processor) {
        List<VcsException> errors = CommitHelper.collectErrors(allExceptions);
        int errorsSize = errors.size();
        int warningsSize = allExceptions.size() - errorsSize;
        if (errorsSize == 0) {
            for (CheckinHandler handler2 : this.myHandlers) {
                handler2.checkinSuccessful();
            }
            processor.afterSuccessfulCheckIn();
            if (this.myCustomResultHandler != null) {
                this.myCustomResultHandler.onSuccess(this.myCommitMessage);
            }
        } else {
            for (CheckinHandler handler3 : this.myHandlers) {
                handler3.checkinFailed(errors);
            }
        }
        if (errorsSize == 0 && warningsSize == 0) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(VcsBundle.message((String)"commit.dialog.completed.successfully", (Object[])new Object[0]));
            }
        } else if (this.myCustomResultHandler == null) {
            this.showErrorDialogAndMoveToAnotherList(processor, errorsSize, warningsSize, errors);
        } else {
            this.myCustomResultHandler.onFailure();
        }
    }

    private void showErrorDialogAndMoveToAnotherList(final GeneralCommitProcessor processor, final int errorsSize, final int warningsSize, final @NotNull List<VcsException> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/vcs/changes/ui/CommitHelper", "showErrorDialogAndMoveToAnotherList"));
        }
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

            @Override
            public void run() {
                String message = errorsSize > 0 && warningsSize > 0 ? VcsBundle.message((String)"message.text.commit.failed.with.errors.and.warnings", (Object[])new Object[0]) : (errorsSize > 0 ? StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])new Object[0]), (int)errorsSize) : StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])new Object[0]), (int)warningsSize));
                message = message + ":\n" + StringUtil.join((Collection)errors, (Function)new Function<VcsException, String>(){

                    public String fun(VcsException e) {
                        return e.getMessage();
                    }
                }, (String)"\n");
                Messages.showErrorDialog((String)message, (String)VcsBundle.message((String)"message.title.commit", (Object[])new Object[0]));
                if (errorsSize > 0) {
                    processor.afterFailedCheckIn();
                }
            }
        }, null, (Project)this.myProject);
    }

    public static void moveToFailedList(ChangeList changeList, String commitMessage, List<Change> failedChanges, String newChangelistName, Project project) {
        VcsShowConfirmationOption option;
        boolean result;
        if (failedChanges.containsAll(changeList.getChanges())) {
            return;
        }
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
        if (configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && !(result = ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)(option = new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }), (Project)project, (String)VcsBundle.message((String)"commit.failed.confirm.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.failed.confirm.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        int index = 1;
        String failedListName = newChangelistName;
        while (changeListManager.findChangeList(failedListName) != null) {
            failedListName = newChangelistName + " (" + ++index + ")";
        }
        LocalChangeList failedList = changeListManager.addChangeList(failedListName, commitMessage);
        changeListManager.moveChangesTo(failedList, failedChanges.toArray(new Change[failedChanges.size()]));
    }

    private static List<VcsException> collectErrors(List<VcsException> vcsExceptions) {
        ArrayList<VcsException> result = new ArrayList<VcsException>();
        for (VcsException vcsException : vcsExceptions) {
            if (vcsException.isWarning()) continue;
            result.add(vcsException);
        }
        return result;
    }

    private class CommitProcessor
    extends GeneralCommitProcessor {
        private boolean myKeepChangeListAfterCommit;
        private LocalHistoryAction myAction;
        private ChangeListsModificationAfterCommit myAfterVcsRefreshModification;
        private boolean myCommitSuccess;
        @Nullable
        private final AbstractVcs myVcs;

        private CommitProcessor(AbstractVcs vcs) {
            this.myVcs = vcs;
            this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.NOTHING;
            if (CommitHelper.this.myChangeList instanceof LocalChangeList) {
                LocalChangeList localList = (LocalChangeList)CommitHelper.this.myChangeList;
                boolean containsAll = new HashSet(CommitHelper.this.myIncludedChanges).containsAll(new HashSet(CommitHelper.this.myChangeList.getChanges()));
                if (containsAll && !localList.isDefault() && !localList.isReadOnly()) {
                    this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.DELETE_LIST;
                } else if (((CommitHelper)CommitHelper.this).myConfiguration.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT && !containsAll && localList.isDefault() && CommitHelper.this.myAllOfDefaultChangeListChangesIncluded) {
                    this.myAfterVcsRefreshModification = ChangeListsModificationAfterCommit.MOVE_OTHERS;
                }
            }
        }

        @Override
        public void callSelf() {
            if (this.myVcs != null && CommitHelper.this.myIncludedChanges.isEmpty()) {
                this.process(this.myVcs, CommitHelper.this.myIncludedChanges);
            }
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, (ChangesUtil.PerVcsProcessor)this);
        }

        public void process(AbstractVcs vcs, List<Change> items) {
            CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                List exceptions;
                List paths = ChangesUtil.getPaths(items);
                this.myPathsToRefresh.addAll(paths);
                if (environment.keepChangeListAfterCommit(CommitHelper.this.myChangeList)) {
                    this.myKeepChangeListAfterCommit = true;
                }
                if ((exceptions = environment.commit(items, CommitHelper.this.myCommitMessage, CommitHelper.this.myAdditionalData, (Set)CommitHelper.this.myFeedback)) != null && exceptions.size() > 0) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(items);
                }
            }
        }

        @Override
        public void afterSuccessfulCheckIn() {
            this.myCommitSuccess = true;
        }

        @Override
        public void afterFailedCheckIn() {
            CommitHelper.moveToFailedList(CommitHelper.this.myChangeList, CommitHelper.this.myCommitMessage, this.getChangesFailedToCommit(), VcsBundle.message((String)"commit.dialog.failed.commit.template", (Object[])new Object[]{CommitHelper.this.myChangeList.getName()}), CommitHelper.this.myProject);
        }

        @Override
        public void doBeforeRefresh() {
            ChangeListManagerImpl clManager = (ChangeListManagerImpl)ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
            clManager.showLocalChangesInvalidated();
            this.myAction = (LocalHistoryAction)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LocalHistoryAction>(){

                public LocalHistoryAction compute() {
                    return LocalHistory.getInstance().startAction(CommitHelper.this.myActionName);
                }
            });
        }

        @Override
        public void customRefresh() {
            final ArrayList<Change> toRefresh = new ArrayList<Change>();
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(){

                public void process(AbstractVcs vcs, List<Change> items) {
                    CheckinEnvironment ce = vcs.getCheckinEnvironment();
                    if (ce != null && ce.isRefreshAfterCommitNeeded()) {
                        toRefresh.addAll(items);
                    }
                }
            });
            if (toRefresh.isEmpty()) {
                return;
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(VcsBundle.message((String)"commit.dialog.refresh.files", (Object[])new Object[0]));
            }
            RefreshVFsSynchronously.updateChanges(toRefresh);
        }

        @Override
        public Runnable postRefresh() {
            return new Runnable(){

                @Override
                public void run() {
                    if (CommitProcessor.this.myAction != null) {
                        CommitProcessor.this.myAction.finish();
                    }
                    if (!CommitHelper.this.myProject.isDisposed()) {
                        final ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
                        clManager.invokeAfterUpdate(new Runnable(){

                            @Override
                            public void run() {
                                if (CommitProcessor.this.myCommitSuccess) {
                                    ChangelistMoveOfferDialog dialog;
                                    if (ChangeListsModificationAfterCommit.DELETE_LIST.equals((Object)CommitProcessor.this.myAfterVcsRefreshModification)) {
                                        if (!CommitProcessor.this.myKeepChangeListAfterCommit) {
                                            clManager.removeChangeList(CommitHelper.this.myChangeList.getName());
                                        }
                                    } else if (ChangeListsModificationAfterCommit.MOVE_OTHERS.equals((Object)CommitProcessor.this.myAfterVcsRefreshModification) && (dialog = new ChangelistMoveOfferDialog(CommitHelper.this.myConfiguration)).showAndGet()) {
                                        Collection changes = clManager.getDefaultChangeList().getChanges();
                                        MoveChangesToAnotherListAction.askAndMove(CommitHelper.this.myProject, changes, null);
                                    }
                                }
                                CommittedChangesCache cache = CommittedChangesCache.getInstance(CommitHelper.this.myProject);
                                cache.refreshAllCachesAsync(false, true);
                                cache.refreshIncomingChangesAsync();
                            }
                        }, InvokeAfterUpdateMode.SILENT, null, (Consumer)new Consumer<VcsDirtyScopeManager>(){

                            public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                                for (FilePath path : CommitProcessor.this.myPathsToRefresh) {
                                    vcsDirtyScopeManager.fileDirty(path);
                                }
                            }
                        }, null);
                        LocalHistory.getInstance().putSystemLabel(CommitHelper.this.myProject, CommitHelper.this.myActionName + ": " + CommitHelper.this.myCommitMessage);
                    }
                }
            };
        }

        private void vcsRefresh() {
            for (FilePath path : this.myPathsToRefresh) {
                CommitHelper.this.myDirtyScopeManager.fileDirty(path);
            }
        }

        @Override
        public void doVcsRefresh() {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    CommitProcessor.this.vcsRefresh();
                }
            });
        }
    }

    private static enum ChangeListsModificationAfterCommit {
        DELETE_LIST,
        MOVE_OTHERS,
        NOTHING;

    }

    private static interface ActionsAroundRefresh {
        public void doBeforeRefresh();

        public void customRefresh();

        public void doVcsRefresh();

        public Runnable postRefresh();
    }

    private static abstract class GeneralCommitProcessor
    implements ChangesUtil.PerVcsProcessor<Change>,
    ActionsAroundRefresh {
        protected final List<FilePath> myPathsToRefresh = new ArrayList<FilePath>();
        protected final List<VcsException> myVcsExceptions = new ArrayList<VcsException>();
        protected final List<Change> myChangesFailedToCommit = new ArrayList<Change>();

        protected GeneralCommitProcessor() {
        }

        public abstract void callSelf();

        public abstract void afterSuccessfulCheckIn();

        public abstract void afterFailedCheckIn();

        public List<FilePath> getPathsToRefresh() {
            return this.myPathsToRefresh;
        }

        public List<VcsException> getVcsExceptions() {
            return this.myVcsExceptions;
        }

        public List<Change> getChangesFailedToCommit() {
            return this.myChangesFailedToCommit;
        }
    }

    private class AlienCommitProcessor
    extends GeneralCommitProcessor {
        private final AbstractVcs myVcs;

        private AlienCommitProcessor(AbstractVcs vcs) {
            this.myVcs = vcs;
        }

        @Override
        public void callSelf() {
            ChangesUtil.processItemsByVcs((Collection)CommitHelper.this.myIncludedChanges, (ChangesUtil.VcsSeparator)new ChangesUtil.VcsSeparator<Change>(){

                public AbstractVcs getVcsFor(Change item) {
                    return AlienCommitProcessor.this.myVcs;
                }
            }, (ChangesUtil.PerVcsProcessor)this);
        }

        public void process(AbstractVcs vcs, List<Change> items) {
            CheckinEnvironment environment;
            if (this.myVcs.getName().equals(vcs.getName()) && (environment = vcs.getCheckinEnvironment()) != null) {
                List paths = ChangesUtil.getPaths(items);
                this.myPathsToRefresh.addAll(paths);
                List exceptions = environment.commit(items, CommitHelper.this.myCommitMessage, CommitHelper.this.myAdditionalData, (Set)CommitHelper.this.myFeedback);
                if (exceptions != null && exceptions.size() > 0) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(items);
                }
            }
        }

        @Override
        public void afterSuccessfulCheckIn() {
        }

        @Override
        public void afterFailedCheckIn() {
        }

        @Override
        public void doBeforeRefresh() {
        }

        @Override
        public void customRefresh() {
        }

        @Override
        public Runnable postRefresh() {
            return null;
        }

        @Override
        public void doVcsRefresh() {
        }
    }
}

