/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.DocumentWrapper;
import com.intellij.openapi.vcs.ex.LineStatusTrackerDrawing;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTracker {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.ex.LineStatusTracker");
    private static final Key<CanNotCalculateDiffPanel> PANEL_KEY = new Key("LineStatusTracker.CanNotCalculateDiffPanel");
    private final Object myLock;
    private boolean myInitialized;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final Document myVcsDocument;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Application myApplication;
    @NotNull
    private final FileEditorManager myFileEditorManager;
    @NotNull
    private final VcsDirtyScopeManager myVcsDirtyScopeManager;
    private MyDocumentListener myDocumentListener;
    @Nullable
    private RevisionPack myBaseRevisionNumber;
    private boolean mySuppressUpdate;
    private boolean myBulkUpdate;
    private boolean myAnathemaThrown;
    private boolean myReleased;
    @NotNull
    private Mode myMode;
    @NotNull
    private List<Range> myRanges;

    private LineStatusTracker(@NotNull Document document, @NotNull Document vcsDocument, @NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (vcsDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDocument", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "<init>"));
        }
        this.myLock = new Object();
        this.myDocument = document;
        this.myVcsDocument = vcsDocument;
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myApplication = ApplicationManager.getApplication();
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myVcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myMode = mode;
        this.myRanges = new ArrayList<Range>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(@NotNull String vcsContent, @NotNull RevisionPack baseRevisionNumber) {
        if (vcsContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContent", "com/intellij/openapi/vcs/ex/LineStatusTracker", "initialize"));
        }
        if (baseRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRevisionNumber", "com/intellij/openapi/vcs/ex/LineStatusTracker", "initialize"));
        }
        this.myApplication.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            try {
                if (this.myReleased) {
                    return;
                }
                if (this.myBaseRevisionNumber != null && this.myBaseRevisionNumber.contains(baseRevisionNumber)) {
                    return;
                }
                this.myBaseRevisionNumber = baseRevisionNumber;
                this.myVcsDocument.setReadOnly(false);
                this.myVcsDocument.setText((CharSequence)vcsContent);
                this.myVcsDocument.setReadOnly(true);
                this.reinstallRanges();
                if (this.myDocumentListener != null) return;
                this.myDocumentListener = new MyDocumentListener();
                this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
            }
            finally {
                this.myInitialized = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinstallRanges() {
        this.myApplication.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myReleased) {
                return;
            }
            this.removeAnathema();
            this.removeHighlightersFromMarkupModel();
            try {
                this.myRanges = new RangesBuilder(this.myDocument, this.myVcsDocument, this.myMode).getRanges();
            }
            catch (FilesTooBigForDiffException e) {
                this.installAnathema();
                return;
            }
            for (Range range : this.myRanges) {
                range.setHighlighter(this.createHighlighter(range));
            }
        }
    }

    private void installAnathema() {
        FileEditor[] editors;
        this.myAnathemaThrown = true;
        for (FileEditor editor : editors = this.myFileEditorManager.getAllEditors(this.myVirtualFile)) {
            CanNotCalculateDiffPanel panel = (CanNotCalculateDiffPanel)((Object)editor.getUserData(PANEL_KEY));
            if (panel != null) continue;
            CanNotCalculateDiffPanel newPanel = new CanNotCalculateDiffPanel();
            editor.putUserData(PANEL_KEY, (Object)newPanel);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)((Object)newPanel));
        }
    }

    private void removeAnathema() {
        FileEditor[] editors;
        if (!this.myAnathemaThrown) {
            return;
        }
        this.myAnathemaThrown = false;
        for (FileEditor editor : editors = this.myFileEditorManager.getEditors(this.myVirtualFile)) {
            CanNotCalculateDiffPanel panel = (CanNotCalculateDiffPanel)((Object)editor.getUserData(PANEL_KEY));
            if (panel == null) continue;
            this.myFileEditorManager.removeTopComponent(editor, (JComponent)((Object)panel));
            editor.putUserData(PANEL_KEY, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(@NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "setMode"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myMode == mode) {
                return;
            }
            this.myMode = mode;
            this.reinstallRanges();
        }
    }

    @Nullable
    private RangeHighlighter createHighlighter(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createHighlighter"));
        }
        this.myApplication.assertIsDispatchThread();
        LOG.assertTrue(!this.myReleased, (Object)"Already released");
        if (this.myMode == Mode.SILENT) {
            return null;
        }
        int first = range.getLine1() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine1());
        int second = range.getLine2() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine2());
        TextAttributes attr = LineStatusTrackerDrawing.getAttributesFor(range);
        RangeHighlighter highlighter = DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true).addRangeHighlighter(first, second, 999, attr, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setThinErrorStripeMark(true);
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        highlighter.setLineMarkerRenderer(LineStatusTrackerDrawing.createRenderer(range, this));
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        String tooltip = range.getLine1() == range.getLine2() ? (range.getVcsLine1() + 1 == range.getVcsLine2() ? VcsBundle.message((String)"tooltip.text.line.before.deleted", (Object[])new Object[]{range.getLine1() + 1}) : VcsBundle.message((String)"tooltip.text.lines.before.deleted", (Object[])new Object[]{range.getLine1() + 1, range.getVcsLine2() - range.getVcsLine1()})) : (range.getLine1() + 1 == range.getLine2() ? VcsBundle.message((String)"tooltip.text.line.changed", (Object[])new Object[]{range.getLine1() + 1}) : VcsBundle.message((String)"tooltip.text.lines.changed", (Object[])new Object[]{range.getLine1() + 1, range.getLine2()}));
        highlighter.setErrorStripeTooltip((Object)tooltip);
        return highlighter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.myLock;
        synchronized (object) {
            this.myReleased = true;
            if (this.myDocumentListener != null) {
                this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
            }
            if (this.myApplication.isDispatchThread()) {
                this.removeAnathema();
                this.removeHighlightersFromMarkupModel();
            } else {
                this.invalidateRanges();
                this.myApplication.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LineStatusTracker.this.removeAnathema();
                        LineStatusTracker.this.removeHighlightersFromMarkupModel();
                    }
                });
            }
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getProject"));
        }
        return project;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getDocument"));
        }
        return document;
    }

    @NotNull
    public Document getVcsDocument() {
        Document document = this.myVcsDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsDocument"));
        }
        return document;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getMode"));
        }
        return mode;
    }

    public boolean isSilentMode() {
        return this.myMode == Mode.SILENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<Range> getRanges() {
        Object object = this.myLock;
        // MONITORENTER : object
        List<Range> list = Collections.unmodifiableList(this.myRanges);
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getRanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkUpdate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myReleased) {
                return;
            }
            this.myBulkUpdate = true;
            this.removeAnathema();
            this.removeHighlightersFromMarkupModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHighlightersFromMarkupModel() {
        this.myApplication.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                if (range.getHighlighter() != null) {
                    range.getHighlighter().dispose();
                }
                range.invalidate();
            }
            this.myRanges.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateRanges() {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                range.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkUpdate() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myReleased) {
                return;
            }
            this.myBulkUpdate = false;
            this.reinstallRanges();
        }
    }

    private void markFileUnchanged() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean stillEmpty;
                FileDocumentManager.getInstance().saveDocument(LineStatusTracker.this.myDocument);
                Object object = LineStatusTracker.this.myLock;
                synchronized (object) {
                    stillEmpty = LineStatusTracker.this.myRanges.isEmpty();
                }
                if (stillEmpty) {
                    LineStatusTracker.this.myVcsDirtyScopeManager.fileDirty(LineStatusTracker.this.myVirtualFile);
                }
            }
        });
    }

    @NotNull
    private int[] fixRanges(@NotNull DocumentEvent e, int line1, int line2) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
        }
        CharSequence document = this.myDocument.getCharsSequence();
        int offset = e.getOffset();
        if (e.getOldLength() == 0 && e.getNewLength() != 0) {
            if (StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && LineStatusTracker.isNewline(offset - 1, document)) {
                int[] nArray = new int[]{line1, line2 - 1};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
            if (StringUtil.startsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && LineStatusTracker.isNewline(offset + e.getNewLength(), document)) {
                int[] nArray = new int[]{line1 + 1, line2};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
        }
        if (e.getOldLength() != 0 && e.getNewLength() == 0) {
            if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && LineStatusTracker.isNewline(offset - 1, document)) {
                int[] nArray = new int[]{line1, line2 - 1};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
            if (StringUtil.startsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && LineStatusTracker.isNewline(offset + e.getNewLength(), document)) {
                int[] nArray = new int[]{line1 + 1, line2};
                if (nArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
                }
                return nArray;
            }
        }
        int[] nArray = new int[]{line1, line2};
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "fixRanges"));
        }
        return nArray;
    }

    private static boolean isNewline(int offset, @NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/vcs/ex/LineStatusTracker", "isNewline"));
        }
        if (offset < 0) {
            return false;
        }
        if (offset >= sequence.length()) {
            return false;
        }
        return sequence.charAt(offset) == '\n';
    }

    private void doUpdateRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, int beforeTotalLines) {
        ArrayList<Range> rangesBeforeChange = new ArrayList<Range>();
        ArrayList<Range> rangesAfterChange = new ArrayList<Range>();
        ArrayList<Range> changedRanges = new ArrayList<Range>();
        this.sortRanges(beforeChangedLine1, beforeChangedLine2, linesShift, rangesBeforeChange, changedRanges, rangesAfterChange);
        Range firstChangedRange = (Range)ContainerUtil.getFirstItem(changedRanges);
        Range lastChangedRange = (Range)ContainerUtil.getLastItem(changedRanges);
        if (firstChangedRange != null && firstChangedRange.getLine1() < beforeChangedLine1) {
            beforeChangedLine1 = firstChangedRange.getLine1();
        }
        if (lastChangedRange != null && lastChangedRange.getLine2() > beforeChangedLine2) {
            beforeChangedLine2 = lastChangedRange.getLine2();
        }
        this.doUpdateRanges(beforeChangedLine1, beforeChangedLine2, linesShift, beforeTotalLines, rangesBeforeChange, changedRanges, rangesAfterChange);
    }

    private void doUpdateRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, int beforeTotalLines, @NotNull List<Range> rangesBefore, @NotNull List<Range> changedRanges, @NotNull List<Range> rangesAfter) {
        if (rangesBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesBefore", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doUpdateRanges"));
        }
        if (changedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRanges", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doUpdateRanges"));
        }
        if (rangesAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesAfter", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doUpdateRanges"));
        }
        try {
            int vcsTotalLines = DiffUtil.getLineCount(this.myVcsDocument);
            Range lastRangeBefore = (Range)ContainerUtil.getLastItem(rangesBefore);
            Range firstRangeAfter = (Range)ContainerUtil.getFirstItem(rangesAfter);
            int afterChangedLine1 = beforeChangedLine1;
            int afterChangedLine2 = beforeChangedLine2 + linesShift;
            int vcsLine1 = LineStatusTracker.getVcsLine1(lastRangeBefore, beforeChangedLine1);
            int vcsLine2 = LineStatusTracker.getVcsLine2(firstRangeAfter, beforeChangedLine2, beforeTotalLines, vcsTotalLines);
            List<Range> newChangedRanges = this.getNewChangedRanges(afterChangedLine1, afterChangedLine2, vcsLine1, vcsLine2);
            LineStatusTracker.shiftRanges(rangesAfter, linesShift);
            if (!changedRanges.equals(newChangedRanges)) {
                this.replaceRanges(changedRanges, newChangedRanges);
                this.myRanges = new ArrayList<Range>(rangesBefore.size() + newChangedRanges.size() + rangesAfter.size());
                this.myRanges.addAll(rangesBefore);
                this.myRanges.addAll(newChangedRanges);
                this.myRanges.addAll(rangesAfter);
                for (Range range : this.myRanges) {
                    if (range.hasHighlighter()) continue;
                    range.setHighlighter(this.createHighlighter(range));
                }
                if (this.myRanges.isEmpty()) {
                    this.markFileUnchanged();
                }
            }
        }
        catch (ProcessCanceledException vcsTotalLines) {
        }
        catch (FilesTooBigForDiffException e1) {
            this.installAnathema();
            this.removeHighlightersFromMarkupModel();
        }
    }

    private static int getVcsLine1(@Nullable Range range, int line) {
        return range == null ? line : line + range.getVcsLine2() - range.getLine2();
    }

    private static int getVcsLine2(@Nullable Range range, int line, int totalLinesBefore, int totalLinesAfter) {
        return range == null ? totalLinesAfter - totalLinesBefore + line : line + range.getVcsLine1() - range.getLine1();
    }

    private List<Range> getNewChangedRanges(int changedLine1, int changedLine2, int vcsLine1, int vcsLine2) throws FilesTooBigForDiffException {
        if (changedLine1 == changedLine2 && vcsLine1 == vcsLine2) {
            return Collections.emptyList();
        }
        if (changedLine1 == changedLine2) {
            return Collections.singletonList(new Range(changedLine1, changedLine2, vcsLine1, vcsLine2));
        }
        if (vcsLine1 == vcsLine2) {
            return Collections.singletonList(new Range(changedLine1, changedLine2, vcsLine1, vcsLine2));
        }
        List<String> lines = new DocumentWrapper(this.myDocument).getLines(changedLine1, changedLine2 - 1);
        List<String> vcsLines = new DocumentWrapper(this.myVcsDocument).getLines(vcsLine1, vcsLine2 - 1);
        return new RangesBuilder(lines, vcsLines, changedLine1, vcsLine1, this.myMode).getRanges();
    }

    private void replaceRanges(@NotNull List<Range> rangesInChange, @NotNull List<Range> newRangesInChange) {
        if (rangesInChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesInChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "replaceRanges"));
        }
        if (newRangesInChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRangesInChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "replaceRanges"));
        }
        for (Range range : rangesInChange) {
            if (range.getHighlighter() != null) {
                range.getHighlighter().dispose();
            }
            range.setHighlighter(null);
            range.invalidate();
        }
        for (Range range : newRangesInChange) {
            range.setHighlighter(this.createHighlighter(range));
        }
    }

    private static void shiftRanges(@NotNull List<Range> rangesAfterChange, int shift) {
        if (rangesAfterChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesAfterChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "shiftRanges"));
        }
        for (Range range : rangesAfterChange) {
            range.shift(shift);
        }
    }

    private void sortRanges(int beforeChangedLine1, int beforeChangedLine2, int linesShift, @NotNull List<Range> rangesBeforeChange, @NotNull List<Range> changedRanges, @NotNull List<Range> rangesAfterChange) {
        if (rangesBeforeChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesBeforeChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "sortRanges"));
        }
        if (changedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRanges", "com/intellij/openapi/vcs/ex/LineStatusTracker", "sortRanges"));
        }
        if (rangesAfterChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesAfterChange", "com/intellij/openapi/vcs/ex/LineStatusTracker", "sortRanges"));
        }
        if (!Registry.is((String)"diff.status.tracker.skip.spaces")) {
            for (Range range : this.myRanges) {
                if (range.getLine2() < beforeChangedLine1) {
                    rangesBeforeChange.add(range);
                    continue;
                }
                if (range.getLine1() > beforeChangedLine2) {
                    rangesAfterChange.add(range);
                    continue;
                }
                changedRanges.add(range);
            }
        } else {
            int lastBefore = -1;
            int firstAfter = this.myRanges.size();
            for (int i = 0; i < this.myRanges.size(); ++i) {
                Range range = this.myRanges.get(i);
                if (range.getLine2() < beforeChangedLine1) {
                    lastBefore = i;
                    continue;
                }
                if (range.getLine1() <= beforeChangedLine2) continue;
                firstAfter = i;
                break;
            }
            CharSequence sequence = this.myDocument.getCharsSequence();
            int lineCount = DiffUtil.getLineCount(this.myDocument);
            while (lastBefore != -1) {
                char c;
                Range firstChangedRange;
                if (lastBefore < this.myRanges.size() - 1 && firstAfter - lastBefore > 1 && (firstChangedRange = this.myRanges.get(lastBefore + 1)).getLine1() < beforeChangedLine1) {
                    beforeChangedLine1 = firstChangedRange.getLine1();
                }
                if (beforeChangedLine1 < 0 || beforeChangedLine1 >= lineCount) break;
                int deltaLines = 0;
                for (int offset1 = this.myDocument.getLineStartOffset(beforeChangedLine1) - 2; offset1 > 0 && StringUtil.isWhiteSpace((char)(c = sequence.charAt(offset1))); --offset1) {
                    if (c != '\n') continue;
                    ++deltaLines;
                }
                if (deltaLines == 0 || this.myRanges.get(lastBefore).getLine2() < (beforeChangedLine1 -= deltaLines)) break;
                while (lastBefore != -1 && this.myRanges.get(lastBefore).getLine2() >= beforeChangedLine1) {
                    --lastBefore;
                }
            }
            while (firstAfter != this.myRanges.size()) {
                char c;
                int afterChangedLine2;
                Range lastChangedRange;
                if (firstAfter > 0 && firstAfter - lastBefore > 1 && (lastChangedRange = this.myRanges.get(firstAfter - 1)).getLine2() > beforeChangedLine2) {
                    beforeChangedLine2 = lastChangedRange.getLine2();
                }
                if ((afterChangedLine2 = beforeChangedLine2 + linesShift - 1) < 0 || afterChangedLine2 >= lineCount) break;
                int deltaLines = 0;
                for (int offset2 = this.myDocument.getLineEndOffset(afterChangedLine2) + 1; offset2 < sequence.length() && StringUtil.isWhiteSpace((char)(c = sequence.charAt(offset2))); ++offset2) {
                    if (c != '\n') continue;
                    ++deltaLines;
                }
                if (deltaLines == 0 || this.myRanges.get(firstAfter).getLine1() > (beforeChangedLine2 += deltaLines)) break;
                while (firstAfter != this.myRanges.size() && this.myRanges.get(firstAfter).getLine1() <= beforeChangedLine2) {
                    ++firstAfter;
                }
            }
            for (int i = 0; i < this.myRanges.size(); ++i) {
                Range range = this.myRanges.get(i);
                if (i <= lastBefore) {
                    rangesBeforeChange.add(range);
                    continue;
                }
                if (i >= firstAfter) {
                    rangesAfterChange.add(range);
                    continue;
                }
                changedRanges.add(range);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getNextRange(Range range) {
        Object object = this.myLock;
        synchronized (object) {
            int index = this.myRanges.indexOf(range);
            if (index == this.myRanges.size() - 1) {
                return null;
            }
            return this.myRanges.get(index + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getPrevRange(Range range) {
        Object object = this.myLock;
        synchronized (object) {
            int index = this.myRanges.indexOf(range);
            if (index <= 0) {
                return null;
            }
            return this.myRanges.get(index - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getNextRange(int line) {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                if (line >= range.getLine2() || range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getPrevRange(int line) {
        Object object = this.myLock;
        synchronized (object) {
            for (int i = this.myRanges.size() - 1; i >= 0; --i) {
                Range range = this.myRanges.get(i);
                if (line <= range.getLine1() || range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range getRangeForLine(int line) {
        Object object = this.myLock;
        synchronized (object) {
            for (Range range : this.myRanges) {
                if (!range.isSelectedByLine(line)) continue;
                return range;
            }
            return null;
        }
    }

    private void doRollbackRange(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "doRollbackRange"));
        }
        DiffUtil.applyModification(this.myDocument, range.getLine1(), range.getLine2(), this.myVcsDocument, range.getVcsLine1(), range.getVcsLine2());
        this.markLinesUnchanged(range.getLine1(), range.getLine1() + range.getVcsLine2() - range.getVcsLine1());
    }

    private void markLinesUnchanged(int startLine, int endLine) {
        if (this.myDocument.getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        ((DocumentImpl)this.myDocument).clearLineModificationFlags(startLine, endLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "rollbackChanges"));
        }
        this.myApplication.assertWriteAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myBulkUpdate) {
                return;
            }
            if (!range.isValid()) {
                LOG.warn("Rollback of invalid range");
                return;
            }
            this.doRollbackRange(range);
        }
    }

    public void rollbackChanges(final @NotNull BitSet lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/vcs/ex/LineStatusTracker", "rollbackChanges"));
        }
        this.runBulkRollback(new Runnable(){

            @Override
            public void run() {
                Range first = null;
                Range last = null;
                int shift = 0;
                for (Range range : LineStatusTracker.this.myRanges) {
                    if (!range.isValid()) {
                        LOG.warn("Rollback of invalid range");
                        break;
                    }
                    boolean check = DiffUtil.isSelectedByLine(lines, range.getLine1(), range.getLine2());
                    if (!check) continue;
                    if (first == null) {
                        first = range;
                    }
                    last = range;
                    Range shiftedRange = new Range(range);
                    shiftedRange.shift(shift);
                    LineStatusTracker.this.doRollbackRange(shiftedRange);
                    shift += range.getVcsLine2() - range.getVcsLine1() - (range.getLine2() - range.getLine1());
                }
                if (first != null) {
                    int beforeChangedLine1 = first.getLine1();
                    int beforeChangedLine2 = last.getLine2();
                    int beforeTotalLines = DiffUtil.getLineCount(LineStatusTracker.this.myDocument) - shift;
                    LineStatusTracker.this.doUpdateRanges(beforeChangedLine1, beforeChangedLine2, shift, beforeTotalLines);
                }
            }
        });
    }

    public void rollbackAllChanges() {
        this.runBulkRollback(new Runnable(){

            @Override
            public void run() {
                LineStatusTracker.this.myDocument.setText((CharSequence)LineStatusTracker.this.myVcsDocument.getText());
                LineStatusTracker.this.removeAnathema();
                LineStatusTracker.this.removeHighlightersFromMarkupModel();
                LineStatusTracker.this.markFileUnchanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBulkRollback(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/vcs/ex/LineStatusTracker", "runBulkRollback"));
        }
        this.myApplication.assertWriteAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myBulkUpdate) {
                return;
            }
            try {
                this.mySuppressUpdate = true;
                task.run();
            }
            catch (Error e) {
                this.reinstallRanges();
                throw e;
            }
            catch (RuntimeException e) {
                this.reinstallRanges();
                throw e;
            }
            finally {
                this.mySuppressUpdate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CharSequence getCurrentContent(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentContent"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        TextRange textRange = this.getCurrentTextRange(range);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        CharSequence charSequence = this.myDocument.getImmutableCharSequence().subSequence(startOffset, endOffset);
        // MONITOREXIT : object
        if (charSequence != null) return charSequence;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentContent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CharSequence getVcsContent(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsContent"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        TextRange textRange = this.getVcsTextRange(range);
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        CharSequence charSequence = this.myVcsDocument.getImmutableCharSequence().subSequence(startOffset, endOffset);
        // MONITOREXIT : object
        if (charSequence != null) return charSequence;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsContent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public TextRange getCurrentTextRange(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentTextRange"));
        }
        this.myApplication.assertReadAccessAllowed();
        Object object = this.myLock;
        // MONITORENTER : object
        if (!range.isValid()) {
            LOG.warn("Current TextRange of invalid range");
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range.getLine1(), range.getLine2());
        // MONITOREXIT : object
        if (textRange != null) return textRange;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getCurrentTextRange"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public TextRange getVcsTextRange(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsTextRange"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        if (!range.isValid()) {
            LOG.warn("Vcs TextRange of invalid range");
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myVcsDocument, range.getVcsLine1(), range.getVcsLine2());
        // MONITOREXIT : object
        if (textRange != null) return textRange;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTracker", "getVcsTextRange"));
    }

    public static LineStatusTracker createOn(@NotNull VirtualFile virtualFile, @NotNull Document document, Project project, @NotNull Mode mode) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/vcs/ex/LineStatusTracker", "createOn"));
        }
        DocumentImpl vcsDocument = new DocumentImpl("", true);
        vcsDocument.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        return new LineStatusTracker(document, vcsDocument, project, virtualFile, mode);
    }

    private static class CanNotCalculateDiffPanel
    extends EditorNotificationPanel {
        public CanNotCalculateDiffPanel() {
            this.myLabel.setText("Can not highlight changed lines. File is too big and there are too many changes.");
        }
    }

    public static class RevisionPack {
        private final long myNumber;
        private final VcsRevisionNumber myRevision;

        public RevisionPack(long number, VcsRevisionNumber revision) {
            this.myNumber = number;
            this.myRevision = revision;
        }

        public long getNumber() {
            return this.myNumber;
        }

        public VcsRevisionNumber getRevision() {
            return this.myRevision;
        }

        public boolean contains(RevisionPack previous) {
            if (this.myRevision.equals(previous.getRevision()) && !this.myRevision.equals(VcsRevisionNumber.NULL)) {
                return true;
            }
            return this.myNumber >= previous.getNumber();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RevisionPack that = (RevisionPack)o;
            return this.myRevision.equals(that.getRevision());
        }

        public int hashCode() {
            return this.myRevision.hashCode();
        }
    }

    private class MyDocumentListener
    extends DocumentAdapter {
        private int myLine1;
        private int myBeforeChangedLines;
        private int myBeforeTotalLines;

        private MyDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(DocumentEvent e) {
            LineStatusTracker.this.myApplication.assertIsDispatchThread();
            Object object = LineStatusTracker.this.myLock;
            synchronized (object) {
                if (LineStatusTracker.this.myReleased) {
                    return;
                }
                if (LineStatusTracker.this.myBulkUpdate || LineStatusTracker.this.mySuppressUpdate || LineStatusTracker.this.myAnathemaThrown || !LineStatusTracker.this.myInitialized) {
                    return;
                }
                assert (LineStatusTracker.this.myDocument == e.getDocument());
                try {
                    this.myLine1 = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset());
                    if (e.getOldLength() == 0) {
                        this.myBeforeChangedLines = 1;
                    } else {
                        int line1 = this.myLine1;
                        int line2 = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getOldLength());
                        this.myBeforeChangedLines = line2 - line1 + 1;
                    }
                    this.myBeforeTotalLines = DiffUtil.getLineCount(LineStatusTracker.this.myDocument);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(DocumentEvent e) {
            LineStatusTracker.this.myApplication.assertIsDispatchThread();
            Object object = LineStatusTracker.this.myLock;
            synchronized (object) {
                int afterChangedLines;
                if (LineStatusTracker.this.myReleased) {
                    return;
                }
                if (LineStatusTracker.this.myBulkUpdate || LineStatusTracker.this.mySuppressUpdate || LineStatusTracker.this.myAnathemaThrown || !LineStatusTracker.this.myInitialized) {
                    return;
                }
                assert (LineStatusTracker.this.myDocument == e.getDocument());
                if (e.getNewLength() == 0) {
                    afterChangedLines = 1;
                } else {
                    int line1 = this.myLine1;
                    int line2 = LineStatusTracker.this.myDocument.getLineNumber(e.getOffset() + e.getNewLength());
                    afterChangedLines = line2 - line1 + 1;
                }
                int linesShift = afterChangedLines - this.myBeforeChangedLines;
                int line1 = this.myLine1;
                int line2 = line1 + this.myBeforeChangedLines;
                int[] fixed = LineStatusTracker.this.fixRanges(e, line1, line2);
                line1 = fixed[0];
                line2 = fixed[1];
                LineStatusTracker.this.doUpdateRanges(line1, line2, linesShift, this.myBeforeTotalLines);
            }
        }
    }

    public static enum Mode {
        DEFAULT,
        SMART,
        SILENT;

    }
}

