/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerContainerImpl
extends TraceableDisposable
implements VirtualFilePointerContainer,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer");
    @NotNull
    private final List<VirtualFilePointer> myList;
    @NotNull
    private final VirtualFilePointerManager myVirtualFilePointerManager;
    @NotNull
    private final Disposable myParent;
    private final VirtualFilePointerListener myListener;
    private volatile Trinity<String[], VirtualFile[], VirtualFile[]> myCachedThings;
    private volatile long myTimeStampOfCachedThings;
    @NonNls
    public static final String URL_ATTR = "url";
    private boolean myDisposed;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    private static final Trinity<String[], VirtualFile[], VirtualFile[]> EMPTY = Trinity.create((Object)ArrayUtil.EMPTY_STRING_ARRAY, (Object)VirtualFile.EMPTY_ARRAY, (Object)VirtualFile.EMPTY_ARRAY);

    public VirtualFilePointerContainerImpl(@NotNull VirtualFilePointerManager manager, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "<init>"));
        }
        super(TRACE_CREATION && !ApplicationInfoImpl.isInPerformanceTest() ? new Throwable("parent = '" + parentDisposable + "' (" + parentDisposable.getClass() + "); listener=" + listener) : null);
        this.myList = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTimeStampOfCachedThings = -1L;
        this.myVirtualFilePointerManager = manager;
        this.myParent = parentDisposable;
        this.myListener = listener;
    }

    public void readExternal(@NotNull Element rootChild, @NotNull String childElements) throws InvalidDataException {
        if (rootChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootChild", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "readExternal"));
        }
        if (childElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childElements", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "readExternal"));
        }
        List urls = rootChild.getChildren(childElements);
        for (Element url : urls) {
            String urlAttribute = url.getAttributeValue(URL_ATTR);
            if (urlAttribute == null) {
                throw new InvalidDataException("path element without url");
            }
            this.add(urlAttribute);
        }
    }

    public void writeExternal(@NotNull Element element, @NotNull String childElementName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "writeExternal"));
        }
        if (childElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childElementName", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "writeExternal"));
        }
        for (VirtualFilePointer pointer : this.myList) {
            String url = pointer.getUrl();
            Element rootPathElement = new Element(childElementName);
            rootPathElement.setAttribute(URL_ATTR, url);
            element.addContent(rootPathElement);
        }
    }

    public void moveUp(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTR, "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "moveUp"));
        }
        int index = this.indexOf(url);
        if (index <= 0) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)(index - 1), (int)index);
    }

    public void moveDown(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTR, "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "moveDown"));
        }
        int index = this.indexOf(url);
        if (index < 0 || index + 1 >= this.myList.size()) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)index, (int)(index + 1));
    }

    private int indexOf(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTR, "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "indexOf"));
        }
        for (int i = 0; i < this.myList.size(); ++i) {
            VirtualFilePointer pointer = this.myList.get(i);
            if (!url.equals(pointer.getUrl())) continue;
            return i;
        }
        return -1;
    }

    public void killAll() {
        this.myList.clear();
    }

    public void add(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "add"));
        }
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(file);
        this.myList.add(pointer);
    }

    public void add(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTR, "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "add"));
        }
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(url);
        this.myList.add(pointer);
    }

    public void remove(@NotNull VirtualFilePointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "remove"));
        }
        assert (!this.myDisposed);
        this.dropCaches();
        boolean result = this.myList.remove(pointer);
        LOG.assertTrue(result);
    }

    @NotNull
    public List<VirtualFilePointer> getList() {
        assert (!this.myDisposed);
        List<VirtualFilePointer> list = Collections.unmodifiableList(this.myList);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "getList"));
        }
        return list;
    }

    public void addAll(@NotNull VirtualFilePointerContainer that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "addAll"));
        }
        assert (!this.myDisposed);
        this.dropCaches();
        List<VirtualFilePointer> thatList = ((VirtualFilePointerContainerImpl)that).myList;
        for (VirtualFilePointer pointer : thatList) {
            this.myList.add(this.duplicate(pointer));
        }
    }

    private void dropCaches() {
        this.myTimeStampOfCachedThings = -1L;
        this.myCachedThings = EMPTY;
    }

    @NotNull
    public String[] getUrls() {
        String[] stringArray = (String[])this.getOrCache().first;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "getUrls"));
        }
        return stringArray;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> getOrCache() {
        assert (!this.myDisposed);
        long timeStamp = this.myTimeStampOfCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> cached = this.myCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> trinity = timeStamp == this.myVirtualFilePointerManager.getModificationCount() ? cached : this.cacheThings();
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "getOrCache"));
        }
        return trinity;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> cacheThings() {
        Trinity result;
        if (this.myList.isEmpty()) {
            result = EMPTY;
        } else {
            ArrayList<VirtualFile> cachedFiles = new ArrayList<VirtualFile>(this.myList.size());
            ArrayList<String> cachedUrls = new ArrayList<String>(this.myList.size());
            ArrayList<VirtualFile> cachedDirectories = new ArrayList<VirtualFile>(this.myList.size() / 3);
            boolean allFilesAreDirs = true;
            for (VirtualFilePointer v : this.myList) {
                VirtualFile file = v.getFile();
                String url = v.getUrl();
                cachedUrls.add(url);
                if (file == null) continue;
                cachedFiles.add(file);
                if (file.isDirectory()) {
                    cachedDirectories.add(file);
                    continue;
                }
                allFilesAreDirs = false;
            }
            VirtualFile[] directories = VfsUtilCore.toVirtualFileArray(cachedDirectories);
            VirtualFile[] files = allFilesAreDirs ? directories : VfsUtilCore.toVirtualFileArray(cachedFiles);
            String[] urlsArray = ArrayUtil.toStringArray(cachedUrls);
            result = Trinity.create((Object)urlsArray, (Object)files, (Object)directories);
        }
        this.myCachedThings = result;
        this.myTimeStampOfCachedThings = this.myVirtualFilePointerManager.getModificationCount();
        Trinity trinity = result;
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "cacheThings"));
        }
        return trinity;
    }

    @NotNull
    public VirtualFile[] getFiles() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().second;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "getFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getDirectories() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().third;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "getDirectories"));
        }
        return virtualFileArray;
    }

    @Nullable
    public VirtualFilePointer findByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTR, "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "findByUrl"));
        }
        assert (!this.myDisposed);
        for (VirtualFilePointer pointer : this.myList) {
            if (!url.equals(pointer.getUrl())) continue;
            return pointer;
        }
        return null;
    }

    public void clear() {
        this.dropCaches();
        this.killAll();
    }

    public int size() {
        return this.myList.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFilePointerContainerImpl)) {
            return false;
        }
        VirtualFilePointerContainerImpl virtualFilePointerContainer = (VirtualFilePointerContainerImpl)((Object)o);
        return this.myList.equals(virtualFilePointerContainer.myList);
    }

    public int hashCode() {
        return this.myList.hashCode();
    }

    protected VirtualFilePointer create(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "create"));
        }
        return this.myVirtualFilePointerManager.create(file, this.myParent, this.myListener);
    }

    protected VirtualFilePointer create(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", URL_ATTR, "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "create"));
        }
        return this.myVirtualFilePointerManager.create(url, this.myParent, this.myListener);
    }

    protected VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
        if (virtualFilePointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFilePointer", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "duplicate"));
        }
        return this.myVirtualFilePointerManager.duplicate(virtualFilePointer, this.myParent, this.myListener);
    }

    @NotNull
    @NonNls
    public String toString() {
        String string = "VFPContainer: " + this.myList;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "toString"));
        }
        return string;
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "clone"));
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.clone(parent, null);
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "clone"));
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "clone"));
        }
        assert (!this.myDisposed);
        VirtualFilePointerContainer clone = this.myVirtualFilePointerManager.createContainer(parent, listener);
        for (VirtualFilePointer pointer : this.myList) {
            clone.add(pointer.getUrl());
        }
        VirtualFilePointerContainer virtualFilePointerContainer = clone;
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl", "clone"));
        }
        return virtualFilePointerContainer;
    }

    public void dispose() {
        assert (!this.myDisposed);
        this.myDisposed = true;
        this.kill(null);
    }
}

