/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class JavaDirectoryServiceImpl
extends CoreJavaDirectoryService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.JavaDirectoryServiceImpl");

    @Override
    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "getPackage"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex();
        String packageName = projectFileIndex.getPackageNameByDirectory(dir.getVirtualFile());
        if (packageName == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)dir.getProject()).findPackage(packageName);
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        PsiClass psiClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, "Class");
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        PsiClass psiClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        return psiClass;
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        return this.createClass(dir, name, templateName, askForUndefinedVariables, Collections.<String, String>emptyMap());
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        if (additionalProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProperties", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClass"));
        }
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName, askForUndefinedVariables, additionalProperties);
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createInterface"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createInterface"));
        }
        String templateName = "Interface";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isInterface()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createInterface"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createEnum"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createEnum"));
        }
        String templateName = "Enum";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isEnum()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createEnum"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createAnnotationType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createAnnotationType"));
        }
        String templateName = "AnnotationType";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isAnnotationType()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createAnnotationType"));
        }
        return psiClass;
    }

    private static PsiClass createClassFromTemplate(@NotNull PsiDirectory dir, String name, String templateName) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClassFromTemplate"));
        }
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName, false, Collections.<String, String>emptyMap());
    }

    private static PsiClass createClassFromTemplate(@NotNull PsiDirectory dir, String name, String templateName, boolean askToDefineVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        PsiElement element;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClassFromTemplate"));
        }
        if (additionalProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProperties", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "createClassFromTemplate"));
        }
        Project project = dir.getProject();
        FileTemplate template = FileTemplateManager.getInstance(project).getInternalTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance(project).getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", name);
        for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        String ext = StdFileTypes.JAVA.getDefaultExtension();
        String fileName = name + "." + ext;
        try {
            element = askToDefineVariables ? new CreateFromTemplateDialog(project, dir, template, null, properties).create() : FileTemplateUtil.createFromTemplate(template, fileName, properties, dir);
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
        if (element == null) {
            return null;
        }
        PsiJavaFile file = (PsiJavaFile)element.getContainingFile();
        PsiClass[] classes = file.getClasses();
        if (classes.length < 1) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, project));
        }
        return classes[0];
    }

    private static String getIncorrectTemplateMessage(String templateName, Project project) {
        return PsiBundle.message((String)"psi.error.incorrect.class.template.message", (Object[])new Object[]{FileTemplateManager.getInstance(project).internalTemplateToSubject(templateName), templateName});
    }

    @Override
    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "checkCreateClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "checkCreateClass"));
        }
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, name);
    }

    public static void checkCreateClassOrInterface(@NotNull PsiDirectory directory, String name) throws IncorrectOperationException {
        String qualifiedName;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "checkCreateClassOrInterface"));
        }
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)name);
        String fileName = name + "." + StdFileTypes.JAVA.getDefaultExtension();
        directory.checkCreateFile(fileName);
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)directory.getProject());
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string = qualifiedName = aPackage == null ? null : aPackage.getQualifiedName();
        if (!StringUtil.isEmpty((String)qualifiedName) && !helper.isQualifiedName(qualifiedName)) {
            throw new IncorrectOperationException("Cannot create class in invalid package: '" + qualifiedName + "'");
        }
    }

    @Override
    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "isSourceRoot"));
        }
        VirtualFile file = dir.getVirtualFile();
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex().getSourceRootForFile(file);
        return file.equals(sourceRoot);
    }

    @Override
    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/psi/impl/file/JavaDirectoryServiceImpl", "getLanguageLevel"));
        }
        return JavaPsiImplementationHelper.getInstance(dir.getProject()).getEffectiveLanguageLevel(dir.getVirtualFile());
    }
}

