/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceparameterobject.IntroduceParameterObjectProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class IntroduceParameterObjectDialog
extends RefactoringDialog {
    private final PsiMethod sourceMethod;
    private final VariableData[] parameterInfo;
    private JTextField sourceMethodTextField;
    private JRadioButton useExistingClassButton;
    private JPanel myUseExistingPanel;
    private JRadioButton createNewClassButton;
    private JTextField classNameField;
    private JPanel myCreateNewClassPanel;
    private JRadioButton myCreateInnerClassRadioButton;
    private JTextField myInnerClassNameTextField;
    private JPanel myInnerClassPanel;
    private JPanel myWholePanel;
    private JPanel myParamsPanel;
    private JCheckBox keepMethodAsDelegate;
    private ReferenceEditorComboWithBrowseButton packageTextField;
    private ReferenceEditorComboWithBrowseButton existingClassField;
    private JCheckBox myGenerateAccessorsCheckBox;
    private JCheckBox myEscalateVisibilityCheckBox;
    private ComboboxWithBrowseButton myDestinationCb;
    private static final String RECENTS_KEY = "IntroduceParameterObject.RECENTS_KEY";
    private static final String EXISTING_KEY = "IntroduceParameterObject.EXISTING_KEY";

    public IntroduceParameterObjectDialog(PsiMethod sourceMethod) {
        super(sourceMethod.getProject(), true);
        this.sourceMethod = sourceMethod;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(RefactorJBundle.message("introduce.parameter.object.title", objectArray));
        com.intellij.ui.DocumentAdapter docListener = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                IntroduceParameterObjectDialog.this.validateButtons();
            }
        };
        PsiClass containingClass = sourceMethod.getContainingClass();
        this.keepMethodAsDelegate.setVisible(containingClass != null && !containingClass.isInterface());
        this.classNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        this.myInnerClassNameTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        PsiParameterList parameterList = sourceMethod.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        this.parameterInfo = new VariableData[parameters.length];
        for (int i = 0; i < this.parameterInfo.length; ++i) {
            this.parameterInfo[i] = new VariableData((PsiVariable)parameters[i]);
            this.parameterInfo[i].name = parameters[i].getName();
            this.parameterInfo[i].passAsParameter = true;
        }
        this.sourceMethodTextField.setText(PsiFormatUtil.formatMethod((PsiMethod)sourceMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.useExistingClassButton);
        buttonGroup.add(this.createNewClassButton);
        buttonGroup.add(this.myCreateInnerClassRadioButton);
        this.createNewClassButton.setSelected(true);
        if (containingClass != null && containingClass.getQualifiedName() == null) {
            this.myCreateInnerClassRadioButton.setEnabled(false);
        }
        this.init();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IntroduceParameterObjectDialog.this.toggleRadioEnablement();
                IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)IntroduceParameterObjectDialog.this.myProject);
                if (IntroduceParameterObjectDialog.this.useExistingClass()) {
                    focusManager.requestFocus((Component)((Object)IntroduceParameterObjectDialog.this.existingClassField), true);
                } else if (IntroduceParameterObjectDialog.this.myCreateInnerClassRadioButton.isSelected()) {
                    focusManager.requestFocus((Component)IntroduceParameterObjectDialog.this.myInnerClassNameTextField, true);
                } else {
                    focusManager.requestFocus((Component)IntroduceParameterObjectDialog.this.classNameField, true);
                }
            }
        };
        this.useExistingClassButton.addActionListener(listener);
        this.createNewClassButton.addActionListener(listener);
        this.myCreateInnerClassRadioButton.addActionListener(listener);
        this.myGenerateAccessorsCheckBox.setSelected(true);
        this.myEscalateVisibilityCheckBox.setSelected(true);
        this.toggleRadioEnablement();
    }

    private void toggleRadioEnablement() {
        UIUtil.setEnabled((Component)this.myUseExistingPanel, (boolean)this.useExistingClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myCreateNewClassPanel, (boolean)this.createNewClassButton.isSelected(), (boolean)true);
        UIUtil.setEnabled((Component)this.myInnerClassPanel, (boolean)this.myCreateInnerClassRadioButton.isSelected(), (boolean)true);
        this.validateButtons();
        this.enableGenerateAccessors();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.IntroduceParameterObject";
    }

    @Override
    protected void doAction() {
        String packageName;
        String className;
        boolean useExistingClass = this.useExistingClass();
        boolean keepMethod = this.keepMethodAsDelegate();
        boolean createInnerClass = this.myCreateInnerClassRadioButton.isSelected();
        if (createInnerClass) {
            className = this.getInnerClassName();
            packageName = "";
        } else if (useExistingClass) {
            String existingClassName = this.getExistingClassName();
            className = StringUtil.getShortName((String)existingClassName);
            packageName = StringUtil.getPackageName((String)existingClassName);
        } else {
            packageName = this.getPackageName();
            className = this.getClassName();
        }
        ArrayList<VariableData> parameters = new ArrayList<VariableData>();
        for (VariableData data2 : this.parameterInfo) {
            if (!data2.passAsParameter) continue;
            parameters.add(data2);
        }
        String newVisibility = this.myEscalateVisibilityCheckBox.isEnabled() && this.myEscalateVisibilityCheckBox.isSelected() ? "EscalateVisible" : null;
        MoveDestination moveDestination = ((DestinationFolderComboBox)this.myDestinationCb).selectDirectory(new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName), false);
        this.invokeRefactoring(new IntroduceParameterObjectProcessor(className, packageName, moveDestination, this.sourceMethod, parameters.toArray(new VariableData[parameters.size()]), keepMethod, useExistingClass, createInnerClass, newVisibility, this.myGenerateAccessorsCheckBox.isSelected()));
    }

    @Override
    protected void canRun() throws ConfigurationException {
        Project project = this.sourceMethod.getProject();
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        List<PsiParameter> parametersToExtract = this.getParametersToExtract();
        if (parametersToExtract.isEmpty()) {
            throw new ConfigurationException("Nothing found to extract");
        }
        if (this.myCreateInnerClassRadioButton.isSelected()) {
            String innerClassName = this.getInnerClassName().trim();
            if (!nameHelper.isIdentifier(innerClassName)) {
                throw new ConfigurationException("'" + innerClassName + "' is invalid inner class name");
            }
            if (this.sourceMethod.getContainingClass().findInnerClassByName(innerClassName, false) != null) {
                throw new ConfigurationException("Inner class with name '" + innerClassName + "' already exist");
            }
        } else if (!this.useExistingClass()) {
            String className = this.getClassName();
            if (className.length() == 0 || !nameHelper.isIdentifier(className)) {
                throw new ConfigurationException("'" + className + "' is invalid parameter class name");
            }
            String packageName = this.getPackageName();
            if (packageName.length() == 0 || !nameHelper.isQualifiedName(packageName)) {
                throw new ConfigurationException("'" + packageName + "' is invalid parameter class package name");
            }
        } else {
            String className = this.getExistingClassName();
            if (className.length() == 0 || !nameHelper.isQualifiedName(className)) {
                throw new ConfigurationException("'" + className + "' is invalid qualified parameter class name");
            }
            if (JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject())) == null) {
                throw new ConfigurationException("'" + className + "' does not exist");
            }
        }
    }

    private String getInnerClassName() {
        return this.myInnerClassNameTextField.getText().trim();
    }

    @NotNull
    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog", "getPackageName"));
        }
        return string;
    }

    @NotNull
    public String getExistingClassName() {
        String string = this.existingClassField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog", "getExistingClassName"));
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.classNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog", "getClassName"));
        }
        return string;
    }

    @NotNull
    public List<PsiParameter> getParametersToExtract() {
        ArrayList<PsiParameter> out = new ArrayList<PsiParameter>();
        for (VariableData info : this.parameterInfo) {
            if (!info.passAsParameter) continue;
            out.add((PsiParameter)info.variable);
        }
        ArrayList<PsiParameter> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectDialog", "getParametersToExtract"));
        }
        return arrayList;
    }

    protected JComponent createCenterPanel() {
        this.sourceMethodTextField.setEditable(false);
        ParameterTablePanel paramsPanel = new ParameterTablePanel(this.myProject, this.parameterInfo, new PsiElement[]{this.sourceMethod}){

            @Override
            protected void updateSignature() {
            }

            @Override
            protected void doEnterAction() {
            }

            @Override
            protected void doCancelAction() {
                IntroduceParameterObjectDialog.this.doCancelAction();
            }
        };
        this.myParamsPanel.add((Component)paramsPanel, "Center");
        return this.myWholePanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.introduceParameterObject");
    }

    public boolean useExistingClass() {
        return this.useExistingClassButton.isSelected();
    }

    public boolean keepMethodAsDelegate() {
        return this.keepMethodAsDelegate.isSelected();
    }

    private void createUIComponents() {
        PsiFile file = this.sourceMethod.getContainingFile();
        this.packageTextField = new PackageNameReferenceEditorCombo(file instanceof PsiJavaFile ? ((PsiJavaFile)file).getPackageName() : "", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)this.packageTextField.getChildComponent()).getDocument();
        DocumentAdapter adapter = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                IntroduceParameterObjectDialog.this.validateButtons();
            }
        };
        document.addDocumentListener((DocumentListener)adapter);
        this.existingClassField = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = IntroduceParameterObjectDialog.this.sourceMethod.getProject();
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                TreeJavaClassChooserDialog chooser = new TreeJavaClassChooserDialog(RefactorJBundle.message("select.wrapper.class", new Object[0]), project, scope, null, null);
                String classText = IntroduceParameterObjectDialog.this.existingClassField.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)project).findClass(classText, GlobalSearchScope.allScope((Project)project));
                if (currentClass != null) {
                    chooser.select(currentClass);
                }
                chooser.show();
                PsiClass selectedClass = (PsiClass)chooser.getSelected();
                if (selectedClass != null) {
                    String className = selectedClass.getQualifiedName();
                    IntroduceParameterObjectDialog.this.existingClassField.setText(className);
                    RecentsManager.getInstance(IntroduceParameterObjectDialog.this.myProject).registerRecentEntry(IntroduceParameterObjectDialog.EXISTING_KEY, className);
                }
            }
        }, "", this.myProject, true, EXISTING_KEY);
        ((EditorComboBox)this.existingClassField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                IntroduceParameterObjectDialog.this.validateButtons();
                IntroduceParameterObjectDialog.this.enableGenerateAccessors();
            }
        });
        this.myDestinationCb = new DestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return IntroduceParameterObjectDialog.this.getPackageName();
            }
        };
        ((DestinationFolderComboBox)this.myDestinationCb).setData(this.myProject, this.sourceMethod.getContainingFile().getContainingDirectory(), (EditorComboBox)this.packageTextField.getChildComponent());
    }

    private void enableGenerateAccessors() {
        VirtualFile virtualFile;
        PsiFile containingFile;
        PsiClass selectedClass;
        boolean existingNotALibraryClass = false;
        if (this.useExistingClassButton.isSelected() && (selectedClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.existingClassField.getText(), GlobalSearchScope.projectScope((Project)this.myProject))) != null && (containingFile = selectedClass.getContainingFile()) != null && (virtualFile = containingFile.getVirtualFile()) != null) {
            existingNotALibraryClass = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES);
        }
        this.myGenerateAccessorsCheckBox.setEnabled(existingNotALibraryClass);
        this.myEscalateVisibilityCheckBox.setEnabled(existingNotALibraryClass);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JRadioButton jRadioButton;
        JTextField jTextField2;
        JPanel jPanel2;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel3;
        JTextField jTextField3;
        JPanel jPanel4;
        JRadioButton jRadioButton3;
        JPanel jPanel5;
        this.createUIComponents();
        this.myWholePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Parameter Class", (int)0, (int)0, null, null));
        this.createNewClassButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Create new class");
        jRadioButton3.setMnemonic('C');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel6.add((Component)jRadioButton3, gridBagConstraints);
        this.myCreateNewClassPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 6;
        gridBagConstraints2.fill = 1;
        jPanel6.add((Component)jPanel4, gridBagConstraints2);
        JLabel jLabel = new JLabel();
        jLabel.setText("Name");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.classNameField = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Package name");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageTextField;
        jPanel4.add((Component)((Object)referenceEditorComboWithBrowseButton), new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("target.destination.folder"));
        jPanel4.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDestinationCb;
        jPanel4.add((Component)comboboxWithBrowseButton, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myUseExistingPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.gridwidth = 4;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 1;
        jPanel6.add((Component)jPanel3, gridBagConstraints3);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Name");
        jLabel4.setDisplayedMnemonic('N');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.existingClassField;
        jPanel3.add((Component)((Object)referenceEditorComboWithBrowseButton2), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myGenerateAccessorsCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Generate accessors");
        jCheckBox3.setMnemonic('G');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 2, 9, 0, 3, 0, null, null, null));
        this.myEscalateVisibilityCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Escalate visibility");
        jCheckBox2.setMnemonic('E');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateInnerClassRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Create inner class");
        jRadioButton2.setMnemonic('I');
        jRadioButton2.setDisplayedMnemonicIndex(7);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(10, 0, 0, 0);
        jPanel6.add((Component)jRadioButton2, gridBagConstraints4);
        this.myInnerClassPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.fill = 1;
        jPanel6.add((Component)jPanel2, gridBagConstraints5);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Name");
        jLabel5.setDisplayedMnemonic('N');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myInnerClassNameTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.useExistingClassButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use existing class");
        jRadioButton.setMnemonic('U');
        jRadioButton.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 4;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.insets = new Insets(10, 0, 0, 0);
        jPanel6.add((Component)jRadioButton, gridBagConstraints6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("com/intellij/refactoring/RefactorJBundle").getString("method.to.extract.parameters.from.label"), (int)0, (int)0, null, null));
        this.sourceMethodTextField = jTextField = new JTextField();
        jPanel7.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(400, -1), null));
        this.keepMethodAsDelegate = jCheckBox = new JCheckBox();
        jCheckBox.setText("Keep method as delegate");
        jCheckBox.setMnemonic('D');
        jCheckBox.setDisplayedMnemonicIndex(15);
        jPanel7.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myParamsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Parameters to Extract", (int)0, (int)0, null, null));
        jLabel.setLabelFor(jTextField3);
        jLabel3.setLabelFor((Component)comboboxWithBrowseButton);
        jLabel5.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

