/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMoveFilesOrDirectoriesHandler
extends MoveFilesOrDirectoriesHandler {
    @Override
    public PsiElement adjustTargetForMove(DataContext dataContext, PsiElement targetContainer) {
        PsiDirectory[] directories;
        Module module;
        if (targetContainer instanceof PsiPackage && (module = (Module)LangDataKeys.TARGET_MODULE.getData(dataContext)) != null && (directories = ((PsiPackage)targetContainer).getDirectories(GlobalSearchScope.moduleScope((Module)module))).length == 1) {
            return directories[0];
        }
        return super.adjustTargetForMove(dataContext, targetContainer);
    }

    @Override
    public boolean canMove(PsiElement[] elements, PsiElement targetContainer) {
        Project project;
        PsiElement[] adjustForMove;
        if (elements.length > 0 && (adjustForMove = this.adjustForMove(project = elements[0].getProject(), elements, targetContainer)) != null) {
            return super.canMove(adjustForMove, targetContainer);
        }
        return super.canMove(elements, targetContainer);
    }

    @Override
    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        if ((sourceElements = super.adjustForMove(project, sourceElements, targetElement)) == null) {
            return null;
        }
        LinkedHashSet<PsiElement> result = new LinkedHashSet<PsiElement>();
        for (PsiElement sourceElement : sourceElements) {
            result.add((PsiElement)(sourceElement instanceof PsiClass ? sourceElement.getContainingFile() : sourceElement));
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    @Override
    public void doMove(final Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        if ((elements = super.adjustForMove(project, elements, targetContainer)) == null) {
            return;
        }
        MoveFilesOrDirectoriesUtil.doMove(project, elements, new PsiElement[]{targetContainer}, callback, new Function<PsiElement[], PsiElement[]>(){

            public PsiElement[] fun(final PsiElement[] elements) {
                return (PsiElement[])new WriteCommandAction<PsiElement[]>(project, "Regrouping ...", new PsiFile[0]){

                    protected void run(@NotNull Result<PsiElement[]> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/move/moveFilesOrDirectories/JavaMoveFilesOrDirectoriesHandler$1$1", "run"));
                        }
                        ArrayList<Object> adjustedElements = new ArrayList<Object>();
                        for (PsiElement element : elements) {
                            PsiClass topLevelClass;
                            if (element instanceof PsiClass && (topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element)) != null) {
                                elements[i] = topLevelClass;
                                PsiFile containingFile = JavaMoveFilesOrDirectoriesHandler.obtainContainingFile((PsiElement)topLevelClass, elements);
                                if (containingFile != null && !adjustedElements.contains(containingFile)) {
                                    adjustedElements.add(containingFile);
                                    continue;
                                }
                            }
                            adjustedElements.add(element);
                        }
                        result.setResult((Object)PsiUtilCore.toPsiElementArray(adjustedElements));
                    }
                }.execute().getResultObject();
            }
        });
    }

    @Nullable
    private static PsiFile obtainContainingFile(@NotNull PsiElement element, PsiElement[] elements) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/move/moveFilesOrDirectories/JavaMoveFilesOrDirectoriesHandler", "obtainContainingFile"));
        }
        PsiFile containingFile = element.getContainingFile();
        PsiClass[] classes = ((PsiClassOwner)containingFile).getClasses();
        HashSet<PsiClass> nonMovedClasses = new HashSet<PsiClass>();
        for (PsiClass aClass : classes) {
            if (ArrayUtilRt.find((Object[])elements, (Object)aClass) >= 0) continue;
            nonMovedClasses.add(aClass);
        }
        if (nonMovedClasses.isEmpty()) {
            return containingFile;
        }
        PsiDirectory containingDirectory = containingFile.getContainingDirectory();
        if (containingDirectory != null) {
            try {
                JavaDirectoryServiceImpl.checkCreateClassOrInterface(containingDirectory, ((PsiClass)element).getName());
                PsiElement createdClass = containingDirectory.add(element);
                element.delete();
                return createdClass.getContainingFile();
            }
            catch (IncorrectOperationException e) {
                Iterator iterator = nonMovedClasses.iterator();
                PsiClass nonMovedClass = (PsiClass)iterator.next();
                PsiFile createdFile = containingDirectory.add((PsiElement)nonMovedClass).getContainingFile();
                nonMovedClass.delete();
                while (iterator.hasNext()) {
                    PsiClass currentClass = (PsiClass)iterator.next();
                    createdFile.add((PsiElement)currentClass);
                    currentClass.delete();
                }
                return containingFile;
            }
        }
        return null;
    }
}

