/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassTypeArgumentMigrationProcessor {
    private static final Logger LOG = Logger.getInstance((String)("#" + ClassTypeArgumentMigrationProcessor.class.getName()));
    private final TypeMigrationLabeler myLabeler;

    public ClassTypeArgumentMigrationProcessor(TypeMigrationLabeler labeler) {
        this.myLabeler = labeler;
    }

    public void migrateClassTypeParameter(PsiReferenceParameterList referenceParameterList, PsiType migrationType) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiClass.class);
        LOG.assertTrue(psiClass != null);
        PsiClass superClass = psiClass.getSuperClass();
        LOG.assertTrue(superClass != null);
        this.myLabeler.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)superClass), migrationType);
        HashMap<PsiElement, Pair<PsiReference[], PsiType>> roots = new HashMap<PsiElement, Pair<PsiReference[], PsiType>>();
        this.markTypeParameterUsages(psiClass, migrationType, referenceParameterList, roots);
        HashSet<PsiElement> processed2 = new HashSet<PsiElement>();
        for (Map.Entry entry : roots.entrySet()) {
            PsiReference[] references;
            PsiElement member = (PsiElement)entry.getKey();
            PsiType type = (PsiType)((Pair)entry.getValue()).second;
            if (member instanceof PsiParameter && ((PsiParameter)member).getDeclarationScope() instanceof PsiMethod) {
                this.myLabeler.migrateMethodCallExpressions(type, (PsiParameter)member, psiClass);
            }
            for (PsiReference usage : references = (PsiReference[])((Pair)entry.getValue()).first) {
                this.myLabeler.migrateRootUsageExpression(usage, processed2);
            }
        }
    }

    private void markTypeParameterUsages(final PsiClass psiClass, PsiType migrationType, PsiReferenceParameterList referenceParameterList, final Map<PsiElement, Pair<PsiReference[], PsiType>> roots) {
        Map<PsiClass, PsiTypeParameter[]> visibleTypeParams = ClassTypeArgumentMigrationProcessor.getTypeParametersHierarchy(referenceParameterList);
        final PsiSubstitutor substitutor = ClassTypeArgumentMigrationProcessor.composeSubstitutor(psiClass.getProject(), migrationType, visibleTypeParams);
        for (Map.Entry<PsiClass, PsiTypeParameter[]> entry : visibleTypeParams.entrySet()) {
            final TypeParameterSearcher parameterSearcher = new TypeParameterSearcher(entry.getValue());
            entry.getKey().accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitMethod(PsiMethod method) {
                    super.visitMethod(method);
                    ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)method, parameterSearcher, psiClass, substitutor, roots);
                    for (PsiParameter parameter : method.getParameterList().getParameters()) {
                        ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)parameter, parameterSearcher, psiClass, substitutor, roots);
                    }
                }

                public void visitField(PsiField field) {
                    super.visitField(field);
                    ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)field, parameterSearcher, psiClass, substitutor, roots);
                }
            });
        }
    }

    private void processMemberType(PsiElement element, TypeParameterSearcher parameterSearcher, PsiClass psiClass, PsiSubstitutor substitutor, Map<PsiElement, Pair<PsiReference[], PsiType>> roots) {
        PsiType elementType = TypeMigrationLabeler.getElementType(element);
        if (elementType != null && ((Boolean)elementType.accept((PsiTypeVisitor)parameterSearcher)).booleanValue()) {
            PsiType memberType = substitutor.substitute(elementType);
            this.prepareMethodsChangeSignature(psiClass, element, memberType);
            List<PsiReference> refs = TypeMigrationLabeler.filterReferences(psiClass, (Query<PsiReference>)ReferencesSearch.search((PsiElement)element, (SearchScope)psiClass.getUseScope()));
            roots.put(element, (Pair<PsiReference[], PsiType>)Pair.create((Object)this.myLabeler.markRootUsages(element, memberType, refs.toArray(new PsiReference[refs.size()])), (Object)memberType));
        }
    }

    private static PsiSubstitutor composeSubstitutor(Project project, PsiType migrationType, Map<PsiClass, PsiTypeParameter[]> visibleTypeParams) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiResolveHelper psiResolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
        for (Map.Entry<PsiClass, PsiTypeParameter[]> entry : visibleTypeParams.entrySet()) {
            PsiClassType clearedOriginalType = JavaPsiFacade.getElementFactory((Project)project).createType(entry.getKey(), PsiSubstitutor.EMPTY);
            for (PsiTypeParameter parameter : entry.getValue()) {
                substitutor = substitutor.put(parameter, psiResolveHelper.getSubstitutionForTypeParameter(parameter, (PsiType)clearedOriginalType, migrationType, true, clearedOriginalType.getLanguageLevel()));
            }
        }
        return substitutor;
    }

    private static Map<PsiClass, PsiTypeParameter[]> getTypeParametersHierarchy(PsiReferenceParameterList referenceParameterList) {
        PsiElement parent = referenceParameterList.getParent();
        LOG.assertTrue(parent instanceof PsiJavaCodeReferenceElement);
        PsiClass superClass = (PsiClass)((PsiJavaCodeReferenceElement)parent).resolve();
        LOG.assertTrue(superClass != null);
        HashMap<PsiClass, PsiTypeParameter[]> visibleTypeParams = new HashMap<PsiClass, PsiTypeParameter[]>();
        visibleTypeParams.put(superClass, superClass.getTypeParameters());
        HashSet superClasses = new HashSet();
        InheritanceUtil.getSuperClasses((PsiClass)superClass, superClasses, (boolean)true);
        for (PsiClass superSuperClass : superClasses) {
            visibleTypeParams.put(superSuperClass, superSuperClass.getTypeParameters());
        }
        return visibleTypeParams;
    }

    private void prepareMethodsChangeSignature(PsiClass currentClass, PsiElement memberToChangeSignature, PsiType memberType) {
        if (memberToChangeSignature instanceof PsiMethod) {
            PsiMethod method = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)currentClass, (PsiMethod)((PsiMethod)memberToChangeSignature), (boolean)true);
            if (method != null && method.getContainingClass() == currentClass) {
                this.myLabeler.addRoot(new TypeMigrationUsageInfo((PsiElement)method), memberType, (PsiElement)method, false);
            }
        } else if (memberToChangeSignature instanceof PsiParameter && ((PsiParameter)memberToChangeSignature).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod superMethod = (PsiMethod)((PsiParameter)memberToChangeSignature).getDeclarationScope();
            int parameterIndex = superMethod.getParameterList().getParameterIndex((PsiParameter)memberToChangeSignature);
            PsiMethod method = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)currentClass, (PsiMethod)superMethod, (boolean)true);
            if (method != null && method.getContainingClass() == currentClass) {
                PsiParameter parameter = method.getParameterList().getParameters()[parameterIndex];
                this.myLabeler.addRoot(new TypeMigrationUsageInfo((PsiElement)parameter), memberType, (PsiElement)parameter, false);
            }
        }
    }

    private static class TypeParameterSearcher
    extends PsiTypeVisitor<Boolean> {
        private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

        private TypeParameterSearcher(PsiTypeParameter[] set) {
            ContainerUtil.addAll(this.myTypeParams, (Object[])set);
        }

        public Boolean visitType(PsiType type) {
            return false;
        }

        public Boolean visitArrayType(PsiArrayType arrayType) {
            return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
        }

        public Boolean visitClassType(PsiClassType classType) {
            PsiType[] types;
            PsiClass aClass = classType.resolve();
            if (aClass instanceof PsiTypeParameter && this.myTypeParams.contains((PsiTypeParameter)aClass)) {
                return true;
            }
            for (PsiType psiType : types = classType.getParameters()) {
                if (!((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            return bound != null && (Boolean)bound.accept((PsiTypeVisitor)this) != false;
        }
    }
}

