/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.duplicates.DuplicatesImpl");

    private DuplicatesImpl() {
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull MatchProvider provider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "invoke"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "invoke"));
        }
        DuplicatesImpl.invoke(project, editor, provider, true);
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull MatchProvider provider, boolean skipPromptWhenOne) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "invoke"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "invoke"));
        }
        List<Match> duplicates = provider.getDuplicates();
        int idx = 0;
        Ref showAll = new Ref();
        String confirmDuplicatePrompt = DuplicatesImpl.getConfirmationPrompt(provider, duplicates);
        for (Match match : duplicates) {
            if (!match.getMatchStart().isValid() || !match.getMatchEnd().isValid() || !DuplicatesImpl.replaceMatch(project, provider, match, editor, ++idx, duplicates.size(), (Ref<Boolean>)showAll, confirmDuplicatePrompt, skipPromptWhenOne)) continue;
            return;
        }
    }

    public static void invoke(Project project, MatchProvider provider) {
        List<Match> duplicates = provider.getDuplicates();
        int idx = 0;
        Ref showAll = new Ref();
        String confirmDuplicatePrompt = DuplicatesImpl.getConfirmationPrompt(provider, duplicates);
        for (Match match : duplicates) {
            PsiFile file = match.getFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), false);
            LOG.assertTrue(editor != null);
            if (!match.getMatchStart().isValid() || !match.getMatchEnd().isValid() || !DuplicatesImpl.replaceMatch(project, provider, match, editor, ++idx, duplicates.size(), (Ref<Boolean>)showAll, confirmDuplicatePrompt, false)) continue;
            return;
        }
    }

    @Nullable
    private static String getConfirmationPrompt(MatchProvider provider, List<Match> duplicates) {
        Match duplicate;
        String confirmDuplicatePrompt = null;
        Iterator<Match> iterator = duplicates.iterator();
        while (iterator.hasNext() && (confirmDuplicatePrompt = provider.getConfirmDuplicatePrompt(duplicate = iterator.next())) == null) {
        }
        return confirmDuplicatePrompt;
    }

    private static boolean replaceMatch(Project project, final MatchProvider provider, final Match match, @NotNull Editor editor, int idx, int size, Ref<Boolean> showAll, String confirmDuplicatePrompt, boolean skipPromptWhenOne) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "replaceMatch"));
        }
        ArrayList<RangeHighlighter> highlighters = DuplicatesImpl.previewMatch(project, match, editor);
        if (!(ApplicationManager.getApplication().isUnitTestMode() || skipPromptWhenOne && size <= 1 || showAll.get() != null && ((Boolean)showAll.get()).booleanValue())) {
            final String prompt = provider.getConfirmDuplicatePrompt(match);
            ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, provider.getReplaceDuplicatesTitle(idx, size), project){

                @Override
                protected String getMessage() {
                    String message = super.getMessage();
                    return prompt != null ? message + prompt : message;
                }
            };
            promptDialog.show();
            boolean allChosen = promptDialog.getExitCode() == 3;
            showAll.set((Object)allChosen);
            if (allChosen && confirmDuplicatePrompt != null && prompt == null && Messages.showOkCancelDialog((Project)project, (String)"In order to replace all occurrences method signature will be changed. Proceed?", (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) != 0) {
                return true;
            }
            if (promptDialog.getExitCode() == 2) {
                return false;
            }
            if (promptDialog.getExitCode() == 1) {
                return true;
            }
        }
        HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, highlighters.get(0));
        new WriteCommandAction(project, MethodDuplicatesHandler.REFACTORING_NAME, MethodDuplicatesHandler.REFACTORING_NAME, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/util/duplicates/DuplicatesImpl$2", "run"));
                }
                try {
                    provider.processMatch(match);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }.execute();
        return false;
    }

    public static ArrayList<RangeHighlighter> previewMatch(Project project, Match match, Editor editor) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        DuplicatesImpl.highlightMatch(project, editor, match, highlighters);
        TextRange textRange = match.getTextRange();
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
        DuplicatesImpl.expandAllRegionsCoveringRange(project, editor, textRange);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
        return highlighters;
    }

    private static void expandAllRegionsCoveringRange(Project project, Editor editor, TextRange textRange) {
        final FoldRegion[] foldRegions = CodeFoldingManager.getInstance(project).getFoldRegionsAtOffset(editor, textRange.getStartOffset());
        boolean anyCollapsed = false;
        for (FoldRegion foldRegion : foldRegions) {
            if (foldRegion.isExpanded()) continue;
            anyCollapsed = true;
            break;
        }
        if (anyCollapsed) {
            editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    for (FoldRegion foldRegion : foldRegions) {
                        if (foldRegion.isExpanded()) continue;
                        foldRegion.setExpanded(true);
                    }
                }
            });
        }
    }

    public static void highlightMatch(Project project, Editor editor, Match match, ArrayList<RangeHighlighter> highlighters) {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, match.getTextRange().getStartOffset(), match.getTextRange().getEndOffset(), attributes, true, highlighters);
    }

    public static void processDuplicates(@NotNull MatchProvider provider, @NotNull Project project, @NotNull Editor editor) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "processDuplicates"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "processDuplicates"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/util/duplicates/DuplicatesImpl", "processDuplicates"));
        }
        Boolean hasDuplicates = provider.hasDuplicates();
        if (hasDuplicates == null || hasDuplicates.booleanValue()) {
            int answer;
            List<Match> duplicates = provider.getDuplicates();
            if (duplicates.size() == 1) {
                DuplicatesImpl.previewMatch(project, duplicates.get(0), editor);
            }
            int n = answer = ApplicationManager.getApplication().isUnitTestMode() || hasDuplicates == null ? 0 : Messages.showYesNoDialog((Project)project, (String)RefactoringBundle.message((String)"0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.method", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), duplicates.size()}), (String)"Process Duplicates", (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                DuplicatesImpl.invoke(project, editor, provider, hasDuplicates != null);
            }
        }
    }
}

