/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class ScriptSupport {
    private final Script script;

    public ScriptSupport(String text, String name) {
        File scriptFile = new File(text);
        GroovyShell shell = new GroovyShell();
        try {
            this.script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(text, name);
        }
        catch (Exception ex) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public String evaluate(MatchResult result, PsiElement context) {
        try {
            Binding binding = new Binding();
            if (result != null) {
                for (MatchResult r : result.getAllSons()) {
                    if (r.isMultipleMatch()) {
                        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                        for (MatchResult r2 : r.getAllSons()) {
                            elements.add(StructuralSearchUtil.getParentIfIdentifier(r2.getMatch()));
                        }
                        binding.setVariable(r.getName(), elements);
                        continue;
                    }
                    binding.setVariable(r.getName(), (Object)StructuralSearchUtil.getParentIfIdentifier(r.getMatch()));
                }
            }
            if (context == null) {
                context = result.getMatch();
            }
            context = StructuralSearchUtil.getParentIfIdentifier(context);
            binding.setVariable("__context__", (Object)context);
            this.script.setBinding(binding);
            Object o = this.script.run();
            String string = String.valueOf(o);
            return string;
        }
        catch (GroovyRuntimeException ex) {
            throw new StructuralSearchException(SSRBundle.message("groovy.script.error", ex.getMessage()));
        }
        finally {
            this.script.setBinding(null);
        }
    }

    public static String checkValidScript(String scriptText) {
        try {
            File scriptFile = new File(scriptText);
            GroovyShell shell = new GroovyShell();
            Script script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(scriptText);
            return null;
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (MultipleCompilationErrorsException e) {
            ErrorCollector errorCollector = e.getErrorCollector();
            List errors = errorCollector.getErrors();
            for (Message error : errors) {
                if (!(error instanceof SyntaxErrorMessage)) continue;
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)error;
                SyntaxException cause = errorMessage.getCause();
                return cause.getMessage();
            }
            return e.getMessage();
        }
        catch (CompilationFailedException ex) {
            return ex.getLocalizedMessage();
        }
    }
}

