/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRunLineMarkerProvider
extends RunLineMarkerContributor {
    private static final Function<PsiElement, String> TOOLTIP_PROVIDER = new Function<PsiElement, String>(){

        public String fun(PsiElement element) {
            return "Run Test";
        }
    };

    @Override
    @Nullable
    public RunLineMarkerContributor.Info getInfo(PsiElement e) {
        if (this.isIdentifier(e)) {
            TestFramework framework;
            PsiClass psiClass;
            TestFramework framework2;
            PsiElement element = e.getParent();
            if (element instanceof PsiClass && (framework2 = TestFrameworks.detectFramework((PsiClass)((PsiClass)element))) != null && framework2.isTestClass(element)) {
                String url = "java:suite://" + ((PsiClass)element).getQualifiedName();
                return this.getInfo(url, framework2, e.getProject());
            }
            if (element instanceof PsiMethod && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null && (framework = TestFrameworks.detectFramework((PsiClass)psiClass)) != null && framework.isTestMethod(element)) {
                String url = "java:test://" + psiClass.getQualifiedName() + "." + ((PsiMethod)element).getName();
                return this.getInfo(url, framework, e.getProject());
            }
        }
        return null;
    }

    @NotNull
    protected RunLineMarkerContributor.Info getInfo(String url, TestFramework framework, Project project) {
        Icon icon = TestRunLineMarkerProvider.getTestStateIcon(url, project);
        RunLineMarkerContributor.Info info = new RunLineMarkerContributor.Info(icon == null ? framework.getIcon() : icon, TOOLTIP_PROVIDER, ExecutorAction.getActions(1));
        if (info == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/TestRunLineMarkerProvider", "getInfo"));
        }
        return info;
    }

    protected boolean isIdentifier(PsiElement e) {
        return e instanceof PsiIdentifier;
    }

    private static Icon getTestStateIcon(String url, Project project) {
        TestStateStorage.Record state = TestStateStorage.getInstance(project).getState(url);
        if (state == null) {
            return null;
        }
        TestStateInfo.Magnitude magnitude = TestIconMapper.getMagnitude((int)state.magnitude);
        return TestIconMapper.getIcon((TestStateInfo.Magnitude)magnitude);
    }
}

