/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileMetaDataRegistryImpl
implements ConfigFileMetaDataRegistry {
    private final List<ConfigFileMetaData> myMetaData = new ArrayList<ConfigFileMetaData>();
    private final Map<String, ConfigFileMetaData> myId2MetaData = new HashMap<String, ConfigFileMetaData>();
    private ConfigFileMetaData[] myCachedMetaData;

    public ConfigFileMetaDataRegistryImpl() {
    }

    public ConfigFileMetaDataRegistryImpl(ConfigFileMetaData[] metaDatas) {
        for (ConfigFileMetaData metaData : metaDatas) {
            this.registerMetaData(metaData);
        }
    }

    @NotNull
    public ConfigFileMetaData[] getMetaData() {
        if (this.myCachedMetaData == null) {
            this.myCachedMetaData = this.myMetaData.toArray(new ConfigFileMetaData[this.myMetaData.size()]);
        }
        if (this.myCachedMetaData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/descriptors/impl/ConfigFileMetaDataRegistryImpl", "getMetaData"));
        }
        return this.myCachedMetaData;
    }

    @Nullable
    public ConfigFileMetaData findMetaData(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/util/descriptors/impl/ConfigFileMetaDataRegistryImpl", "findMetaData"));
        }
        return this.myId2MetaData.get(id);
    }

    public void registerMetaData(ConfigFileMetaData ... metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/util/descriptors/impl/ConfigFileMetaDataRegistryImpl", "registerMetaData"));
        }
        for (ConfigFileMetaData data2 : metaData) {
            this.myMetaData.add(data2);
            this.myId2MetaData.put(data2.getId(), data2);
        }
        this.myCachedMetaData = null;
    }
}

