/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckEmptyTagInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckTagEmptyBodyInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ASTNode node;
                ASTNode child;
                if (!CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag) && (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) != null && (node = child.getTreeNext()) != null && node.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    Fix localQuickFix = new Fix();
                    holder.registerProblem((PsiElement)tag, XmlBundle.message((String)"xml.inspections.tag.empty.body", (Object[])new Object[0]), new LocalQuickFix[]{CheckTagEmptyBodyInspection.isCollapsibleTag(tag) ? localQuickFix : null});
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static boolean isCollapsibleTag(XmlTag tag) {
        String name = tag.getName().toLowerCase();
        return tag.getLanguage() == XMLLanguage.INSTANCE || "link".equals(name) || "br".equals(name) || "meta".equals(name) || "img".equals(name) || "input".equals(name) || "hr".equals(name);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.check.tag.empty.body", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckTagEmptyBody" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection", "getShortName"));
        }
        return "CheckTagEmptyBody";
    }

    public static class Fix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            String string = XmlBundle.message((String)"xml.inspections.replace.tag.empty.body.with.empty.end", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix", "applyFix"));
            }
            final PsiElement tag = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().prepareFileForWrite(tag.getContainingFile())) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
            if (child == null) {
                return;
            }
            final int offset = child.getTextRange().getStartOffset();
            VirtualFile file = tag.getContainingFile().getVirtualFile();
            final Document document = FileDocumentManager.getInstance().getDocument(file);
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xml/util/CheckTagEmptyBodyInspection$Fix$1", "run"));
                    }
                    document.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
                }
            }.execute();
        }
    }
}

