/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryBoxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyBoxed = false;
    @NonNls
    static final Map<String, String> boxedPrimitiveMap = new HashMap<String, String>(8);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.boxing.superfluous.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportSuperfluouslyBoxed");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBoxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    static {
        boxedPrimitiveMap.put("java.lang.Integer", "int");
        boxedPrimitiveMap.put("java.lang.Short", "short");
        boxedPrimitiveMap.put("java.lang.Boolean", "boolean");
        boxedPrimitiveMap.put("java.lang.Long", "long");
        boxedPrimitiveMap.put("java.lang.Byte", "byte");
        boxedPrimitiveMap.put("java.lang.Float", "float");
        boxedPrimitiveMap.put("java.lang.Double", "double");
        boxedPrimitiveMap.put("java.lang.Character", "char");
    }

    private class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiType expectedType;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiType constructorType = expression.getType();
            if (constructorType == null) {
                return;
            }
            String constructorTypeText = constructorType.getCanonicalText();
            if (!boxedPrimitiveMap.containsKey(constructorTypeText)) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[0];
            PsiType parameterType = parameter.getType();
            String parameterTypeText = parameterType.getCanonicalText();
            String boxableConstructorType = boxedPrimitiveMap.get(constructorTypeText);
            if (!boxableConstructorType.equals(parameterTypeText)) {
                return;
            }
            if (!this.canBeUnboxed((PsiCallExpression)expression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            if (!(arguments[0].getType() instanceof PsiPrimitiveType)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String canonicalText = referenceExpression.getCanonicalText();
            if (!boxedPrimitiveMap.containsKey(canonicalText)) {
                return;
            }
            if (!this.canBeUnboxed((PsiCallExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean canBeUnboxed(PsiCallExpression expression) {
            PsiCallExpression containingMethodCallExpression;
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiReferenceExpression) {
                return false;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                if (TypeUtils.isTypeParameter(castExpression.getType())) {
                    return false;
                }
            } else {
                if (parent instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                    PsiExpression thenExpression = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression = conditionalExpression.getElseExpression();
                    if (elseExpression == null || thenExpression == null) {
                        return false;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)thenExpression, (PsiElement)expression, (boolean)false)) {
                        PsiType type = elseExpression.getType();
                        return type instanceof PsiPrimitiveType;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)expression, (boolean)false)) {
                        PsiType type = thenExpression.getType();
                        return type instanceof PsiPrimitiveType;
                    }
                    return true;
                }
                if (parent instanceof PsiBinaryExpression) {
                    PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
                    PsiExpression lhs = binaryExpression.getLOperand();
                    PsiExpression rhs = binaryExpression.getROperand();
                    if (rhs == null) {
                        return false;
                    }
                    return PsiTreeUtil.isAncestor((PsiElement)rhs, (PsiElement)expression, (boolean)false) ? this.canBinaryExpressionBeUnboxed(lhs, rhs) : this.canBinaryExpressionBeUnboxed(rhs, lhs);
                }
            }
            return (containingMethodCallExpression = this.getParentMethodCallExpression((PsiElement)expression)) == null || this.isSameMethodCalledWithoutBoxing(containingMethodCallExpression, expression);
        }

        private boolean canBinaryExpressionBeUnboxed(PsiExpression lhs, PsiExpression rhs) {
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            if (!(lhsType instanceof PsiPrimitiveType) && !ExpressionUtils.isAnnotatedNotNull(lhs)) {
                return false;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)rhsType);
            return unboxedType != null && unboxedType.isAssignableFrom(lhsType);
        }

        @Nullable
        private PsiCallExpression getParentMethodCallExpression(@NotNull PsiElement expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "getParentMethodCallExpression"));
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiExpressionList) {
                return this.getParentMethodCallExpression(parent);
            }
            if (parent instanceof PsiCallExpression) {
                return (PsiCallExpression)parent;
            }
            return null;
        }

        private boolean isSameMethodCalledWithoutBoxing(@NotNull PsiCallExpression methodCallExpression, @NotNull PsiCallExpression boxingExpression) {
            PsiMethod otherMethod;
            if (methodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "isSameMethodCalledWithoutBoxing"));
            }
            if (boxingExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxingExpression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "isSameMethodCalledWithoutBoxing"));
            }
            PsiExpressionList boxedArgumentList = boxingExpression.getArgumentList();
            if (boxedArgumentList == null) {
                return false;
            }
            PsiExpression[] arguments = boxedArgumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression unboxedExpression = arguments[0];
            PsiMethod originalMethod = methodCallExpression.resolveMethod();
            return originalMethod == (otherMethod = MethodCallUtils.findMethodWithReplacedArgument((PsiCall)methodCallExpression, (PsiExpression)boxingExpression, unboxedExpression));
        }
    }

    private static class UnnecessaryBoxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryBoxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "doFix"));
            }
            PsiCallExpression expression = (PsiCallExpression)descriptor.getPsiElement();
            PsiType boxedType = expression.getType();
            if (boxedType == null) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression unboxedExpression = arguments[0];
            PsiType unboxedType = unboxedExpression.getType();
            if (unboxedType == null) {
                return;
            }
            String cast = UnnecessaryBoxingFix.getCastString(unboxedType, boxedType);
            if (cast == null) {
                return;
            }
            int precedence = ParenthesesUtils.getPrecedence(unboxedExpression);
            if (!cast.isEmpty() && precedence > 4) {
                PsiReplacementUtil.replaceExpression((PsiExpression)expression, cast + '(' + unboxedExpression.getText() + ')');
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)expression, cast + unboxedExpression.getText());
            }
        }

        @Nullable
        private static String getCastString(@NotNull PsiType fromType, @NotNull PsiType toType) {
            if (fromType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getCastString"));
            }
            if (toType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getCastString"));
            }
            String toTypeText = toType.getCanonicalText();
            String fromTypeText = fromType.getCanonicalText();
            String unboxedType = boxedPrimitiveMap.get(toTypeText);
            if (unboxedType == null) {
                return null;
            }
            if (fromTypeText.equals(unboxedType)) {
                return "";
            }
            return '(' + unboxedType + ')';
        }
    }
}

