/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakestTypeFinder {
    private WeakestTypeFinder() {
    }

    @NotNull
    public static Collection<PsiClass> calculateWeakestClassesNecessary(@NotNull PsiElement variableOrMethod, boolean useRighthandTypeAsWeakestTypeInAssignments, boolean useParameterizedTypeForCollectionMethods) {
        PsiClass lowerBoundClass;
        PsiType variableOrMethodType;
        if (variableOrMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableOrMethod", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
        }
        if (variableOrMethod instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)variableOrMethod;
            variableOrMethodType = variable.getType();
        } else if (variableOrMethod instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)variableOrMethod;
            variableOrMethodType = method.getReturnType();
            if (PsiType.VOID.equals((Object)variableOrMethodType)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                }
                return list;
            }
        } else {
            throw new IllegalArgumentException("PsiMethod or PsiVariable expected: " + variableOrMethod);
        }
        if (!(variableOrMethodType instanceof PsiClassType)) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
            }
            return list;
        }
        PsiClassType variableOrMethodClassType = (PsiClassType)variableOrMethodType;
        PsiClass variableOrMethodClass = variableOrMethodClassType.resolve();
        if (variableOrMethodClass == null || variableOrMethodClass instanceof PsiTypeParameter) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
            }
            return list;
        }
        Set<PsiClass> weakestTypeClasses = new HashSet<PsiClass>();
        GlobalSearchScope scope = variableOrMethod.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)variableOrMethod.getProject());
        if (variableOrMethod instanceof PsiResourceVariable) {
            lowerBoundClass = facade.findClass("java.lang.AutoCloseable", scope);
            if (lowerBoundClass == null || variableOrMethodClass.equals(lowerBoundClass)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                }
                return list;
            }
            weakestTypeClasses.add(lowerBoundClass);
            PsiResourceVariable resourceVariable = (PsiResourceVariable)variableOrMethod;
            String methodCallText = resourceVariable.getName() + ".close()";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)facade.getElementFactory().createExpressionFromText(methodCallText, resourceVariable.getParent());
            if (!WeakestTypeFinder.findWeakestType(methodCallExpression, weakestTypeClasses)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                }
                return list;
            }
        } else {
            lowerBoundClass = facade.findClass("java.lang.Object", scope);
            if (lowerBoundClass == null || variableOrMethodClass.equals(lowerBoundClass)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                }
                return list;
            }
            weakestTypeClasses.add(lowerBoundClass);
        }
        Query query = ReferencesSearch.search((PsiElement)variableOrMethod, (SearchScope)variableOrMethod.getUseScope());
        boolean hasUsages = false;
        for (PsiReference reference : query) {
            PsiType type;
            PsiMethodCallExpression methodCallExpression;
            PsiType type2;
            if (reference == null) continue;
            hasUsages = true;
            PsiElement referenceElement = reference.getElement();
            PsiElement referenceParent = referenceElement.getParent();
            if (referenceParent instanceof PsiMethodCallExpression) {
                referenceElement = referenceParent;
                referenceParent = referenceElement.getParent();
            }
            PsiElement referenceGrandParent = referenceParent.getParent();
            if (reference instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)reference;
                type2 = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type2);
                if (!PsiType.VOID.equals((Object)returnType) && !WeakestTypeFinder.checkType(returnType, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiExpressionList) {
                if (!(referenceGrandParent instanceof PsiMethodCallExpression)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, methodCallExpression, useParameterizedTypeForCollectionMethods, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceGrandParent instanceof PsiMethodCallExpression) {
                methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (!WeakestTypeFinder.findWeakestType(methodCallExpression, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, assignmentExpression, useRighthandTypeAsWeakestTypeInAssignments, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)referenceParent;
                type2 = variable.getType();
                if (!type2.isAssignableFrom(variableOrMethodType) || !WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)referenceParent;
                if (!Comparing.equal((Object)foreachStatement.getIteratedValue(), (Object)referenceElement)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                PsiClass javaLangIterableClass = facade.findClass("java.lang.Iterable", scope);
                if (javaLangIterableClass == null) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                WeakestTypeFinder.checkClass(javaLangIterableClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiReturnStatement) {
                PsiElement owner = PsiTreeUtil.getParentOfType((PsiElement)referenceParent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                if (owner instanceof PsiMethod) {
                    type2 = ((PsiMethod)owner).getReturnType();
                } else if (owner instanceof PsiLambdaExpression) {
                    type2 = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)owner));
                } else {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                if (!WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)referenceParent;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiField)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                PsiField field = (PsiField)target;
                PsiClass containingClass = field.getContainingClass();
                WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(arrayInitializerExpression, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiThrowStatement) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(throwStatement, variableOrMethodClass, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)referenceParent;
                PsiExpression condition = conditionalExpression.getCondition();
                if (referenceElement.equals(condition)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                type = ExpectedTypeUtils.findExpectedType((PsiExpression)conditionalExpression, true);
                if (!WeakestTypeFinder.checkType(type, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)referenceParent;
                type2 = binaryExpression.getType();
                if (variableOrMethodType.equals(type2) && !WeakestTypeFinder.checkType(type2, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
            } else {
                PsiNewExpression newExpression;
                PsiExpression qualifier;
                if (referenceParent instanceof PsiSwitchStatement) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                if (referenceParent instanceof PsiPrefixExpression) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                if (referenceParent instanceof PsiPostfixExpression) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                if (referenceParent instanceof PsiIfStatement) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                if (referenceParent instanceof PsiForStatement) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                    }
                    return list;
                }
                if (referenceParent instanceof PsiNewExpression && (qualifier = (newExpression = (PsiNewExpression)referenceParent).getQualifier()) != null) {
                    type = newExpression.getType();
                    if (!(type instanceof PsiClassType)) {
                        List<PsiClass> list = Collections.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                        }
                        return list;
                    }
                    PsiClassType classType = (PsiClassType)type;
                    PsiClass innerClass = classType.resolve();
                    if (innerClass == null) {
                        List<PsiClass> list = Collections.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
                        }
                        return list;
                    }
                    PsiClass outerClass = innerClass.getContainingClass();
                    if (outerClass != null) {
                        WeakestTypeFinder.checkClass(outerClass, weakestTypeClasses);
                    }
                }
            }
            if (!weakestTypeClasses.contains(variableOrMethodClass) && !weakestTypeClasses.isEmpty()) continue;
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
            }
            return list;
        }
        if (!hasUsages) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
            }
            return list;
        }
        Set<PsiClass> set = weakestTypeClasses = WeakestTypeFinder.filterAccessibleClasses(weakestTypeClasses, variableOrMethodClass, variableOrMethod);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/WeakestTypeFinder", "calculateWeakestClassesNecessary"));
        }
        return set;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiMethodCallExpression methodCallExpression, boolean useParameterizedTypeForCollectionMethods, Set<PsiClass> weakestTypeClasses) {
        PsiClassType classType;
        PsiType[] parameterTypes;
        PsiType qualifierType;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifier;
        PsiClass containingClass;
        PsiType type;
        if (!(referenceElement instanceof PsiExpression)) {
            return false;
        }
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null) {
            return false;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiExpressionList expressionList = methodCallExpression.getArgumentList();
        Object[] expressions = expressionList.getExpressions();
        int index = ArrayUtil.indexOf((Object[])expressions, (Object)referenceElement);
        if (index < 0) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 0) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (index < parameters.length) {
            PsiParameter parameter = parameters[index];
            type = parameter.getType();
        } else {
            PsiParameter parameter = parameters[parameters.length - 1];
            type = parameter.getType();
            if (!(type instanceof PsiEllipsisType)) {
                return false;
            }
        }
        if (!useParameterizedTypeForCollectionMethods) {
            return WeakestTypeFinder.checkType(type, substitutor, weakestTypeClasses);
        }
        String methodName = method.getName();
        if (("remove".equals(methodName) || "get".equals(methodName) || "containsKey".equals(methodName) || "containsValue".equals(methodName) || "contains".equals(methodName) || "indexOf".equals(methodName) || "lastIndexOf".equals(methodName)) && (InheritanceUtil.isInheritor((PsiClass)(containingClass = method.getContainingClass()), (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection")) && (qualifier = (methodExpression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (parameterTypes = (classType = (PsiClassType)qualifierType).getParameters()).length > 0) {
            PsiType parameterType = parameterTypes[0];
            Object expression = expressions[index];
            PsiType expressionType = expression.getType();
            if (expressionType == null || parameterType == null || !parameterType.isAssignableFrom(expressionType)) {
                return false;
            }
            return WeakestTypeFinder.checkType(parameterType, substitutor, weakestTypeClasses);
        }
        return WeakestTypeFinder.checkType(type, substitutor, weakestTypeClasses);
    }

    private static boolean checkType(@Nullable PsiType type, @NotNull PsiSubstitutor substitutor, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/siyeh/ig/psiutils/WeakestTypeFinder", "checkType"));
        }
        if (weakestTypeClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weakestTypeClasses", "com/siyeh/ig/psiutils/WeakestTypeFinder", "checkType"));
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter) {
            PsiType substitution = substitutor.substitute((PsiTypeParameter)aClass);
            return WeakestTypeFinder.checkType(substitution, weakestTypeClasses);
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    private static boolean findWeakestType(PsiMethodCallExpression methodCallExpression, Set<PsiClass> weakestTypeClasses) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiClassType[] classTypes = throwsList.getReferencedTypes();
        HashSet<PsiClassType> thrownTypes = new HashSet<PsiClassType>(Arrays.asList(classTypes));
        List<PsiMethod> superMethods = WeakestTypeFinder.findAllSuperMethods(method);
        boolean checked = false;
        if (!superMethods.isEmpty()) {
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)methodCallExpression, false);
            for (PsiMethod superMethod : superMethods) {
                PsiClass containingClass;
                PsiType returnType = superMethod.getReturnType();
                if (expectedType instanceof PsiClassType) {
                    if (!(returnType instanceof PsiClassType)) continue;
                    PsiClassType expectedClassType = (PsiClassType)expectedType;
                    expectedClassType.rawType().isAssignableFrom(returnType);
                } else if (expectedType != null && returnType != null && !expectedType.isAssignableFrom(returnType)) continue;
                if (WeakestTypeFinder.throwsIncompatibleException(superMethod, thrownTypes) || !PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)methodCallExpression, null) || !WeakestTypeFinder.checkClass(containingClass = superMethod.getContainingClass(), weakestTypeClasses)) continue;
                checked = true;
                break;
            }
        }
        if (!checked) {
            if (TypeUtils.isTypeParameter(method.getReturnType())) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
        }
        return true;
    }

    private static List<PsiMethod> findAllSuperMethods(PsiMethod method) {
        final ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

            public boolean process(MethodSignatureBackedByPsiMethod method) {
                result.add(method.getMethod());
                return true;
            }
        });
        Collections.sort(result, new Comparator<PsiMethod>(){

            @Override
            public int compare(PsiMethod method1, PsiMethod method2) {
                PsiClass aClass1 = method1.getContainingClass();
                PsiClass aClass2 = method2.getContainingClass();
                if (aClass1 == null || aClass2 == null || aClass1.equals(aClass2)) {
                    return 0;
                }
                if (aClass1.isInterface() && !aClass2.isInterface()) {
                    return -1;
                }
                if (!aClass1.isInterface() && aClass2.isInterface()) {
                    return 1;
                }
                if (aClass1.isInheritor(aClass2, true)) {
                    return 1;
                }
                if (aClass2.isInheritor(aClass1, true)) {
                    return -1;
                }
                String name1 = aClass1.getName();
                String name2 = aClass2.getName();
                return name1.compareTo(name2);
            }
        });
        return result;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiAssignmentExpression assignmentExpression, boolean useRighthandTypeAsWeakestTypeInAssignments, Set<PsiClass> weakestTypeClasses) {
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        if (JavaTokenType.EQ != tokenType) {
            return false;
        }
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        if (rhs == null) {
            return false;
        }
        PsiType lhsType = lhs.getType();
        PsiType rhsType = rhs.getType();
        if (lhsType == null || rhsType == null || !lhsType.isAssignableFrom(rhsType)) {
            return false;
        }
        return !(referenceElement.equals(rhs) ? !WeakestTypeFinder.checkType(lhsType, weakestTypeClasses) : useRighthandTypeAsWeakestTypeInAssignments && (!(rhs instanceof PsiNewExpression) || !(rhs instanceof PsiTypeCastExpression)) && lhsType.equals(rhsType));
    }

    private static boolean findWeakestType(PsiArrayInitializerExpression arrayInitializerExpression, Set<PsiClass> weakestTypeClasses) {
        PsiType type = arrayInitializerExpression.getType();
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiArrayType arrayType = (PsiArrayType)type;
        PsiType componentType = arrayType.getComponentType();
        return WeakestTypeFinder.checkType(componentType, weakestTypeClasses);
    }

    private static boolean findWeakestType(PsiThrowStatement throwStatement, PsiClass variableOrMethodClass, Set<PsiClass> weakestTypeClasses) {
        PsiClassType runtimeExceptionType = TypeUtils.getType("java.lang.RuntimeException", (PsiElement)throwStatement);
        PsiClass runtimeExceptionClass = runtimeExceptionType.resolve();
        if (runtimeExceptionClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)runtimeExceptionClass, (boolean)true)) {
            if (!WeakestTypeFinder.checkType((PsiType)runtimeExceptionType, weakestTypeClasses)) {
                return false;
            }
        } else {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)throwStatement, PsiMethod.class);
            if (method == null) {
                return false;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] referencedTypes = throwsList.getReferencedTypes();
            boolean checked = false;
            for (PsiClassType referencedType : referencedTypes) {
                PsiClass throwableClass = referencedType.resolve();
                if (throwableClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)throwableClass, (boolean)true) || !WeakestTypeFinder.checkType((PsiType)referencedType, weakestTypeClasses)) continue;
                checked = true;
                break;
            }
            if (!checked) {
                return false;
            }
        }
        return true;
    }

    private static boolean throwsIncompatibleException(PsiMethod method, Collection<PsiClassType> exceptionTypes) {
        PsiClassType[] superThrownTypes;
        PsiReferenceList superThrowsList = method.getThrowsList();
        block0: for (PsiClassType superThrownType : superThrownTypes = superThrowsList.getReferencedTypes()) {
            if (exceptionTypes.contains(superThrownType)) continue;
            for (PsiClassType exceptionType : exceptionTypes) {
                if (!InheritanceUtil.isInheritor((PsiType)superThrownType, (String)exceptionType.getCanonicalText())) continue;
                continue block0;
            }
            PsiClass aClass = superThrownType.resolve();
            if (aClass == null) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Error")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkType(@Nullable PsiType type, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (weakestTypeClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weakestTypeClasses", "com/siyeh/ig/psiutils/WeakestTypeFinder", "checkType"));
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    public static Set<PsiClass> filterAccessibleClasses(Set<PsiClass> weakestTypeClasses, PsiClass upperBound, PsiElement context) {
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        for (PsiClass weakestTypeClass : weakestTypeClasses) {
            if (PsiUtil.isAccessible((PsiMember)weakestTypeClass, (PsiElement)context, null) && !weakestTypeClass.isDeprecated()) {
                result.add(weakestTypeClass);
                continue;
            }
            PsiClass visibleInheritor = WeakestTypeFinder.getVisibleInheritor(weakestTypeClass, upperBound, context);
            if (visibleInheritor == null) continue;
            result.add(visibleInheritor);
        }
        return result;
    }

    @Nullable
    private static PsiClass getVisibleInheritor(@NotNull PsiClass superClass, PsiClass upperBound, PsiElement context) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/siyeh/ig/psiutils/WeakestTypeFinder", "getVisibleInheritor"));
        }
        Query search = DirectClassInheritorsSearch.search((PsiClass)superClass, (SearchScope)context.getResolveScope());
        Project project = superClass.getProject();
        for (PsiClass aClass : search) {
            if (!aClass.isInheritor(superClass, true) || !upperBound.isInheritor(aClass, true)) continue;
            if (PsiUtil.isAccessible((Project)project, (PsiMember)aClass, (PsiElement)context, null)) {
                return aClass;
            }
            return WeakestTypeFinder.getVisibleInheritor(aClass, upperBound, context);
        }
        return null;
    }

    private static boolean checkClass(@Nullable PsiClass aClass, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (weakestTypeClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weakestTypeClasses", "com/siyeh/ig/psiutils/WeakestTypeFinder", "checkClass"));
        }
        if (aClass == null) {
            return false;
        }
        boolean shouldAdd = true;
        Iterator<PsiClass> iterator = weakestTypeClasses.iterator();
        while (iterator.hasNext()) {
            PsiClass weakestTypeClass = iterator.next();
            if (weakestTypeClass.equals(aClass)) {
                return true;
            }
            if (aClass.isInheritor(weakestTypeClass, true)) {
                iterator.remove();
                continue;
            }
            if (weakestTypeClass.isInheritor(aClass, true)) {
                shouldAdd = false;
                continue;
            }
            iterator.remove();
            shouldAdd = false;
        }
        if (!shouldAdd) {
            return false;
        }
        weakestTypeClasses.add(aClass);
        return true;
    }
}

