/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageInfoReader {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.images.util.ImageInfoReader");

    private ImageInfoReader() {
    }

    @Nullable
    public static Info getInfo(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/util/ImageInfoReader", "getInfo"));
        }
        return ImageInfoReader.read(file);
    }

    @Nullable
    public static Info getInfo(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/intellij/images/util/ImageInfoReader", "getInfo"));
        }
        return ImageInfoReader.read(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Info read(@NotNull String file) {
        Info info;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/util/ImageInfoReader", "read"));
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            info = ImageInfoReader.readFileData(raf);
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Info read(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/intellij/images/util/ImageInfoReader", "read"));
        }
        DataInputStream is = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(data));
        try {
            Info info = ImageInfoReader.readFileData(is);
            return info;
        }
        catch (IOException e) {
            Info info = null;
            return info;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    private static Info readFileData(@NotNull DataInput di) throws IOException {
        if (di == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "di", "org/intellij/images/util/ImageInfoReader", "readFileData"));
        }
        int b1 = di.readUnsignedByte();
        int b2 = di.readUnsignedByte();
        if (b1 == 71 && b2 == 73) {
            return ImageInfoReader.readGif(di);
        }
        if (b1 == 137 && b2 == 80) {
            return ImageInfoReader.readPng(di);
        }
        if (b1 == 255 && b2 == 216) {
            return ImageInfoReader.readJpeg(di);
        }
        return null;
    }

    @Nullable
    private static Info readGif(DataInput di) throws IOException {
        byte[] GIF_MAGIC_87A = new byte[]{70, 56, 55, 97};
        byte[] GIF_MAGIC_89A = new byte[]{70, 56, 57, 97};
        byte[] a = new byte[11];
        di.readFully(a);
        if (!ImageInfoReader.eq(a, 0, GIF_MAGIC_89A, 0, 4) && !ImageInfoReader.eq(a, 0, GIF_MAGIC_87A, 0, 4)) {
            return null;
        }
        int width = ImageInfoReader.getShortLittleEndian(a, 4);
        int height = ImageInfoReader.getShortLittleEndian(a, 6);
        int flags = a[8] & 0xFF;
        int bpp = (flags >> 4 & 7) + 1;
        return new Info(width, height, bpp);
    }

    private static Info readBmp(RandomAccessFile raf) throws IOException {
        byte[] a = new byte[44];
        if (raf.read(a) != a.length) {
            return null;
        }
        int width = ImageInfoReader.getIntLittleEndian(a, 16);
        int height = ImageInfoReader.getIntLittleEndian(a, 20);
        if (width < 1 || height < 1) {
            return null;
        }
        int bpp = ImageInfoReader.getShortLittleEndian(a, 26);
        if (bpp != 1 && bpp != 4 && bpp != 8 && bpp != 16 && bpp != 24 & bpp != 32) {
            return null;
        }
        return new Info(width, height, bpp);
    }

    @Nullable
    private static Info readJpeg(DataInput di) throws IOException {
        byte[] a = new byte[13];
        while (true) {
            di.readFully(a, 0, 4);
            int marker = ImageInfoReader.getShortBigEndian(a, 0);
            int size = ImageInfoReader.getShortBigEndian(a, 2);
            if ((marker & 0xFF00) != 65280) {
                return null;
            }
            if (marker == 65504) {
                if (size < 14) {
                    di.skipBytes(size - 2);
                    continue;
                }
                di.readFully(a, 0, 12);
                di.skipBytes(size - 14);
                continue;
            }
            if (marker >= 65472 && marker <= 65487 && marker != 65476 && marker != 65480) {
                di.readFully(a, 0, 6);
                int bpp = (a[0] & 0xFF) * (a[5] & 0xFF);
                int width = ImageInfoReader.getShortBigEndian(a, 3);
                int height = ImageInfoReader.getShortBigEndian(a, 1);
                return new Info(width, height, bpp);
            }
            di.skipBytes(size - 2);
        }
    }

    @Nullable
    private static Info readPng(DataInput di) throws IOException {
        byte[] PNG_MAGIC = new byte[]{78, 71, 13, 10, 26, 10};
        byte[] a = new byte[27];
        di.readFully(a);
        if (!ImageInfoReader.eq(a, 0, PNG_MAGIC, 0, 6)) {
            return null;
        }
        int width = ImageInfoReader.getIntBigEndian(a, 14);
        int height = ImageInfoReader.getIntBigEndian(a, 18);
        int bpp = a[22] & 0xFF;
        int colorType = a[23] & 0xFF;
        if (colorType == 2 || colorType == 6) {
            bpp *= 3;
        }
        return new Info(width, height, bpp);
    }

    private static int getShortBigEndian(byte[] a, int offset) {
        return (a[offset] & 0xFF) << 8 | a[offset + 1] & 0xFF;
    }

    private static boolean eq(byte[] a1, int offset1, byte[] a2, int offset2, int num) {
        while (num-- > 0) {
            if (a1[offset1++] == a2[offset2++]) continue;
            return false;
        }
        return true;
    }

    private static int getIntBigEndian(byte[] a, int offset) {
        return (a[offset] & 0xFF) << 24 | (a[offset + 1] & 0xFF) << 16 | (a[offset + 2] & 0xFF) << 8 | a[offset + 3] & 0xFF;
    }

    private static int getIntLittleEndian(byte[] a, int offset) {
        return (a[offset + 3] & 0xFF) << 24 | (a[offset + 2] & 0xFF) << 16 | (a[offset + 1] & 0xFF) << 8 | a[offset] & 0xFF;
    }

    private static int getShortLittleEndian(byte[] a, int offset) {
        return a[offset] & 0xFF | (a[offset + 1] & 0xFF) << 8;
    }

    public static class Info {
        public int width;
        public int height;
        public int bpp;

        public Info(int width, int height, int bpp) {
            this.width = width;
            this.height = height;
            this.bpp = bpp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info info = (Info)o;
            if (this.width != info.width) {
                return false;
            }
            if (this.height != info.height) {
                return false;
            }
            return this.bpp == info.bpp;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.bpp;
            return result;
        }
    }
}

