/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.NetUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class BuiltInWebServerPackage$BuiltInWebServer$294e1965 {
    public static final boolean compareNameAndProjectBasePath(@JetValueParameter(name="projectName") @NotNull String projectName, @JetValueParameter(name="project") @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && basePath.length() > projectName.length() && KotlinPackage.endsWith$default((String)basePath, (String)projectName, (boolean)false, (int)2) && basePath.charAt(basePath.length() - projectName.length() - 1) == '/';
    }

    @Nullable
    public static final VirtualFile findIndexFile(@JetValueParameter(name="basedir") @NotNull VirtualFile basedir) {
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        VirtualFile[] children = basedir.getChildren();
        if (children == null || KotlinPackage.isEmpty((Object[])children)) {
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        for (int i = 0; i < stringArray.length; ++i) {
            String indexNamePrefix = stringArray[i];
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children.length; ++j) {
                VirtualFile child = children[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !KotlinPackage.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@JetValueParameter(name="host") @NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            block7: {
                block6: {
                    InetAddress address = InetAddress.getByName(host);
                    if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress())) break block6;
                    String string = address.getCanonicalHostName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"address.getCanonicalHostName()");
                    if (!KotlinPackage.equals((String)host, (String)string, (boolean)true)) break block7;
                }
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return KotlinPackage.equals((String)localHostName, (String)host, (boolean)true) || KotlinPackage.endsWith$default((String)host, (String)".local", (boolean)false, (int)2) && KotlinPackage.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true);
        }
        catch (UnknownHostException ignored) {
            return false;
        }
    }
}

