/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerPackage$BuiltInWebServer$294e1965;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"{\u0004)iB)\u001a4bk2$x+\u001a2TKJ4XM\u001d*p_R\u001c\bK]8wS\u0012,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b!\t,\u0018\u000e\u001c;J]^+'mU3sm\u0016\u0014(BF,fEN+'O^3s%>|Go\u001d)s_ZLG-\u001a:\u000b\rqJg.\u001b;?\u0015\u001d9W\r\u001e*p_RTAAZ5mK*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'b\u0001<gg*9\u0001O]8kK\u000e$(b\u0002)s_*,7\r\u001e\u0006\t!\u0006$\b.\u00138g_*9!/Z:pYZ,'\u0002\u00029bi\"Taa\u0015;sS:<'BB6pi2LgN\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT\u0011bQ8na\u0006t\u0017n\u001c8\u000b\u0019I{w\u000e\u001e)s_ZLG-\u001a:\u0003\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!B\u0002\u0005\u0003!\u0001A\u0002A\u0003\u0004\t\u0005A!\u0001\u0004\u0001\u0006\u0003!%QA\u0001C\u0003\u0011\u0015)!\u0001B\u0002\t\f\u0015\u0011Aq\u0001\u0005\u0007\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\u0011Aq\u0001E\u0007\u000b\r!Q\u0001C\u0004\r\u0001\u0015\u0019A!\u0001E\b\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0011A\u0001\u0002\u0005\u0005\u000b\t!Q\u0001C\u0004\u0006\u0003!MQa\u0001\u0003\t\u0011%a\u0001!B\u0001\t\u0015\u0015\u0011A!\u0003E\u000b\u000b\t!\u0019\u0002C\u0005\u0005\u00011\r\u0001cC\r\u0003\u000b\u0005A!\u0001H\u0006\u001d\u00185nBa\u0003\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001\u0012\u0002)\u0004\u0001u5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001c\u0003Q\u0007\u0003\t3!B\u0001\t\r1\u0005\u0011kA\u0004\u0005\u0007%\t\u0001RB\u0007\u0002\u0011\u001di\u0011\u0001c\u0004.<\u0011Y\u0001\u0004CO\u0007\t\u0001A\t\"\u0004\u0002\u0006\u0003!E\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005AY\u0001UB\u0001C\r)\u0011\u0001\u0003\u0004\r\u0002E\u001bq\u0001\u0002\u0005\n\u0003!5Q\"\u0001\u0005\u000b\u001b\u0005Ay!N\u0006\u0006\u0015\u0011\u0019\u000f\u0001'\u0002\"\u0005\u0015\t\u00012A)\u0004\u0007\u0011\u0015\u0011\"\u0001\u0003\u0001"})
public final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Companion.ORDER_ROOT_TYPES.1 ORDER_ROOT_TYPES;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(DefaultWebServerRootsProvider.class);
        OBJECT$ = Companion = org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$init$9();
        ORDER_ROOT_TYPES = new NotNullLazyValue<OrderRootType[]>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(Companion.ORDER_ROOT_TYPES.1.class);
            }

            @NotNull
            protected OrderRootType[] compute() {
                OrderRootType javaDocRootType = org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$getJavadocOrderRootType$0(DefaultWebServerRootsProvider.Companion);
                return javaDocRootType == null ? new OrderRootType[]{OrderRootType.DOCUMENTATION, OrderRootType.SOURCES, OrderRootType.CLASSES} : new OrderRootType[]{javaDocRootType, OrderRootType.DOCUMENTATION, OrderRootType.SOURCES, OrderRootType.CLASSES};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PathInfo resolve(@JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="project") @NotNull Project project) {
        AccessToken accessToken;
        AccessToken token3;
        int index;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String effectivePath = path;
        if (PlatformUtils.isIntelliJ() && (index = KotlinPackage.indexOf$default((String)effectivePath, (char)'/', (int)0, (boolean)false, (int)6)) > 0) {
            String string = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.getName()");
            if (!KotlinPackage.regionMatches((String)effectivePath, (int)0, (String)string, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                Module module;
                String moduleName = KotlinPackage.substring((String)effectivePath, (int)0, (int)index);
                token3 = ReadAction.start();
                try {
                    module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                }
                finally {
                    token3.finish();
                }
                if (module != null && !module.isDisposed()) {
                    effectivePath = KotlinPackage.substring((String)effectivePath, (int)(index + 1));
                    PairFunction<String, VirtualFile, VirtualFile> resolver = WebServerPathToFileManager.getInstance(project).getResolver(effectivePath);
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    RootProvider[] rootProviderArray = RootProvider.values();
                    for (int i = 0; i < rootProviderArray.length; ++i) {
                        RootProvider rootProvider = rootProviderArray[i];
                        ModuleRootManager moduleRootManager2 = moduleRootManager;
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                        VirtualFile[] virtualFileArray = rootProvider.getRoots(moduleRootManager2);
                        PairFunction<String, VirtualFile, VirtualFile> pairFunction = resolver;
                        Intrinsics.checkExpressionValueIsNotNull(pairFunction, (String)"resolver");
                        PathInfo result = DefaultWebServerRootsProvider.Companion.findByRelativePath(effectivePath, virtualFileArray, pairFunction, moduleName);
                        if (result == null) continue;
                        return result;
                    }
                    PairFunction<String, VirtualFile, VirtualFile> pairFunction = resolver;
                    Intrinsics.checkExpressionValueIsNotNull(pairFunction, (String)"resolver");
                    PathInfo result = DefaultWebServerRootsProvider.Companion.findInModuleLibraries(effectivePath, module, pairFunction);
                    if (result != null) {
                        return result;
                    }
                }
            }
        }
        AccessToken token2 = ReadAction.start();
        try {
            token3 = ModuleManager.getInstance((Project)project).getModules();
            accessToken = token3;
        }
        catch (Throwable token3) {
            throw token3;
        }
        finally {
            token2.finish();
        }
        AccessToken modules = accessToken;
        PairFunction<String, VirtualFile, VirtualFile> resolver = WebServerPathToFileManager.getInstance(project).getResolver(effectivePath);
        RootProvider[] rootProviderArray = RootProvider.values();
        for (int i = 0; i < rootProviderArray.length; ++i) {
            RootProvider rootProvider = rootProviderArray[i];
            AccessToken accessToken2 = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)accessToken2, (String)"modules");
            PairFunction<String, VirtualFile, VirtualFile> pairFunction = resolver;
            Intrinsics.checkExpressionValueIsNotNull(pairFunction, (String)"resolver");
            PathInfo result = DefaultWebServerRootsProvider.Companion.findByRelativePath(project, effectivePath, (Module[])accessToken2, rootProvider, pairFunction);
            if (result == null) continue;
            return result;
        }
        AccessToken accessToken3 = modules;
        Intrinsics.checkExpressionValueIsNotNull((Object)accessToken3, (String)"modules");
        PairFunction<String, VirtualFile, VirtualFile> pairFunction = resolver;
        Intrinsics.checkExpressionValueIsNotNull(pairFunction, (String)"resolver");
        return DefaultWebServerRootsProvider.Companion.findInLibraries(project, (Module[])accessToken3, effectivePath, pairFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo getRoot(@JetValueParameter(name="file") @NotNull VirtualFile file, @JetValueParameter(name="project") @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AccessToken token = ReadAction.start();
        try {
            boolean isLibrary;
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance(project);
            DirectoryInfo info = directoryIndex.getInfoForFile(file);
            if (!info.isExcluded() && !info.isInProject()) {
                PathInfo pathInfo = file.getFileSystem() == JarFileSystem.getInstance() ? DefaultWebServerRootsProvider.Companion.getInfoForDocJar(file, project) : (PathInfo)null;
                return pathInfo;
            }
            VirtualFile root = info.getSourceRoot();
            if (root == null) {
                root = info.getContentRoot();
                if (root == null) {
                    void value;
                    root = info.getLibraryClassRoot();
                    isLibrary = true;
                    boolean bl = root != null;
                    if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
                        String string = file.getPresentableUrl();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.getPresentableUrl()");
                        String message = string;
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                } else {
                    isLibrary = false;
                }
            } else {
                isLibrary = info.isInLibrarySource();
            }
            Module module = info.getModule();
            if (isLibrary && module == null) {
                OrderEntry[] orderEntryArray = directoryIndex.getOrderEntries(info);
                for (int i = 0; i < orderEntryArray.length; ++i) {
                    OrderEntry entry = orderEntryArray[i];
                    if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                    module = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                    break;
                }
            }
            VirtualFile virtualFile = root;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            PathInfo pathInfo = new PathInfo(file, virtualFile, DefaultWebServerRootsProvider.Companion.getModuleNameQualifier(project, module), isLibrary);
            return pathInfo;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            token.finish();
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"w\u0004)a!k\\8u!J|g/\u001b3fe*iB)\u001a4bk2$x+\u001a2TKJ4XM\u001d*p_R\u001c\bK]8wS\u0012,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b!\t,\u0018\u000e\u001c;J]^+'mU3sm\u0016\u0014(\u0002B#ok6Taa[8uY&t'B\u0002\u001fj]&$hH\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTaa\u0015;sS:<'\u0002C4fiJ{w\u000e^:\u000b\u0017I|w\u000e^'b]\u0006<WM\u001d\u0006\u0012\u001b>$W\u000f\\3S_>$X*\u00198bO\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u000bI|w\u000e^:\u000b\u000b\u0005\u0013(/Y=\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\u0004m\u001a\u001c(BB*P+J\u001bUIC\u0004D\u001f:#VI\u0014+\u000b\u0011\u0015C6\tT+E\u000b\u0012c(B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0007\u0011\t\u0001\u0012\u0001\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0003!!QA\u0001C\u0004\u0011\u0013)!\u0001\u0002\u0003\t\u000b\u0015\t\u0001bB\u0003\u0003\t\u0015Ay!\u0002\u0002\u0005\f!AQA\u0001\u0003\u0007\u0011#)1\u0001\"\u0004\t\u000e1\u0001Qa\u0001C\u0003\u0011%a\u0001!\u0002\u0002\u0005\r!QQa\u0001\u0003\t\u0011'a\u0001!\u0002\u0002\u0005\u0011!MQA\u0001C\u0007\u0011\u001b!\u0011\u0019\u0001\u0007\u00033\u0019)\u0011\u0001C\u0002\n\u0007%\u0011Q!\u0001\u0005\u0003[a!1\u0003g\u0003\u001e\u000e\u0011\u0001\u0001BB\u0007\u0003\u000b\u0005Aq\u0001U\u0002\u0001C\u0019)\u0011\u0001c\u0004\n\u0007%\u0011Q!\u0001E\t#\u000e1A1B\u0005\u0003\u0011%a\t!D\u0001\t\u0014AV\u0001g\u0003Y\fk=)a\u0002Bq\u00011\u000f\t#!B\u0001\t\u0005E\u001bq\u0001b\u0002\n\u0003\u0011\u0001Q\"\u0001E\u0005\u001b\u0005!)\u0001"})
    private static final abstract class RootProvider
    extends Enum<RootProvider> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ RootProvider SOURCE;
        public static final /* enum */ RootProvider CONTENT;
        public static final /* enum */ RootProvider EXCLUDED;
        private static final /* synthetic */ RootProvider[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(RootProvider.class);
            RootProvider[] rootProviderArray = new RootProvider[3];
            RootProvider[] rootProviderArray2 = rootProviderArray;
            rootProviderArray[0] = SOURCE = new SOURCE("SOURCE", 0);
            rootProviderArray[1] = CONTENT = new CONTENT("CONTENT", 1);
            rootProviderArray[2] = EXCLUDED = new EXCLUDED("EXCLUDED", 2);
            $VALUES = rootProviderArray;
        }

        @NotNull
        public abstract VirtualFile[] getRoots(@JetValueParameter(name="rootManager") @NotNull ModuleRootManager var1);

        public static RootProvider[] values() {
            return (RootProvider[])$VALUES.clone();
        }

        public static RootProvider valueOf(String string) {
            return Enum.valueOf(RootProvider.class, string);
        }

        @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"B\u0004)11kT+S\u0007\u0016SABU8piB\u0013xN^5eKJTQ\u0004R3gCVdGoV3c'\u0016\u0014h/\u001a:S_>$8\u000f\u0015:pm&$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015A\u0011W/\u001b7u\u0013:<VMY*feZ,'O\u0003\u0005hKR\u0014vn\u001c;t\u0015-\u0011xn\u001c;NC:\fw-\u001a:\u000b#5{G-\u001e7f%>|G/T1oC\u001e,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\u0015\u0011xn\u001c;t\u0015\u0015\t%O]1z\u0015\u0019Yw\u000e\u001e7j]*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r1hm\u001d7\u000b\u0005A\u0019!\u0002\u0002\u0005\u0001!\u0011QA\u0001C\u0001\u0011\u000b)1\u0001B\u0001\t\u00031\u0001Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u0013)!\u0001B\u0002\t\u000b\u0015\u0011Aq\u0001E\u0006\u000b\t!A\u0001\u0003\u0004\u0006\u0007\u0011%\u0001\u0002\u0002\u0007\u0001\u000b\u0005Aq!B\u0002\u0005\f!5A\u0002A\u0003\u0003\t\u0011A\u0001\"B\u0002\u0005\u000e!=A\u0002A\u0003\u0003\t\u001bAy!\u0002\u0002\u0005\n!!Aa9\u0001\r\u0006e\u0011Q!\u0001\u0005\u0003[a!1\u0002G\u0002\u001e\u000e\u0011\u0001\u0001rA\u0007\u0003\u000b\u0005AQ\u0001U\u0002\u0001C\u0019)\u0011\u0001\u0003\u0004\n\u0007%\u0011Q!\u0001\u0005\b#\u000e1AaA\u0005\u0003\u0011\u001fa\t!D\u0001\t\u0011U\u0002\u0001"})
        public static final class SOURCE
        extends RootProvider {
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(SOURCE.class);
            }

            @Override
            @NotNull
            public VirtualFile[] getRoots(@JetValueParameter(name="rootManager") @NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                VirtualFile[] virtualFileArray = rootManager.getSourceRoots();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"rootManager.getSourceRoots()");
                return virtualFileArray;
            }

            SOURCE() {
            }
        }

        @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"C\u0004)91i\u0014(U\u000b:#&\u0002\u0004*p_R\u0004&o\u001c<jI\u0016\u0014(\"\b#fM\u0006,H\u000e^,fEN+'O^3s%>|Go\u001d)s_ZLG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u0001\"-^5mi&sw+\u001a2TKJ4XM\u001d\u0006\tO\u0016$(k\\8ug*Y!o\\8u\u001b\u0006t\u0017mZ3s\u0015Eiu\u000eZ;mKJ{w\u000e^'b]\u0006<WM\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*)!o\\8ug*)\u0011I\u001d:bs*11n\u001c;mS:T1BV5siV\fGNR5mK*\u0019aOZ:m\u0015\t\u00012A\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\u0002!\u0015Qa\u0001\u0003\u0002\u0011\u0005a\u0001!B\u0002\u0005\u0004!\u0005A\u0002A\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!%QA\u0001\u0003\u0004\u0011\u0015)!\u0001b\u0002\t\f\u0015\u0011A\u0001\u0002\u0005\u0007\u000b\r!I\u0001\u0003\u0003\r\u0001\u0015\t\u0001bB\u0003\u0004\t\u0017Ai\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0002C\u0003\u0004\t\u001bAy\u0001\u0004\u0001\u0006\u0005\u00115\u0001rB\u0003\u0003\t\u0013AA\u0001Br\u0001\u0019\u000bI\"!B\u0001\t\u00055BBa\u0003\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001\u00052Q!\u0001\u0005\u0007\u0013\rI!!B\u0001\t\u000fE\u001ba\u0001B\u0002\n\u0005!=A\u0012A\u0007\u0002\u0011!)\u0004\u0001"})
        public static final class CONTENT
        extends RootProvider {
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CONTENT.class);
            }

            @Override
            @NotNull
            public VirtualFile[] getRoots(@JetValueParameter(name="rootManager") @NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                VirtualFile[] virtualFileArray = rootManager.getContentRoots();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"rootManager.getContentRoots()");
                return virtualFileArray;
            }

            CONTENT() {
            }
        }

        @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"D\u0004)AQ\tW\"M+\u0012+EI\u0003\u0007S_>$\bK]8wS\u0012,'OC\u000fEK\u001a\fW\u000f\u001c;XK\n\u001cVM\u001d<feJ{w\u000e^:Qe>4\u0018\u000eZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT\u0001CY;jYRLenV3c'\u0016\u0014h/\u001a:\u000b\u0011\u001d,GOU8piNT1B]8pi6\u000bg.Y4fe*\tRj\u001c3vY\u0016\u0014vn\u001c;NC:\fw-\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&TQA]8piNTQ!\u0011:sCfTaa[8uY&t'b\u0003,jeR,\u0018\r\u001c$jY\u0016T1A\u001e4tY*\u0011\u0001c\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\u0003A)!B\u0002\u0005\u0003!\tA\u0002A\u0003\u0004\t\u0007A\t\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005AI!\u0002\u0002\u0005\u0007!)QA\u0001C\u0004\u0011\u0017)!\u0001\u0002\u0003\t\r\u0015\u0019A\u0011\u0002\u0005\u0005\u0019\u0001)\u0011\u0001C\u0004\u0006\u0007\u0011-\u0001R\u0002\u0007\u0001\u000b\t!A\u0001\u0003\u0005\u0006\u0007\u00115\u0001r\u0002\u0007\u0001\u000b\t!i\u0001c\u0004\u0006\u0005\u0011%\u0001\u0002\u0002\u0003d\u00021\u0015\u0011DA\u0003\u0002\u0011\ti\u0003\u0004B\u0006\u0019\u0007u5A\u0001\u0001E\u0004\u001b\t)\u0011\u0001C\u0003Q\u0007\u0001\tc!B\u0001\t\r%\u0019\u0011BA\u0003\u0002\u0011\u001d\t6A\u0002\u0003\u0004\u0013\tAy\u0001$\u0001\u000e\u0003!AQ\u0007\u0001"})
        public static final class EXCLUDED
        extends RootProvider {
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(EXCLUDED.class);
            }

            @Override
            @NotNull
            public VirtualFile[] getRoots(@JetValueParameter(name="rootManager") @NotNull ModuleRootManager rootManager) {
                Intrinsics.checkParameterIsNotNull((Object)rootManager, (String)"rootManager");
                VirtualFile[] virtualFileArray = rootManager.getExcludeRoots();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"rootManager.getExcludeRoots()");
                return virtualFileArray;
            }

            EXCLUDED() {
            }
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"+\f)I1i\\7qC:LwN\u001c\u0006\u001e\t\u00164\u0017-\u001e7u/\u0016\u00147+\u001a:wKJ\u0014vn\u001c;t!J|g/\u001b3fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(\u0002\u00052vS2$\u0018J\\,fEN+'O^3s\u0015\r\te.\u001f\u0006\u0007W>$H.\u001b8\u000b!=\u0013F)\u0012*`%>{Ek\u0018+Z!\u0016\u001b&B\u000f#fM\u0006,H\u000e^,fEN+'O^3s%>|Go\u001d)s_ZLG-\u001a:%\u0007>l\u0007/\u00198j_:$sJ\u0015#F%~\u0013vj\u0014+`)f\u0003Vi\u0015\u00132\u0015M9W\r^(S\t\u0016\u0013vLU(P)~#\u0016\fU#T\u0015I1\u0017N\u001c3CsJ+G.\u0019;jm\u0016\u0004\u0016\r\u001e5\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\tA\fG\u000f\u001b\u0006\u0007'R\u0014\u0018N\\4\u000b\u000f5|G-\u001e7fg*)\u0011I\u001d:bs*1Qj\u001c3vY\u0016Ta!\\8ek2,'\u0002\u0004:p_R\u0004&o\u001c<jI\u0016\u0014(\u0002\u0004*p_R\u0004&o\u001c<jI\u0016\u0014(\u0002\u0003:fg>dg/\u001a:\u000b\u0019A\u000b\u0017N\u001d$v]\u000e$\u0018n\u001c8\u000b\tU$\u0018\u000e\u001c\u0006\f-&\u0014H/^1m\r&dWMC\u0002wMNT\u0001\u0002U1uQ&sgm\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'B\u000b#fM\u0006,H\u000e^,fEN+'O^3s%>|Go\u001d)s_ZLG-\u001a:%%>|G\u000f\u0015:pm&$WM\u001d\u0006\u0006e>|Go\u001d\u0006\u000b[>$W\u000f\\3OC6,'b\u00044j]\u0012Le\u000eT5ce\u0006\u0014\u0018.Z:\u000b\u001b\u0019Lg\u000eZ%o\u0019&\u0014'/\u0019:z\u0015=a\u0017N\u0019:bef4\u0015\u000e\\3OC6,'\u0002\u0004:fY\u0006$\u0018N^3QCRD'b\u00027jEJ\f'/\u001f\u0006\b\u0019&\u0014'/\u0019:z\u0015%a\u0017N\u0019:be&,7OC\u000bgS:$\u0017J\\'pIVdW\rT5ce\u0006\u0014\u0018.Z:\u000b\rI,7/\u001e7u\u0015\r\u0011VM\u001a\u0006\b\u0005>|G.Z1o\u0015A9W\r^%oM>4uN\u001d#pG*\u000b'O\u0003\u0003gS2,'bF4fi*\u000bg/\u00193pG>\u0013H-\u001a:S_>$H+\u001f9f\u00155y%\u000fZ3s%>|G\u000fV=qK*1r-\u001a;N_\u0012,H.\u001a(b[\u0016\fV/\u00197jM&,'\u000f'\u0002\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)1\u0001B\u0001\t\u00021\u0001Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0007\u0015\u0019AQ\u0001E\u0003\u0019\u0001)!\u0001\u0003\u0003\r\u0003\u0015\u0011A!\u0001\u0005\u0005\u000b\u0005Ai!\u0002\u0002\u0005\n!9QA\u0001\u0003\u0006\u0011\u001f)!\u0001b\u0003\t\f\u0015\u0019AA\u0002\u0005\u0007\u0019\u0001)1\u0001\"\u0002\t\u00121\u0001Qa\u0001C\u0003\u0011'a\u0001!\u0002\u0002\u0005\f!UQa\u0001\u0003\t\u0011)a\u0001!B\u0002\u0005\u0004!]A\u0002A\u0003\u0003\t\u0015AQ\"B\u0002\u0005\u0014!eA\u0002A\u0003\u0003\t\u0017Aa\"B\u0002\u0005\u0016!mA\u0002A\u0003\u0004\t\u0005Ai\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001RD\u0003\u0003\t\u0019Aa!B\u0001\t\u001f\u0015\u0011A!\u0004E\u0010\u000b\t!Y\u0002#\u0005\u0006\u0005\u0011A\u0001BC\u0003\u0003\t\u0005A\u0001#\u0002\u0002\u0005\u0014!eQA\u0001C\u000b\u00117)!\u0001b\u0003\t\"\u0015\u0011A\u0011\u0005E\u0015\u000b\r!\u0011\u0003\u0003\u000b\r\u0001\u0015\u0011A!\u0005\u0005\u0015\u000b\t!Y\u0001C\u0007\u0006\u0007\u0011\u0015\u0002B\u0006\u0007\u0001\u000b\r!)\u0001#\f\r\u0001\u0015\u0011AQ\u0005\u0005\u0017\u000b\r!\t\u0003#\r\r\u0001\u0015\u0011A\u0011\u0005E\u0019\t\r\u000fABA\r\u0003\u000b\u0005A1!\f\t\u0005C\u0012A:!\t\u0002\u0006\u0003!\u001dQkA\u0005\u0006\t\u0011\u001d\u0011\"\u0001\u0005\u0005\u0019\u0003i1\u0001\"\u0003\n\u0003!!Qf3\u0001\u0005\u0003a)QT\u0002\u0003\u0001\u0011\u0017i!!B\u0001\t\u000eA\u001b\u0001!(\u0004\u0005\u0001!AQBA\u0003\u0002\u0011\u001d\u00016\u0011AO\u000b\t\u0001A\u0011\"\u0004\u0004\u0006\u0003!=\u0011bA\u0005\u0003\u000b\u0005A\t\u0002U\u0002\u0002;\u001b!\u0001\u0001C\u0006\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0004u\u0015B\u0001\u0001\u0005\r\u001b9)\u0011\u0001\u0003\u0006\n\u0007%\u0011Q!\u0001\u0005\b\u0013\rI!!B\u0001\t\u0017%\u0019\u0011BA\u0003\u0002\u0011-\u00016AA\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u00079!Q!C\u0001\t\u00195\t\u0001\u0012D\u0007\u0002\u00119i!\u0001#\b\r\u00025\t\u0001bD\u0007\u0002\u0011?i+\u0019\u0001\u0003\u00021\u0015ij\u0001\u0002\u0001\t\u00115\u0011Q!\u0001\u0005\b!\u000e\u0001QT\u0003\u0003\u0001\u0011Cia!B\u0001\t\u0010%\u0019\u0011BA\u0003\u0002\u0011-\u00016\u0011AO\u0013\t\u0001AA\"\u0004\b\u0006\u0003!Q\u0011bA\u0005\u0003\u000b\u0005Aq!C\u0002\n\u0005\u0015\t\u0001bC\u0005\u0004\u0013\t)\u0011\u0001C\u0006Q\u0007\u0005iz\u0001\u0002\u0001\t#5\u0019Q!\u0001\u0005\b\u0019\u0003\u000161A\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u00071!Q!C\u0001\t\u00195\t\u0001BD\u0007\u0003\u0011Aa\t!D\u0001\t 5\t\u0001BDWB\u0002\u0011\t\u00014EO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!5\u0001k\u0001\u0001\u001e\u0016\u0011\u0001\u0001\"C\u0007\u0007\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0002u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001C\u0004Q\u0007\u0005i*\u0003\u0002\u0001\t\u00195qQ!\u0001\u0005\u000b\u0013\rI!!B\u0001\t\u000f%\u0019\u0011BA\u0003\u0002\u0011-I1!\u0003\u0002\u0006\u0003!Y\u0001ka\u0001\"\u0007\u0015\t\u0001r\u0003G\u0001#\u000eaA1E\u0005\u0002\u00111i\u0011\u0001#\u0007\u000e\u0005!uA\u0012A\u0007\u0002\u00119i\u0011\u0001c\b.z\u0011\t\u0001DEO\u0007\t\u0001A)#\u0004\u0002\u0006\u0003!9\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001bE\u0007\u0003\u000b\u0005Aq\u0001UB\u0001;\u001b!\u0001\u0001c\n\u000e\u0005\u0015\t\u00012\u0005)\u0004\u0003u\u0015B\u0001\u0001\u0005\r\u001b9)\u0011\u0001\u0003\u0006\n\u0007%\u0011Q!\u0001\u0005\b\u0013\rI!!B\u0001\t\u0017%\u0019\u0011BA\u0003\u0002\u0011-\u000161A\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u0007-!!#C\u0001\t\u00195\t\u0001BD\u0007\u0002\u00119i\u0011\u0001\u0003\n\u000e\u0003!}Q&3\u0001\u0005\u0003a)RT\u0005\u0003\u0001\u00111ia\"B\u0001\t\u0015%\u0019\u0011BA\u0003\u0002\u0011\u001dI1!\u0003\u0002\u0006\u0003!Y\u0011bA\u0005\u0003\u000b\u0005A1\u0002U\u0002\u0001;\u001b!\u0001\u0001#\n\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0002u5A\u0001\u0001\u0005\u0014\u001b\t)\u0011\u0001C\u0004Q\u0007\u0005i*\u0002\u0002\u0001\t,51Q!\u0001\u0005\u0014\u0013\rI!!B\u0001\t\u0018A\u001b\u0019!(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011#\u00016AA\u0011\u0003\u000b\u0005A9#U\u0002\u000e\tUI\u0011\u0001\"\u0001\u000e\u0003!}Q\"\u0001\u0005\u000f\u001b\u0005Aa\"D\u0001\t)5\t\u0001RD\u00174\t\u0005AR#(\u0004\u0005\u0001!AQBA\u0003\u0002\u0011\u001d\u00016\u0001AO\u0007\t\u0001A)\"\u0004\u0002\u0006\u0003!E\u0001k!\u0001\u001e&\u0011\u0001\u0001\u0002D\u0007\u000f\u000b\u0005A!\"C\u0002\n\u0005\u0015\t\u0001bB\u0005\u0004\u0013\t)\u0011\u0001C\u0006\n\u0007%\u0011Q!\u0001\u0005\f!\u000e\t\u0011eA\u0003\u0002\u0011/a\t!U\u0002\n\tUI\u0011\u0001\u0003\u0007\u000e\u0003!qQ\"\u0001E\u000f\u001b\u0005Ay\"l\u000f\u0005\u0003a9RT\u0002\u0003\u0001\u0011_i!!B\u0001\t\u0017A\u001b\u0001!(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0004\u000b\u0005A9\u0002$\u0001R\u0007\u001d!q#C\u0001\t\u00195\t\u0001\u0002E\u0007\u0002\u00113i+\u0002B\u0001\u00191\u0005\u001aQ!\u0001E\u0015\u0019\u0003\t6a\u0001\u0003\u0019\u0013\u0005AQ#,\u0010\u0005\u0003aIRT\u0002\u0003\u0001\u0011\u0017i!!B\u0001\t\u000eA\u001b\u0001!h\u0004\u0005\u0001!UQbA\u0003\u0002\u0011#a\t\u0001UB\u0001C\r)\u0011\u0001C\u0004\r\u0002E\u001bq\u0001B\r\n\u0003!qQ\"\u0001E\r\u001b\u0005Ai\"\u000e\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final ORDER_ROOT_TYPES.1 getORDER_ROOT_TYPES() {
            return ORDER_ROOT_TYPES;
        }

        private final OrderRootType getJavadocOrderRootType() {
            try {
                return JavadocOrderRootType.getInstance();
            }
            catch (Throwable e) {
                return null;
            }
        }

        private final PathInfo findInModuleLibraries(@JetValueParameter(name="path") String path, @JetValueParameter(name="module") Module module, @JetValueParameter(name="resolver") PairFunction<String, VirtualFile, VirtualFile> resolver) {
            int index = KotlinPackage.indexOf$default((String)path, (char)'/', (int)0, (boolean)false, (int)6);
            if (index <= 0) {
                return null;
            }
            Ref result = Ref.create();
            String string = KotlinPackage.substring((String)path, (int)0, (int)index);
            String string2 = KotlinPackage.substring((String)path, (int)(index + 1));
            Ref ref = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"result");
            this.findInModuleLibraries(resolver, string, string2, (Ref<PathInfo>)ref, module);
            return (PathInfo)result.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PathInfo findInLibraries(@JetValueParameter(name="project") Project project, @JetValueParameter(name="modules") Module[] modules, @JetValueParameter(name="path") String path, @JetValueParameter(name="resolver") PairFunction<String, VirtualFile, VirtualFile> resolver) {
            int index = KotlinPackage.indexOf$default((String)path, (char)'/', (int)0, (boolean)false, (int)6);
            if (index < 0) {
                return null;
            }
            String libraryFileName = KotlinPackage.substring((String)path, (int)0, (int)index);
            String relativePath = KotlinPackage.substring((String)path, (int)(index + 1));
            AccessToken token = ReadAction.start();
            try {
                int n;
                Ref result = Ref.create();
                Module[] moduleArray = modules;
                for (n = 0; n < moduleArray.length; ++n) {
                    Module module = moduleArray[n];
                    if (module.isDisposed()) continue;
                    Ref ref = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"result");
                    if (!Companion.findInModuleLibraries(resolver, libraryFileName, relativePath, (Ref<PathInfo>)ref, module)) continue;
                    PathInfo pathInfo = (PathInfo)result.get();
                    return pathInfo;
                }
                moduleArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module library;
                    Module module = library = moduleArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"library");
                    PathInfo pathInfo = Companion.findInLibrary(libraryFileName, relativePath, (Library)module, resolver);
                    if (pathInfo == null) continue;
                    PathInfo pathInfo2 = pathInfo;
                    return pathInfo2;
                }
                Unit unit = Unit.INSTANCE$;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                token.finish();
            }
            return null;
        }

        private final boolean findInModuleLibraries(@JetValueParameter(name="resolver") PairFunction<String, VirtualFile, VirtualFile> resolver, @JetValueParameter(name="libraryFileName") String libraryFileName, @JetValueParameter(name="relativePath") String relativePath, @JetValueParameter(name="result") Ref<PathInfo> result, @JetValueParameter(name="module") Module module) {
            ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)new Processor<Library>(result, libraryFileName, relativePath, resolver){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ Ref $result;
                final /* synthetic */ String $libraryFileName;
                final /* synthetic */ String $relativePath;
                final /* synthetic */ PairFunction $resolver;

                static {
                    $kotlinClass = Reflection.createKotlinClass(findInModuleLibraries.1.class);
                }

                public boolean process(@JetValueParameter(name="library") @NotNull Library library) {
                    Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                    this.$result.set((Object)org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$findInLibrary$3(DefaultWebServerRootsProvider.Companion, this.$libraryFileName, this.$relativePath, library, (PairFunction<String, VirtualFile, VirtualFile>)this.$resolver));
                    return this.$result.isNull();
                }
                {
                    this.$result = $captured_local_variable$0;
                    this.$libraryFileName = $captured_local_variable$1;
                    this.$relativePath = $captured_local_variable$2;
                    this.$resolver = $captured_local_variable$3;
                }
            });
            return !result.isNull();
        }

        private final PathInfo findInLibrary(@JetValueParameter(name="libraryFileName") String libraryFileName, @JetValueParameter(name="relativePath") String relativePath, @JetValueParameter(name="library") Library library, @JetValueParameter(name="resolver") PairFunction<String, VirtualFile, VirtualFile> resolver) {
            OrderRootType[] orderRootTypeArray = (OrderRootType[])this.getORDER_ROOT_TYPES().getValue();
            for (int i = 0; i < orderRootTypeArray.length; ++i) {
                OrderRootType rootType = orderRootTypeArray[i];
                VirtualFile[] virtualFileArray = library.getFiles(rootType);
                for (int j = 0; j < virtualFileArray.length; ++j) {
                    VirtualFile file;
                    VirtualFile root = virtualFileArray[j];
                    if (!StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)libraryFileName) || (file = (VirtualFile)resolver.fun((Object)relativePath, (Object)root)) == null) continue;
                    return new PathInfo(file, root, (String)null, true);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PathInfo getInfoForDocJar(@JetValueParameter(name="file") VirtualFile file, @JetValueParameter(name="project") Project project) {
            OrderRootType orderRootType = this.getJavadocOrderRootType();
            if (orderRootType == null) {
                return null;
            }
            OrderRootType javaDocRootType = orderRootType;
            @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.LOCAL_CLASS, data={"^\u0006)IE)\u001a4bk2$x+\u001a2TKJ4XM\u001d*p_R\u001c\bK]8wS\u0012,'\u000fJ\"p[B\fg.[8oI\u001d,G/\u00138g_\u001a{'\u000fR8d\u0015\u0006\u0014H\u0005T5ce\u0006\u0014\u0018\u0010\u0015:pG\u0016\u001c8o\u001c:\u000b\u0013A\u0013xnY3tg>\u0014(bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0003vi&d'b\u0002'jEJ\f'/\u001f\u0006\b_B,g.\u00199j\u0015\u0015\u0011xn\u001c;t\u0015%a\u0017N\u0019:be&,7O\u0003\u0004=S:LGO\u0010\u0006\u000e\u001fJ$WM\u001d*p_R$\u0016\u0010]3\u000b\u0007Y47OC\u0006WSJ$X/\u00197GS2,'b\u00029s_*,7\r\u001e\u0006\b!J|'.Z2u\u0015\u0019iw\u000eZ;mK*1Qj\u001c3vY\u0016T\u0011bZ3u\u001b>$W\u000f\\3\u000b\u0013M,G/T8ek2,'B\u0002:fgVdGO\u0003\u0005QCRD\u0017J\u001c4p\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT\u0001CY;jYRLenV3c'\u0016\u0014h/\u001a:\u000b\u0013\u001d,GOU3tk2$(\"C:fiJ+7/\u001e7u\u0015\u001d\u0001(o\\2fgNTq\u0001\\5ce\u0006\u0014\u0018PC\u0004C_>dW-\u00198\u000b\r-|G\u000f\\5o5\u0007QA\u0001\u0005\u0001\u0019\u0005)\u0011\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0005A\u0002A\u0003\u0003\t\u0005A1!\u0002\u0002\u0005\u0006!\u001dQA\u0001\u0003\u0004\u0011\u0011)1\u0001b\u0002\t\u00061\u0001QA\u0001\u0003\u0004\u0011\u0015)!\u0001\"\u0002\t\f\u0015\u0011A!\u0002\u0005\u0007\u000b\t!)\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0003\t\u000bAy!B\u0002\u0005\u000f!AA\u0002A\u0003\u0003\t\u001dA\u0001\"B\u0001\t\u0016\u0015\u0011A\u0011\u0003\u0005\f\u000b\t!\u0011\u0002c\u0006\u0006\u0007\u0011M\u0001B\u0003\u0007\u0001\u000b\t!\u0019\u0002\u0003\u0006\u0006\u0003!uQa\u0001\u0003\f\u00119a\u0001!\u0002\u0002\u0005\b!\u0015A!\u0002\u0007\u00013\u0019)\u0011\u0001\u0003\u0002\n\u0007%\u0011Q!\u0001\u0005\u0005[Y!\u0001\u0019\u0004M\bC\r)\u0011\u0001c\u0004\r\u0002U\u001ba\"B\u0002\u0005\u0010%\t\u0001\u0002C\u0007\u0004\t#I\u0011\u0001\u0003\u0005\u0012\u000b\u0011I\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001\"\f\f\u0005\u00014A\u001a\"I\u0002\u0006\u0003!QA\u0012A+\u0004\u001d\u0015\u0019A1C\u0005\u0002\u0011+i1\u0001\u0002\u0007\n\u0003!U\u0011#\u0002C\r\u0013\u0005!\u0001!D\u0001\t\u00165\u001aBa\u0003\r\u000e;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\f#\u000e)A!D\u0005\u0002\t\u0003i\u0011\u0001\u0003\u00076#\u0015\u0001Ba9\u0001\u0019\n\u0005\u0012Q!\u0001\u0005\u0001#\u000eIA\u0011B\u0005\u0002\t\u0001i\u0011\u0001#\u0003\u000e\u0003!-Q\"\u0001E\u0007"})
            public final class LibraryProcessor
            implements Processor<Library> {
                public static final /* synthetic */ KClass $kotlinClass;
                @Nullable
                private PathInfo result;
                @Nullable
                private Module module;
                final /* synthetic */ OrderRootType $javaDocRootType;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ Project $project;

                static {
                    $kotlinClass = Reflection.createKotlinClass(LibraryProcessor.class);
                }

                @Nullable
                public final PathInfo getResult() {
                    return this.result;
                }

                public final void setResult(@JetValueParameter(name="<set-?>", type="?") @Nullable PathInfo pathInfo) {
                    this.result = pathInfo;
                }

                @Nullable
                public final Module getModule() {
                    return this.module;
                }

                public final void setModule(@JetValueParameter(name="<set-?>", type="?") @Nullable Module module) {
                    this.module = module;
                }

                public boolean process(@JetValueParameter(name="library") @NotNull Library library) {
                    Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                    VirtualFile[] virtualFileArray = library.getFiles(this.$javaDocRootType);
                    for (int i = 0; i < virtualFileArray.length; ++i) {
                        VirtualFile root = virtualFileArray[i];
                        if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)this.$file, (boolean)false)) continue;
                        this.result = new PathInfo(this.$file, root, org.jetbrains.builtInWebServer.DefaultWebServerRootsProvider$Companion.access$getModuleNameQualifier$5(DefaultWebServerRootsProvider.Companion, this.$project, this.module), true);
                        return false;
                    }
                    return true;
                }

                public LibraryProcessor(@JetValueParameter(name="$captured_local_variable$0", type="?") OrderRootType $captured_local_variable$0, @JetValueParameter(name="$captured_local_variable$1", type="?") VirtualFile $captured_local_variable$1, @JetValueParameter(name="$captured_local_variable$2", type="?") Project $captured_local_variable$2) {
                    this.$javaDocRootType = $captured_local_variable$0;
                    this.$file = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                }
            }
            LibraryProcessor processor = new LibraryProcessor(javaDocRootType, file, project);
            AccessToken token = ReadAction.start();
            try {
                int n;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Module[] moduleArray = moduleManager.getModules();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module module = moduleArray[n];
                    if (module.isDisposed()) continue;
                    processor.setModule(module);
                    ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary((Processor)processor);
                    if (processor.getResult() == null) continue;
                    PathInfo pathInfo = processor.getResult();
                    return pathInfo;
                }
                processor.setModule(null);
                moduleArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                for (n = 0; n < moduleArray.length; ++n) {
                    Module library;
                    Module module = library = moduleArray[n];
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"library");
                    if (processor.process((Library)module)) continue;
                    PathInfo pathInfo = processor.getResult();
                    return pathInfo;
                }
                Unit unit = Unit.INSTANCE$;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                token.finish();
            }
            return null;
        }

        private final String getModuleNameQualifier(@JetValueParameter(name="project") Project project, @JetValueParameter(name="module", type="?") Module module) {
            if (module != null && PlatformUtils.isIntelliJ()) {
                String string = module.getName();
                String string2 = project.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.getName()");
                if (!KotlinPackage.equals((String)string, (String)string2, (boolean)true)) {
                    String string3 = module.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"module.getName()");
                    if (!BuiltInWebServerPackage$BuiltInWebServer$294e1965.compareNameAndProjectBasePath(string3, project)) {
                        return module.getName();
                    }
                }
            }
            return null;
        }

        private final PathInfo findByRelativePath(@JetValueParameter(name="path") String path, @JetValueParameter(name="roots") VirtualFile[] roots, @JetValueParameter(name="resolver") PairFunction<String, VirtualFile, VirtualFile> resolver, @JetValueParameter(name="moduleName", type="?") String moduleName) {
            for (int i = 0; i < roots.length; ++i) {
                VirtualFile root = roots[i];
                VirtualFile file = (VirtualFile)resolver.fun((Object)path, (Object)root);
                if (file == null) continue;
                return new PathInfo(file, root, moduleName, false);
            }
            return null;
        }

        private final PathInfo findByRelativePath(@JetValueParameter(name="project") Project project, @JetValueParameter(name="path") String path, @JetValueParameter(name="modules") Module[] modules, @JetValueParameter(name="rootProvider") RootProvider rootProvider, @JetValueParameter(name="resolver") PairFunction<String, VirtualFile, VirtualFile> resolver) {
            for (int i = 0; i < modules.length; ++i) {
                ModuleRootManager moduleRootManager;
                Module module = modules[i];
                if (module.isDisposed()) continue;
                ModuleRootManager moduleRootManager2 = moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager2, (String)"moduleRootManager");
                PathInfo result = this.findByRelativePath(path, rootProvider.getRoots(moduleRootManager2), resolver, null);
                if (result == null) continue;
                result.moduleName = this.getModuleNameQualifier(project, module);
                return result;
            }
            return null;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ OrderRootType access$getJavadocOrderRootType$0(@JetValueParameter(name="$this", type="?") Companion $this) {
            return $this.getJavadocOrderRootType();
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$9() {
            return new Companion();
        }
    }
}

