/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.Breakpoint$$TImpl;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.util.concurrency.Promise;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0016\n)q!I]3bWB|\u0017N\u001c;CCN,'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\tI\u0016\u0014WoZ4fe*\tAJC\u0002B]fTaa[8uY&t'B\u0003\"sK\u0006\\\u0007o\\5oi*1A(\u001b8jizRa\u0001^1sO\u0016$(\u0002\u0005\"sK\u0006\\\u0007o\\5oiR\u000b'oZ3u\u0015\u0011a\u0017N\\3\u000b\u0007%sGO\u0003\u0004d_2,XN\u001c\u0006\nG>tG-\u001b;j_:Taa\u0015;sS:<'bB3oC\ndW\r\u001a\u0006\b\u0005>|G.Z1o\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0010C\u000e$X/\u00197M_\u000e\fG/[8og*YQ*\u001e;bE2,G*[:u\u0015\u0011)H/\u001b7\u000b\t1K7\u000f\u001e\u0006\u0013O\u0016$\u0018i\u0019;vC2dunY1uS>t7OC\u0005hKR\u001cu\u000e\\;n]*)a/\u00197vK*aq-\u001a;D_:$\u0017\u000e^5p]*a1/\u001a;D_:$\u0017\u000e^5p]*)A-\u001b:us*Aq-\u001a;ESJ$\u0018P\u0003\u0005tKR$\u0015N\u001d;z\u0015)9W\r^#oC\ndW\r\u001a\u0006\u000bg\u0016$XI\\1cY\u0016$'BC5t%\u0016\u001cx\u000e\u001c<fI*iq-\u001a;JgJ+7o\u001c7wK\u0012TqaZ3u\u0019&tWMC\u0004tKRd\u0015N\\3\u000b\u0013\u001d,G\u000fV1sO\u0016$(\"\u00024mkND'\"\u00052sK\u0006\\\u0007o\\5oi6\u000bg.Y4fe*\t\"I]3bWB|\u0017N\u001c;NC:\fw-\u001a:\u000b\u000fA\u0013x.\\5tK*Y1m\u001c8dkJ\u0014XM\\2z\u0015!A\u0017m\u001d5D_\u0012,'BD5t-6\u0014VmZ5ti\u0016\u0014X\r\u001a\u0006\u0012g\u0016$\u0018i\u0019;vC2dunY1uS>t'\u0002B+oSRTaa\u00142kK\u000e$(BE:fi\u0006\u001bG/^1m\u0019>\u001c\u0017\r^5p]N$\u001cA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\tA)\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001r\u0001\u0007\u0001\u000b\r!\u0011\u0001C\u0003\r\u0001\u0015\u0019AA\u0001\u0005\u0007\u0019\u0001)1\u0001\u0002\u0002\t\u00101\u0001Qa\u0001\u0003\u0003\u0011#a\u0001!\u0002\u0002\u0005\u0003!)Q!\u0001\u0005\n\u000b\t!a\u0001c\u0005\u0006\u0005\u00115\u0001rB\u0003\u0004\t\tA)\u0002\u0004\u0001\u0006\u0005\u00111\u0001bC\u0003\u0003\t!A9\"B\u0002\u0005\u0003!%B\u0002A\u0003\u0003\t\u0003A1\"\u0002\u0002\u0005\u0014!-Ra\u0001\u0003\u000b\u0011Ua\u0001!\u0002\u0002\u0005\u0015!)RA\u0001\u0003\u0002\u0011S)1\u0001\u0002\u0002\t01\u0001QA\u0001C\u0007\u0011a)1\u0001\u0002\u0002\t\u00181\u0001Aa\u0005G\u0002+\u0015!\u0001\u0001\u0003\u0002\u0016\u0005\u0015\t\u0001RA\r\u0003\u000b\u0005A1!\f\u000b\u0005G\u0012A\"\"I\u0004\u0006\u0003!=\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001V\u0007!)1\u0001\u0002\u0006\n\u0003!EQb\u0001\u0003\r\u0013\u0005A\t\"L\b\u0005G\u0012Aj!\t\u0002\u0006\u0003!!Qk\u0001\u0005\u0006\u0007\u00115\u0011\"\u0001C\u0003\u001b\r!I\"C\u0001\u0005\u00065~Ba3\u0007\u0019\u000fu=A\u0001\u0001\u0005\u000e\u001b\r)\u0011\u0001#\u0003\r\u0002A\u001b\u0001!I\u0002\u0006\u0003!%A\u0012\u0001\u0015,+\u000eqQa\u0001\u0003\b\u0013\u0005Aq!D\u0002\u0005\u001c%\t\u0001bB\t\u0006\t9I\u0011\u0001\u0002\u0001\u000e\u0003!9Qf\u0006CC\u001aau\u0011EA\u0003\u0002\u0011\u0015!#\u0001\u000b\u0002V\u00079)1\u0001\"\b\n\u0003\u0011\u0005Qb\u0001\u0003\u0010\u0013\u0005!\t!E\u0003\u0005 %\tA\u0001A\u0007\u0002\t\u0003i[\u0004Bf\r1!ij\u0001\u0002\u0001\t\u001b5\u0011Q!\u0001\u0005\u0006!\u000e\u0001\u0011EA\u0003\u0002\u0011\u0015A3&V\u0002\u000f\u000b\r!\u0001\"C\u0001\u0005\u00025\u0019A\u0001E\u0005\u0002\t\u0003\tR\u0001\"\t\n\u0003\u0011\u0001Q\"\u0001C\u0001[1!1\u000e\u0002\r\u0012C\t)\u0011\u0001C\u0003%WU\u001bA!D\u0002\u0005$%\tA\u0011A\u0017\u0017\t-g\u00014B\u0011\u0003\u000b\u0005AA\u0001\u000b\u0005V\u00079)1\u0001b\u0003\n\u0003\u0011\u0015Qb\u0001\u0003\u0013\u0013\u0005!)!E\u0003\u0005&%\tA\u0001A\u0007\u0002\t\u000bis\u0002B6\u00051\u0013\t#!B\u0001\t\bU\u001b\u0001\"B\u0002\u0005\n%\t\u00012B\u0007\u0004\tMI\u0011\u0001c\u0003.+\u0011\u0019\u0002tEO\u0007\t\u0001AA#\u0004\u0002\u0006\u0003!I\u0001k\u0001\u0001\"\t\u0015\t\u0001RC\u0005\u0002\t\u0007\t6!\u0002C\u0014\u0013\u0005A1\"D\u0001\t\u00185NAa\u0003\r\u0017C\t)\u0011\u0001\u0003\u0003R\u0007\r!a#C\u0001\u0005\u00065NAa\u0005M\u0017C\t)\u0011\u0001C\u0003R\u0007\r!i#C\u0001\u0005\u00025*Ba\u0001\r\u0018;#!\u0001\u0001C\u0007\u000e\t\u0015\u0011A\u0011\u0001\u0005\u0001\u0019\u0003\u00016\u0001A\u0011\u0003\u000b\u0005AA\"U\u0002\u0006\t]I\u0011\u0001\u0002\u0001\u000e\u0003!eQ&\u0007\u0003\u00041ciJ\u0002\u0002\u0001\t\u001b5AQ!\u0001\u0005\u000e\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001A\u0012\u0001)\u0004\u0001\u0005\u0012Q!\u0001\u0005\r#\u000e)A\u0011G\u0005\u0002\t\u0001i\u0011\u0001#\u00056\u000f\u0004)Y\u0019\u0001\u0003d\u0002E)A\u0001\u0001\u0005\u0003+\t)\u0011\u0001#\u0002\u0019\tu5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001c\u0002Q\u0007\u0001ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0005!\u000e\u0005QT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\tA\u001b\u0011!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u0013a\t\u0001UB\u0002;\u001b!\u0001\u0001\u0003\u0005\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0005\u0005:Q!\u0001E\u0002\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011kA\u0007\u0005\t%\tA\u0001A\u0007\u0002\u0011\u0017i\u0011\u0001\"\u0002\u000e\u0003\u0011\u0015Q\"\u0001\u0005\b\u001b\u0005!\t\u0001"})
public abstract class BreakpointBase<L>
implements Breakpoint {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final List<L> actualLocations;
    private volatile boolean dirty;
    @Nullable
    private String condition;
    private boolean enabled;
    @NotNull
    private final BreakpointTarget target;
    private int line;
    private final int column;

    static {
        $kotlinClass = Reflection.createKotlinClass(BreakpointBase.class);
    }

    @NotNull
    public final List<L> getActualLocations() {
        return this.actualLocations;
    }

    protected final boolean getDirty() {
        return this.dirty;
    }

    protected final void setDirty(@JetValueParameter(name="<set-?>") boolean bl) {
        this.dirty = bl;
    }

    @Override
    public boolean getIsResolved() {
        return !this.actualLocations.isEmpty();
    }

    @Override
    @Nullable
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(@JetValueParameter(name="value", type="?") @Nullable String value) {
        if (Intrinsics.areEqual((Object)this.getCondition(), (Object)value) ^ true) {
            this.condition = value;
            this.dirty = true;
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(@JetValueParameter(name="value") boolean value) {
        if (value != this.getEnabled()) {
            this.enabled = value;
            this.dirty = true;
        }
    }

    public final void setActualLocations(@JetValueParameter(name="value", type="?") @Nullable List<? extends L> value) {
        this.actualLocations.clear();
        if (!ContainerUtil.isEmpty((Collection)value)) {
            List<? extends L> list = value;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            this.actualLocations.addAll((Collection)list);
        }
    }

    public final void setActualLocation(@JetValueParameter(name="value", type="?") @Nullable L value) {
        this.actualLocations.clear();
        if (value != null) {
            this.actualLocations.add(value);
        }
    }

    public abstract boolean isVmRegistered();

    public int hashCode() {
        int result = this.getLine();
        result *= 31 + this.column;
        result *= 31 + (this.getEnabled() ? 1 : 0);
        if (this.getCondition() != null) {
            String string = this.getCondition();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            result *= 31 + string.hashCode();
        }
        return result *= 31 + this.getTarget().hashCode();
    }

    @NotNull
    public abstract Promise<?> flush(@JetValueParameter(name="breakpointManager") @NotNull BreakpointManager var1);

    @Override
    @NotNull
    public BreakpointTarget getTarget() {
        return this.target;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(@JetValueParameter(name="<set-?>") int n) {
        this.line = n;
    }

    public final int getColumn() {
        return this.column;
    }

    public BreakpointBase(@JetValueParameter(name="target") @NotNull BreakpointTarget target, @JetValueParameter(name="line") int line, @JetValueParameter(name="column") int column, @JetValueParameter(name="condition", type="?") @Nullable String condition, @JetValueParameter(name="enabled") boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        this.line = line;
        this.column = column;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLockFreeCopyOnWriteList<L>()");
        this.actualLocations = list;
        this.condition = condition;
        this.enabled = enabled;
    }

    @Override
    public boolean isActualLineCorrect() {
        return Breakpoint$$TImpl.isActualLineCorrect(this);
    }
}

