/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.load.kotlin.reflect

import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleParameters
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl
import kotlin.reflect.jvm.internal.impl.di.InjectorForRuntimeDescriptorLoader
import kotlin.reflect.jvm.internal.impl.name.Name
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassResolver
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager

public class RuntimeModuleData private(private val injector: InjectorForRuntimeDescriptorLoader) {
    public val module: ModuleDescriptor get() = injector.getModuleDescriptor()

    public val localClassResolver: LocalClassResolver get() = injector.getDeserializationComponentsForJava().components.localClassResolver

    companion object {
        public fun create(classLoader: ClassLoader): RuntimeModuleData {
            val storageManager = LockBasedStorageManager()
            val module = ModuleDescriptorImpl(Name.special("<runtime module for $classLoader>"), storageManager,
                                              ModuleParameters(listOf(), JavaToKotlinClassMap.INSTANCE))
            module.addDependencyOnModule(module)
            module.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule())
            module.seal()
            val injector = InjectorForRuntimeDescriptorLoader(classLoader, module, storageManager)
            module.initialize(injector.getJavaDescriptorResolver().packageFragmentProvider)
            return RuntimeModuleData(injector)
        }
    }
}
