/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;

public class GroovyScriptClass
extends LightElement
implements PsiClass,
SyntheticElement {
    private final GroovyFile myFile;
    private volatile PsiMethod myMainMethod = null;
    private volatile PsiMethod myRunMethod = null;
    private volatile boolean myInitialized = false;
    private final LightModifierList myModifierList;

    public GroovyScriptClass(GroovyFile file) {
        super(file.getManager(), file.getLanguage());
        this.myFile = file;
        this.myModifierList = new LightModifierList(this.myManager, (Language)GroovyLanguage.INSTANCE, new String[]{"public"});
    }

    public String toString() {
        return "Script Class:" + this.getQualifiedName();
    }

    public String getText() {
        return "class " + this.getName() + " {}";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        }
    }

    public PsiElement copy() {
        return new GroovyScriptClass(this.myFile);
    }

    public GroovyFile getContainingFile() {
        return this.myFile;
    }

    public TextRange getTextRange() {
        return this.myFile.getTextRange();
    }

    public int getTextOffset() {
        return 0;
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.isScript();
    }

    @Nullable
    public String getQualifiedName() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        String packName = this.myFile.getPackageName();
        if (packName.isEmpty()) {
            return name;
        }
        return packName + "." + name;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isWritable() {
        return this.myFile.isWritable();
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "add"));
        }
        return this.myFile.add(element);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "addAfter"));
        }
        return this.myFile.addAfter(element, anchor);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "addBefore"));
        }
        return this.myFile.addBefore(element, anchor);
    }

    public PsiReferenceList getExtendsList() {
        return null;
    }

    public PsiReferenceList getImplementsList() {
        return null;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType type = this.getSuperClassTypeFromBaseScriptAnnotatedVariable();
        if (type != null) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{type};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType superClassFromDSL = GroovyDslFileIndex.processScriptSuperClasses(this.myFile);
        if (superClassFromDSL != null) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{superClassFromDSL};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType superClass = TypesUtil.createTypeByFQClassName("groovy.lang.Script", (PsiElement)this);
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{superClass};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @Nullable
    private PsiClassType getSuperClassTypeFromBaseScriptAnnotatedVariable() {
        return (PsiClassType)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)false, (Computable)new Computable<PsiClassType>(){

            public PsiClassType compute() {
                return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)GroovyScriptClass.this.myFile, (CachedValueProvider)new CachedValueProvider<PsiClassType>(){

                    @Nullable
                    public CachedValueProvider.Result<PsiClassType> compute() {
                        PsiType type;
                        GrTypeElement typeElement;
                        GrModifierList modifierList;
                        GrVariableDeclaration declaration = GroovyScriptClass.this.findDeclaration();
                        if (declaration != null && (modifierList = declaration.getModifierList()).findAnnotation("groovy.transform.BaseScript") != null && (typeElement = declaration.getTypeElementGroovy()) != null && (type = typeElement.getType()) instanceof PsiClassType) {
                            return CachedValueProvider.Result.create((Object)((PsiClassType)type), (Object[])new Object[]{GroovyScriptClass.this.myFile});
                        }
                        return CachedValueProvider.Result.create(null, (Object[])new Object[]{GroovyScriptClass.this.myFile});
                    }
                });
            }
        });
    }

    @Nullable
    private GrVariableDeclaration findDeclaration() {
        final Ref ref = Ref.create();
        this.myFile.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariableDeclaration(GrVariableDeclaration variableDeclaration) {
                super.visitVariableDeclaration(variableDeclaration);
                if (variableDeclaration.getModifierList().findAnnotation("groovy.transform.BaseScript") != null) {
                    ref.set((Object)variableDeclaration);
                }
            }

            @Override
            public void visitElement(GroovyPsiElement element) {
                if (ref.isNull()) {
                    super.visitElement(element);
                }
            }
        });
        return (GrVariableDeclaration)ref.get();
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getImplementsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass((PsiClass)this);
    }

    public PsiClass[] getInterfaces() {
        return PsiClassImplUtil.getInterfaces((PsiClass)this);
    }

    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers((PsiClass)this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getSupers"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes((PsiClass)this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getSuperTypes"));
        }
        return psiClassTypeArray;
    }

    public PsiClass getContainingClass() {
        return null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection collection = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getVisibleSignatures"));
        }
        return collection;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = GrScriptField.getScriptFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiMethod[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiMethod[]> compute() {
                PsiMethod[] methods;
                if (!GroovyScriptClass.this.myInitialized) {
                    GroovyScriptClass.this.initMethods();
                }
                int addMain = GroovyScriptClass.this.hasMain(methods = GroovyScriptClass.this.myFile.getMethods()) ? 0 : 1;
                int addRun = GroovyScriptClass.this.hasRun(methods) ? 0 : 1;
                PsiMethod[] result = GroovyScriptClass.this.initMethods(methods, addMain, addRun);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{GroovyScriptClass.this.myFile});
            }
        });
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getMethods"));
        }
        return psiMethodArray;
    }

    private PsiMethod[] initMethods(PsiMethod[] methods, int addMain, int addRun) {
        if (addMain + addRun == 0) {
            return methods;
        }
        PsiMethod[] result = new PsiMethod[methods.length + addMain + addRun];
        if (addMain == 1) {
            result[0] = this.myMainMethod;
        }
        if (addRun == 1) {
            result[addMain] = this.myRunMethod;
        }
        System.arraycopy(methods, 0, result, addMain + addRun, methods.length);
        return result;
    }

    private boolean hasMain(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "hasMain"));
        }
        assert (this.myMainMethod != null);
        return ContainerUtil.find((Object[])methods, (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod method) {
                return method.isEquivalentTo((PsiElement)GroovyScriptClass.this.myMainMethod);
            }
        }) != null;
    }

    private boolean hasRun(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "hasRun"));
        }
        assert (this.myRunMethod != null);
        return ContainerUtil.find((Object[])methods, (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod method) {
                return method.isEquivalentTo((PsiElement)GroovyScriptClass.this.myRunMethod);
            }
        }) != null;
    }

    private synchronized void initMethods() {
        if (this.myInitialized) {
            return;
        }
        this.myMainMethod = new LightMethodBuilder(this.getManager(), (Language)GroovyLanguage.INSTANCE, "main").setContainingClass((PsiClass)this).setMethodReturnType((PsiType)PsiType.VOID).addParameter("args", (PsiType)new PsiArrayType((PsiType)PsiType.getJavaLangString((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()))).addModifiers(new String[]{"public", "static"});
        this.myRunMethod = new LightMethodBuilder(this.getManager(), (Language)GroovyLanguage.INSTANCE, "run").setContainingClass((PsiClass)this).setMethodReturnType((PsiType)TypesUtil.getJavaLangObject((PsiElement)this)).addModifier("public");
        this.myInitialized = true;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getConstructors"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getInnerClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getInitializers"));
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getTypeParameters"));
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields((PsiClass)this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods((PsiClass)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        return PsiClassImplUtil.findFieldByName((PsiClass)this, (String)name, (boolean)checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature((PsiClass)this, (PsiMethod)patternMethod, (boolean)checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature((PsiClass)this, (PsiMethod)patternMethod, (boolean)checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName((PsiClass)this, (String)name, (boolean)checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName((PsiClass)this, (String)name, (boolean)checkBases);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "findMethodsAndTheirSubstitutorsByName"));
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List list = PsiClassImplUtil.getAllWithSubstitutorsByMap((PsiClass)this, (PsiClassImplUtil.MemberType)PsiClassImplUtil.MemberType.METHOD);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "getAllMethodsAndTheirSubstitutors"));
        }
        return list;
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return PsiClassImplUtil.findInnerByName((PsiClass)this, (String)name, (boolean)checkBases);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    public boolean hasTypeParameters() {
        return false;
    }

    public PsiJavaToken getLBrace() {
        return null;
    }

    public PsiJavaToken getRBrace() {
        return null;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public PsiElement getScope() {
        return this.myFile;
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "isInheritor"));
        }
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    @Nullable
    public String getName() {
        String fileName = this.myFile.getName();
        String name = FileUtilRt.getNameWithoutExtension((String)fileName);
        if (StringUtil.isJavaIdentifier((String)name)) {
            return name;
        }
        return null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "setName"));
        }
        this.myFile.setName(PathUtil.makeFileName((String)name, (String)this.myFile.getViewProvider().getVirtualFile().getExtension()));
        return this;
    }

    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "hasModifierProperty"));
        }
        return this.myModifierList.hasModifierProperty(name);
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass", "processDeclarations"));
        }
        return PsiClassImplUtil.processDeclarationsInClass((PsiClass)this, (PsiScopeProcessor)processor, (ResolveState)state, (Set)ContainerUtil.newHashSet(), (PsiElement)lastParent, (PsiElement)place, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)place), (boolean)false);
    }

    public PsiElement getContext() {
        return this.myFile;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                String name = GroovyScriptClass.this.getName();
                return name != null ? name : "<unnamed>";
            }

            public String getLocationString() {
                String packageName = GroovyScriptClass.this.myFile.getPackageName();
                return "(groovy script" + (packageName.isEmpty() ? "" : ", " + packageName) + ")";
            }

            public Icon getIcon(boolean open) {
                return GroovyScriptClass.this.getIcon(3);
            }
        };
    }

    @Nullable
    public PsiElement getOriginalElement() {
        return JavaPsiImplementationHelper.getInstance((Project)this.getProject()).getOriginalClass((PsiClass)this);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    public Icon getIcon(int flags) {
        Icon icon = this.myFile.getIcon(flags);
        RowIcon baseIcon = ElementBase.createLayeredIcon((Iconable)this, (Icon)icon, (int)0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    public void delete() throws IncorrectOperationException {
        this.myFile.delete();
    }
}

