/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitMergeAction
extends GitRepositoryAction {
    GitMergeAction() {
    }

    @Nullable
    protected abstract DialogState displayDialog(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3);

    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, final Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitMergeAction", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoots", "git4idea/actions/GitMergeAction", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRoot", "git4idea/actions/GitMergeAction", "perform"));
        }
        DialogState dialogState = this.displayDialog(project, gitRoots, defaultRoot);
        if (dialogState == null) {
            return;
        }
        final VirtualFile selectedRoot = dialogState.selectedRoot;
        final Computable<GitLineHandler> handlerProvider = dialogState.handlerProvider;
        final Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, "Before update");
        new Task.Backgroundable(project, dialogState.progressTitle, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitMergeAction$1", "run"));
                }
                GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
                Git git = (Git)ServiceManager.getService(Git.class);
                final GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(selectedRoot, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                final GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(selectedRoot);
                final GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
                try {
                    GitCommandResult result = git.runCommand(new Computable<GitLineHandler>(){

                        public GitLineHandler compute() {
                            GitLineHandler handler = (GitLineHandler)handlerProvider.compute();
                            handler.addLineListener(localChangesDetector);
                            handler.addLineListener(untrackedFilesDetector);
                            handler.addLineListener(mergeConflict);
                            return handler;
                        }
                    });
                    affectedRoots.add(selectedRoot);
                    GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(selectedRoot);
                    assert (repository != null) : "Repository can't be null for root " + selectedRoot;
                    String revision = repository.getCurrentRevision();
                    if (revision == null) {
                        return;
                    }
                    GitRevisionNumber currentRev = new GitRevisionNumber(revision);
                    GitMergeAction.this.handleResult(result, project, mergeConflict, localChangesDetector, untrackedFilesDetector, repository, currentRev, affectedRoots, beforeLabel);
                }
                finally {
                    DvcsUtil.workingTreeChangeFinished((Project)project, (AccessToken)token);
                }
            }
        }.queue();
    }

    private void handleResult(GitCommandResult result, Project project, GitSimpleEventDetector mergeConflictDetector, GitLocalChangesWouldBeOverwrittenDetector localChangesDetector, GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector, GitRepository repository, GitRevisionNumber currentRev, Set<VirtualFile> affectedRoots, Label beforeLabel) {
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        VirtualFile root = repository.getRoot();
        if (result.success() || mergeConflictDetector.hasHappened()) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            GitMergeUtil.showUpdates(this, project, exceptions, root, currentRev, beforeLabel, this.getActionName(), ActionInfo.UPDATE);
            repositoryManager.updateRepository(root);
            this.runFinalTasks(project, GitVcs.getInstance(project), affectedRoots, this.getActionName(), exceptions);
        } else if (localChangesDetector.wasMessageDetected()) {
            LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, repository.getRoot(), this.getActionName(), localChangesDetector.getRelativeFilePaths());
        } else if (untrackedFilesDetector.wasMessageDetected()) {
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, untrackedFilesDetector.getRelativeFilePaths(), this.getActionName(), null);
        } else {
            GitUIUtil.notifyError(project, "Git " + this.getActionName() + " Failed", result.getErrorOutputAsJoinedString(), true, null);
            repositoryManager.updateRepository(root);
        }
    }

    @Override
    protected boolean executeFinalTasksSynchronously() {
        return false;
    }

    protected static class DialogState {
        final VirtualFile selectedRoot;
        final String progressTitle;
        final Computable<GitLineHandler> handlerProvider;

        DialogState(@NotNull VirtualFile root, @NotNull String title, @NotNull Computable<GitLineHandler> provider) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/actions/GitMergeAction$DialogState", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/actions/GitMergeAction$DialogState", "<init>"));
            }
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "git4idea/actions/GitMergeAction$DialogState", "<init>"));
            }
            this.selectedRoot = root;
            this.progressTitle = title;
            this.handlerProvider = provider;
        }
    }
}

