/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBrancherImpl
implements GitBrancher {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitPlatformFacade myFacade;
    @NotNull
    private final Git myGit;

    GitBrancherImpl(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Git git) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBrancherImpl", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/branch/GitBrancherImpl", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/branch/GitBrancherImpl", "<init>"));
        }
        this.myProject = project;
        this.myFacade = facade;
        this.myGit = git;
    }

    @Override
    public void checkoutNewBranch(final @NotNull String name, final @NotNull List<GitRepository> repositories) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBrancherImpl", "checkoutNewBranch"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "checkoutNewBranch"));
        }
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$1", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories);
            }
        }.runInBackground();
    }

    private GitBranchWorker newWorker(ProgressIndicator indicator) {
        return new GitBranchWorker(this.myProject, this.myFacade, this.myGit, new GitBranchUiHandlerImpl(this.myProject, this.myFacade, this.myGit, indicator));
    }

    @Override
    public void createNewTag(final @NotNull String name, final @NotNull String reference, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/GitBrancherImpl", "createNewTag"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/branch/GitBrancherImpl", "createNewTag"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "createNewTag"));
        }
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$2", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final @NotNull String reference, final boolean detach, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "git4idea/branch/GitBrancherImpl", "checkout"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "checkout"));
        }
        new CommonBackgroundTask(this.myProject, "Checking out " + reference, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$3", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, detach, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(final @NotNull String newBranchName, final @NotNull String startPoint, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (newBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBranchName", "git4idea/branch/GitBrancherImpl", "checkoutNewBranchStartingFrom"));
        }
        if (startPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPoint", "git4idea/branch/GitBrancherImpl", "checkoutNewBranchStartingFrom"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "checkoutNewBranchStartingFrom"));
        }
        new CommonBackgroundTask(this.myProject, String.format("Checking out %s from %s", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$4", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(final @NotNull String branchName, final @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitBrancherImpl", "deleteBranch"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "deleteBranch"));
        }
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$5", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).deleteBranch(branchName, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(final @NotNull String branchName, final @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitBrancherImpl", "deleteRemoteBranch"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "deleteRemoteBranch"));
        }
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$6", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranch(branchName, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void compare(final @NotNull String branchName, final @NotNull List<GitRepository> repositories, final @NotNull GitRepository selectedRepository) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitBrancherImpl", "compare"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "compare"));
        }
        if (selectedRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRepository", "git4idea/branch/GitBrancherImpl", "compare"));
        }
        new CommonBackgroundTask(this.myProject, "Comparing with " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$7", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).compare(branchName, repositories, selectedRepository);
            }
        }.runInBackground();
    }

    @Override
    public void merge(final @NotNull String branchName, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitBrancherImpl", "merge"));
        }
        if (deleteOnMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleteOnMerge", "git4idea/branch/GitBrancherImpl", "merge"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "merge"));
        }
        new CommonBackgroundTask(this.myProject, "Merging " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$8", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void rebase(final @NotNull List<GitRepository> repositories, final @NotNull String branchName) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBrancherImpl", "rebase"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/branch/GitBrancherImpl", "rebase"));
        }
        new CommonBackgroundTask(this.myProject, "Rebasing " + branchName, null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$9", "execute"));
                }
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, branchName);
            }
        }.runInBackground();
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(@Nullable Project project, @NotNull String title, @Nullable Runnable callInAwtAfterExecution) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/branch/GitBrancherImpl$CommonBackgroundTask", "<init>"));
            }
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$CommonBackgroundTask", "run"));
            }
            this.execute(indicator);
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode()) {
                    this.myCallInAwtAfterExecution.run();
                } else {
                    application.invokeLater(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
                }
            }
        }

        abstract void execute(@NotNull ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }
    }
}

