/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommandResult {
    private final boolean mySuccess;
    private final int myExitCode;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;
    @Nullable
    private final Throwable myException;

    public GitCommandResult(boolean success, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output, @Nullable Throwable exception) {
        if (errorOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutput", "git4idea/commands/GitCommandResult", "<init>"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/commands/GitCommandResult", "<init>"));
        }
        this.myExitCode = exitCode;
        this.mySuccess = success;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
        this.myException = exception;
    }

    @NotNull
    public static GitCommandResult merge(@Nullable GitCommandResult first, @NotNull GitCommandResult second) {
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "git4idea/commands/GitCommandResult", "merge"));
        }
        if (first == null) {
            GitCommandResult gitCommandResult = second;
            if (gitCommandResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "merge"));
            }
            return gitCommandResult;
        }
        int mergedExitCode = first.myExitCode == 0 ? second.myExitCode : (second.myExitCode == 0 ? first.myExitCode : second.myExitCode);
        GitCommandResult gitCommandResult = new GitCommandResult(first.success() && second.success(), mergedExitCode, ContainerUtil.concat(first.myErrorOutput, second.myErrorOutput), ContainerUtil.concat(first.myOutput, second.myOutput), (Throwable)ObjectUtils.chooseNotNull((Object)second.myException, (Object)first.myException));
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "merge"));
        }
        return gitCommandResult;
    }

    public boolean success() {
        return this.mySuccess;
    }

    @NotNull
    public List<String> getOutput() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myOutput);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getOutput"));
        }
        return arrayList;
    }

    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    public String getErrorOutputAsHtmlString() {
        List<String> outputToDisplay = this.myErrorOutput.isEmpty() && !this.success() ? this.myOutput : this.myErrorOutput;
        String string = StringUtil.join(GitCommandResult.cleanup(outputToDisplay), (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getErrorOutputAsHtmlString"));
        }
        return string;
    }

    @NotNull
    public String getErrorOutputAsJoinedString() {
        String string = StringUtil.join(this.myErrorOutput, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getErrorOutputAsJoinedString"));
        }
        return string;
    }

    @NotNull
    public String getOutputAsJoinedString() {
        String string = StringUtil.join(this.myOutput, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "getOutputAsJoinedString"));
        }
        return string;
    }

    @Nullable
    public Throwable getException() {
        return this.myException;
    }

    @NotNull
    public static GitCommandResult error(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/commands/GitCommandResult", "error"));
        }
        GitCommandResult gitCommandResult = new GitCommandResult(false, 1, Collections.singletonList(error), Collections.<String>emptyList(), null);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "error"));
        }
        return gitCommandResult;
    }

    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        if (errorOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutput", "git4idea/commands/GitCommandResult", "cleanup"));
        }
        List list = ContainerUtil.map(errorOutput, (Function)new Function<String, String>(){

            public String fun(String errorMessage) {
                return GitUtil.cleanupErrorPrefixes(errorMessage);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitCommandResult", "cleanup"));
        }
        return list;
    }
}

