/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.InferencePackage;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.SubstitutingScope;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeVariable;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.DisjointKeysUnionTypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.IndexedParametersSubstitution;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilPackage;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypesApproximationPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeSubstitutor {
    private static final int MAX_RECURSION_DEPTH = 100;
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    @NotNull
    private final TypeSubstitution substitution;

    @NotNull
    public static TypeSubstitutor create(@NotNull TypeSubstitution substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "create"));
        }
        TypeSubstitutor typeSubstitutor2 = new TypeSubstitutor(substitution);
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "create"));
        }
        return typeSubstitutor2;
    }

    @NotNull
    public static TypeSubstitutor createChainedSubstitutor(@NotNull TypeSubstitution first, @NotNull TypeSubstitution second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "createChainedSubstitutor"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "createChainedSubstitutor"));
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(DisjointKeysUnionTypeSubstitution.create(first, second));
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "createChainedSubstitutor"));
        }
        return typeSubstitutor2;
    }

    @NotNull
    public static TypeSubstitutor create(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
        if (substitutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionContext", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "create"));
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(TypeConstructorSubstitution.createByConstructorsMap(substitutionContext));
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "create"));
        }
        return typeSubstitutor2;
    }

    @NotNull
    public static TypeSubstitutor create(@NotNull JetType context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "create"));
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new IndexedParametersSubstitution(context.getConstructor(), context.getArguments()));
        if (typeSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "create"));
        }
        return typeSubstitutor2;
    }

    protected TypeSubstitutor(@NotNull TypeSubstitution substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "<init>"));
        }
        this.substitution = substitution;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    @NotNull
    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.substitution;
        if (typeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "getSubstitution"));
        }
        return typeSubstitution;
    }

    @NotNull
    public JetType safeSubstitute(@NotNull JetType type2, @NotNull Variance howThisTypeIsUsed) {
        JetType jetType;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "safeSubstitute"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "safeSubstitute"));
        }
        if (this.isEmpty()) {
            JetType jetType2 = type2;
            if (jetType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "safeSubstitute"));
            }
            return jetType2;
        }
        try {
            jetType = this.unsafeSubstitute(new TypeProjectionImpl(howThisTypeIsUsed, type2), 0).getType();
        }
        catch (SubstitutionException e) {
            JetType jetType3 = ErrorUtils.createErrorType(e.getMessage());
            if (jetType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "safeSubstitute"));
            }
            return jetType3;
        }
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "safeSubstitute"));
        }
        return jetType;
    }

    @Nullable
    public JetType substitute(@NotNull JetType type2, @NotNull Variance howThisTypeIsUsed) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "substitute"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "substitute"));
        }
        TypeProjection projection = this.substitute(new TypeProjectionImpl(howThisTypeIsUsed, type2));
        return projection == null ? null : projection.getType();
    }

    @Nullable
    public TypeProjection substitute(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "substitute"));
        }
        TypeProjection substitutedTypeProjection = this.substituteWithoutApproximation(typeProjection);
        if (!this.substitution.approximateCapturedTypes()) {
            return substitutedTypeProjection;
        }
        return TypesApproximationPackage.approximateCapturedTypesIfNecessary(substitutedTypeProjection);
    }

    @Nullable
    public TypeProjection substituteWithoutApproximation(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "substituteWithoutApproximation"));
        }
        if (this.isEmpty()) {
            return typeProjection;
        }
        try {
            return this.unsafeSubstitute(typeProjection, 0);
        }
        catch (SubstitutionException e) {
            return null;
        }
    }

    @NotNull
    private TypeProjection unsafeSubstitute(@NotNull TypeProjection originalProjection, int recursionDepth) throws SubstitutionException {
        if (originalProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalProjection", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
        }
        TypeSubstitutor.assertRecursionDepth(recursionDepth, originalProjection, this.substitution);
        if (originalProjection.isStarProjection()) {
            TypeProjection typeProjection = originalProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
            }
            return typeProjection;
        }
        JetType type2 = originalProjection.getType();
        TypeProjection replacement = this.substitution.get(type2);
        Variance originalProjectionKind = originalProjection.getProjectionKind();
        if (replacement == null && TypesPackage.isFlexible(type2) && !TypesPackage.isCustomTypeVariable(type2)) {
            Flexibility flexibility = TypesPackage.flexibility(type2);
            TypeProjection substitutedLower = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibility.getLowerBound()), recursionDepth + 1);
            TypeProjection substitutedUpper = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibility.getUpperBound()), recursionDepth + 1);
            Variance substitutedProjectionKind = substitutedLower.getProjectionKind();
            assert (substitutedProjectionKind == substitutedUpper.getProjectionKind() && originalProjectionKind == Variance.INVARIANT || originalProjectionKind == substitutedProjectionKind) : "Unexpected substituted projection kind: " + (Object)((Object)substitutedProjectionKind) + "; original: " + (Object)((Object)originalProjectionKind);
            JetType substitutedFlexibleType = DelegatingFlexibleType.create(substitutedLower.getType(), substitutedUpper.getType(), flexibility.getExtraCapabilities());
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(substitutedProjectionKind, substitutedFlexibleType);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
            }
            return typeProjectionImpl;
        }
        if (KotlinBuiltIns.isNothing(type2) || type2.isError()) {
            TypeProjection typeProjection = originalProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
            }
            return typeProjection;
        }
        if (replacement != null) {
            VarianceConflictType varianceConflict = TypeSubstitutor.conflictType(originalProjectionKind, replacement.getProjectionKind());
            boolean allowVarianceConflict = InferencePackage.isCaptured(type2);
            if (!allowVarianceConflict) {
                switch (varianceConflict) {
                    case OUT_IN_IN_POSITION: {
                        throw new SubstitutionException("Out-projection in in-position");
                    }
                    case IN_IN_OUT_POSITION: {
                        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.OUT_VARIANCE, KotlinBuiltIns.getInstance().getNullableAnyType());
                        if (typeProjectionImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
                        }
                        return typeProjectionImpl;
                    }
                }
            }
            CustomTypeVariable typeVariable = TypesPackage.getCustomTypeVariable(type2);
            if (replacement.isStarProjection()) {
                TypeProjection typeProjection = replacement;
                if (typeProjection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
                }
                return typeProjection;
            }
            JetType substitutedType = typeVariable != null ? typeVariable.substitutionResult(replacement.getType()) : TypeUtils.makeNullableIfNeeded(replacement.getType(), type2.isMarkedNullable());
            if (!type2.getAnnotations().isEmpty()) {
                substitutedType = TypeUtilPackage.replaceAnnotations(substitutedType, new CompositeAnnotations(substitutedType.getAnnotations(), type2.getAnnotations()));
            }
            Variance resultingProjectionKind = varianceConflict == VarianceConflictType.NO_CONFLICT ? TypeSubstitutor.combine(originalProjectionKind, replacement.getProjectionKind()) : originalProjectionKind;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(resultingProjectionKind, substitutedType);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
            }
            return typeProjectionImpl;
        }
        TypeProjection typeProjection = this.substituteCompoundType(originalProjection, recursionDepth);
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "unsafeSubstitute"));
        }
        return typeProjection;
    }

    private TypeProjection substituteCompoundType(TypeProjection originalProjection, int recursionDepth) throws SubstitutionException {
        final JetType type2 = originalProjection.getType();
        Variance projectionKind = originalProjection.getProjectionKind();
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return originalProjection;
        }
        List<TypeProjection> substitutedArguments = this.substituteTypeArguments(type2.getConstructor().getParameters(), type2.getArguments(), recursionDepth);
        TypeSubstitution substitutionFilteringTypeParameters = new TypeSubstitution(){
            private final Collection<TypeConstructor> containedOrCapturedTypeParameters;
            {
                this.containedOrCapturedTypeParameters = TypeUtilPackage.getContainedAndCapturedTypeParameterConstructors(type2);
            }

            @Override
            @Nullable
            public TypeProjection get(@NotNull JetType key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor$1", "get"));
                }
                return this.containedOrCapturedTypeParameters.contains(key.getConstructor()) ? TypeSubstitutor.this.substitution.get(key) : null;
            }

            @Override
            public boolean isEmpty() {
                return TypeSubstitutor.this.substitution.isEmpty();
            }
        };
        JetTypeImpl substitutedType = JetTypeImpl.create(type2.getAnnotations(), type2.getConstructor(), type2.isMarkedNullable(), substitutedArguments, substitutionFilteringTypeParameters, new SubstitutingScope(type2.getMemberScope(), TypeSubstitutor.create(substitutionFilteringTypeParameters)), type2.getCapabilities());
        return new TypeProjectionImpl(projectionKind, substitutedType);
    }

    private List<TypeProjection> substituteTypeArguments(List<TypeParameterDescriptor> typeParameters, List<TypeProjection> typeArguments, int recursionDepth) throws SubstitutionException {
        ArrayList<TypeProjection> substitutedArguments = new ArrayList<TypeProjection>(typeParameters.size());
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            TypeProjection typeArgument = typeArguments.get(i);
            TypeProjection substitutedTypeArgument = this.unsafeSubstitute(typeArgument, recursionDepth + 1);
            switch (TypeSubstitutor.conflictType(typeParameter.getVariance(), substitutedTypeArgument.getProjectionKind())) {
                case NO_CONFLICT: {
                    if (typeParameter.getVariance() == Variance.INVARIANT || substitutedTypeArgument.isStarProjection()) break;
                    substitutedTypeArgument = new TypeProjectionImpl(Variance.INVARIANT, substitutedTypeArgument.getType());
                    break;
                }
                case OUT_IN_IN_POSITION: 
                case IN_IN_OUT_POSITION: {
                    substitutedTypeArgument = TypeUtils.makeStarProjection(typeParameter);
                }
            }
            substitutedArguments.add(substitutedTypeArgument);
        }
        return substitutedArguments;
    }

    @NotNull
    public static Variance combine(@NotNull Variance typeParameterVariance, @NotNull Variance projectionKind) {
        if (typeParameterVariance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterVariance", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "combine"));
        }
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "combine"));
        }
        if (typeParameterVariance == Variance.INVARIANT) {
            Variance variance = projectionKind;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "combine"));
            }
            return variance;
        }
        if (projectionKind == Variance.INVARIANT) {
            Variance variance = typeParameterVariance;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "combine"));
            }
            return variance;
        }
        if (typeParameterVariance == projectionKind) {
            Variance variance = projectionKind;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor", "combine"));
            }
            return variance;
        }
        throw new AssertionError((Object)("Variance conflict: type parameter variance '" + (Object)((Object)typeParameterVariance) + "' and " + "projection kind '" + (Object)((Object)projectionKind) + "' cannot be combined"));
    }

    private static VarianceConflictType conflictType(Variance position, Variance argument) {
        if (position == Variance.IN_VARIANCE && argument == Variance.OUT_VARIANCE) {
            return VarianceConflictType.OUT_IN_IN_POSITION;
        }
        if (position == Variance.OUT_VARIANCE && argument == Variance.IN_VARIANCE) {
            return VarianceConflictType.IN_IN_OUT_POSITION;
        }
        return VarianceConflictType.NO_CONFLICT;
    }

    private static void assertRecursionDepth(int recursionDepth, TypeProjection projection, TypeSubstitution substitution) {
        if (recursionDepth > 100) {
            throw new IllegalStateException("Recursion too deep. Most likely infinite loop while substituting " + TypeSubstitutor.safeToString(projection) + "; substitution: " + TypeSubstitutor.safeToString(substitution));
        }
    }

    private static String safeToString(Object o) {
        try {
            return o.toString();
        }
        catch (Throwable e) {
            if (e.getClass().getName().equals("com.intellij.openapi.progress.ProcessCanceledException")) {
                throw (RuntimeException)e;
            }
            return "[Exception while computing toString(): " + e + "]";
        }
    }

    private static enum VarianceConflictType {
        NO_CONFLICT,
        IN_IN_OUT_POSITION,
        OUT_IN_IN_POSITION;

    }

    private static final class SubstitutionException
    extends Exception {
        public SubstitutionException(String message) {
            super(message);
        }
    }
}

