/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeCapabilities;
import org.jetbrains.kotlin.load.kotlin.SignatureDeserializer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSerializerExtension
extends SerializerExtension {
    private final JvmSerializationBindings bindings;
    private final JetTypeMapper typeMapper;
    private final AnnotationSerializer annotationSerializer;

    public JvmSerializerExtension(@NotNull JvmSerializationBindings bindings, @NotNull JetTypeMapper typeMapper) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "<init>"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "<init>"));
        }
        this.annotationSerializer = new AnnotationSerializer();
        this.bindings = bindings;
        this.typeMapper = typeMapper;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class.Builder proto, @NotNull StringTable stringTable) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeClass"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeClass"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeClass"));
        }
        AnnotationDescriptor annotation2 = descriptor.getAnnotations().findAnnotation(KotlinBuiltIns.FQ_NAMES.annotation);
        if (annotation2 != null) {
            proto.addExtension(JvmProtoBuf.classAnnotation, this.annotationSerializer.serializeAnnotation(annotation2, stringTable));
        }
    }

    @Override
    public void serializeCallable(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull StringTable stringTable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeCallable"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeCallable"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeCallable"));
        }
        this.saveSignature(callable, proto, stringTable);
        this.saveImplClassName(callable, proto, stringTable);
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor, @NotNull ProtoBuf.Callable.ValueParameter.Builder proto, @NotNull StringTable stringTable) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeValueParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeValueParameter"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeValueParameter"));
        }
        Integer index2 = this.bindings.get(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, descriptor);
        if (index2 != null) {
            proto.setExtension(JvmProtoBuf.index, index2);
        }
    }

    @Override
    public void serializeType(@NotNull JetType type2, @NotNull ProtoBuf.Type.Builder proto, @NotNull StringTable stringTable) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeType"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeType"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "serializeType"));
        }
        for (AnnotationDescriptor annotation2 : type2.getAnnotations()) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.annotationSerializer.serializeAnnotation(annotation2, stringTable));
        }
        if (type2.getCapabilities() instanceof RawTypeCapabilities) {
            proto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    @NotNull
    public String getLocalClassName(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "getLocalClassName"));
        }
        String string = AsmUtil.shortNameByAsmType(this.typeMapper.mapClass(descriptor));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "getLocalClassName"));
        }
        return string;
    }

    private void saveSignature(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull StringTable stringTable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "saveSignature"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "saveSignature"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "saveSignature"));
        }
        SignatureSerializer signatureSerializer = new SignatureSerializer(stringTable);
        if (callable instanceof FunctionDescriptor) {
            JvmProtoBuf.JvmMethodSignature signature;
            if (callable instanceof DeserializedSimpleFunctionDescriptor) {
                DeserializedSimpleFunctionDescriptor deserialized = (DeserializedSimpleFunctionDescriptor)callable;
                signature = signatureSerializer.copyMethodSignature(deserialized.getProto().getExtension(JvmProtoBuf.methodSignature), deserialized.getNameResolver());
            } else {
                Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, (FunctionDescriptor)callable);
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature = method != null ? signatureSerializer.methodSignature(method) : null;
            }
            if (signature != null) {
                proto.setExtension(JvmProtoBuf.methodSignature, signature);
            }
        } else if (callable instanceof PropertyDescriptor) {
            JvmProtoBuf.JvmPropertySignature signature;
            Method syntheticMethod;
            boolean isStaticInOuter;
            String fieldName;
            Type fieldType;
            PropertyDescriptor property = (PropertyDescriptor)callable;
            PropertyGetterDescriptor getter = property.getGetter();
            PropertySetterDescriptor setter = property.getSetter();
            Method getterMethod = getter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter);
            Method setterMethod = setter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, setter);
            Pair<Type, String> field = this.bindings.get(JvmSerializationBindings.FIELD_FOR_PROPERTY, property);
            if (field != null) {
                fieldType = (Type)field.first;
                fieldName = (String)field.second;
                isStaticInOuter = this.bindings.get(JvmSerializationBindings.STATIC_FIELD_IN_OUTER_CLASS, property);
                syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, property);
            } else {
                fieldType = null;
                fieldName = null;
                isStaticInOuter = false;
                syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, property);
            }
            if (callable instanceof DeserializedPropertyDescriptor) {
                DeserializedPropertyDescriptor deserializedCallable = (DeserializedPropertyDescriptor)callable;
                signature = signatureSerializer.copyPropertySignature(deserializedCallable.getProto().getExtension(JvmProtoBuf.propertySignature), deserializedCallable.getNameResolver());
            } else {
                signature = signatureSerializer.propertySignature(fieldType, fieldName, isStaticInOuter, syntheticMethod, getterMethod, setterMethod);
            }
            proto.setExtension(JvmProtoBuf.propertySignature, signature);
        }
    }

    private void saveImplClassName(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull StringTable stringTable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "saveImplClassName"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "saveImplClassName"));
        }
        if (stringTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "saveImplClassName"));
        }
        String name = this.bindings.get(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, callable);
        if (name != null) {
            proto.setExtension(JvmProtoBuf.implClassName, stringTable.getSimpleNameIndex(Name.identifier(name)));
        }
    }

    @NotNull
    private static Method getAsmMethod(@NotNull String nameAndDesc) {
        if (nameAndDesc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameAndDesc", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "getAsmMethod"));
        }
        int indexOf = nameAndDesc.indexOf(40);
        Method method = new Method(nameAndDesc.substring(0, indexOf), nameAndDesc.substring(indexOf));
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension", "getAsmMethod"));
        }
        return method;
    }

    private static class SignatureSerializer {
        private final StringTable stringTable;

        public SignatureSerializer(@NotNull StringTable stringTable) {
            if (stringTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringTable", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "<init>"));
            }
            this.stringTable = stringTable;
        }

        @NotNull
        public JvmProtoBuf.JvmMethodSignature copyMethodSignature(@NotNull JvmProtoBuf.JvmMethodSignature signature, @NotNull NameResolver nameResolver) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "copyMethodSignature"));
            }
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "copyMethodSignature"));
            }
            String method = new SignatureDeserializer(nameResolver).methodSignatureString(signature);
            JvmProtoBuf.JvmMethodSignature jvmMethodSignature = this.methodSignature(JvmSerializerExtension.getAsmMethod(method));
            if (jvmMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "copyMethodSignature"));
            }
            return jvmMethodSignature;
        }

        @NotNull
        public JvmProtoBuf.JvmMethodSignature methodSignature(@NotNull Method method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            JvmProtoBuf.JvmMethodSignature.Builder signature = JvmProtoBuf.JvmMethodSignature.newBuilder();
            signature.setName(this.stringTable.getStringIndex(method.getName()));
            signature.setReturnType(this.type(method.getReturnType()));
            for (Type type2 : method.getArgumentTypes()) {
                signature.addParameterType(this.type(type2));
            }
            JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature.build();
            if (jvmMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            return jvmMethodSignature;
        }

        @NotNull
        public JvmProtoBuf.JvmPropertySignature copyPropertySignature(@NotNull JvmProtoBuf.JvmPropertySignature signature, @NotNull NameResolver nameResolver) {
            boolean isStaticInOuter;
            String fieldName;
            Type fieldType;
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "copyPropertySignature"));
            }
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "copyPropertySignature"));
            }
            SignatureDeserializer signatureDeserializer = new SignatureDeserializer(nameResolver);
            if (signature.hasField()) {
                JvmProtoBuf.JvmFieldSignature field = signature.getField();
                fieldType = Type.getType(signatureDeserializer.typeDescriptor(field.getType()));
                fieldName = nameResolver.getName(field.getName()).asString();
                isStaticInOuter = field.getIsStaticInOuter();
            } else {
                fieldType = null;
                fieldName = null;
                isStaticInOuter = false;
            }
            Method syntheticMethod = signature.hasSyntheticMethod() ? JvmSerializerExtension.getAsmMethod(signatureDeserializer.methodSignatureString(signature.getSyntheticMethod())) : null;
            Method getter = signature.hasGetter() ? JvmSerializerExtension.getAsmMethod(signatureDeserializer.methodSignatureString(signature.getGetter())) : null;
            Method setter = signature.hasSetter() ? JvmSerializerExtension.getAsmMethod(signatureDeserializer.methodSignatureString(signature.getSetter())) : null;
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = this.propertySignature(fieldType, fieldName, isStaticInOuter, syntheticMethod, getter, setter);
            if (jvmPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "copyPropertySignature"));
            }
            return jvmPropertySignature;
        }

        @NotNull
        public JvmProtoBuf.JvmPropertySignature propertySignature(@Nullable Type fieldType, @Nullable String fieldName, boolean isStaticInOuter, @Nullable Method syntheticMethod, @Nullable Method getter, @Nullable Method setter) {
            JvmProtoBuf.JvmPropertySignature.Builder signature = JvmProtoBuf.JvmPropertySignature.newBuilder();
            if (fieldType != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldType;
                signature.setField(this.fieldSignature(fieldType, fieldName, isStaticInOuter));
            }
            if (syntheticMethod != null) {
                signature.setSyntheticMethod(this.methodSignature(syntheticMethod));
            }
            if (getter != null) {
                signature.setGetter(this.methodSignature(getter));
            }
            if (setter != null) {
                signature.setSetter(this.methodSignature(setter));
            }
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = signature.build();
            if (jvmPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            return jvmPropertySignature;
        }

        @NotNull
        public JvmProtoBuf.JvmFieldSignature fieldSignature(@NotNull Type type2, @NotNull String name, boolean isStaticInOuter) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            JvmProtoBuf.JvmFieldSignature.Builder signature = JvmProtoBuf.JvmFieldSignature.newBuilder();
            signature.setName(this.stringTable.getStringIndex(name));
            signature.setType(this.type(type2));
            if (isStaticInOuter) {
                signature.setIsStaticInOuter(true);
            }
            JvmProtoBuf.JvmFieldSignature jvmFieldSignature = signature.build();
            if (jvmFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            return jvmFieldSignature;
        }

        @NotNull
        public JvmProtoBuf.JvmType type(@NotNull Type givenType) {
            if (givenType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "givenType", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "type"));
            }
            JvmProtoBuf.JvmType.Builder builder = JvmProtoBuf.JvmType.newBuilder();
            Type type2 = givenType;
            if (type2.getSort() == 9) {
                builder.setArrayDimension(type2.getDimensions());
                type2 = type2.getElementType();
            }
            if (type2.getSort() == 10) {
                FqName fqName2 = SignatureSerializer.internalNameToFqName(type2.getInternalName());
                builder.setClassFqName(this.stringTable.getFqNameIndex(fqName2));
            } else {
                builder.setPrimitiveType(JvmProtoBuf.JvmType.PrimitiveType.valueOf(type2.getSort()));
            }
            JvmProtoBuf.JvmType jvmType = builder.build();
            if (jvmType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "type"));
            }
            return jvmType;
        }

        @NotNull
        private static FqName internalNameToFqName(@NotNull String internalName) {
            if (internalName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            FqName fqName2 = FqName.fromSegments(Arrays.asList(internalName.split("/")));
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            return fqName2;
        }
    }
}

