/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.MaxLocalsCalculator;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MaxStackFrameSizeAndLocalsCalculator
extends MaxLocalsCalculator {
    private static final int[] FRAME_SIZE_CHANGE_BY_OPCODE;
    private final LabelWrapper firstLabel;
    private LabelWrapper currentBlock;
    private LabelWrapper previousBlock;
    private int stackSize;
    private int maxStackSize;
    private int maxStack;
    private final Collection<ExceptionHandler> exceptionHandlers = new LinkedList<ExceptionHandler>();
    private final Map<Label, LabelWrapper> labelWrappersMap = new HashMap<Label, LabelWrapper>();

    public MaxStackFrameSizeAndLocalsCalculator(int api, int access, String descriptor, MethodVisitor mv) {
        super(api, access, descriptor, mv);
        this.firstLabel = this.getLabelWrapper(new Label());
        this.processLabel(this.firstLabel.label);
    }

    @Override
    public void visitFrame(int type2, int nLocal, Object[] local, int nStack, Object[] stack) {
        throw new AssertionError((Object)"We don't support visitFrame because currently nobody needs");
    }

    @Override
    public void visitInsn(int opcode) {
        this.increaseStackSize(FRAME_SIZE_CHANGE_BY_OPCODE[opcode]);
        if (opcode >= 172 && opcode <= 177 || opcode == 191) {
            this.noSuccessor();
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode != 188) {
            this.increaseStackSize(1);
        }
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.increaseStackSize(FRAME_SIZE_CHANGE_BY_OPCODE[opcode]);
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, @NotNull String type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitTypeInsn"));
        }
        if (opcode == 187) {
            this.increaseStackSize(1);
        }
        super.visitTypeInsn(opcode, type2);
    }

    @Override
    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc) {
        int stackSizeVariation;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitFieldInsn"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitFieldInsn"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitFieldInsn"));
        }
        char c = desc.charAt(0);
        switch (opcode) {
            case 178: {
                stackSizeVariation = c == 'D' || c == 'J' ? 2 : 1;
                break;
            }
            case 179: {
                stackSizeVariation = c == 'D' || c == 'J' ? -2 : -1;
                break;
            }
            case 180: {
                stackSizeVariation = c == 'D' || c == 'J' ? 1 : 0;
                break;
            }
            default: {
                stackSizeVariation = c == 'D' || c == 'J' ? -3 : -2;
            }
        }
        this.increaseStackSize(stackSizeVariation);
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        int argSize = Type.getArgumentsAndReturnSizes(desc);
        int sizeVariation = opcode == 184 ? (argSize & 3) - (argSize >> 2) + 1 : (argSize & 3) - (argSize >> 2);
        this.increaseStackSize(sizeVariation);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInvokeDynamicInsn(@NotNull String name, @NotNull String desc, @NotNull Handle bsm, Object ... bsmArgs) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitInvokeDynamicInsn"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitInvokeDynamicInsn"));
        }
        if (bsm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bsm", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitInvokeDynamicInsn"));
        }
        if (bsmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bsmArgs", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitInvokeDynamicInsn"));
        }
        int argSize = Type.getArgumentsAndReturnSizes(desc);
        this.increaseStackSize((argSize & 3) - (argSize >> 2) + 1);
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public void visitJumpInsn(int opcode, @NotNull Label label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitJumpInsn"));
        }
        if (this.currentBlock != null) {
            this.stackSize += FRAME_SIZE_CHANGE_BY_OPCODE[opcode];
            this.addSuccessor(this.getLabelWrapper(label), this.stackSize);
            if (opcode == 167) {
                this.noSuccessor();
            }
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(@NotNull Label label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitLabel"));
        }
        this.processLabel(label);
        super.visitLabel(label);
    }

    private void processLabel(Label label) {
        LabelWrapper wrapper = this.getLabelWrapper(label);
        if (this.currentBlock != null) {
            this.currentBlock.outputStackMax = this.maxStackSize;
            this.addSuccessor(wrapper, this.stackSize);
        }
        this.currentBlock = wrapper;
        this.stackSize = 0;
        this.maxStackSize = 0;
        if (this.previousBlock != null) {
            this.previousBlock.nextLabel = wrapper;
        }
        this.previousBlock = wrapper;
    }

    @Override
    public void visitLdcInsn(@NotNull Object cst) {
        if (cst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cst", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitLdcInsn"));
        }
        if (cst instanceof Long || cst instanceof Double) {
            this.increaseStackSize(2);
        } else {
            this.increaseStackSize(1);
        }
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, @NotNull Label dflt, Label ... labels) {
        if (dflt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dflt", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitTableSwitchInsn"));
        }
        if (labels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labels", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitTableSwitchInsn"));
        }
        this.visitSwitchInsn(dflt, labels);
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(@NotNull Label dflt, @NotNull int[] keys, @NotNull Label[] labels) {
        if (dflt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dflt", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitLookupSwitchInsn"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitLookupSwitchInsn"));
        }
        if (labels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labels", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitLookupSwitchInsn"));
        }
        this.visitSwitchInsn(dflt, labels);
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    private void visitSwitchInsn(Label dflt, Label[] labels) {
        if (this.currentBlock != null) {
            --this.stackSize;
            this.addSuccessor(this.getLabelWrapper(dflt), this.stackSize);
            for (Label label : labels) {
                this.addSuccessor(this.getLabelWrapper(label), this.stackSize);
            }
            this.noSuccessor();
        }
    }

    @Override
    public void visitMultiANewArrayInsn(@NotNull String desc, int dims) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitMultiANewArrayInsn"));
        }
        if (this.currentBlock != null) {
            this.increaseStackSize(dims - 1);
        }
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        for (ExceptionHandler handler2 : this.exceptionHandlers) {
            LabelWrapper l = handler2.start;
            LabelWrapper e = handler2.end;
            while (l != e) {
                l.addSuccessor(handler2.handlerLabel, 0, true);
                l = l.nextLabel;
            }
        }
        int max = 0;
        Stack<LabelWrapper> stack = new Stack<LabelWrapper>();
        HashSet<LabelWrapper> pushed = new HashSet<LabelWrapper>();
        stack.push(this.firstLabel);
        pushed.add(this.firstLabel);
        while (!stack.empty()) {
            LabelWrapper current = (LabelWrapper)stack.pop();
            int start = current.inputStackSize;
            int blockMax = start + current.outputStackMax;
            if (blockMax > max) {
                max = blockMax;
            }
            for (ControlFlowEdge edge : current.successors) {
                LabelWrapper successor = edge.successor;
                if (pushed.contains(successor)) continue;
                successor.inputStackSize = edge.isExceptional ? 1 : start + edge.outputStackSize;
                pushed.add(successor);
                stack.push(successor);
            }
        }
        this.maxStack = Math.max(this.maxStack, Math.max(maxStack, max));
        super.visitMaxs(this.maxStack, maxLocals);
    }

    @Override
    public void visitTryCatchBlock(@NotNull Label start, @NotNull Label end, @NotNull Label handler2, String type2) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitTryCatchBlock"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitTryCatchBlock"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/codegen/inline/MaxStackFrameSizeAndLocalsCalculator", "visitTryCatchBlock"));
        }
        ExceptionHandler exceptionHandler = new ExceptionHandler(this.getLabelWrapper(start), this.getLabelWrapper(end), this.getLabelWrapper(handler2));
        this.exceptionHandlers.add(exceptionHandler);
        super.visitTryCatchBlock(start, end, handler2, type2);
    }

    private LabelWrapper getLabelWrapper(final Label label) {
        return ContainerUtil.getOrCreate(this.labelWrappersMap, label, new Factory<LabelWrapper>(){

            @Override
            public LabelWrapper create() {
                return new LabelWrapper(label);
            }
        });
    }

    private void increaseStackSize(int variation) {
        this.updateStackSize(this.stackSize + variation);
    }

    private void updateStackSize(int size) {
        if (size > this.maxStackSize) {
            this.maxStackSize = size;
        }
        this.stackSize = size;
    }

    private void addSuccessor(LabelWrapper successor, int outputStackSize) {
        this.currentBlock.addSuccessor(successor, outputStackSize, false);
    }

    private void noSuccessor() {
        if (this.currentBlock != null) {
            this.currentBlock.outputStackMax = this.maxStackSize;
            this.currentBlock = null;
        }
    }

    static {
        int[] b = new int[202];
        String s = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i = 0; i < b.length; ++i) {
            b[i] = s.charAt(i) - 69;
        }
        FRAME_SIZE_CHANGE_BY_OPCODE = b;
    }

    private static class LabelWrapper {
        private final Label label;
        private LabelWrapper nextLabel = null;
        private final Collection<ControlFlowEdge> successors = new LinkedList<ControlFlowEdge>();
        private int outputStackMax = 0;
        private int inputStackSize = 0;

        public LabelWrapper(Label label) {
            this.label = label;
        }

        private void addSuccessor(LabelWrapper successor, int outputStackSize, boolean isExceptional) {
            this.successors.add(new ControlFlowEdge(successor, outputStackSize, isExceptional));
        }
    }

    private static class ControlFlowEdge {
        private final LabelWrapper successor;
        private final int outputStackSize;
        private final boolean isExceptional;

        public ControlFlowEdge(LabelWrapper successor, int outputStackSize, boolean isExceptional) {
            this.successor = successor;
            this.outputStackSize = outputStackSize;
            this.isExceptional = isExceptional;
        }
    }

    private static class ExceptionHandler {
        private final LabelWrapper start;
        private final LabelWrapper end;
        private final LabelWrapper handlerLabel;

        public ExceptionHandler(LabelWrapper start, LabelWrapper end, LabelWrapper handlerLabel) {
            this.start = start;
            this.end = end;
            this.handlerLabel = handlerLabel;
        }
    }
}

