/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.MethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\"\f)\u0001b)\u001b=Ti\u0006\u001c7.\u00118bYfTXM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*91m\u001c3fO\u0016t'\u0002D8qi&l\u0017N_1uS>t'\u0002\u00034jqN#\u0018mY6\u000b\u001d5+G\u000f[8e\u0003:\fG.\u001f>fe*11m\\7n_:T!BQ1tS\u000e4\u0016\r\\;f\u0015%y'M[3di^,'MC\u0002bg6TA\u0001\u001e:fK*A\u0011M\\1msNL7O\u0003\u0004=S:LGO\u0010\u0006\u0006_^tWM\u001d\u0006\u0007'R\u0014\u0018N\\4\u000b\u00155,G\u000f[8e\u001d>$WM\u0003\u0006NKRDw\u000e\u001a(pI\u0016TqaY8oi\u0016DHOC\bGSb\u001cF/Y2l\u0007>tG/\u001a=u\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u000bO\u0016$8i\u001c8uKb$(b\u0002\u001ftKRlsH\u0010\u0006\u0004\u0013:$(\"E7bq\u0016CHO]1Ti\u0006\u001c7nU5{K*!r-\u001a;NCb,\u0005\u0010\u001e:b'R\f7m[*ju\u0016TAc]3u\u001b\u0006DX\t\u001f;sCN#\u0018mY6TSj,'bC:bm\u0016$7\u000b^1dWNTq\u0001S1tQ6\u000b\u0007O\u0003\u0003vi&d'\u0002E!cgR\u0014\u0018m\u0019;J]Ntgj\u001c3f\u0015\u0011a\u0015n\u001d;\u000b\u001d\u001d,GoU1wK\u0012\u001cF/Y2lg*9\u0011N\u001c3fq>3'\u0002\u00028pI\u0016T\u0001B\\3x\rJ\fW.\u001a\u0006\b]2{7-\u00197t\u0015\u0019q7\u000b^1dW*)aI]1nK*!b/[:ji\u000e{g\u000e\u001e:pY\u001acwn^#eO\u0016TA!\u001b8t]*I1/^2dKN\u001cxN\u001d\u0006\b\u0005>|G.Z1o\u001551\u0015\u000e_*uC\u000e\\gI]1nK*aR\r_3dkR,\u0017I\u001a;fe&sG.\u001b8f\u0007\u0006dG.T1sW\u0016\u0014(\u0002B+oSRTaDR5y'R\f7m[!oC2L(0\u001a:%\r&D8\u000b^1dW\u001a\u0013\u0018-\\3\u000b;\u0015DXmY;uK\n+gm\u001c:f\u0013:d\u0017N\\3DC2dW*\u0019:lKJTQ$\u001a=fGV$XMU3ti>\u0014Xm\u0015;bG.Le\u000e\u0016:z\u0007\u0006$8\r\u001b\u0006\u001aKb,7-\u001e;f'\u00064Xm\u0015;bG.\u0014UMZ8sKR\u0013\u0018PC\ttCZ,7\u000b^1dW\u0006sGm\u00117fCJ$ A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0003\t\tAA!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0003\t\u0003A\t!\u0002\u0002\u0005\n!)QA\u0001\u0003\u0006\u0011\u0017)!\u0001b\u0003\t\r\u0015\u0011AA\u0002E\u0007\u000b\r!i\u0001#\u0003\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001fA\u0001\u0002\u0004\u0001\u0006\u0007\u00111\u0001\"\u0003\u0007\u0001\u000b\r!)\u0001\u0003\u0006\r\u0001\u0015\t\u0001RC\u0003\u0003\t'A1\"\u0002\u0002\u0005\u0015!AQA\u0001\u0003\u0007\u0011%)!\u0001\"\u0002\t\u0015\u0015\u0019Aq\u0002E\r\u0019\u0001)!\u0001b\u0005\t \u0015\u0019A\u0011\u0004\u0005\u0010\u0019\u0001)1\u0001\u0002\u0004\t!1\u0001Qa\u0001C\b\u0011Ca\u0001!\u0002\u0002\u0005\u001a!yQA\u0001\u0003\u0007\u0011A)1\u0001\"\u0004\t)1\u0001QA\u0001C\u0007\u0011Q)1\u0001b\u0004\t-1\u0001Qa\u0001\u0003\u0004\u0011[a\u0001!B\u0002\u0005\u0010!=B\u0002A\u0003\u0003\t\u000bA\u0001\u0004B\u0002\r\u0007eAQ!\u0001\u0005\u0005\u0013\u0011I1!B\u0001\t\u000fa9\u0001\u0004BO\u0001.5\u0002Ba\u0019\u0003\u0019\u0014\u0005\u001aQ!\u0001\u0005\n1%)6\u0001C\u0003\u0004\t'I\u0011\u0001c\u0006\u000e\u0007\u0011]\u0011\"\u0001E\f[\u007f!1\u0019\u0004\r\u000e;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0001\u0011eA\u0003\u0002\u00111AB\u0002K\u0011V\u00079)1\u0001B\u0007\n\u0003\u0011\u0015Qb\u0001C\u000e\u0013\u0005!)!E\u0003\u0005\u001d%\tA\u0001A\u0007\u0002\t\u000bis\u0004B2\u00051;\t##B\u0001\t\u001b%!\u0011bA\u0003\u0002\u00117AZ\"C\u0005\n\u0011\u0015\t\u0001BD\u0005\u0005\u0013\r)\u0011\u0001C\u0004\u0019\u000faq\u0001$D+\u0004\u0011\u0015\u0019AQD\u0005\u0002\u0011;i1\u0001B\t\n\u0003!uQ&\u0006\u0003\u00021Giz\u0001\u0002\u0001\t%5\u0019Q!\u0001E\u000e17\u00016\u0001A\u0011\u0004\u000b\u0005AA\u0002\u0007\u0007R\u0007\u0015!\u0019#C\u0001\u0005\u00065\t\u0001bDW%\t)A*#h\u0004\u0005\u0001!\u0019RbA\u0003\u0002\u00111AB\u0002U\u0002\u0001;\u001f!\u0001\u0001c\n\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0005\u0011\u0005C\u0003\u0002\u0011?IA!C\u0002\u0006\u0003!9\u0001d\u0002M\u0010#\u000e9AQE\u0005\u0002\u0011Ai\u0011\u0001\"\u0002\u000e\u0003\u0011\u0015Qv\b\u0003\u000b1Siz\u0001\u0002\u0001\t+5\u0019Q!\u0001\u0005\r11\u00016\u0001AO\b\t\u0001AY#D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u00111C\t6a\u0002C\u0015\u0013\u0005!\t!D\u0001\u0005\u00065\tAQA\u0017\u001c\t\u0005)2!B\u0001\t#a\t\u0002dFO\b\t\u0001AQ#D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u00121G\t6a\u0002\u0003\u0018\u0013\u0005!\u0001!D\u0001\t%5\t\u0001bD\u0017\u001c\t\u0005)2!B\u0001\t#a\t\u0002\u0014GO\b\t\u0001AQ#D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u00121G\t6a\u0002C\u0019\u0013\u0005!\u0001!D\u0001\t%5\t\u0001bD\u0017\u001c\t\u0005)2!B\u0001\t#a\t\u0002$GO\b\t\u0001AQ#D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u00121G\t6a\u0002\u0003\u001a\u0013\u0005!\u0001!D\u0001\t%5\t\u0001bD\u0017\u001c\t\u0005)2!B\u0001\t#a\t\u00024GO\b\t\u0001AQ#D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u00121G\t6a\u0002C\u001a\u0013\u0005!\u0001!D\u0001\t%5\t\u0001bD\u0017\u001c\t\u0005)2!B\u0001\t#a\t\u0002DGO\b\t\u0001AQ#D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u00121G\t6a\u0002\u0003\u001b\u0013\u0005!\u0001!D\u0001\t%5\t\u0001bD[,\u000b+\"1\u001d\u0001\r\b;\u001f!\u0001\u0001c\u0004\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u0001Qt\u0002\u0003\u0001\u0011#i1!B\u0001\t\u0012aE\u0001k!\u0001\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0005\t3!B\u0001\t\u0007a\u0019\u0011kA\u0005\u0005\u000f%\tA\u0001A\u0007\u0002\u0011+i\u0011\u0001C\u0006\u000e\u0003!]\u0001"})
public final class FixStackAnalyzer
extends MethodAnalyzer<BasicValue> {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final HashMap<AbstractInsnNode, List<? extends BasicValue>> savedStacks;
    private int maxExtraStackSize;
    @NotNull
    private final FixStackContext context;

    static {
        $kotlinClass = Reflection.createKotlinClass(FixStackAnalyzer.class);
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<? extends BasicValue>> getSavedStacks() {
        return this.savedStacks;
    }

    public final int getMaxExtraStackSize() {
        return this.maxExtraStackSize;
    }

    @Override
    protected boolean visitControlFlowEdge(int insn, int successor) {
        AbstractInsnNode insnNode = this.getInstructions().get(insn);
        return !(insnNode instanceof JumpInsnNode) || !this.context.getBreakContinueGotoNodes().contains(insnNode);
    }

    @Override
    @NotNull
    protected Frame<BasicValue> newFrame(int nLocals, int nStack) {
        return new FixStackFrame(nLocals, nStack);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.getMethod().instructions.indexOf(node);
    }

    private final void executeBeforeInlineCallMarker(FixStackFrame $receiver, AbstractInsnNode insn) {
        this.saveStackAndClear($receiver, insn);
    }

    private final void saveStackAndClear(FixStackFrame $receiver, AbstractInsnNode insn) {
        List<BasicValue> savedValues = $receiver.getStackContent();
        KotlinPackage.set(this.savedStacks, insn, savedValues);
        $receiver.clearStack();
    }

    private final void executeAfterInlineCallMarker(FixStackFrame $receiver, AbstractInsnNode insn) {
        AbstractInsnNode beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(insn);
        if ($receiver.getStackSize() > 0) {
            List<? extends BasicValue> savedValues;
            BasicValue returnValue = $receiver.pop();
            $receiver.clearStack();
            List<? extends BasicValue> list = savedValues = this.savedStacks.get(beforeInlineMarker);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            Collection collection = list;
            Intrinsics.checkExpressionValueIsNotNull(collection, "savedValues!!");
            $receiver.pushAll(collection);
            $receiver.push(returnValue);
        } else {
            List<? extends BasicValue> savedValues;
            List<? extends BasicValue> list = savedValues = this.savedStacks.get(beforeInlineMarker);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            Collection collection = list;
            Intrinsics.checkExpressionValueIsNotNull(collection, "savedValues!!");
            $receiver.pushAll(collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void executeRestoreStackInTryCatch(FixStackFrame $receiver, AbstractInsnNode insn) {
        void key;
        void $receiver2;
        AbstractInsnNode saveNode = this.context.getSaveStackMarkerForRestoreMarker().get(insn);
        Map map2 = this.savedStacks;
        AbstractInsnNode abstractInsnNode = saveNode;
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "saveNode!!");
        AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
        Object value = $receiver2.get(key);
        if (value == null && !$receiver2.containsKey(key)) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insn) + ": Restore stack is unavailable for " + this.indexOf(saveNode))));
        }
        List savedValues = (List)value;
        $receiver.pushAll(savedValues);
    }

    private final void executeSaveStackBeforeTry(FixStackFrame $receiver, AbstractInsnNode insn) {
        this.saveStackAndClear($receiver, insn);
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    public FixStackAnalyzer(@NotNull String owner, @NotNull MethodNode methodNode, @NotNull FixStackContext context) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(owner, methodNode, new OptimizationBasicInterpreter());
        this.context = context;
        this.savedStacks = KotlinPackage.hashMapOf(new Pair[0]);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={" \b)ia)\u001b=Ti\u0006\u001c7N\u0012:b[\u0016T\u0001CR5y'R\f7m[!oC2L(0\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TqaY8eK\u001e,gN\u0003\u0007paRLW.\u001b>bi&|gN\u0003\u0005gSb\u001cF/Y2l\u0015\u00151%/Y7f\u0015%y'M[3di^,'MC\u0002bg6TA\u0001\u001e:fK*A\u0011M\\1msNL7O\u0003\u0006CCNL7MV1mk\u0016Ta\u0001P5oSRt$b\u00028M_\u000e\fGn\u001d\u0006\u0004\u0013:$(B\u00028Ti\u0006\u001c7N\u0003\u0006fqR\u0014\u0018m\u0015;bG.TQa\u0015;bG.T1aY8n\u0015!Ig\u000e^3mY&T'\u0002B;uS2T!bY8oi\u0006Lg.\u001a:t\u001559W\r^#yiJ\f7\u000b^1dW*Q1\r\\3beN#\u0018mY6\u000b\tUs\u0017\u000e\u001e\u0006\bKb,7-\u001e;f\u0015\u0011Ign\u001d8\u000b!\u0005\u00137\u000f\u001e:bGRLen\u001d8O_\u0012,'bC5oi\u0016\u0014\bO]3uKJT1\"\u00138uKJ\u0004(/\u001a;fe*Aq-\u001a;Ti\u0006\u001c7NC\u0001j\u0015=9W\r^*uC\u000e\\7i\u001c8uK:$(\u0002\u0002'jgRTAA[1wC*!\u0011N\\5u\u0015\r\u0019(o\u0019\u0006\u0004a>\u0004(\u0002\u00029vg\"TQA^1mk\u0016Tq\u0001];tQ\u0006cGN\u0003\u0004wC2,Xm\u001d\u0006\u000b\u0007>dG.Z2uS>tG>\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\t\u000bA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0001\u0007\u0001\u000b\t!\t\u0001C\u0001\u0006\u0005\u0011!\u0001\u0012B\u0003\u0003\t\u0013AQ!\u0002\u0002\u0005\u000b!-QA\u0001C\u0006\u0011\u0019)1\u0001\u0002\u0004\t\t1\u0001Qa\u0001\u0003\u0007\u0011\u001ba\u0001!B\u0001\t\u0005\u0015\u0019Aq\u0002\u0005\t\u0019\u0001)!\u0001\"\u0002\t\u0002\u0015\t\u0001BC\u0003\u0003\t%A)\"\u0002\u0002\u0005\u0014!YQA\u0001\u0003\u000b\u0011/)1\u0001\"\u0006\t\u00141\u0001QA\u0001C\u000b\u0011')1\u0001b\u0004\t\u001b1\u0001Qa\u0001C\u0006\u0011;a\u0001!B\u0002\u0005\r!}A\u0002A\u0003\u0003\t\u0017Ai\"\u0002\u0002\u0005\r!}QA\u0001\u0003\u0007\u0011\u001b)1\u0001b\u0004\t$1\u0001Q!\u0001\u0005\u0013\u000b\t!y\u0002C\u0006\u0006\u0005\u0011\u0001\u00022E\u0003\u0003\t\u0019AA!B\u0002\u0005\u0010!1B\u0002A\u0003\u0003\tAAa\u0003B\"\u0003\u0019\u000fI\u0002\"B\u0001\t\u000e%!\u0011bA\u0003\u0002\u0011\u001dAr\u0001'\u0004.+\u0011\u0019G\u0001G\u0005\"\u0011\u0015\t\u0001bC\u0005\u0005\u0013\r)\u0011\u0001C\u0004\u0019\u000faYQk\u0001\u0005\u0006\u0007\u0011I\u0011\"\u0001E\f\u001b\r!A\"C\u0001\t\u00185VAa\u0003M\rC\r)\u0011\u0001\u0003\u0007\u0019\u0019E\u001b1\u0001\"\u0007\n\u0003\u0011\u0001Q\u0016\n\u0003\f17iz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001E\r13\u00016\u0001AO\r\t\u0001Aq\"\u0004\u0005\u0006\u0003!i\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\u0019\u001bA\u001b\t!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u000f\u0011m\u0011\"\u0001\u0003\u0001\u001b\u0005AY\"D\u0001\t\u001d5*Ba\u0003\r\u0011;\u001f!\u0001\u0001#\t\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u0001\u0011eA\u0003\u0002\u0011\u001dAr!U\u0002\u0006\tAI\u0011\u0001#\b\u000e\u0003\u0011\u0015Qv\u0004\u0003\u00041E\t\u0003\"B\u0001\t\u001f%!\u0011bA\u0003\u0002\u0011\u001dAr\u0001G\bR\u0007\r!\u0011#C\u0001\t\"5\u0002Ca\u0003M\u0013;7!\u0001\u0001C\n\u000e\u0013\u0015\t\u0001RB\u0005\u0006\t\u0003I1!B\u0001\t\u000fa9\u0001T\u0002)\u0004\u0001\u0005BQ!\u0001E\u0007\u0013\u0011I1!B\u0001\t\u000fa9\u0001TB)\u0004\u000b\u0011\u0015\u0012\"\u0001\u0005\u0012\u001b\u0005A\u0011#,\u0006\u0005\u0017a\u001d\u0012eA\u0003\u0002\u0011\u001dAr!U\u0002\u0004\tOI\u0011\u0001#\b.+\u0011Y\u0001\u0004FO\b\t\u0001AI#D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0001\u0005\u001aQ!\u0001\u0005\r11\t6!\u0002\u0003\u0015\u0013\u0005!\u0001!D\u0001\t\u001e5RBa\u0001\r\u0016;3!\u0001\u0001c\u000b\u000e\u0011\u0015\t\u00012E\u0005\u0005\u0013\r)\u0011\u0001C\u0004\u0019\u000fa\r\u0002k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0004\r\r#\u000e)A!F\u0005\u0002\t\u0001i\u0011\u0001\u0003\n6G\u0015\u0011Ca9\u0001\u0019\u000fu=A\u0001\u0001E\b\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\t!h\u0004\u0005\u0001!EQbA\u0003\u0002\u0011!A\u0002\u0002U\u0002\u0002C\r)\u0011\u0001c\u0002\u0019\bE\u001b\u0011\u0002B\u0004\n\u0003\u0011\u0001Q\"\u0001E\t\u001b\u0005!)!D\u0001\u0005\u0006\u0001"})
    public final class FixStackFrame
    extends Frame<BasicValue> {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Stack<BasicValue> extraStack;

        static {
            $kotlinClass = Reflection.createKotlinClass(FixStackFrame.class);
        }

        @NotNull
        public final Stack<BasicValue> getExtraStack() {
            return this.extraStack;
        }

        @Override
        @NotNull
        public Frame<BasicValue> init(@NotNull Frame<? extends BasicValue> src) {
            Intrinsics.checkParameterIsNotNull(src, "src");
            this.extraStack.clear();
            Frame<? extends BasicValue> frame = src;
            if (frame == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer.FixStackFrame");
            }
            this.extraStack.addAll((Collection)((FixStackFrame)frame).extraStack);
            Frame<BasicValue> frame2 = super.init(src);
            Intrinsics.checkExpressionValueIsNotNull(frame2, "super.init(src)");
            return frame2;
        }

        @Override
        public void clearStack() {
            this.extraStack.clear();
            super.clearStack();
        }

        @Override
        public void execute(@NotNull AbstractInsnNode insn, @NotNull Interpreter<BasicValue> interpreter) {
            Intrinsics.checkParameterIsNotNull(insn, "insn");
            Intrinsics.checkParameterIsNotNull(interpreter, "interpreter");
            if (PseudoInsn.SAVE_STACK_BEFORE_TRY.isa(insn)) {
                FixStackAnalyzer.this.executeSaveStackBeforeTry(this, insn);
            } else if (PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.isa(insn)) {
                FixStackAnalyzer.this.executeRestoreStackInTryCatch(this, insn);
            } else if (InlineCodegenUtil.isBeforeInlineMarker(insn)) {
                FixStackAnalyzer.this.executeBeforeInlineCallMarker(this, insn);
            } else if (InlineCodegenUtil.isAfterInlineMarker(insn)) {
                FixStackAnalyzer.this.executeAfterInlineCallMarker(this, insn);
            }
            super.execute(insn, interpreter);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<BasicValue> getStackContent() {
            ArrayList<BasicValue> savedStack = KotlinPackage.arrayListOf(new BasicValue[0]);
            Iterable $receiver = new IntRange(0, super.getStackSize() - 1);
            for (Object item : $receiver) {
                BasicValue basicValue;
                void it;
                int n = ((Number)item).intValue();
                Collection collection = savedStack;
                Intrinsics.checkExpressionValueIsNotNull((BasicValue)FixStackFrame.super.getStack((int)it), "super.getStack(it)");
                collection.add(basicValue);
            }
            savedStack.addAll((Collection<BasicValue>)this.extraStack);
            return savedStack;
        }

        @Override
        public void push(@NotNull BasicValue value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            if (super.getStackSize() < this.getMaxStackSize()) {
                super.push((Value)value);
            } else {
                this.extraStack.add(value);
                FixStackAnalyzer.this.maxExtraStackSize = Math.max(FixStackAnalyzer.this.maxExtraStackSize, this.extraStack.size());
            }
        }

        public final void pushAll(@NotNull Collection<? extends BasicValue> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            Iterable $receiver = values;
            for (Object element : $receiver) {
                BasicValue it = (BasicValue)element;
                this.push(it);
            }
        }

        @Override
        @NotNull
        public BasicValue pop() {
            if (KotlinPackage.isNotEmpty((Collection)this.extraStack)) {
                BasicValue basicValue = this.extraStack.pop();
                Intrinsics.checkExpressionValueIsNotNull(basicValue, "extraStack.pop()");
                return basicValue;
            }
            BasicValue basicValue = (BasicValue)super.pop();
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.pop()");
            return basicValue;
        }

        @Override
        @NotNull
        public BasicValue getStack(int i) {
            if (i < super.getMaxStackSize()) {
                BasicValue basicValue = (BasicValue)super.getStack(i);
                Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.getStack(i)");
                return basicValue;
            }
            BasicValue basicValue = (BasicValue)this.extraStack.get(i - this.getMaxStackSize());
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "extraStack[i - getMaxStackSize()]");
            return basicValue;
        }

        public FixStackFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
            this.extraStack = new Stack();
        }
    }
}

