/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetConstructor;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegationSpecifierList;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetElementImpl;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetWhenConditionInRange;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"s$))\u0002k\\:ji&|g.\u001b8h'R\u0014\u0018\r^3hS\u0016\u001c(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u0006\u0004\u0003:L(\"E!C'R\u0013\u0016i\u0011+`\u001b>#\u0015JR%F%*\u0019\u0002k\\:ji&|g.\u001b8h'R\u0014\u0018\r^3hs*!\"*\u001a;N_\u0012Lg-[3s\u0019&\u001cHoT<oKJT1\u0001]:j\u0015Q9W\r^!C'R\u0013\u0016i\u0011+`\u001b>#\u0015JR%F%*a\u0011I\u0015*B3~\u000b5iQ#T'*A\"*\u001a;BeJ\f\u00170Q2dKN\u001cX\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u001f\u001d,G/\u0011*S\u0003f{\u0016iQ\"F'NSq!Q*`)f\u0003VI\u0003\u0010KKR\u0014\u0015N\\1ss\u0016C\bO]3tg&|gnV5uQRK\b/\u001a*I'*Qq-\u001a;B'~#\u0016\fU#\u000b\u0019\r\u000bE\nT0F\u0019\u0016kUI\u0014+\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0010O\u0016$8)\u0011'M?\u0016cU)T#O)*y1)\u0011'M?\u0016C\u0006KU#T'&{eJ\u0003\nhKR\u001c\u0015\t\u0014'`\u000bb\u0003&+R*T\u0013>s%\u0002E\"P\u001bB\u000be*S(O?>\u0013%*R\"U\u0015QQU\r^(cU\u0016\u001cG\u000fR3dY\u0006\u0014\u0018\r^5p]*\u0019r-\u001a;D\u001f6\u0003\u0016IT%P\u001d~{%IS#D)*y1)\u0016+`\u0007\"\u000b%kX)V\u001fR+5K\u0003\u0006KKR,E.Z7f]RT!cZ3u\u0007V#vl\u0011%B%~\u000bVk\u0014+F'*\u0001B)R\"M\u0003J\u000bE+S(O?:\u000bU*\u0012\u0006\u0014\u0015\u0016$h*Y7fI\u0012+7\r\\1sCRLwN\u001c\u0006\u0014O\u0016$H)R\"M\u0003J\u000bE+S(O?:\u000bU*\u0012\u0006\u0018\t\u0016\u001bE*\u0011*B)&{ej\u0018*F)V\u0013fj\u0018+Z!\u0016SaBS3u\t\u0016\u001cG.\u0019:bi&|gN\u0003\u000ehKR$Ui\u0011'B%\u0006#\u0016j\u0014(`%\u0016#VK\u0015(`)f\u0003VIC\u000bE\u000b\u000ec\u0015IU!U\u0013>sulU%H\u001d\u0006#VKU#\u000b1\u001d,G\u000fR#D\u0019\u0006\u0013\u0016\tV%P\u001d~\u001b\u0016j\u0012(B)V\u0013VI\u0003\u0011E\u000b\u000ec\u0015IU!U\u0013>sulU%H\u001d\u0006#VKU#`\u001fJ{F)\u0012$B+2#&bI4fi\u0012+5\tT!S\u0003RKuJT0T\u0013\u001es\u0015\tV+S\u000b~{%k\u0018#F\r\u0006+F\n\u0016\u0006\u0016\t\u0016\u001bE*\u0011*B)&{ejX,J)\"{&i\u0014#Z\u0015YQU\r\u001e#fG2\f'/\u0019;j_:<\u0016\u000e\u001e5C_\u0012L(\u0002G4fi\u0012+5\tT!S\u0003RKuJT0X\u0013RCuLQ(E3*9A)\u0012$B+2#&BC4fi\u0012+e)Q+M)*!B)\u0012'F\u000f\u0006#vJU0T+B+%kX\"B\u00192SABS3u\u000b:,X.\u00128uefTqcZ3u\t\u0016cUiR!U\u001fJ{6+\u0016)F%~\u001b\u0015\t\u0014'\u000b\u0015\u0015c5+R0F\u001dR\u0013\u0016L\u0003\u0007KKR<\u0006.\u001a8F]R\u0014\u0018PC\u0007hKR,EjU#`\u000b:#&+\u0017\u0006\u000f\r&s\u0015\tT0N\u001f\u0012Ke)S#S\u0015E9W\r\u001e$J\u001d\u0006cu,T(E\u0013\u001aKUI\u0015\u0006\u0012\r>\u0013vLU#E\u000b\u000ec\u0015IU!U\u0013>s%\u0002F4fi\u001a{%k\u0018*F\t\u0016\u001bE*\u0011*B)&{eJ\u0003\rG\u001fJ{VK\u0014*F'>ce+\u0012#`%\u00163UIU#O\u0007\u0016SaCS3u%\u00164WM]3oG\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u001cO\u0016$hi\u0014*`+:\u0013ViU(M-\u0016#uLU#G\u000bJ+ejQ#\u000bO\u0019+fj\u0011+J\u001f:{F*\u0013+F%\u0006cu,\u0012-Q%\u0016\u001b6+S(O?\u0012+5\tT!S\u0003RKuJ\u0014\u0006\u001d\u0015\u0016$h)\u001e8di&|g\u000eT5uKJ\fG.\u0012=qe\u0016\u001c8/[8o\u0015):W\r\u001e$V\u001d\u000e#\u0016j\u0014(`\u0019&#VIU!M?\u0016C\u0006KU#T'&{ej\u0018#F\u00072\u000b%+\u0011+J\u001f:S1CR+O\u0007RKuJT0Q\u0003J\u000bU*\u0012+F%NS1BS3u\rVt7\r^5p]*1r-\u001a;G+:\u001bE+S(O?B\u000b%+Q'F)\u0016\u00136K\u0003\bJ\u001d:+%kX'P\t&3\u0015*\u0012*\u000b#\u001d,G/\u0013(O\u000bJ{Vj\u0014#J\r&+%KC\nM\u001f:;u\fT%U\u000bJ\u000bEjX*V\r\u001aK\u0005L\u0003\fhKRduJT$`\u0019&#VIU!M?N+fIR%Y\u00155qU\u000b\u0014'B\u00052+u\fV-Q\u000b*y!*\u001a;Ok2d\u0017M\u00197f)f\u0004XM\u0003\thKRtU\u000b\u0014'B\u00052+u\fV-Q\u000b*\trJV#S%&#UiX'P\t&3\u0015*\u0012*\u000b)\u001d,Go\u0014,F%JKE)R0N\u001f\u0012Ke)S#S\u0015]\u0001\u0016IU!N\u000bR+%k\u0018#F\r\u0006+F\nV0W\u00032+VI\u0003\u0007KKR\u0004\u0016M]1nKR,'O\u0003\u000ehKR\u0004\u0016IU!N\u000bR+%k\u0018#F\r\u0006+F\nV0W\u00032+VIC\bT\u000b\u0006cU\tR0N\u001f\u0012Ke)S#S\u0015I9W\r^*F\u00032+EiX'P\t&3\u0015*\u0012*\u000bKM+5i\u0014(E\u0003JKvlQ(O'R\u0013Vk\u0011+P%~#U\tT#H\u0003RKuJT0D\u00032c%\u0002\b&fi\u000e{gn\u001d;sk\u000e$xN\u001d#fY\u0016<\u0017\r^5p]\u000e\u000bG\u000e\u001c\u0006)O\u0016$8+R\"P\u001d\u0012\u000b%+W0D\u001f:\u001bFKU+D)>\u0013v\fR#M\u000b\u001e\u000bE+S(O?\u000e\u000bE\n\u0014\u0006))f\u0003Vi\u0018)B%\u0006kU\tV#S'~{%k\u0018#F\u00072\u000b%+\u0011+J\u001f:{6+S$O\u0003R+&+\u0012\u0006,O\u0016$H+\u0017)F?B\u000b%+Q'F)\u0016\u00136kX(S?\u0012+5\tT!S\u0003RKuJT0T\u0013\u001es\u0015\tV+S\u000b*\u0001RK\u0014*F\u0003\u000eC\u0015I\u0011'F?\u000e{E)\u0012\u0006\u0014O\u0016$XK\u0014*F\u0003\u000eC\u0015I\u0011'F?\u000e{E)\u0012\u0006\r+:+6+\u0012#`-\u0006cU+\u0012\u0006\u0014\u0015\u0016$()\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0010O\u0016$XKT+T\u000b\u0012{f+\u0011'V\u000b*iQkU#M\u000bN\u001bv,\u0012'W\u0013NS\u0001cZ3u+N+E*R*T?\u0016ce+S*\u000b\u001fY\u000bE*V#`\u0003J;U+T#O)NS!cZ3u-\u0006cU+R0B%\u001e+V*\u0012(U'*ya+\u0011'`\u001fJ{f+\u0011*`\u001d>#UI\u0003\nhKR4\u0016\tT0P%~3\u0016IU0O\u001f\u0012+%B\u0006,B%&\u000bejQ#`\u0013:{\u0006KU(K\u000b\u000e#\u0016j\u0014(\u000b#)+G\u000fV=qKB\u0013xN[3di&|gNC\rhKR4\u0016IU%B\u001d\u000e+u,\u0013(`!J{%*R\"U\u0013>s%\"\u0005,B%&\u000bejQ#`\u001b>#\u0015JR%F%*!r-\u001a;W\u0003JK\u0015IT\"F?6{E)\u0013$J\u000bJS1CV%T\u0013\nKE*\u0013+Z?6{E)\u0013$J\u000bJSacZ3u-&\u001b\u0016JQ%M\u0013RKv,T(E\u0013\u001aKUI\u0015\u0006\u0018/\"+ejX\"P\u001d\u0012KE+S(O?&suLU!O\u000f\u0016SqCS3u/\",gnQ8oI&$\u0018n\u001c8J]J\u000bgnZ3\u000b5\u001d,Go\u0016%F\u001d~\u001buJ\u0014#J)&{ejX%O?J\u000bejR#\u000b\u001f]CUIT0F1B\u0013ViU*J\u001f:S\u0011CS3u/\",g.\u0012=qe\u0016\u001c8/[8o\u0015I9W\r^,I\u000b:{V\t\u0017)S\u000bN\u001b\u0016j\u0014(\u000b'5|G-\u001b4jKJ\u001cV\r\u001e)pg&$\u0018n\u001c8\u000b\rQ|7.\u001a8t\u0015\u0015\t%O]1z\u0015]QU\r^'pI&4\u0017.\u001a:LKf<xN\u001d3U_.,gNC\u0003mKb,'OC\tEK\u000ed\u0017M]1uS>t\u0007*Z1eKJ\u0014*A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u0006!\u0015A\u0002A\u0003\u0004\t\u0007A9\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012B\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001rA\u0003\u0004\t\u0011Aa\u0001\u0004\u0001\u0006\u0007\u0011!\u0001r\u0002\u0007\u0001\u000b\u0005A\u0019\"\u0002\u0002\u0005\u000e!QQA\u0001\u0003\b\u0011\u0013)1\u0001b\u0004\t\u00131\u0001Qa\u0001\u0003\u0005\u00113a\u0001!B\u0002\u0005\t!qA\u0002A\u0003\u0004\t\u0011Ay\u0002\u0004\u0001\u0006\u0007\u0011!\u0001\"\u0005\u0007\u0001\u000b\r!A\u0001#\u000b\r\u0001\u0015\u0019A\u0001\u0002\u0005\u0018\u0019\u0001)1\u0001\u0002\u0003\t21\u0001Qa\u0001\u0003\u0005\u0011qa\u0001!B\u0002\u0005\t!mB\u0002A\u0003\u0004\t\u0011Aq\u0004\u0004\u0001\u0006\u0007\u0011!\u0001R\t\u0007\u0001\u000b\r!A\u0001C\u0013\r\u0001\u0015\u0019A\u0001\u0002E(\u0019\u0001)1\u0001\u0002\u0003\tW1\u0001Qa\u0001\u0003\u0005\u0011?b\u0001!B\u0002\u0005\t!\u0019D\u0002A\u0003\u0004\t\u0011AI\u0007\u0004\u0001\u0006\u0007\u0011\u0015\u0001R\u000e\u0007\u0001\u000b\t!\u0011\u0001c\u001c\u0006\u0007\u0011\r\u0002b\u000e\u0007\u0001\u000b\t!\u0019\u0003C\u001c\u0005G\u0006a!!G\u0002\u0006\u0003!\u0019\u0001dAO\u0001q5*Ba\u0019\u0003\u0019\u0007\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\na%\u0001tA+\u0004\u0011\u0015\u0019AaA\u0005\u0002\u0011\u0015i1\u0001B\u0003\n\u0003!)Q&\u0006\u0003d\ta-\u0011\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!-\u00014\u0002M\u0004+\u000eAQa\u0001C\u0006\u0013\u0005AQ!D\u0002\u0005\u000e%\t\u0001\"B\u0017\u0016\t\r$\u0001dB\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001B\u0002\r\u00071\u000f)6\u0001C\u0003\u0004\t\u001dI\u0011\u0001C\u0003\u000e\u0007\u0011A\u0011\"\u0001\u0005\u0006[U!1\r\u0002M\tC!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001\u0005\t1!A:!V\u0002\t\u000b\r!\t\"C\u0001\t\u000b5\u0019AQC\u0005\u0002\u0011\u0015iS\u0003B2\u00051-\t\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011!A\u0002\u0002g\u0002V\u0007!)1\u0001B\u0006\n\u0003!)Qb\u0001C\f\u0013\u0005AQ!L\u000b\u0005G\u0012AB\"\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005A\t\u0002'\u0005\u0019\bU\u001b\u0001\"B\u0002\u0005\u0019%\t\u0001\"B\u0007\u0004\t5I\u0011\u0001C\u0003.+\u0011\u0019G\u0001g\u0007\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001C\u0005\u0019\u0013a\u001dQk\u0001\u0005\u0006\u0007\u0011m\u0011\"\u0001\u0005\u0006\u001b\r!i\"C\u0001\t\u000b5*Ba\u0019\u0003\u0019\u001f\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u0014aM\u0001tA+\u0004\u0011\u0015\u0019AaD\u0005\u0002\u0011\u0015i1\u0001\u0002\t\n\u0003!)Q&\u0006\u0003d\ta\u0005\u0012\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!Q\u0001D\u0003M\u0004+\u000eAQa\u0001C\u0011\u0013\u0005AQ!D\u0002\u0005$%\t\u0001\"B\u0017\u0016\t\r$\u0001DE\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001B\u0003\r\u000b1\u000f)6\u0001C\u0003\u0004\tII\u0011\u0001C\u0003\u000e\u0007\u0011\u0015\u0012\"\u0001\u0005\u0006[U!1\r\u0002\r\u0014C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001\u0005\t1!A:!V\u0002\t\u000b\r!1#C\u0001\t\u000b5\u0019AqE\u0005\u0002\u0011\u0015iS\u0003B2\u00051Q\t\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011+A*\u0002g\u0002V\u0007!)1\u0001\u0002\u000b\n\u0003!)Qb\u0001\u0003\u0016\u0013\u0005AQ!L\u000b\u0005G\u0012AZ#\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019\bU\u001b\u0001\"B\u0002\u0005,%\t\u0001\"B\u0007\u0004\tYI\u0011\u0001C\u0003.+\u0011\u0019G\u0001'\f\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001C\u0006\u0019\u0017a\u001dQk\u0001\u0005\u0006\u0007\u00115\u0012\"\u0001\u0005\u0006\u001b\r!y#C\u0001\t\u000b5*Ba\u0019\u0003\u00191\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u0018a]\u0001tA+\u0004\u0011\u0015\u0019A\u0001G\u0005\u0002\u0011\u0015i1\u0001B\r\n\u0003!)Q&\u0006\u0003d\taM\u0012\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!%\u0001\u0014\u0002M\u0004+\u000eAQa\u0001C\u001a\u0013\u0005AQ!D\u0002\u00055%\t\u0001\"B\u0017\u0016\t\r$\u0001TG\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t1\u000f)6\u0001C\u0003\u0004\tkI\u0011\u0001C\u0003\u000e\u0007\u0011Y\u0012\"\u0001\u0005\u0006[U!1\r\u0002M\u001cC!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001\u0005\r11A:!V\u0002\t\u000b\r!9$C\u0001\t\u000b5\u0019A\u0011H\u0005\u0002\u0011\u0015iS\u0003B2\u00051u\t\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u00113AJ\u0002g\u0002V\u0007!)1\u0001B\u000f\n\u0003!)Qb\u0001\u0003\u001f\u0013\u0005AQ!L\u000b\u0005G\u0012Aj$\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005AQ\u0002G\u0007\u0019\bU\u001b\u0001\"B\u0002\u0005>%\t\u0001\"B\u0007\u0004\t\u007fI\u0011\u0001C\u0003.+\u0011\u0019G\u0001\u0007\u0011\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001#\u0003\u0019\na\u001dQk\u0001\u0005\u0006\u0007\u0011\u0001\u0013\"\u0001\u0005\u0006\u001b\r!\t%C\u0001\t\u000b5*Ba\u0019\u0003\u0019C\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u0013aI\u0001tA+\u0004\u0011\u0015\u0019A!I\u0005\u0002\u0011\u0015i1\u0001b\u0011\n\u0003!)Q&\u0006\u0003d\ta\u0011\u0013\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!m\u00014\u0004M\u0004+\u000eAQa\u0001\u0003#\u0013\u0005AQ!D\u0002\u0005G%\t\u0001\"B\u0017\u0016\t\r$\u0001tI\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0002M\u00051\u000f)6\u0001C\u0003\u0004\t\u000fJ\u0011\u0001C\u0003\u000e\u0007\u0011!\u0013\"\u0001\u0005\u0006[U!1\r\u0002M%C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001\u0005\u000f19A:!V\u0002\t\u000b\r!I%C\u0001\t\u000b5\u0019A1J\u0005\u0002\u0011\u0015iS\u0003B2\u00051\u0019\n\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011\u0013AJ\u0001g\u0002V\u0007!)1\u0001\u0002\u0014\n\u0003!)Qb\u0001C'\u0013\u0005AQ!L\u000b\u0005G\u0012Ar%\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005Ai\u0002'\b\u0019\bU\u001b\u0001\"B\u0002\u0005O%\t\u0001\"B\u0007\u0004\t!J\u0011\u0001C\u0003.+\u0011\u0019G\u0001'\u0015\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0006\u0019\u0015a\u001dQk\u0001\u0005\u0006\u0007\u0011E\u0013\"\u0001\u0005\u0006\u001b\r!\u0011&C\u0001\t\u000b5*Ba\u0019\u0003\u0019T\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u0011aA\u0001tA+\u0004\u0011\u0015\u0019A1K\u0005\u0002\u0011\u0015i1\u0001\u0002\u0016\n\u0003!)Q&\u0006\u0003d\taU\u0013\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!y\u0001d\u0004M\u0004+\u000eAQa\u0001C+\u0013\u0005AQ!D\u0002\u0005X%\t\u0001\"B\u0017\u0016\t\r$\u0001\u0004L\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001b\u0004\r\u00101\u000f)6\u0001C\u0003\u0004\t1J\u0011\u0001C\u0003\u000e\u0007\u0011e\u0013\"\u0001\u0005\u0006[U!1\r\u0002\r.C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001\u0005\n1%A:!V\u0002\t\u000b\r!Q&C\u0001\t\u000b5\u0019A1L\u0005\u0002\u0011\u0015iS\u0003B2\u000519\n\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011'A\u001a\u0002g\u0002V\u0007!)1\u0001\u0002\u0018\n\u0003!)Qb\u0001C/\u0013\u0005AQ!L\u000b\u0005G\u0012Ar&\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005Ay\u0002g\b\u0019\bU\u001b\u0001\"B\u0002\u0005_%\t\u0001\"B\u0007\u0004\tAJ\u0011\u0001C\u0003.+\u0011\u0019G\u0001'\u0019\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001#\u0003\u0019\na\u001dQk\u0001\u0005\u0006\u0007\u0011\u0005\u0014\"\u0001\u0005\u0006\u001b\r!\u0011'C\u0001\t\u000b5*Ba\u0019\u0003\u0019d\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\na%\u0001tA+\u0004\u0011\u0015\u0019A1M\u0005\u0002\u0011\u0015i1\u0001\u0002\u001a\n\u0003!)Q&\u0006\u0003d\ta\u0015\u0014\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!\u0001\u0002\u0004\u0005M\u0004+\u000eAQa\u0001C3\u0013\u0005AQ!D\u0002\u0005h%\t\u0001\"B\u0017\u0016\t\r$\u0001\u0004N\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0005M\u00111\u000f)6\u0001C\u0003\u0004\tQJ\u0011\u0001C\u0003\u000e\u0007\u0011)\u0014\"\u0001\u0005\u0006[\u0015\"9\u0001g\u001b\u001e$\u0011\u0001\u0001BN\u0007\n\u000b\u0005A\u0011#C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u00131IA\u0012#E\u0002\u0006\u0003!\u0011\u0002D\u0005)\u0004\u0001\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\na%\u0001tA)\u0004\r\u0011-\u0014\"\u0001\u0005\u0006\u001b\tA)\u0003$\u00016\u0001\u0001"})
public final class PositioningStrategies {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT;
    @NotNull
    public static final PositioningStrategy<JetDeclaration> DECLARATION_RETURN_TYPE;
    @NotNull
    public static final PositioningStrategy<JetNamedDeclaration> DECLARATION_NAME;
    @NotNull
    public static final PositioningStrategy<JetDeclaration> DECLARATION_SIGNATURE;
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @NotNull
    public static final PositioningStrategy<JetFunctionLiteralExpression> FUNCTION_LITERAL_EXPRESSION_DECLARATION;
    @NotNull
    public static final PositioningStrategy<JetDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> ABSTRACT_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> INNER_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> OVERRIDE_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> FINAL_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> SEALED_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> VARIANCE_MODIFIER;
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @NotNull
    public static final PositioningStrategy<JetReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @NotNull
    public static final PositioningStrategy<JetArrayAccessExpression> ARRAY_ACCESS;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> VISIBILITY_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetTypeProjection> VARIANCE_IN_PROJECTION;
    @NotNull
    public static final PositioningStrategy<JetParameter> PARAMETER_DEFAULT_VALUE;
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @NotNull
    public static final PositioningStrategy<JetDeclarationWithBody> DECLARATION_WITH_BODY;
    @NotNull
    public static final PositioningStrategy<JetNamedDeclaration> VAL_OR_VAR_NODE;
    @NotNull
    public static final PositioningStrategy<JetWhenEntry> ELSE_ENTRY;
    @NotNull
    public static final PositioningStrategy<JetWhenExpression> WHEN_EXPRESSION;
    @NotNull
    public static final PositioningStrategy<JetWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @NotNull
    public static final PositioningStrategy<JetNullableType> NULLABLE_TYPE;
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @NotNull
    public static final PositioningStrategy<JetElement> VALUE_ARGUMENTS;
    @NotNull
    public static final PositioningStrategy<JetFunction> FUNCTION_PARAMETERS;
    @NotNull
    public static final PositioningStrategy<JetElement> CUT_CHAR_QUOTES;
    @NotNull
    public static final PositioningStrategy<JetElement> LONG_LITERAL_SUFFIX;
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @NotNull
    public static final PositioningStrategy<JetBinaryExpressionWithTypeRHS> AS_TYPE;
    @NotNull
    public static final PositioningStrategy<JetObjectDeclaration> COMPANION_OBJECT;
    @NotNull
    public static final PositioningStrategy<JetConstructorDelegationCall> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @NotNull
    public static final PositioningStrategy<JetEnumEntry> DELEGATOR_SUPER_CALL;
    @NotNull
    public static final PositioningStrategy<JetBinaryExpression> UNUSED_VALUE;
    @NotNull
    public static final PositioningStrategy<JetBinaryExpression> USELESS_ELVIS;
    public static final PositioningStrategies INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(PositioningStrategies.class);
        new PositioningStrategies();
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final PositioningStrategy<JetDeclaration> getDECLARATION_RETURN_TYPE() {
        return DECLARATION_RETURN_TYPE;
    }

    @NotNull
    public final PositioningStrategy<JetNamedDeclaration> getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final PositioningStrategy<JetDeclaration> getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDECLARATION_SIGNATURE_OR_DEFAULT() {
        return DECLARATION_SIGNATURE_OR_DEFAULT;
    }

    @NotNull
    public final PositioningStrategy<JetFunctionLiteralExpression> getFUNCTION_LITERAL_EXPRESSION_DECLARATION() {
        return FUNCTION_LITERAL_EXPRESSION_DECLARATION;
    }

    @NotNull
    public final PositioningStrategy<JetDeclaration> getTYPE_PARAMETERS_OR_DECLARATION_SIGNATURE() {
        return TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getABSTRACT_MODIFIER() {
        return ABSTRACT_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getINNER_MODIFIER() {
        return INNER_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getOVERRIDE_MODIFIER() {
        return OVERRIDE_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getFINAL_MODIFIER() {
        return FINAL_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getSEALED_MODIFIER() {
        return SEALED_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getVARIANCE_MODIFIER() {
        return VARIANCE_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getFOR_REDECLARATION() {
        return FOR_REDECLARATION;
    }

    @NotNull
    public final PositioningStrategy<JetReferenceExpression> getFOR_UNRESOLVED_REFERENCE() {
        return FOR_UNRESOLVED_REFERENCE;
    }

    @platformStatic
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> modifierSetPosition(JetModifierKeywordToken ... tokens) {
        Intrinsics.checkParameterIsNotNull(tokens, "tokens");
        return new PositioningStrategy<JetModifierListOwner>(tokens){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ JetModifierKeywordToken[] $tokens;

            static {
                $kotlinClass = Reflection.createKotlinClass(modifierSetPosition.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetModifierListOwner element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetModifierList $receiver = element.getModifierList();
                JetModifierList jetModifierList = $receiver;
                if (jetModifierList == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "No modifier list, but modifier has been found by the analyzer";
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                JetModifierList modifierList = jetModifierList;
                JetModifierKeywordToken[] jetModifierKeywordTokenArray = this.$tokens;
                for (int i = 0; i < jetModifierKeywordTokenArray.length; ++i) {
                    JetModifierKeywordToken token = jetModifierKeywordTokenArray[i];
                    PsiElement element2 = modifierList.getModifier(token);
                    if (element2 == null) continue;
                    return PositioningStrategyKt.markElement(element2);
                }
                throw (Throwable)new IllegalStateException("None of the modifiers is found: " + KotlinPackage.listOf(this.$tokens));
            }
            {
                this.$tokens = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public final PositioningStrategy<JetArrayAccessExpression> getARRAY_ACCESS() {
        return ARRAY_ACCESS;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getVISIBILITY_MODIFIER() {
        return VISIBILITY_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetTypeProjection> getVARIANCE_IN_PROJECTION() {
        return VARIANCE_IN_PROJECTION;
    }

    @NotNull
    public final PositioningStrategy<JetParameter> getPARAMETER_DEFAULT_VALUE() {
        return PARAMETER_DEFAULT_VALUE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCALL_ELEMENT() {
        return CALL_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<JetDeclarationWithBody> getDECLARATION_WITH_BODY() {
        return DECLARATION_WITH_BODY;
    }

    @NotNull
    public final PositioningStrategy<JetNamedDeclaration> getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final PositioningStrategy<JetWhenEntry> getELSE_ENTRY() {
        return ELSE_ENTRY;
    }

    @NotNull
    public final PositioningStrategy<JetWhenExpression> getWHEN_EXPRESSION() {
        return WHEN_EXPRESSION;
    }

    @NotNull
    public final PositioningStrategy<JetWhenConditionInRange> getWHEN_CONDITION_IN_RANGE() {
        return WHEN_CONDITION_IN_RANGE;
    }

    @NotNull
    public final PositioningStrategy<JetNullableType> getNULLABLE_TYPE() {
        return NULLABLE_TYPE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCALL_EXPRESSION() {
        return CALL_EXPRESSION;
    }

    @NotNull
    public final PositioningStrategy<JetElement> getVALUE_ARGUMENTS() {
        return VALUE_ARGUMENTS;
    }

    @NotNull
    public final PositioningStrategy<JetFunction> getFUNCTION_PARAMETERS() {
        return FUNCTION_PARAMETERS;
    }

    @NotNull
    public final PositioningStrategy<JetElement> getCUT_CHAR_QUOTES() {
        return CUT_CHAR_QUOTES;
    }

    @NotNull
    public final PositioningStrategy<JetElement> getLONG_LITERAL_SUFFIX() {
        return LONG_LITERAL_SUFFIX;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getUNREACHABLE_CODE() {
        return UNREACHABLE_CODE;
    }

    @NotNull
    public final PositioningStrategy<JetBinaryExpressionWithTypeRHS> getAS_TYPE() {
        return AS_TYPE;
    }

    @NotNull
    public final PositioningStrategy<JetObjectDeclaration> getCOMPANION_OBJECT() {
        return COMPANION_OBJECT;
    }

    @NotNull
    public final PositioningStrategy<JetConstructorDelegationCall> getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final PositioningStrategy<JetEnumEntry> getDELEGATOR_SUPER_CALL() {
        return DELEGATOR_SUPER_CALL;
    }

    @NotNull
    public final PositioningStrategy<JetBinaryExpression> getUNUSED_VALUE() {
        return UNUSED_VALUE;
    }

    @NotNull
    public final PositioningStrategy<JetBinaryExpression> getUSELESS_ELVIS() {
        return USELESS_ELVIS;
    }

    PositioningStrategies() {
        INSTANCE$ = this;
        DEFAULT = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DEFAULT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element;
                if (psiElement instanceof JetObjectLiteralExpression) {
                    JetObjectDeclaration objectDeclaration = ((JetObjectLiteralExpression)element).getObjectDeclaration();
                    PsiElement objectKeyword = objectDeclaration.getObjectKeyword();
                    JetDelegationSpecifierList delegationSpecifierList = objectDeclaration.getDelegationSpecifierList();
                    if (delegationSpecifierList == null) {
                        return PositioningStrategyKt.markElement(objectKeyword);
                    }
                    return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
                }
                if (psiElement instanceof JetObjectDeclaration) {
                    PsiElement psiElement2 = ((JetObjectDeclaration)element).getObjectKeyword();
                    PsiElement psiElement3 = ((JetObjectDeclaration)element).getNameIdentifier();
                    if (psiElement3 == null) {
                        psiElement3 = ((JetObjectDeclaration)element).getObjectKeyword();
                    }
                    return PositioningStrategyKt.markRange(psiElement2, psiElement3);
                }
                if (psiElement instanceof JetConstructorDelegationCall) {
                    return PositioningStrategies.INSTANCE$.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark((JetConstructorDelegationCall)element);
                }
                return super.mark(element);
            }
        };
        DECLARATION_RETURN_TYPE = new PositioningStrategy<JetDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_RETURN_TYPE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return PositioningStrategyKt.markElement(this.getElementToMark(element));
            }

            public boolean isValid(@NotNull JetDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
            }

            /*
             * WARNING - void declaration
             */
            private final PsiElement getElementToMark(JetDeclaration declaration) {
                void nameIdentifierOrPlaceholder;
                void returnTypeRef;
                JetDeclaration jetDeclaration = declaration;
                Pair<JetTypeReference, PsiElement> pair = jetDeclaration instanceof JetCallableDeclaration ? new Pair<JetTypeReference, PsiElement>(((JetCallableDeclaration)declaration).getTypeReference(), ((JetCallableDeclaration)declaration).getNameIdentifier()) : (jetDeclaration instanceof JetPropertyAccessor ? new Pair<JetTypeReference, PsiElement>(((JetPropertyAccessor)declaration).getReturnTypeReference(), ((JetPropertyAccessor)declaration).getNamePlaceholder()) : new Pair<Object, Object>(null, null));
                JetTypeReference jetTypeReference = pair.component1();
                PsiElement psiElement = pair.component2();
                pair = null;
                if (returnTypeRef != null) {
                    return (PsiElement)returnTypeRef;
                }
                if (nameIdentifierOrPlaceholder != null) {
                    return nameIdentifierOrPlaceholder;
                }
                return declaration;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<JetNamedDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_NAME.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetNamedDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof JetClassOrObject) {
                        PsiElement psiElement;
                        PsiElement psiElement2 = ((JetClassOrObject)element).getModifierList();
                        if (psiElement2 == null || (psiElement2 = psiElement2.getModifier(JetTokens.ENUM_KEYWORD)) == null) {
                            ASTNode aSTNode = ((JetClassOrObject)element).getNode().findChildByType(TokenSet.create(JetTokens.CLASS_KEYWORD, JetTokens.OBJECT_KEYWORD));
                            psiElement2 = psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                        }
                        if (psiElement2 == null) {
                            psiElement = element;
                        }
                        PsiElement startElement = psiElement;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof JetNamedFunction) {
                    return PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().mark((JetDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<JetDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_SIGNATURE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetDeclaration jetDeclaration = element;
                if (jetDeclaration instanceof JetConstructor) {
                    PsiElement psiElement = ((JetConstructor)element).getConstructorKeyword();
                    if (psiElement == null) {
                        psiElement = ((JetConstructor)element).getValueParameterList();
                    }
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement begin = psiElement;
                    JetParameterList jetParameterList = ((JetConstructor)element).getValueParameterList();
                    PsiElement psiElement2 = jetParameterList != null ? (PsiElement)jetParameterList : ((JetConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement end = psiElement2;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (jetDeclaration instanceof JetFunction) {
                    NavigatablePsiElement navigatablePsiElement;
                    PsiElement endOfSignatureElement;
                    JetTypeReference jetTypeReference = ((JetFunction)element).getTypeReference();
                    JetElementImplStub jetElementImplStub = jetTypeReference != null ? (JetElementImplStub)jetTypeReference : (JetElementImplStub)((JetFunction)element).getValueParameterList();
                    PsiElement psiElement = jetElementImplStub != null ? (PsiElement)jetElementImplStub : ((JetFunction)element).getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = endOfSignatureElement = (PsiElement)element;
                    }
                    if (element instanceof JetFunctionLiteral) {
                        JetTypeReference jetTypeReference2 = ((JetFunctionLiteral)element).getReceiverTypeReference();
                        JetElementImplStub jetElementImplStub2 = jetTypeReference2 != null ? (JetElementImplStub)jetTypeReference2 : (JetElementImplStub)((JetFunctionLiteral)element).getValueParameterList();
                        navigatablePsiElement = jetElementImplStub2 != null ? (NavigatablePsiElement)jetElementImplStub2 : (NavigatablePsiElement)element;
                    } else {
                        navigatablePsiElement = element;
                    }
                    NavigatablePsiElement startElement = navigatablePsiElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (jetDeclaration instanceof JetProperty) {
                    JetTypeReference jetTypeReference = ((JetProperty)element).getTypeReference();
                    PsiElement psiElement = jetTypeReference != null ? (PsiElement)jetTypeReference : ((JetProperty)element).getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (jetDeclaration instanceof JetPropertyAccessor) {
                    PsiElement psiElement;
                    PsiElement psiElement3;
                    JetTypeReference jetTypeReference = ((JetPropertyAccessor)element).getReturnTypeReference();
                    if (jetTypeReference != null) {
                        psiElement3 = jetTypeReference;
                    } else {
                        ASTNode aSTNode = ((JetPropertyAccessor)element).getRightParenthesis();
                        psiElement3 = psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                    }
                    if (psiElement3 == null) {
                        PsiElement psiElement4 = ((JetPropertyAccessor)element).getNamePlaceholder();
                        psiElement = psiElement4;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement4, "element.getNamePlaceholder()");
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (jetDeclaration instanceof JetClass) {
                    PsiElement psiElement = ((JetClass)element).getNameIdentifier();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = psiElement;
                    JetParameterList jetParameterList = ((JetClass)element).getPrimaryConstructorParameterList();
                    if (jetParameterList == null) {
                        PsiElement psiElement5 = nameAsDeclaration;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement5, "nameAsDeclaration");
                        return PositioningStrategyKt.markElement(psiElement5);
                    }
                    JetParameterList primaryConstructorParameterList = jetParameterList;
                    PsiElement psiElement6 = nameAsDeclaration;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement6, "nameAsDeclaration");
                    return PositioningStrategyKt.markRange(psiElement6, primaryConstructorParameterList);
                }
                if (jetDeclaration instanceof JetObjectDeclaration) {
                    return PositioningStrategies.INSTANCE$.getDECLARATION_NAME().mark((JetNamedDeclaration)element);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_SIGNATURE_OR_DEFAULT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof JetDeclaration ? PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().mark((JetDeclaration)element) : PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof JetDeclaration ? PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().isValid((JetDeclaration)element) : PositioningStrategies.INSTANCE$.getDEFAULT().isValid(element);
            }
        };
        FUNCTION_LITERAL_EXPRESSION_DECLARATION = new PositioningStrategy<JetFunctionLiteralExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(FUNCTION_LITERAL_EXPRESSION_DECLARATION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetFunctionLiteralExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PositioningStrategy<PsiElement> positioningStrategy = PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE_OR_DEFAULT();
                PsiElement psiElement = element.getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getFunctionLiteral()");
                return positioningStrategy.mark(psiElement);
            }

            public boolean isValid(@NotNull JetFunctionLiteralExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PositioningStrategy<PsiElement> positioningStrategy = PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE_OR_DEFAULT();
                PsiElement psiElement = element.getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getFunctionLiteral()");
                return positioningStrategy.isValid(psiElement);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<JetDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclaration element) {
                JetTypeParameterList jetTypeParameterList;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetTypeParameterListOwner && (jetTypeParameterList = ((JetTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(jetTypeParameterList);
                }
                return PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().mark((JetDeclaration)((PsiElement)element));
            }
        };
        JetModifierKeywordToken[] jetModifierKeywordTokenArray = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken = JetTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken, "JetTokens.ABSTRACT_KEYWORD");
        jetModifierKeywordTokenArray[0] = jetModifierKeywordToken;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray2 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken2 = JetTokens.INNER_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken2, "JetTokens.INNER_KEYWORD");
        jetModifierKeywordTokenArray2[0] = jetModifierKeywordToken2;
        INNER_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray2);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray3 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken3 = JetTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken3, "JetTokens.OVERRIDE_KEYWORD");
        jetModifierKeywordTokenArray3[0] = jetModifierKeywordToken3;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray3);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray4 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken4 = JetTokens.FINAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken4, "JetTokens.FINAL_KEYWORD");
        jetModifierKeywordTokenArray4[0] = jetModifierKeywordToken4;
        FINAL_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray4);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray5 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken5 = JetTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken5, "JetTokens.SEALED_KEYWORD");
        jetModifierKeywordTokenArray5[0] = jetModifierKeywordToken5;
        SEALED_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray5);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray6 = new JetModifierKeywordToken[2];
        JetModifierKeywordToken jetModifierKeywordToken6 = JetTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken6, "JetTokens.IN_KEYWORD");
        jetModifierKeywordTokenArray6[0] = jetModifierKeywordToken6;
        JetModifierKeywordToken jetModifierKeywordToken7 = JetTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken7, "JetTokens.OUT_KEYWORD");
        jetModifierKeywordTokenArray6[1] = jetModifierKeywordToken7;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray6);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(FOR_REDECLARATION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof JetNamedDeclaration) {
                    psiElement = ((JetNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement2 instanceof JetFile) {
                    JetPackageDirective jetPackageDirective = ((JetFile)element).getPackageDirective();
                    if (jetPackageDirective == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement = jetPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = (PsiElement)null;
                }
                if (nameIdentifier == null && element instanceof JetObjectDeclaration) {
                    return PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
                }
                PsiElement psiElement3 = nameIdentifier;
                if (psiElement3 == null) {
                    psiElement3 = element;
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement3, "nameIdentifier ?: element");
                return PositioningStrategyKt.markElement(psiElement3);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<JetReferenceExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(FOR_UNRESOLVED_REFERENCE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetReferenceExpression element) {
                List<TextRange> ranges2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetArrayAccessExpression && !(ranges2 = ((JetArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                    List<TextRange> list = ranges2;
                    Intrinsics.checkExpressionValueIsNotNull(list, "ranges");
                    return list;
                }
                return KotlinPackage.listOf(JetPsiUtilKt.getCalleeHighlightingRange(element));
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<JetArrayAccessExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(ARRAY_ACCESS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetArrayAccessExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getIndicesNode();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getIndicesNode()");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        VISIBILITY_MODIFIER = new PositioningStrategy<JetModifierListOwner>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VISIBILITY_MODIFIER.1.class);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<TextRange> mark(@NotNull JetModifierListOwner element) {
                PsiElement psiElement;
                PsiElement nameIdentifier;
                void destination;
                void $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<JetModifierKeywordToken> visibilityTokens = KotlinPackage.listOf(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
                JetModifierList modifierList = element.getModifierList();
                Iterable iterable = visibilityTokens;
                JetModifierListOwner jetModifierListOwner = $receiver2;
                Collection collection = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
                for (T item : $receiver) {
                    void it;
                    JetModifierKeywordToken jetModifierKeywordToken = (JetModifierKeywordToken)item;
                    void var11_10 = destination;
                    PsiElement psiElement2 = modifierList;
                    TextRange textRange = psiElement2 != null && (psiElement2 = ((JetModifierList)psiElement2).getModifier((JetModifierKeywordToken)it)) != null ? psiElement2.getTextRange() : null;
                    var11_10.add(textRange);
                }
                List<TextRange> result2 = KotlinPackage.filterNotNull((List)destination);
                if (!result2.isEmpty()) {
                    return result2;
                }
                if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                jetModifierListOwner = element;
                if (jetModifierListOwner instanceof JetObjectDeclaration) {
                    psiElement = ((JetObjectDeclaration)element).getObjectKeyword();
                } else if (jetModifierListOwner instanceof JetPropertyAccessor) {
                    psiElement = ((JetPropertyAccessor)element).getNamePlaceholder();
                } else if (jetModifierListOwner instanceof JetClassInitializer) {
                    psiElement = element;
                } else {
                    throw (Throwable)new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + "'");
                }
                PsiElement elementToMark = psiElement;
                return PositioningStrategyKt.markElement(elementToMark);
            }
        };
        VARIANCE_IN_PROJECTION = new PositioningStrategy<JetTypeProjection>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VARIANCE_IN_PROJECTION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetTypeProjection element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getProjectionToken();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getProjectionToken()!!");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<JetParameter>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(PARAMETER_DEFAULT_VALUE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetParameter element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetExpression jetExpression = element.getDefaultValue();
                if (jetExpression == null) {
                    Intrinsics.throwNpe();
                }
                ASTNode aSTNode = jetExpression.getNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getDefaultValue()!!.getNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CALL_ELEMENT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                JetElement jetElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element;
                if (!(psiElement instanceof JetCallElement)) {
                    psiElement = null;
                }
                return PositioningStrategyKt.markElement((jetElement = (JetCallElement)psiElement) != null && (jetElement = jetElement.getCalleeExpression()) != null ? (PsiElement)jetElement : element);
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<JetDeclarationWithBody>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_WITH_BODY.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetExpression jetExpression = element.getBodyExpression();
                if (!(jetExpression instanceof JetBlockExpression)) {
                    jetExpression = null;
                }
                JetBlockExpression jetBlockExpression = (JetBlockExpression)jetExpression;
                TextRange lastBracketRange = jetBlockExpression != null ? jetBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull JetDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (!super.isValid((PsiElement)element)) return false;
                JetExpression jetExpression = element.getBodyExpression();
                if (!(jetExpression instanceof JetBlockExpression)) {
                    jetExpression = null;
                }
                JetBlockExpression jetBlockExpression = (JetBlockExpression)jetExpression;
                if (jetBlockExpression == null) return false;
                TextRange textRange = jetBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<JetNamedDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VAL_OR_VAR_NODE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetNamedDeclaration element) {
                List list;
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetNamedDeclaration jetNamedDeclaration = element;
                if (jetNamedDeclaration instanceof JetParameter) {
                    PsiElement psiElement = ((JetParameter)element).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    list = PositioningStrategyKt.markElement(psiElement);
                } else if (jetNamedDeclaration instanceof JetProperty) {
                    PsiElement psiElement = ((JetProperty)element).getValOrVarKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.valOrVarKeyword");
                    list = PositioningStrategyKt.markElement(psiElement);
                } else {
                    list = (List)((Object)KotlinPackage.error("Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element)));
                }
                return list;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<JetWhenEntry>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(ELSE_ENTRY.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetWhenEntry element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getElseKeyword();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getElseKeyword()!!");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<JetWhenExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(WHEN_EXPRESSION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetWhenExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getWhenKeyword()");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<JetWhenConditionInRange>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(WHEN_CONDITION_IN_RANGE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetWhenConditionInRange element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getOperationReference()");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<JetNullableType>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(NULLABLE_TYPE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetNullableType element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getQuestionMarkNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CALL_EXPRESSION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetCallExpression) {
                    JetTypeArgumentList jetTypeArgumentList = ((JetCallExpression)element).getTypeArgumentList();
                    JetElement jetElement = jetTypeArgumentList != null ? (JetElement)jetTypeArgumentList : (JetElement)((JetCallExpression)element).getCalleeExpression();
                    if (jetElement == null) {
                        jetElement = (JetElement)element;
                    }
                    return PositioningStrategyKt.markRange(element, jetElement);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<JetElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VALUE_ARGUMENTS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetElement element) {
                PsiElement psiElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetElement jetElement = element;
                if (!(jetElement instanceof JetValueArgumentList)) {
                    jetElement = null;
                }
                if ((psiElement = (JetValueArgumentList)jetElement) == null || (psiElement = psiElement.getRightParenthesis()) == null) {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<JetFunction>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(FUNCTION_PARAMETERS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetFunction element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof JetFunctionLiteral) {
                    ASTNode aSTNode = ((JetFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getLBrace().getNode()");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE_OR_DEFAULT().mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<JetElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CUT_CHAR_QUOTES.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetConstantExpression && Intrinsics.areEqual(((JetConstantExpression)element).getNode().getElementType(), JetNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = ((JetConstantExpression)element).getTextRange();
                    return KotlinPackage.listOf(TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<JetElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(LONG_LITERAL_SUFFIX.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetConstantExpression && Intrinsics.areEqual(((JetConstantExpression)element).getNode().getElementType(), JetNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    return KotlinPackage.listOf(TextRange.create(endOffset - 1, endOffset));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(UNREACHABLE_CODE.1.class);
            }

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
                List list = (List)((DiagnosticWithParameters1)Errors.UNREACHABLE_CODE.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull(list, "Errors.UNREACHABLE_CODE.cast(diagnostic).getA()");
                return list;
            }
        };
        AS_TYPE = new PositioningStrategy<JetBinaryExpressionWithTypeRHS>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(AS_TYPE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getOperationReference()");
                return PositioningStrategyKt.markRange(psiElement, element);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<JetObjectDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(COMPANION_OBJECT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetObjectDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.hasModifier(JetTokens.COMPANION_KEYWORD)) {
                    JetModifierKeywordToken[] jetModifierKeywordTokenArray = new JetModifierKeywordToken[1];
                    JetModifierKeywordToken jetModifierKeywordToken = JetTokens.COMPANION_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken, "JetTokens.COMPANION_KEYWORD");
                    jetModifierKeywordTokenArray[0] = jetModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray).mark((JetModifierListOwner)((PsiElement)element));
                }
                return PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<JetConstructorDelegationCall>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(SECONDARY_CONSTRUCTOR_DELEGATION_CALL.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetConstructorDelegationCall element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.isImplicit()) {
                    PsiElement $receiver = element;
                    JetSecondaryConstructor jetSecondaryConstructor = PsiTreeUtil.getParentOfType($receiver, JetSecondaryConstructor.class, true);
                    if (jetSecondaryConstructor == null) {
                        Intrinsics.throwNpe();
                    }
                    JetSecondaryConstructor constructor = jetSecondaryConstructor;
                    JetParameterList jetParameterList = constructor.getValueParameterList();
                    if (jetParameterList == null) {
                        return PositioningStrategyKt.markElement(constructor);
                    }
                    JetParameterList valueParameterList = jetParameterList;
                    PsiElement psiElement = constructor.getConstructorKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "constructor.getConstructorKeyword()");
                    PsiElement psiElement2 = valueParameterList.getLastChild();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement2, "valueParameterList.getLastChild()");
                    return PositioningStrategyKt.markRange(psiElement, psiElement2);
                }
                JetConstructorDelegationReferenceExpression jetConstructorDelegationReferenceExpression = element.getCalleeExpression();
                return PositioningStrategyKt.markElement(jetConstructorDelegationReferenceExpression != null ? (JetElementImpl)jetConstructorDelegationReferenceExpression : (JetElementImpl)element);
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<JetEnumEntry>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DELEGATOR_SUPER_CALL.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetEnumEntry element) {
                JetElementImplStub jetElementImplStub;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<JetDelegationSpecifier> specifiers = element.getDelegationSpecifiers();
                if (specifiers.isEmpty()) {
                    jetElementImplStub = element;
                } else {
                    JetElementImplStub jetElementImplStub2 = specifiers.get(0);
                    jetElementImplStub = jetElementImplStub2;
                    Intrinsics.checkExpressionValueIsNotNull(jetElementImplStub2, "specifiers[0]");
                }
                return PositioningStrategyKt.markElement(jetElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<JetBinaryExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(UNUSED_VALUE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetExpression jetExpression = element.getLeft();
                if (jetExpression == null) {
                    Intrinsics.throwNpe();
                }
                return KotlinPackage.listOf(new TextRange(PsiUtilsKt.getStartOffset(jetExpression), PsiUtilsKt.getEndOffset(element.getOperationReference())));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<JetBinaryExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(USELESS_ELVIS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return KotlinPackage.listOf(new TextRange(PsiUtilsKt.getStartOffset(element.getOperationReference()), PsiUtilsKt.getEndOffset(element)));
            }
        };
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={" \u0004)\tB)Z2mCJ\fG/[8o\u0011\u0016\fG-\u001a:\u000b+A{7/\u001b;j_:LgnZ*ue\u0006$XmZ5fg*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0006eS\u0006<gn\\:uS\u000e\u001c(\"\u0001+\u000b\u001d)+G\u000fR3dY\u0006\u0014\u0018\r^5p]*\u0019\u0001o]5\u000b'A{7/\u001b;j_:LgnZ*ue\u0006$XmZ=\u000b\rqJg.\u001b;?\u0015\u001dI7OV1mS\u0012Tq!\u001a7f[\u0016tGOC\u0004C_>dW-\u00198O\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!\u0002\u0002\u0005\u0003!!Qa\u0001\u0003\u0004\u0011\u000fa\u0001!B\u0002\u0005\u0004!%A\u0002A\u0003\u0002\u0011\t)1\u0001\"\u0003\t\u000e1\u0001QA\u0001\u0003\u0004\u0011\u000f!\u0011\u0002$\u0002\u0016\r\u0011\u0001\u0001bA\u000b\u0004\u000b\u0005A9\u0001g\u0002\u001a\u0013\u0015\t\u0001\u0002B\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001\u0004B\u0017\u0017\t-AZ!(\u0005\u0005\u0001!1Q\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001Q\u0007\u0001\t3!B\u0001\t\u000ba)\u0011kA\u0003\u0005\f%\tA\u0011A\u0007\u0002\u0011\u0017)\u0014$\u0002\r\u0005G\u0004\tb\u0001\u0002\u0001\t\u0007U\u0019Q!\u0001E\u00041\u000fAR!I\u0005\u0006\u0003!\u0015\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a\u0015\u0011kA\u0002\u0005\u000b%\tA\u0001\u0001"})
    private static class DeclarationHeader<T extends JetDeclaration>
    extends PositioningStrategy<T> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(DeclarationHeader.class);
        }

        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            if (element instanceof JetNamedDeclaration && !(element instanceof JetObjectDeclaration) && !(element instanceof JetSecondaryConstructor) && !(element instanceof JetFunction) && ((JetNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }
}

