/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.MultiDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.StringTemplateTranslator;
import org.jetbrains.kotlin.js.translate.expression.TryTranslator;
import org.jetbrains.kotlin.js.translate.expression.WhenTranslator;
import org.jetbrains.kotlin.js.translate.expression.loopTranslator.LoopTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.UnaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetBreakExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetContinueExpression;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetPrefixExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class ExpressionVisitor
extends TranslatorVisitor<JsNode> {
    @Override
    protected JsNode emptyResult(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "emptyResult"));
        }
        return context.getEmptyExpression();
    }

    @Override
    @NotNull
    public JsNode visitConstantExpression(@NotNull JetConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        JsNode jsNode = ExpressionVisitor.translateConstantExpression(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode translateConstantExpression(@NotNull JetConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, context.bindingContext());
        assert (compileTimeValue != null) : ErrorReportingUtils.message(expression, "Expression is not compile time value: " + expression.getText() + " ");
        JetType expectedType = context.bindingContext().getType(expression);
        ConstantValue<?> constant = compileTimeValue.toConstantValue(expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE);
        if (constant instanceof NullValue) {
            JsNullLiteral jsNullLiteral = JsLiteral.NULL;
            if (jsNullLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNullLiteral;
        }
        Object value = constant.getValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(((Number)value).intValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Long) {
            JsExpression jsExpression = JsAstUtils.newLong((Long)value, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsExpression;
        }
        if (value instanceof Number) {
            JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(((Number)value).doubleValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Boolean) {
            JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.getBoolean((Boolean)value);
            if (jsBooleanLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsBooleanLiteral;
        }
        if (value instanceof String) {
            JsStringLiteral jsStringLiteral = context.program().getStringLiteral((String)value);
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        if (value instanceof Character) {
            JsStringLiteral jsStringLiteral = context.program().getStringLiteral(value.toString());
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        throw new AssertionError((Object)ErrorReportingUtils.message(expression, "Unsupported constant expression: " + expression.getText() + " "));
    }

    @Override
    @NotNull
    public JsNode visitBlockExpression(@NotNull JetBlockExpression jetBlock, @NotNull TranslationContext context) {
        if (jetBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetBlock", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        List<JetExpression> statements = jetBlock.getStatements();
        JsBlock jsBlock = new JsBlock();
        for (JetExpression statement : statements) {
            JsNode jsNode = Translation.translateExpression(statement, context, jsBlock);
            JsStatement jsStatement = JsAstUtils.convertToStatement(jsNode);
            if (JsAstUtils.isEmptyStatement(jsStatement)) continue;
            jsBlock.getStatements().add(jsStatement);
        }
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        return jsBlock2;
    }

    @Override
    public JsNode visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitMultiDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitMultiDeclaration"));
        }
        JetExpression jetInitializer = multiDeclaration.getInitializer();
        assert (jetInitializer != null) : "Initializer for multi declaration must be not null";
        JsExpression initializer = Translation.translateAsExpression(jetInitializer, context);
        return MultiDeclarationTranslator.translate(multiDeclaration, context.scope().declareTemporary(), initializer, context);
    }

    @Override
    @NotNull
    public JsNode visitReturnExpression(@NotNull JetReturnExpression jetReturnExpression, @NotNull TranslationContext context) {
        if (jetReturnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetReturnExpression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        JetExpression returned = jetReturnExpression.getReturnedExpression();
        JetDeclarationWithBody parent = PsiTreeUtil.getParentOfType((PsiElement)jetReturnExpression, JetDeclarationWithBody.class);
        if (parent instanceof JetSecondaryConstructor) {
            JsNode jsNode = new JsReturn(new JsNameRef("$this")).source(jetReturnExpression);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsNode;
        }
        if (returned == null) {
            JsNode jsNode = new JsReturn(null).source(jetReturnExpression);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsNode;
        }
        JsExpression jsReturnExpression = Translation.translateAsExpression(returned, context);
        if (JsAstUtils.isEmptyExpression(jsReturnExpression)) {
            JsExpression jsExpression = context.getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsExpression;
        }
        JsNode jsNode = new JsReturn(jsReturnExpression).source(jetReturnExpression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        JetExpression expressionInside = expression.getExpression();
        if (expressionInside != null) {
            JsNode jsNode = Translation.translateExpression(expressionInside, context);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
            }
            return jsNode;
        }
        JsEmpty jsEmpty = JsEmpty.INSTANCE$;
        if (jsEmpty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        return jsEmpty;
    }

    @Override
    @NotNull
    public JsNode visitBinaryExpression(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        JsExpression jsExpression = BinaryOperationTranslator.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitProperty(@NotNull JetProperty expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        VariableDescriptor descriptor = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, expression);
        JsExpression initializer = TranslationUtils.translateInitializerForProperty(expression, context);
        if (initializer != null && JsAstUtils.isEmptyExpression(initializer)) {
            JsExpression jsExpression = context.getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
            }
            return jsExpression;
        }
        JsName name = context.getNameForDescriptor(descriptor);
        if (BindingContextUtils.isVarCapturedInClosure(context.bindingContext(), descriptor)) {
            JsNameRef alias = Namer.getCapturedVarAccessor(name.makeRef());
            initializer = JsAstUtils.wrapValue(alias, initializer == null ? JsLiteral.NULL : initializer);
        }
        JsNode jsNode = JsAstUtils.newVar(name, initializer).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        JsExpression jsExpression = CallableReferenceTranslator.INSTANCE$.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitCallExpression(@NotNull JetCallExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        JsNode jsNode = CallExpressionTranslator.translate(expression, null, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitIfExpression(@NotNull JetIfExpression expression, @NotNull TranslationContext context) {
        JsStatement elseStatement;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        assert (expression.getCondition() != null) : "condition should not ne null: " + expression.getText();
        JsExpression testExpression = Translation.translateAsExpression(expression.getCondition(), context);
        if (JsAstUtils.isEmptyExpression(testExpression)) {
            JsExpression jsExpression = testExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
            }
            return jsExpression;
        }
        boolean isKotlinExpression = BindingContextUtilPackage.isUsedAsExpression(expression, context.bindingContext());
        JetExpression thenExpression = expression.getThen();
        JetExpression elseExpression = expression.getElse();
        JsStatement thenStatement = thenExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(thenExpression, context) : null;
        JsStatement jsStatement = elseStatement = elseExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(elseExpression, context) : null;
        if (isKotlinExpression) {
            boolean canBeJsExpression;
            JsExpression jsThenExpression = JsAstUtils.extractExpressionFromStatement(thenStatement);
            JsExpression jsElseExpression = JsAstUtils.extractExpressionFromStatement(elseStatement);
            boolean bl = canBeJsExpression = jsThenExpression != null && jsElseExpression != null;
            if (canBeJsExpression) {
                JsExpression jsExpression = new JsConditional(testExpression, jsThenExpression, jsElseExpression).source(expression);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
                }
                return jsExpression;
            }
        }
        JsIf ifStatement = new JsIf(testExpression, thenStatement, elseStatement);
        JsNode jsNode = ifStatement.source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        JsExpression jsExpression = ReferenceTranslator.translateSimpleNameWithQualifier(expression, null, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitWhileExpression(@NotNull JetWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        JsNode jsNode = LoopTranslator.createWhile(false, expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitDoWhileExpression(@NotNull JetDoWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        JsNode jsNode = LoopTranslator.createWhile(true, expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        JsStringLiteral stringLiteral = ExpressionVisitor.resolveAsStringConstant(expression, context);
        if (stringLiteral != null) {
            JsStringLiteral jsStringLiteral = stringLiteral;
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
            }
            return jsStringLiteral;
        }
        JsNode jsNode = ExpressionVisitor.resolveAsTemplate(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode resolveAsTemplate(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        JsExpression jsExpression = StringTemplateTranslator.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        return jsExpression;
    }

    @Nullable
    private static JsStringLiteral resolveAsStringConstant(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        Object value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression);
        if (value == null) {
            return null;
        }
        assert (value instanceof String) : "Compile time constant template should be a String constant.";
        String constantString = (String)value;
        return context.program().getStringLiteral(constantString);
    }

    @Override
    @NotNull
    public JsNode visitDotQualifiedExpression(@NotNull JetDotQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        return jsNode;
    }

    @Override
    public JsNode visitLabeledExpression(@NotNull JetLabeledExpression expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitLabeledExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        if (BindingContextUtilPackage.isUsedAsExpression(expression, context.bindingContext())) {
            return Translation.translateAsExpression(baseExpression, context).source(expression);
        }
        JsScope scope2 = context.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsFunctionScope functionScope = (JsFunctionScope)scope2;
        String labelIdent = ExpressionVisitor.getReferencedName(expression.getTargetLabel());
        JsName labelName = functionScope.enterLabel(labelIdent);
        JsStatement baseStatement = Translation.translateAsStatement(baseExpression, context);
        functionScope.exitLabel();
        return new JsLabel(labelName, baseStatement).source(expression);
    }

    @Override
    @NotNull
    public JsNode visitPrefixExpression(@NotNull JetPrefixExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitPostfixExpression(@NotNull JetPostfixExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitIsExpression(@NotNull JetIsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        JsExpression jsExpression = Translation.patternTranslator(context).translateIsExpression(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSafeQualifiedExpression(@NotNull JetSafeQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        return jsNode;
    }

    @Override
    @Nullable
    public JsNode visitWhenExpression(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        return WhenTranslator.translate(expression, context);
    }

    @Override
    @NotNull
    public JsNode visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(expression.getLeft(), context);
        if (expression.getOperationReference().getReferencedNameElementType() != JetTokens.AS_KEYWORD) {
            JsExpression jsExpression2 = jsExpression.source(expression);
            if (jsExpression2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression2;
        }
        JetTypeReference right = expression.getRight();
        assert (right != null);
        JetType rightType = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.TYPE, right);
        JetType leftType = BindingContextUtils.getTypeNotNull(context.bindingContext(), expression.getLeft());
        if (TypeUtils.isNullableType(rightType) || !TypeUtils.isNullableType(leftType)) {
            JsExpression jsExpression3 = jsExpression.source(expression);
            if (jsExpression3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression3;
        }
        JsExpression jsExpression4 = TranslationUtils.sure(jsExpression, context).source(expression);
        if (jsExpression4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        return jsExpression4;
    }

    private static String getReferencedName(JetSimpleNameExpression expression) {
        return expression.getReferencedName().replaceAll("^@", "").replaceAll("(?:^`(.*)`$)", "$1");
    }

    private static JsNameRef getTargetLabel(JetExpressionWithLabel expression, TranslationContext context) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        if (labelElement == null) {
            return null;
        }
        String labelIdent = ExpressionVisitor.getReferencedName(labelElement);
        JsScope scope2 = context.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsName labelName = ((JsFunctionScope)scope2).findLabel(labelIdent);
        assert (labelName != null);
        return labelName.makeRef();
    }

    @Override
    @NotNull
    public JsNode visitBreakExpression(@NotNull JetBreakExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        JsNode jsNode = new JsBreak(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitContinueExpression(@NotNull JetContinueExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        JsNode jsNode = new JsContinue(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        JsExpression jsExpression = new LiteralFunctionTranslator(context).translate(expression.getFunctionLiteral());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitFunctionLiteralExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitNamedFunction(@NotNull JetNamedFunction expression, @NotNull TranslationContext context) {
        boolean isExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        JsExpression alias = new LiteralFunctionTranslator(context).translate(expression);
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        JsName name = context.getNameForDescriptor(descriptor);
        if (InlineUtil.isInline(descriptor)) {
            MetadataProperties.setStaticRef(name, alias);
        }
        JsExpression result2 = (isExpression = BindingContextUtilPackage.isUsedAsExpression(expression, context.bindingContext())) ? alias : JsAstUtils.newVar(name, alias);
        JsNode jsNode = result2.source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitThisExpression(@NotNull JetThisExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        DeclarationDescriptor thisExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression.getInstanceReference());
        assert (thisExpression != null) : "This expression must reference a descriptor: " + expression.getText();
        JsExpression jsExpression = context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(thisExpression)).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        JsExpression jsExpression = AccessTranslationUtils.translateAsGet(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSuperExpression(@NotNull JetSuperExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        DeclarationDescriptor superClassDescriptor = context.bindingContext().get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        assert (superClassDescriptor != null) : ErrorReportingUtils.message(expression);
        JsExpression jsExpression = ReferenceTranslator.translateAsFQReference(superClassDescriptor, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitForExpression(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        JsNode jsNode = LoopTranslator.translateForExpression(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitTryExpression(@NotNull JetTryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        JsTry jsTry = new TryTranslator(expression, context).translate();
        if (jsTry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        return jsTry;
    }

    @Override
    @NotNull
    public JsNode visitThrowExpression(@NotNull JetThrowExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        JetExpression thrownExpression = expression.getThrownExpression();
        assert (thrownExpression != null) : "Thrown expression must not be null";
        JsNode jsNode = new JsThrow(Translation.translateAsExpression(thrownExpression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        JsExpression jsExpression = ClassTranslator.generateObjectLiteral(expression.getObjectDeclaration(), context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitObjectDeclaration(@NotNull JetObjectDeclaration expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForElement(context.bindingContext(), expression);
        JsName name = context.getNameForDescriptor(descriptor);
        JsInvocation value = ClassTranslator.generateClassCreation(expression, context);
        JsNode jsNode = JsAstUtils.newVar(name, value).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        return jsNode;
    }
}

