/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public class MultiDeclarationTranslator
extends AbstractTranslator {
    @NotNull
    private final JetMultiDeclaration multiDeclaration;
    @NotNull
    private final JsName multiObjectName;
    @Nullable
    private final JsExpression initializer;

    @NotNull
    public static JsVars translate(@NotNull JetMultiDeclaration multiDeclaration, @NotNull JsName multiObjectName, @Nullable JsExpression initializer, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        if (multiObjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiObjectName", "org/jetbrains/kotlin/js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        JsVars jsVars = new MultiDeclarationTranslator(multiDeclaration, multiObjectName, initializer, context).translate();
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/MultiDeclarationTranslator", "translate"));
        }
        return jsVars;
    }

    private MultiDeclarationTranslator(@NotNull JetMultiDeclaration multiDeclaration, @NotNull JsName multiObjectName, @Nullable JsExpression initializer, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/js/translate/expression/MultiDeclarationTranslator", "<init>"));
        }
        if (multiObjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiObjectName", "org/jetbrains/kotlin/js/translate/expression/MultiDeclarationTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/MultiDeclarationTranslator", "<init>"));
        }
        super(context);
        this.multiDeclaration = multiDeclaration;
        this.multiObjectName = multiObjectName;
        this.initializer = initializer;
    }

    private JsVars translate() {
        ArrayList<JsVars.JsVar> jsVars = new ArrayList<JsVars.JsVar>();
        if (this.initializer != null) {
            jsVars.add(new JsVars.JsVar(this.multiObjectName, this.initializer));
        }
        JsNameRef multiObjNameRef = this.multiObjectName.makeRef();
        for (JetMultiDeclarationEntry entry : this.multiDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> entryInitCall = this.context().bindingContext().get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            assert (entryInitCall != null) : "Entry init call must be not null";
            JsExpression entryInitializer = CallTranslator.translate(this.context(), entryInitCall, multiObjNameRef);
            FunctionDescriptor candidateDescriptor = entryInitCall.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(candidateDescriptor)) {
                InlineUtils.setInlineCallMetadata(entryInitializer, entry, entryInitCall, this.context());
            }
            VariableDescriptor descriptor = BindingContextUtils.getNotNull(this.context().bindingContext(), BindingContext.VARIABLE, entry);
            JsName name = this.context().getNameForDescriptor(descriptor);
            jsVars.add(new JsVars.JsVar(name, entryInitializer));
        }
        return new JsVars(jsVars, true);
    }
}

