/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataProvider;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\r\u0006)\u0019\"*\u0019<b\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003m_\u0006$'bD\"mCN\u001cH)\u0019;b\r&tG-\u001a:\u000b\u001bM,'/[1mSj\fG/[8o\u0015=!Wm]3sS\u0006d\u0017N_1uS>t'B\u0002\u001fj]&$hHC\tl_Rd\u0017N\\\"mCN\u001ch)\u001b8eKJT\u0011cS8uY&t7\t\\1tg\u001aKg\u000eZ3s\u0015y!Wm]3sS\u0006d\u0017N_3e\t\u0016\u001c8M]5qi>\u0014(+Z:pYZ,'O\u0003\u0010EKN,'/[1mSj,G\rR3tGJL\u0007\u000f^8s%\u0016\u001cx\u000e\u001c<fe*ia-\u001b8e\u00072\f7o\u001d#bi\u0006Tqa\u00197bgNLEMC\u0004DY\u0006\u001c8/\u00133\u000b\t9\fW.\u001a\u0006\u0012\u00072\f7o\u001d#bi\u0006\u0004&o\u001c<jI\u0016\u0014hO\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u00012A\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001bA\u0003\u0003\t\rA9!B\u0002\u0005\b!\u0015A\u0002A\u0003\u0004\t\tAQ\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001B\u0002\u0007\u0001\u000b\t!!\u0001C\u0003\u0006\u0005\u0011\u0011\u0001BB\u0003\u0003\t\u0005A\u0001\"B\u0002\u0005\u000e!=A\u0002A\u0003\u0004\t\u000fA\t\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0012C\u0003\u0003\t\u001bAy\u0001B\u0002\r\u0006e\u0019Q!\u0001\u0005\u00051\u0011iC\u0002B1\u00051\u0017\t3!B\u0001\t\u000ba)Qk\u0001\u0003\u0006\u0007\u0011-\u0011\"\u0001\u0005\u0007[1!\u0011\r\u0002M\u0005C\r)\u0011\u0001#\u0003\u0019\nU\u001bA!B\u0002\u0005\n%\t\u00012B\u0017\u0017\t-Aj!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001dAr\u0001U\u0002\u0001C\u0011)\u0011\u0001c\u0004\r\u0002a=\u0011kA\u0003\u0005\u000e%\t\u0001\u0002C\u0007\u0002\u0011#)\u0014%\u0002\u0011\u0005G\u0004AB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0005\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\b\t\u0011I\u0011\u0001\u0002\u0001\u000e\u0003!-Q\"\u0001\u0005\u0007"})
public final class JavaClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    static {
        $kotlinClass = Reflection.createKotlinClass(JavaClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassDataProvider findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean value = Intrinsics.areEqual(kotlinJvmBinaryClass2.getClassId(), classId);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Class with incorrect id found: expected " + classId + ", actual " + kotlinJvmBinaryClass2.getClassId();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        String[] stringArray = this.deserializedDescriptorResolver.readData(kotlinJvmBinaryClass2, DeserializedDescriptorResolver.KOTLIN_CLASS);
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        Intrinsics.checkExpressionValueIsNotNull(data2, "data");
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(data2);
        return new ClassDataProvider(classData, new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass2));
    }

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(deserializedDescriptorResolver, "deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

