/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingContextUtils {
    private BindingContextUtils() {
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull BindingContext bindingContext, @Nullable JetElement element, boolean onlyReference) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "extractVariableDescriptorIfAny"));
        }
        DeclarationDescriptor descriptor = null;
        if (!onlyReference && (element instanceof JetVariableDeclaration || element instanceof JetParameter)) {
            descriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        } else if (element instanceof JetSimpleNameExpression) {
            descriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, (JetSimpleNameExpression)element);
        } else if (element instanceof JetQualifiedExpression) {
            descriptor = BindingContextUtils.extractVariableDescriptorIfAny(bindingContext, ((JetQualifiedExpression)element).getSelectorExpression(), onlyReference);
        }
        if (descriptor instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor;
        }
        return null;
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/BindingContextUtils", "recordFunctionDeclarationToDescriptor"));
        }
        if (function.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            throw new IllegalArgumentException("function of kind " + (Object)((Object)function.getKind()) + " cannot have declaration");
        }
        trace.record(BindingContext.FUNCTION, psiElement, function);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        V v = BindingContextUtils.getNotNull(bindingContext, slice, key, "Value at " + slice + " must not be null for " + key);
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static JetType getTypeNotNull(@NotNull BindingContext bindingContext, @NotNull JetExpression expression) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        JetType result2 = bindingContext.getType(expression);
        if (result2 == null) {
            throw new IllegalStateException("Type must be not null for " + expression);
        }
        JetType jetType = result2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getTypeNotNull"));
        }
        return jetType;
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        if (messageIfNull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageIfNull", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        V value = bindingContext.get(slice, key);
        if (value == null) {
            throw new IllegalStateException(messageIfNull);
        }
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getNotNull"));
        }
        return v;
    }

    @NotNull
    public static DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull JetElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        JetNamedDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)element, JetNamedDeclaration.class);
        if (declaration instanceof JetFunctionLiteral) {
            DeclarationDescriptor declarationDescriptor = BindingContextUtils.getEnclosingDescriptor(context, declaration);
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
            }
            return declarationDescriptor;
        }
        DeclarationDescriptor descriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        assert (descriptor != null) : "No descriptor for named declaration: " + declaration.getText() + "\n(of type " + declaration.getClass() + ")";
        DeclarationDescriptor declarationDescriptor = descriptor;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingDescriptor"));
        }
        return declarationDescriptor;
    }

    public static FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context, @NotNull JetElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getEnclosingFunctionDescriptor"));
        }
        JetFunction function = PsiTreeUtil.getParentOfType((PsiElement)element, JetFunction.class);
        return (FunctionDescriptor)context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull JetSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (targetLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLabel", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        if (declarationsByLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsByLabel", "org/jetbrains/kotlin/resolve/BindingContextUtils", "reportAmbiguousLabel"));
        }
        ArrayList<PsiElement> targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor : declarationsByLabel) {
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
            assert (element != null) : "Label can only point to something in the same lexical scope";
            targets.add(element);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    @Nullable
    public static JetType updateRecordedType(@Nullable JetType type2, @NotNull JetExpression expression, @NotNull BindingTrace trace, boolean shouldBeMadeNullable) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "updateRecordedType"));
        }
        if (type2 == null) {
            return null;
        }
        if (shouldBeMadeNullable) {
            type2 = TypeUtils.makeNullable(type2);
        }
        trace.recordType(expression, type2);
        return type2;
    }

    @Nullable
    public static JetTypeInfo getRecordedTypeInfo(@NotNull JetExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getRecordedTypeInfo"));
        }
        if (!context.get(BindingContext.PROCESSED, expression).booleanValue()) {
            return null;
        }
        JetTypeInfo result2 = context.get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        return result2 != null ? result2 : TypeInfoFactoryPackage.noTypeInfo(DataFlowInfo.EMPTY);
    }

    public static boolean isExpressionWithValidReference(@NotNull JetExpression expression, @NotNull BindingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/BindingContextUtils", "isExpressionWithValidReference"));
        }
        if (expression instanceof JetCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression, context);
            return resolvedCall instanceof VariableAsFunctionResolvedCall;
        }
        return expression instanceof JetReferenceExpression;
    }

    public static boolean isVarCapturedInClosure(BindingContext bindingContext, DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof VariableDescriptor) || descriptor instanceof PropertyDescriptor) {
            return false;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
        return bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) != null && variableDescriptor.isVar();
    }

    @NotNull
    public static Pair<FunctionDescriptor, PsiElement> getContainingFunctionSkipFunctionLiterals(@Nullable DeclarationDescriptor startDescriptor, boolean strict) {
        PsiElement containingFunction;
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(startDescriptor, FunctionDescriptor.class, strict);
        PsiElement psiElement = containingFunction = containingFunctionDescriptor != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        while (containingFunction instanceof JetFunctionLiteral) {
            containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? DescriptorToSourceUtils.getSourceFromDescriptor(containingFunctionDescriptor) : null;
        }
        Pair<FunctionDescriptor, PsiElement> pair = new Pair<FunctionDescriptor, PsiElement>(containingFunctionDescriptor, containingFunction);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getContainingFunctionSkipFunctionLiterals"));
        }
        return pair;
    }

    @Nullable
    public static ResolvedCall<ConstructorDescriptor> getDelegationConstructorCall(@NotNull BindingContext bindingContext, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getDelegationConstructorCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/BindingContextUtils", "getDelegationConstructorCall"));
        }
        return bindingContext.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructorDescriptor);
    }

    static void addOwnDataTo(final @NotNull BindingTrace trace, final @Nullable TraceEntryFilter filter, boolean commitDiagnostics, @NotNull MutableSlicedMap map2, MutableDiagnosticsWithSuppression diagnostics) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BindingContextUtils", "addOwnDataTo"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/BindingContextUtils", "addOwnDataTo"));
        }
        map2.forEach(new Function3<WritableSlice, Object, Object, Void>(){

            @Override
            public Void invoke(WritableSlice slice, Object key, Object value) {
                if (filter == null || filter.accept(slice, key)) {
                    trace.record(slice, key, value);
                }
                return null;
            }
        });
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : diagnostics.getOwnDiagnostics()) {
            if (filter != null && !filter.accept(null, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }
}

