/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationStub;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegationSpecifierList;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPropertyDelegate;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class DeclarationsChecker {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationChecker annotationChecker;

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull BindingTrace trace) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        if (modifiersChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiersChecker", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        if (annotationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "<init>"));
        }
        this.descriptorResolver = descriptorResolver;
        this.modifiersChecker = modifiersChecker.withTrace(trace);
        this.annotationChecker = annotationChecker;
        this.trace = trace;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "process"));
        }
        for (JetFile file : bodiesResolveContext.getFiles()) {
            this.checkModifiersAndAnnotationsInPackageDirective(file);
            this.annotationChecker.check(file, this.trace, null);
        }
        Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> classes2 = bodiesResolveContext.getDeclaredClasses();
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : classes2.entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = entry.getValue();
            this.checkSupertypesForConsistency(classDescriptorWithResolutionScopes);
            this.checkTypesInClassHeader(classOrObject);
            if (classOrObject instanceof JetClass) {
                JetClass jetClass = (JetClass)classOrObject;
                this.checkClass(bodiesResolveContext, jetClass, classDescriptorWithResolutionScopes);
                this.descriptorResolver.checkNamesInConstraints(jetClass, classDescriptorWithResolutionScopes, classDescriptorWithResolutionScopes.getScopeForClassHeaderResolution(), this.trace);
            } else if (classOrObject instanceof JetObjectDeclaration) {
                this.checkObject((JetObjectDeclaration)classOrObject, classDescriptorWithResolutionScopes);
            }
            this.checkPrimaryConstructor(classOrObject, classDescriptorWithResolutionScopes);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, classDescriptorWithResolutionScopes);
        }
        Map<JetNamedFunction, SimpleFunctionDescriptor> functions2 = bodiesResolveContext.getFunctions();
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : functions2.entrySet()) {
            JetNamedFunction jetNamedFunction = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            this.checkFunction(jetNamedFunction, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(jetNamedFunction, functionDescriptor);
        }
        Map<JetProperty, PropertyDescriptor> properties2 = bodiesResolveContext.getProperties();
        for (Map.Entry<JetProperty, PropertyDescriptor> entry : properties2.entrySet()) {
            JetProperty property = entry.getKey();
            PropertyDescriptor propertyDescriptor = entry.getValue();
            this.checkProperty(property, propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(property, propertyDescriptor);
        }
        for (Map.Entry<JetDeclarationStub, CallableMemberDescriptor> entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)entry.getValue();
            JetSecondaryConstructor declaration = (JetSecondaryConstructor)entry.getKey();
            this.checkConstructorDeclaration(constructorDescriptor, declaration);
        }
    }

    private void checkConstructorDeclaration(ConstructorDescriptor constructorDescriptor, JetDeclaration declaration) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
    }

    private void checkModifiersAndAnnotationsInPackageDirective(JetFile file) {
        JetPackageDirective packageDirective = file.getPackageDirective();
        if (packageDirective == null) {
            return;
        }
        JetModifierList modifierList = packageDirective.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            JetSimpleNameExpression reference;
            JetConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null || (reference = calleeExpression.getConstructorReferenceExpression()) == null) continue;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        this.annotationChecker.check(packageDirective, this.trace, null);
        ModifierCheckerCore.INSTANCE$.check(packageDirective, this.trace, null);
    }

    private void checkTypesInClassHeader(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkTypesInClassHeader"));
        }
        for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
            this.checkBoundsForTypeInClassHeader(delegationSpecifier.getTypeReference());
        }
        if (!(classOrObject instanceof JetClass)) {
            return;
        }
        JetClass jetClass = (JetClass)classOrObject;
        for (JetTypeParameter jetTypeParameter : jetClass.getTypeParameters()) {
            this.checkBoundsForTypeInClassHeader(jetTypeParameter.getExtendsBound());
            this.checkFinalUpperBounds(jetTypeParameter.getExtendsBound());
        }
        for (JetTypeConstraint constraint : jetClass.getTypeConstraints()) {
            this.checkBoundsForTypeInClassHeader(constraint.getBoundTypeReference());
            this.checkFinalUpperBounds(constraint.getBoundTypeReference());
        }
    }

    private void checkBoundsForTypeInClassHeader(@Nullable JetTypeReference typeReference) {
        JetType type2;
        if (typeReference != null && (type2 = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkBounds(typeReference, type2, this.trace);
        }
    }

    private void checkFinalUpperBounds(@Nullable JetTypeReference typeReference) {
        JetType type2;
        if (typeReference != null && (type2 = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkUpperBoundType(typeReference, type2, this.trace);
        }
    }

    private void checkSupertypesForConsistency(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkSupertypesForConsistency"));
        }
        Multimap<TypeConstructor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classDescriptor.getDefaultType());
        for (Map.Entry<TypeConstructor, Collection<TypeProjection>> entry : multimap.asMap().entrySet()) {
            Collection<TypeProjection> projections = entry.getValue();
            if (projections.size() <= 1) continue;
            TypeConstructor typeConstructor2 = entry.getKey();
            ClassifierDescriptor declarationDescriptor = typeConstructor2.getDeclarationDescriptor();
            assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            LinkedHashSet<JetType> conflictingTypes = Sets.newLinkedHashSet();
            for (TypeProjection projection : projections) {
                conflictingTypes.add(projection.getType());
            }
            DeclarationsChecker.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
            JetClassOrObject psiElement = (JetClassOrObject)DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            assert (psiElement != null);
            JetDelegationSpecifierList delegationSpecifierList = psiElement.getDelegationSpecifierList();
            assert (delegationSpecifierList != null);
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
        }
    }

    private static void removeDuplicateTypes(Set<JetType> conflictingTypes) {
        Iterator<JetType> iterator2 = conflictingTypes.iterator();
        block0: while (iterator2.hasNext()) {
            JetType type2 = iterator2.next();
            for (JetType otherType : conflictingTypes) {
                boolean subtypeOf = JetTypeChecker.DEFAULT.equalTypes(type2, otherType);
                if (type2 == otherType || !subtypeOf) continue;
                iterator2.remove();
                continue block0;
            }
        }
    }

    private void checkObject(JetObjectDeclaration declaration, ClassDescriptor classDescriptor) {
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on(declaration, classDescriptor));
        }
    }

    private void checkClass(BodiesResolveContext c, JetClass aClass, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass);
        if (aClass.isInterface()) {
            ASTNode traitKeyword = aClass.getNode().findChildByType(JetTokens.TRAIT_KEYWORD);
            if (traitKeyword != null) {
                this.trace.report(Errors.DEPRECATED_TRAIT_KEYWORD.on(traitKeyword.getPsi()));
            }
            this.checkConstructorInTrait(aClass);
        } else if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            this.checkAnnotationClassWithBody(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass instanceof JetEnumEntry) {
            this.checkEnumEntry((JetEnumEntry)aClass, classDescriptor);
        }
    }

    private void checkPrimaryConstructor(JetClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        JetPrimaryConstructor declaration = classOrObject.getPrimaryConstructor();
        if (primaryConstructor2 == null || declaration == null) {
            return;
        }
        for (JetParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor propertyDescriptor = this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
            if (propertyDescriptor == null) continue;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, propertyDescriptor);
            this.checkPropertyLateInit(parameter, propertyDescriptor);
        }
        if (declaration.getModifierList() != null && !declaration.hasConstructorKeyword()) {
            this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on(declaration.getModifierList()));
        }
        if (!(classOrObject instanceof JetClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on(declaration));
        }
        this.checkConstructorDeclaration(primaryConstructor2, declaration);
    }

    private void checkTypeParameters(JetTypeParameterListOwner typeParameterListOwner) {
        for (JetTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            TypeParameterDescriptor typeParameter = this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter);
            if (typeParameter != null) {
                DescriptorResolver.checkConflictingUpperBounds(this.trace, typeParameter, jetTypeParameter);
            }
            this.annotationChecker.check(jetTypeParameter, this.trace, null);
        }
    }

    private void checkConstructorInTrait(JetClass klass) {
        JetPrimaryConstructor primaryConstructor2 = klass.getPrimaryConstructor();
        if (primaryConstructor2 != null) {
            this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(primaryConstructor2));
        }
    }

    private void checkAnnotationClassWithBody(JetClassOrObject classOrObject) {
        if (classOrObject.getBody() != null) {
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(classOrObject.getBody()));
        }
    }

    private void checkValOnAnnotationParameter(JetClass aClass) {
        for (JetParameter parameter : aClass.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) continue;
            this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on(parameter));
        }
    }

    private void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            JetNamedDeclaration member;
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION || (member = (JetNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor)) == null || !member.hasModifier(JetTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on(member));
        }
    }

    private void checkProperty(JetProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkPropertyAbstractness(property, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        }
        this.checkPropertyLateInit(property, propertyDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
    }

    private void checkPropertyLateInit(@NotNull JetCallableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyLateInit"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyLateInit"));
        }
        JetModifierList modifierList = property.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiElement modifier = modifierList.getModifier(JetTokens.LATE_INIT_KEYWORD);
        if (modifier == null) {
            return;
        }
        boolean hasBackingField = Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
        boolean hasDelegateOrInitializer = false;
        boolean hasCorrespondingValueParameter = false;
        if (property instanceof JetProperty) {
            hasDelegateOrInitializer = ((JetProperty)property).hasDelegateExpressionOrInitializer();
        } else if (property instanceof JetParameter) {
            hasCorrespondingValueParameter = true;
        }
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        PropertySetterDescriptor setter = propertyDescriptor.getSetter();
        boolean customGetterOrSetter = false;
        if (getter != null) {
            customGetterOrSetter = getter.hasBody();
        }
        if (setter != null) {
            customGetterOrSetter |= setter.hasBody();
        }
        boolean returnTypeIsNullable = true;
        boolean returnTypeIsPrimitive = true;
        JetType returnType2 = propertyDescriptor.getReturnType();
        if (returnType2 != null) {
            returnTypeIsNullable = TypeUtils.isNullableType(returnType2);
            returnTypeIsPrimitive = KotlinBuiltIns.isPrimitiveType(returnType2);
        }
        if (!hasBackingField || hasCorrespondingValueParameter || hasDelegateOrInitializer || customGetterOrSetter || returnTypeIsNullable || returnTypeIsPrimitive || propertyDescriptor.getExtensionReceiverParameter() != null) {
            this.trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on(modifier));
        }
    }

    private void checkPropertyAbstractness(@NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull ClassDescriptor classDescriptor) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        JetPropertyAccessor getter = property.getGetter();
        JetPropertyAccessor setter = property.getSetter();
        JetModifierList modifierList = property.getModifierList();
        if (modifierList != null && modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                String name = property.getName();
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on(property, name != null ? name : "", classDescriptor));
                return;
            }
            if (classDescriptor.getKind() == ClassKind.INTERFACE) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(property));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            JetPropertyDelegate delegate2;
            JetExpression initializer = property.getInitializer();
            if (initializer != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on(initializer));
            }
            if ((delegate2 = property.getDelegate()) != null) {
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on(delegate2));
            }
            if (getter != null && getter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on(getter));
            }
            if (setter != null && setter.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on(setter));
            }
        }
    }

    private void checkPropertyInitializer(@NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        boolean hasAccessorImplementation;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        JetPropertyAccessor getter = property.getGetter();
        JetPropertyAccessor setter = property.getSetter();
        boolean bl = hasAccessorImplementation = getter != null && getter.hasBody() || setter != null && setter.hasBody();
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property));
            }
            return;
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean inTrait = containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE;
        JetExpression initializer = property.getInitializer();
        JetPropertyDelegate delegate2 = property.getDelegate();
        boolean backingFieldRequired = Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_TRAIT.on(property));
        }
        if (initializer == null && delegate2 == null) {
            boolean error = false;
            if (backingFieldRequired && !inTrait && !propertyDescriptor.isLateInit() && Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor))) {
                if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on(property));
                } else {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on(property));
                }
            }
            if (!error && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property));
            }
            if (inTrait && property.hasModifier(JetTokens.FINAL_KEYWORD) && backingFieldRequired) {
                this.trace.report(Errors.FINAL_PROPERTY_IN_TRAIT.on(property));
            }
            return;
        }
        if (inTrait) {
            if (delegate2 != null) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_TRAIT.on(delegate2));
            } else {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_TRAIT.on(initializer));
            }
        } else if (delegate2 == null) {
            if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on(initializer));
            } else if (property.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on(initializer));
            }
        }
    }

    protected void checkFunction(JetNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inTrait;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDescriptor;
            boolean bl = inTrait = classDescriptor.getKind() == ClassKind.INTERFACE;
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on(function, functionDescriptor.getName().asString(), classDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(function));
            }
            if ((hasBody = function.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on(function, functionDescriptor));
            }
            if (!hasBody && function.hasModifier(JetTokens.FINAL_KEYWORD) && inTrait) {
                this.trace.report(Errors.FINAL_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            if (!(hasBody || hasAbstractModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            return;
        }
        if (!function.hasBody() && !hasAbstractModifier) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on(function, functionDescriptor));
        }
    }

    private void checkAccessors(@NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        block8: {
            JetModifierList getterModifierList;
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkAccessors"));
            }
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkAccessors"));
            }
            for (JetPropertyAccessor accessor : property.getAccessors()) {
                PropertyAccessorDescriptor propertyAccessorDescriptor;
                PropertyAccessorDescriptor propertyAccessorDescriptor2 = propertyAccessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
                assert (propertyAccessorDescriptor != null) : "No property accessor descriptor for " + property.getText();
                this.modifiersChecker.checkModifiersForDeclaration(accessor, propertyAccessorDescriptor);
            }
            JetPropertyAccessor getter = property.getGetter();
            PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
            JetModifierList jetModifierList = getterModifierList = getter != null ? getter.getModifierList() : null;
            if (getterModifierList == null || getterDescriptor == null) break block8;
            Map<JetModifierKeywordToken, PsiElement> tokens = this.modifiersChecker.getTokensCorrespondingToModifiers(getterModifierList, Sets.newHashSet(JetTokens.PUBLIC_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PRIVATE_KEYWORD, JetTokens.INTERNAL_KEYWORD));
            if (getterDescriptor.getVisibility() != propertyDescriptor.getVisibility()) {
                for (PsiElement token : tokens.values()) {
                    this.trace.report(Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY.on(token));
                }
            } else {
                for (PsiElement token : tokens.values()) {
                    this.trace.report(Errors.REDUNDANT_MODIFIER_IN_GETTER.on(token));
                }
            }
        }
    }

    private void checkEnumEntry(@NotNull JetEnumEntry enumEntry, @NotNull ClassDescriptor classDescriptor) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isEnumClass(declaration)) {
            ClassDescriptor enumClass = (ClassDescriptor)declaration;
            if (!enumEntry.hasInitializer() && !DescriptorUtils.hasDefaultConstructor(enumClass)) {
                this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(enumEntry));
            }
        } else assert (DescriptorUtils.isTrait(declaration)) : "Enum entry should be declared in enum class: " + classDescriptor + " " + (Object)((Object)classDescriptor.getKind());
    }
}

