/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProjectionKind;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScope;
import org.jetbrains.kotlin.resolve.scopes.utils.UtilsPackage;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

public class DescriptorResolver {
    public static final Name COPY_METHOD_NAME = Name.identifier("copy");
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public DescriptorResolver(@NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull StorageManager storageManager, @NotNull TypeResolver typeResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (delegatedPropertyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedPropertyResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/resolve/DescriptorResolver", "<init>"));
        }
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.storageManager = storageManager;
        this.typeResolver = typeResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    public List<JetType> resolveSupertypes(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull JetClassOrObject jetClass, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveSupertypes"));
        }
        ArrayList<JetType> supertypes2 = Lists.newArrayList();
        List<JetDelegationSpecifier> delegationSpecifiers = jetClass.getDelegationSpecifiers();
        Collection<JetType> declaredSupertypes = this.resolveDelegationSpecifiers(scope2, delegationSpecifiers, this.typeResolver, trace, false);
        for (JetType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !this.containsClass(supertypes2)) {
            supertypes2.add(0, this.builtIns.getEnumType(classDescriptor.getDefaultType()));
        }
        if (supertypes2.isEmpty()) {
            JetType defaultSupertype = this.getDefaultSupertype(jetClass, trace, classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS);
            DescriptorResolver.addValidSupertype(supertypes2, defaultSupertype);
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<JetType> supertypes2, JetType declaredSupertype) {
        if (!declaredSupertype.isError()) {
            supertypes2.add(declaredSupertype);
        }
    }

    private boolean containsClass(Collection<JetType> result2) {
        for (JetType type2 : result2) {
            ClassifierDescriptor descriptor = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor instanceof ClassDescriptor) || ((ClassDescriptor)descriptor).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    private JetType getDefaultSupertype(JetClassOrObject jetClass, BindingTrace trace, boolean isAnnotation) {
        if (jetClass instanceof JetEnumEntry) {
            JetClassOrObject parent = JetStubbedPsiUtil.getContainingDeclaration(jetClass, JetClassOrObject.class);
            ClassDescriptor parentDescriptor = trace.getBindingContext().get(BindingContext.CLASS, parent);
            if (parentDescriptor.getTypeConstructor().getParameters().isEmpty()) {
                return parentDescriptor.getDefaultType();
            }
            trace.report(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER.on(jetClass.getNameIdentifier()));
            return ErrorUtils.createErrorType("Supertype not specified");
        }
        if (isAnnotation) {
            return this.builtIns.getAnnotationType();
        }
        return this.builtIns.getAnyType();
    }

    public Collection<JetType> resolveDelegationSpecifiers(LexicalScope extensibleScope, List<JetDelegationSpecifier> delegationSpecifiers, @NotNull TypeResolver resolver2, BindingTrace trace, boolean checkBounds) {
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegationSpecifiers"));
        }
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JetType> result2 = Lists.newArrayList();
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                JetType supertype = resolver2.resolveType(extensibleScope, typeReference, trace, checkBounds);
                if (TypesPackage.isDynamic(supertype)) {
                    trace.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result2.add(supertype);
                JetTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType);
                continue;
            }
            result2.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result2;
    }

    @Nullable
    private static JetTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNullableSupertypeAndStripQuestionMarks"));
        }
        while (typeElement instanceof JetNullableType) {
            JetNullableType nullableType = (JetNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof JetNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable JetTypeElement typeElement) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkProjectionsInImmediateArguments"));
        }
        if (typeElement instanceof JetUserType) {
            JetUserType userType = (JetUserType)typeElement;
            List<JetTypeProjection> typeArguments = userType.getTypeArguments();
            for (JetTypeProjection typeArgument : typeArguments) {
                if (typeArgument.getProjectionKind() == JetProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
            }
        }
    }

    @NotNull
    public static SimpleFunctionDescriptor createComponentFunctionDescriptor(int parameterIndex, @NotNull PropertyDescriptor property, @NotNull ValueParameterDescriptor parameter, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        Name functionName = DataClassUtilsPackage.createComponentName(parameterIndex);
        JetType returnType2 = property.getType();
        SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.EMPTY, functionName, CallableMemberDescriptor.Kind.SYNTHESIZED, parameter.getSource());
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), Collections.emptyList(), returnType2, Modality.FINAL, property.getVisibility());
        trace.record(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createComponentFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createCopyFunctionDescriptor(@NotNull Collection<ValueParameterDescriptor> constructorParameters, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (constructorParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        JetType returnType2 = classDescriptor.getDefaultType();
        SimpleFunctionDescriptorImpl functionDescriptor = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.EMPTY, COPY_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor.getSource());
        ArrayList<ValueParameterDescriptorImpl> parameterDescriptors = Lists.newArrayList();
        for (ValueParameterDescriptor parameter : constructorParameters) {
            PropertyDescriptor propertyDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
            boolean declaresDefaultValue = propertyDescriptor != null;
            ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, null, parameter.getIndex(), parameter.getAnnotations(), parameter.getName(), parameter.getType(), declaresDefaultValue, parameter.getVarargElementType(), parameter.getSource());
            parameterDescriptors.add(parameterDescriptor);
            if (!declaresDefaultValue) continue;
            trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor, propertyDescriptor);
        }
        functionDescriptor.initialize((JetType)null, classDescriptor.getThisAsReceiverParameter(), Collections.emptyList(), parameterDescriptors, returnType2, Modality.FINAL, Visibilities.PUBLIC);
        trace.record(BindingContext.DATA_CLASS_COPY_FUNCTION, classDescriptor, functionDescriptor);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createCopyFunctionDescriptor"));
        }
        return simpleFunctionDescriptorImpl;
    }

    public static Visibility getDefaultVisibility(JetModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        JetModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.DEFAULT_VISIBILITY) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? Visibilities.LOCAL : Visibilities.DEFAULT_VISIBILITY);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, Visibility visibility, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !Visibilities.isPrivate(visibility) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(LexicalScope scope2, FunctionDescriptor owner, JetParameter valueParameter, int index2, JetType type2, BindingTrace trace) {
        JetType varargElementType = null;
        JetType variableType = type2;
        if (valueParameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            varargElementType = type2;
            variableType = this.getVarargParameterType(type2);
        }
        JetModifierList modifierList = valueParameter.getModifierList();
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, valueParameter.getModifierList(), trace);
        Annotations valueParameterAnnotations = Annotations.EMPTY;
        if (modifierList != null) {
            if (valueParameter.hasValOrVar()) {
                AnnotationSplitter annotationSplitter = AnnotationSplitter.create(this.storageManager, allAnnotations, KotlinPackage.setOf(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER));
                valueParameterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
            } else {
                valueParameterAnnotations = allAnnotations;
            }
        }
        ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(owner, null, index2, valueParameterAnnotations, JetPsiUtil.safeName(valueParameter.getName()), variableType, valueParameter.hasDefaultValue(), varargElementType, SourcePackage.toSourceElement(valueParameter));
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = valueParameterDescriptor;
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private JetType getVarargParameterType(@NotNull JetType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        JetType primitiveArrayType = this.builtIns.getPrimitiveArrayJetTypeByPrimitiveJetType(elementType);
        if (primitiveArrayType != null) {
            JetType jetType = primitiveArrayType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
            }
            return jetType;
        }
        JetType jetType = this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVarargParameterType"));
        }
        return jetType;
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForCallableDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, List<JetTypeParameter> typeParameters, BindingTrace trace) {
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            JetTypeParameter typeParameter = typeParameters.get(i);
            result2.add(this.resolveTypeParameterForCallableDescriptor(containingDescriptor, extensibleScope, typeParameter, i, trace));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForCallableDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, JetTypeParameter typeParameter, int index2, BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            assert (!(containingDescriptor instanceof ClassifierDescriptor)) : "This method is intended for functions/properties";
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_OF_FUNCTION_OR_PROPERTY.on(typeParameter));
        }
        AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(typeParameter, trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, Annotations.EMPTY, typeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index2, SourcePackage.toSourceElement(typeParameter));
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        extensibleScope.addClassifierDescriptor(typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable JetClassOrObject object, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        ConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, SourcePackage.toSourceElement(object));
        if (object != null) {
            JetPrimaryConstructor primaryConstructor2 = object.getPrimaryConstructor();
            trace.record(BindingContext.CONSTRUCTOR, primaryConstructor2 != null ? primaryConstructor2 : object, constructorDescriptor);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "createAndRecordPrimaryConstructorForObject"));
        }
        return constructorDescriptorImpl;
    }

    public JetType resolveTypeParameterExtendsBound(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull JetTypeReference extendsBound, LexicalScope scope2, BindingTrace trace) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveTypeParameterExtendsBound"));
        }
        if (extendsBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendsBound", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveTypeParameterExtendsBound"));
        }
        JetType type2 = this.typeResolver.resolveType(scope2, extendsBound, trace, false);
        if (type2.getConstructor().equals(typeParameterDescriptor.getTypeConstructor())) {
            trace.report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(extendsBound));
            type2 = ErrorUtils.createErrorType("Cyclic upper bound: " + type2);
        }
        return type2;
    }

    public void resolveGenericBounds(@NotNull JetTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor, LexicalScope scope2, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveGenericBounds"));
        }
        ArrayList<UpperBoundCheckerTask> deferredUpperBoundCheckerTasks = Lists.newArrayList();
        List<JetTypeParameter> typeParameters = declaration.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = Maps.newHashMap();
        for (int i = 0; i < typeParameters.size(); ++i) {
            JetTypeParameter jetTypeParameter = typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            JetType type2 = this.resolveTypeParameterExtendsBound(typeParameterDescriptor, extendsBound, scope2, trace);
            typeParameterDescriptor.addUpperBound(type2);
            deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(extendsBound, type2));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            JetSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            JetTypeReference boundTypeReference = constraint.getBoundTypeReference();
            JetType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope2, boundTypeReference, trace, false);
                deferredUpperBoundCheckerTasks.add(new UpperBoundCheckerTask(boundTypeReference, bound));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter, typeParameters.get(parameter.getIndex()));
        }
        if (!(declaration instanceof JetClass)) {
            for (UpperBoundCheckerTask checkerTask : deferredUpperBoundCheckerTasks) {
                DescriptorResolver.checkUpperBoundType(checkerTask.upperBound, checkerTask.upperBoundType, trace);
            }
            this.checkNamesInConstraints(declaration, descriptor, scope2, trace);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter, @NotNull JetTypeParameter typeParameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkConflictingUpperBounds"));
        }
        if (KotlinBuiltIns.isNothing(parameter.getUpperBoundsAsType())) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull JetTypeParameterListOwner declaration, @NotNull DeclarationDescriptor descriptor, @NotNull LexicalScope scope2, @NotNull BindingTrace trace) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkNamesInConstraints"));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstraints()) {
            JetTypeReference boundTypeReference;
            JetSimpleNameExpression nameExpression = constraint.getSubjectTypeParameterName();
            if (nameExpression == null) continue;
            Name name = nameExpression.getReferencedNameAsName();
            ClassifierDescriptor classifier2 = UtilsPackage.asJetScope(scope2).getClassifier(name, NoLookupLocation.UNSORTED);
            if (classifier2 instanceof TypeParameterDescriptor && classifier2.getContainingDeclaration() == descriptor) continue;
            if (classifier2 != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression, constraint, declaration));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression, classifier2);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression, nameExpression));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope2, boundTypeReference, trace, true);
        }
    }

    public static void checkUpperBoundType(JetTypeReference upperBound, @NotNull JetType upperBoundType, BindingTrace trace) {
        if (upperBoundType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBoundType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkUpperBoundType"));
        }
        if (!TypeUtils.canHaveSubtypes(JetTypeChecker.DEFAULT, upperBoundType)) {
            trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (TypesPackage.isDynamic(upperBoundType)) {
            trace.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull LexicalScope scope2, @NotNull JetParameter parameter, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        JetType type2 = this.resolveParameterType(scope2, parameter, trace);
        VariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptor(parameter, type2, trace, scope2);
        if (variableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return variableDescriptor;
    }

    private JetType resolveParameterType(LexicalScope scope2, JetParameter parameter, BindingTrace trace) {
        JetTypeReference typeReference = parameter.getTypeReference();
        JetType type2 = typeReference != null ? this.typeResolver.resolveType(scope2, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull JetParameter parameter, @NotNull JetType type2, BindingTrace trace, @NotNull LexicalScope scope2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, parameter.getModifierList(), trace), JetPsiUtil.safeName(parameter.getName()), type2, false, SourcePackage.toSourceElement(parameter));
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(LexicalScope scope2, JetVariableDeclaration variable, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        VariableDescriptorWithInitializerImpl result2;
        JetType type2;
        DeclarationDescriptor containingDeclaration = scope2.getOwnerDescriptor();
        if (JetPsiUtil.isScriptDeclaration(variable)) {
            PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable.isVar(), JetPsiUtil.safeName(variable.getName()), CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(variable), false);
            type2 = this.getVariableType(propertyDescriptor, scope2, variable, dataFlowInfo, false, trace);
            ReceiverParameterDescriptor receiverParameter = ((ScriptDescriptor)containingDeclaration).getThisAsReceiverParameter();
            propertyDescriptor.setType(type2, Collections.emptyList(), receiverParameter, (JetType)null);
            DescriptorResolver.initializeWithDefaultGetterSetter(propertyDescriptor);
            trace.record(BindingContext.VARIABLE, variable, propertyDescriptor);
            result2 = propertyDescriptor;
        } else {
            LocalVariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptorWithType(scope2, variable, null, trace);
            type2 = this.getVariableType(variableDescriptor, scope2, variable, dataFlowInfo, false, trace);
            variableDescriptor.setOutType(type2);
            result2 = variableDescriptor;
        }
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        LocalVariableDescriptor localVariableDescriptor = result2;
        if (localVariableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptor"));
        }
        return localVariableDescriptor;
    }

    private static void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null && !Visibilities.isPrivate(propertyDescriptor.getVisibility())) {
            getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, Annotations.EMPTY);
            getter.initialize(propertyDescriptor.getType());
        }
        if ((setter = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter = DescriptorFactory.createDefaultSetter(propertyDescriptor, Annotations.EMPTY);
        }
        propertyDescriptor.initialize(getter, setter);
    }

    @NotNull
    public LocalVariableDescriptor resolveLocalVariableDescriptorWithType(@NotNull LexicalScope scope2, @NotNull JetVariableDeclaration variable, @Nullable JetType type2, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable.getModifierList(), trace), JetPsiUtil.safeName(variable.getName()), type2, variable.isVar(), SourcePackage.toSourceElement(variable));
        trace.record(BindingContext.VARIABLE, variable, variableDescriptor);
        LocalVariableDescriptor localVariableDescriptor = variableDescriptor;
        if (localVariableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveLocalVariableDescriptorWithType"));
        }
        return localVariableDescriptor;
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull LexicalScope scope2, @NotNull JetProperty property, final @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors2;
        LexicalScope scopeWithTypeParameters;
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        JetModifierList modifierList = property.getModifierList();
        boolean isVar = property.isVar();
        boolean hasBody = DescriptorResolver.hasBody(property);
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(property, DescriptorResolver.getDefaultVisibility(property, containingDeclaration));
        Modality modality = containingDeclaration instanceof ClassDescriptor ? ModifiersChecker.resolveModalityFromModifiers(property, DescriptorResolver.getDefaultModality(containingDeclaration, visibility, hasBody)) : Modality.FINAL;
        final AnnotationSplitter.PropertyWrapper wrapper = new AnnotationSplitter.PropertyWrapper();
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList, trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, (Function0<? extends Set<? extends AnnotationUseSiteTarget>>)new Function0<Set<AnnotationUseSiteTarget>>(){

            @Override
            public Set<AnnotationUseSiteTarget> invoke() {
                return AnnotationSplitter.getTargetSet(false, trace.getBindingContext(), wrapper);
            }
        });
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(KotlinPackage.listOf(annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD), annotationSplitter.getOtherAnnotations()));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(containingDeclaration, propertyAnnotations, modality, visibility, isVar, JetPsiUtil.safeName(property.getName()), CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(property), modifierList != null && modifierList.hasModifier(JetTokens.LATE_INIT_KEYWORD));
        wrapper.setProperty(propertyDescriptor);
        JetType receiverType = null;
        List<JetTypeParameter> typeParameters = property.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope2;
            typeParameterDescriptors2 = Collections.emptyList();
        } else {
            LexicalWritableScope writableScope = new LexicalWritableScope(scope2, containingDeclaration, false, null, new TraceBasedRedeclarationHandler(trace), "Scope with type parameters of a property");
            typeParameterDescriptors2 = this.resolveTypeParametersForCallableDescriptor(propertyDescriptor, writableScope, typeParameters, trace);
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.resolveGenericBounds(property, propertyDescriptor, writableScope, typeParameterDescriptors2, trace);
            scopeWithTypeParameters = writableScope;
        }
        JetTypeReference receiverTypeRef = property.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType);
        ReceiverParameterDescriptor implicitInitializerReceiver = property.hasDelegate() ? null : receiverDescriptor;
        LexicalScope propertyScope = JetScopeUtils.getPropertyDeclarationInnerScope(propertyDescriptor, scope2, typeParameterDescriptors2, implicitInitializerReceiver, trace);
        JetType type2 = this.getVariableType(propertyDescriptor, propertyScope, property, dataFlowInfo, true, trace);
        propertyDescriptor.setType(type2, typeParameterDescriptors2, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDeclaration), receiverDescriptor);
        PropertyGetterDescriptorImpl getter = this.resolvePropertyGetterDescriptor(scopeWithTypeParameters, property, propertyDescriptor, annotationSplitter, trace);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeWithTypeParameters, property, propertyDescriptor, annotationSplitter, trace);
        propertyDescriptor.initialize(getter, setter);
        trace.record(BindingContext.VARIABLE, property, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyDescriptor"));
        }
        return propertyDescriptorImpl;
    }

    static boolean hasBody(JetProperty property) {
        boolean hasBody = property.hasDelegateExpressionOrInitializer();
        if (!hasBody) {
            JetPropertyAccessor getter = property.getGetter();
            if (getter != null && getter.hasBody()) {
                hasBody = true;
            }
            JetPropertyAccessor setter = property.getSetter();
            if (!hasBody && setter != null && setter.hasBody()) {
                hasBody = true;
            }
        }
        return hasBody;
    }

    @NotNull
    private JetType getVariableType(final @NotNull VariableDescriptorWithInitializerImpl variableDescriptor, final @NotNull LexicalScope scope2, final @NotNull JetVariableDeclaration variable, final @NotNull DataFlowInfo dataFlowInfo, boolean notLocal, final @NotNull BindingTrace trace) {
        boolean hasDelegate;
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        JetTypeReference propertyTypeRef = variable.getTypeReference();
        boolean bl = hasDelegate = variable instanceof JetProperty && ((JetProperty)variable).hasDelegateExpression();
        if (propertyTypeRef == null) {
            if (!variable.hasInitializer()) {
                JetProperty property;
                if (hasDelegate && variableDescriptor instanceof PropertyDescriptor && (property = (JetProperty)variable).hasDelegateExpression()) {
                    DeferredType deferredType = DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(){

                        @Override
                        public JetType invoke() {
                            return DescriptorResolver.this.resolveDelegatedPropertyType(property, (PropertyDescriptor)((Object)variableDescriptor), scope2, property.getDelegateExpression(), dataFlowInfo, trace);
                        }
                    });
                    if (deferredType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
                    }
                    return deferredType;
                }
                if (!notLocal) {
                    trace.report(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER.on(variable));
                }
                JetType jetType = ErrorUtils.createErrorType("No type, no body");
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
                }
                return jetType;
            }
            if (notLocal) {
                DeferredType deferredType = DeferredType.createRecursionIntolerant(this.storageManager, trace, new Function0<JetType>(){

                    @Override
                    public JetType invoke() {
                        JetType initializerType = DescriptorResolver.this.resolveInitializerType(scope2, variable.getInitializer(), dataFlowInfo, trace);
                        DescriptorResolver.this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable, dataFlowInfo, initializerType, trace);
                        return DescriptorResolver.transformAnonymousTypeIfNeeded(variableDescriptor, variable, initializerType, trace);
                    }
                });
                if (deferredType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
                }
                return deferredType;
            }
            JetType initializerType = this.resolveInitializerType(scope2, variable.getInitializer(), dataFlowInfo, trace);
            this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable, dataFlowInfo, initializerType, trace);
            JetType jetType = initializerType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
            }
            return jetType;
        }
        JetType type2 = this.typeResolver.resolveType(scope2, propertyTypeRef, trace, true);
        this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable, dataFlowInfo, type2, trace);
        JetType jetType = type2;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getVariableType"));
        }
        return jetType;
    }

    private void setConstantForVariableIfNeeded(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, final @NotNull LexicalScope scope2, final @NotNull JetVariableDeclaration variable, final @NotNull DataFlowInfo dataFlowInfo, final @NotNull JetType variableType, final @NotNull BindingTrace trace) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (variableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableType", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "setConstantForVariableIfNeeded"));
        }
        if (!DescriptorUtils.shouldRecordInitializerForProperty(variableDescriptor, variableType)) {
            return;
        }
        if (!variable.hasInitializer()) {
            return;
        }
        variableDescriptor.setCompileTimeInitializer(this.storageManager.createRecursionTolerantNullableLazyValue(new Function0<ConstantValue<?>>(){

            @Override
            @Nullable
            public ConstantValue<?> invoke() {
                JetExpression initializer = variable.getInitializer();
                JetType initializerType = DescriptorResolver.this.expressionTypingServices.safeGetType(scope2, initializer, variableType, dataFlowInfo, trace);
                return DescriptorResolver.this.constantExpressionEvaluator.evaluateToConstantValue(initializer, trace, initializerType);
            }
        }, null));
    }

    @NotNull
    private JetType resolveDelegatedPropertyType(@NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull LexicalScope scope2, @NotNull JetExpression delegateExpression, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        JetType getterReturnType;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        LexicalScope accessorScope = JetScopeUtils.makeScopeForPropertyAccessor(propertyDescriptor, scope2, trace);
        JetType type2 = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, property, propertyDescriptor, scope2, accessorScope, trace, dataFlowInfo);
        if (type2 != null && (getterReturnType = this.delegatedPropertyResolver.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, type2, trace, accessorScope)) != null) {
            JetType jetType = getterReturnType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
            }
            return jetType;
        }
        JetType jetType = ErrorUtils.createErrorType("Type from delegate");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveDelegatedPropertyType"));
        }
        return jetType;
    }

    @Nullable
    static JetType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull JetNamedDeclaration declaration, @NotNull JetType type2, @NotNull BindingTrace trace) {
        boolean definedInClass;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "transformAnonymousTypeIfNeeded"));
        }
        ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
        if (classifier2 == null || !DescriptorUtils.isAnonymousObject(classifier2) || DescriptorUtils.isLocal(descriptor)) {
            return type2;
        }
        boolean bl = definedInClass = DescriptorUtils.getParentOfType(descriptor, ClassDescriptor.class) != null;
        if (!definedInClass || !Visibilities.isPrivate(descriptor.getVisibility())) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                return type2.getConstructor().getSupertypes().iterator().next();
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration, type2.getConstructor().getSupertypes()));
        }
        return type2;
    }

    @NotNull
    private JetType resolveInitializerType(@NotNull LexicalScope scope2, @NotNull JetExpression initializer, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        JetType jetType = this.expressionTypingServices.safeGetType(scope2, initializer, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolveInitializerType"));
        }
        return jetType;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull LexicalScope scope2, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        if (annotationSplitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationSplitter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertySetterDescriptor"));
        }
        JetPropertyAccessor setter = property.getSetter();
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter != null) {
            CompositeAnnotations annotations2 = new CompositeAnnotations(KotlinPackage.listOf(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, setter.getModifierList(), trace)));
            JetParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveModalityFromModifiers(setter, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(setter, propertyDescriptor.getVisibility()), setter.hasBody(), false, CallableMemberDescriptor.Kind.DECLARATION, null, SourcePackage.toSourceElement(setter));
            if (parameter != null) {
                JetType type2;
                JetTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    type2 = this.typeResolver.resolveType(scope2, typeReference, trace, true);
                    JetType inType = propertyDescriptor.getType();
                    if (inType != null && !TypeUtils.equalTypes(type2, inType)) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scope2, setterDescriptor, parameter, 0, type2, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property.isVar()) {
            Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, setterAnnotations, !property.hasDelegate());
        }
        if (!property.isVar() && setter != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    @Nullable
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull LexicalScope scope2, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, BindingTrace trace) {
        PropertyGetterDescriptorImpl getterDescriptor;
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        if (annotationSplitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationSplitter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePropertyGetterDescriptor"));
        }
        JetPropertyAccessor getter = property.getGetter();
        if (getter != null) {
            JetType outType;
            CompositeAnnotations getterAnnotations = new CompositeAnnotations(KotlinPackage.listOf(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER), annotationSplitter.getOtherAnnotations(), this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, getter.getModifierList(), trace)));
            JetType returnType2 = outType = propertyDescriptor.getType();
            JetTypeReference returnTypeReference = getter.getReturnTypeReference();
            if (returnTypeReference != null) {
                returnType2 = this.typeResolver.resolveType(scope2, returnTypeReference, trace, true);
                if (outType != null && !TypeUtils.equalTypes(returnType2, outType)) {
                    trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyDescriptor.getReturnType(), outType));
                }
            }
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, getterAnnotations, ModifiersChecker.resolveModalityFromModifiers(getter, propertyDescriptor.getModality()), ModifiersChecker.resolveVisibilityFromModifiers(getter, propertyDescriptor.getVisibility()), getter.hasBody(), false, CallableMemberDescriptor.Kind.DECLARATION, null, SourcePackage.toSourceElement(getter));
            getterDescriptor.initialize(returnType2);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        } else {
            Annotations getterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER);
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, getterAnnotations, !property.hasDelegate());
            getterDescriptor.initialize(propertyDescriptor.getType());
        }
        return getterDescriptor;
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull LexicalScope scope2, @NotNull JetParameter parameter, final BindingTrace trace) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        JetType type2 = this.resolveParameterType(scope2, parameter, trace);
        Name name = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        JetModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        final AnnotationSplitter.PropertyWrapper propertyWrapper = new AnnotationSplitter.PropertyWrapper();
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, parameter.getModifierList(), trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, (Function0<? extends Set<? extends AnnotationUseSiteTarget>>)new Function0<Set<AnnotationUseSiteTarget>>(){

            @Override
            public Set<AnnotationUseSiteTarget> invoke() {
                return AnnotationSplitter.getTargetSet(true, trace.getBindingContext(), propertyWrapper);
            }
        });
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD), annotationSplitter.getOtherAnnotations());
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, propertyAnnotations, ModifiersChecker.resolveModalityFromModifiers(parameter, Modality.FINAL), ModifiersChecker.resolveVisibilityFromModifiers(parameter, DescriptorResolver.getDefaultVisibility(parameter, classDescriptor)), isMutable, name, CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(parameter), false);
        propertyWrapper.setProperty(propertyDescriptor);
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), (ReceiverParameterDescriptor)null);
        Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        CompositeAnnotations getterAnnotations = new CompositeAnnotations(KotlinPackage.listOf(annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER)));
        PropertyGetterDescriptorImpl getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, getterAnnotations);
        PropertySetterDescriptorImpl setter = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor, setterAnnotations) : null;
        propertyDescriptor.initialize(getter, setter);
        getter.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        PropertyDescriptorImpl propertyDescriptorImpl = propertyDescriptor;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePrimaryConstructorParameterToAProperty"));
        }
        return propertyDescriptorImpl;
    }

    public static void checkBounds(@NotNull JetTypeReference typeReference, @NotNull JetType type2, @NotNull BindingTrace trace) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (type2.isError()) {
            return;
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        assert (parameters2.size() == arguments2.size());
        List<JetTypeReference> jetTypeArguments = typeElement.getTypeArgumentsAsTypes();
        if (TypesPackage.isFlexible(type2) && !TypesPackage.isDynamic(type2)) {
            assert (jetTypeArguments.size() == 2) : "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilPackage.getElementTextWithContext(typeReference);
            Flexibility flexibility = TypesPackage.flexibility(type2);
            DescriptorResolver.checkBounds(jetTypeArguments.get(0), flexibility.getLowerBound(), trace);
            DescriptorResolver.checkBounds(jetTypeArguments.get(1), flexibility.getUpperBound(), trace);
            return;
        }
        assert (jetTypeArguments.size() == arguments2.size()) : typeElement.getText() + ": " + jetTypeArguments + " - " + arguments2;
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(type2);
        for (int i = 0; i < jetTypeArguments.size(); ++i) {
            JetTypeReference jetTypeArgument = jetTypeArguments.get(i);
            if (jetTypeArgument == null) continue;
            JetType typeArgument = arguments2.get(i).getType();
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            DescriptorResolver.checkBounds(jetTypeArgument, typeArgument, typeParameterDescriptor, substitutor2, trace);
        }
    }

    public static void checkBounds(@NotNull JetTypeReference jetTypeArgument, @NotNull JetType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace) {
        if (jetTypeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgument", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkBounds"));
        }
        for (JetType bound : typeParameterDescriptor.getUpperBounds()) {
            JetType substitutedBound = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
            if (JetTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    public static boolean checkHasOuterClassInstance(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/resolve/DescriptorResolver", "checkHasOuterClassInstance"));
        }
        ClassDescriptor classDescriptor = DescriptorResolver.getContainingClass(scope2);
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor, target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/kotlin/resolve/DescriptorResolver", "isInsideOuterClassOrItsSubclass"));
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull LexicalScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/DescriptorResolver", "getContainingClass"));
        }
        return DescriptorUtils.getParentOfType(scope2.getOwnerDescriptor(), ClassDescriptor.class, false);
    }

    public static void resolvePackageHeader(@NotNull JetPackageDirective packageDirective, @NotNull ModuleDescriptor module, @NotNull BindingTrace trace) {
        if (packageDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDirective", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "resolvePackageHeader"));
        }
        for (JetSimpleNameExpression nameExpression : packageDirective.getPackageNames()) {
            FqName fqName2 = packageDirective.getFqName(nameExpression);
            PackageViewDescriptor packageView = module.getPackage(fqName2);
            trace.record(BindingContext.REFERENCE_TARGET, nameExpression, packageView);
            PackageViewDescriptor parentPackageView = packageView.getContainingDeclaration();
            assert (parentPackageView != null) : "Should not be null since " + fqName2 + " should not be root";
            trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, parentPackageView.getMemberScope());
        }
    }

    public static void registerFileInPackage(@NotNull BindingTrace trace, @NotNull JetFile file) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/DescriptorResolver", "registerFileInPackage"));
        }
        FqName fqName2 = file.getPackageFqName();
        Collection<JetFile> files = trace.get(BindingContext.PACKAGE_TO_FILES, fqName2);
        if (files == null) {
            files = Sets.newIdentityHashSet();
        }
        files.add(file);
        trace.record(BindingContext.PACKAGE_TO_FILES, fqName2, files);
    }

    static final class UpperBoundCheckerTask {
        JetTypeReference upperBound;
        JetType upperBoundType;

        private UpperBoundCheckerTask(JetTypeReference upperBound, JetType upperBoundType) {
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

