/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetKeywordToken;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;

public class ModifiersChecker {
    private static final Set<JetModifierKeywordToken> MODIFIERS_ILLEGAL_ON_PARAMETERS = Sets.newHashSet();
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final Iterable<DeclarationChecker> declarationCheckers;

    public static boolean isIllegalInner(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isIllegalInner"));
        }
        return ModifiersChecker.checkIllegalInner(descriptor) != InnerModifierCheckResult.ALLOWED;
    }

    public static boolean isCompanionModifierAllowed(@NotNull JetDeclaration declaration) {
        JetDeclaration containingDeclaration;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isCompanionModifierAllowed"));
        }
        return declaration instanceof JetObjectDeclaration && (containingDeclaration = JetStubbedPsiUtil.getContainingDeclaration(declaration)) instanceof JetClassOrObject;
    }

    @NotNull
    private static InnerModifierCheckResult checkIllegalInner(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
        }
        if (!(descriptor instanceof ClassDescriptor)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        DeclarationDescriptor containingDeclaration = classDescriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        if (DescriptorUtils.isTrait(containingDeclaration)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.IN_TRAIT;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        if (DescriptorUtils.isObject(containingDeclaration)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.IN_OBJECT;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ALLOWED;
        if (innerModifierCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
        }
        return innerModifierCheckResult;
    }

    private static boolean isIllegalNestedClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isIllegalNestedClass"));
        }
        if (!(descriptor instanceof ClassDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
        return containingClass.isInner() || containingClass.getContainingDeclaration() instanceof FunctionDescriptor;
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Modality defaultModality) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierListOwner.getModifierList(), defaultModality);
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        return modality;
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Modality defaultModality) {
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (modifierList == null) {
            Modality modality = defaultModality;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        if (modifierList.hasModifier(JetTokens.SEALED_KEYWORD)) {
            Modality modality = Modality.SEALED;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                Modality modality = Modality.ABSTRACT;
                if (modality == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
                }
                return modality;
            }
            Modality modality = Modality.OPEN;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        if (hasAbstractModifier) {
            Modality modality = Modality.ABSTRACT;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        boolean hasFinalModifier = modifierList.hasModifier(JetTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            Modality modality = Modality.OPEN;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        if (hasFinalModifier) {
            Modality modality = Modality.FINAL;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        Modality modality = defaultModality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        return modality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Visibility defaultVisibility) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        return visibility;
    }

    public static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(JetTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(JetTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public static boolean isInnerClass(@Nullable JetModifierList modifierList) {
        return modifierList != null && modifierList.hasModifier(JetTokens.INNER_KEYWORD);
    }

    public ModifiersChecker(@NotNull AnnotationChecker annotationChecker, @NotNull Iterable<DeclarationChecker> declarationCheckers) {
        if (annotationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/resolve/ModifiersChecker", "<init>"));
        }
        if (declarationCheckers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationCheckers", "org/jetbrains/kotlin/resolve/ModifiersChecker", "<init>"));
        }
        this.annotationChecker = annotationChecker;
        this.declarationCheckers = declarationCheckers;
    }

    @NotNull
    public ModifiersCheckingProcedure withTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "withTrace"));
        }
        ModifiersCheckingProcedure modifiersCheckingProcedure = new ModifiersCheckingProcedure(trace);
        if (modifiersCheckingProcedure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "withTrace"));
        }
        return modifiersCheckingProcedure;
    }

    static {
        MODIFIERS_ILLEGAL_ON_PARAMETERS.addAll(Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY));
        MODIFIERS_ILLEGAL_ON_PARAMETERS.remove(JetTokens.VARARG_KEYWORD);
    }

    public class ModifiersCheckingProcedure {
        @NotNull
        private final BindingTrace trace;

        private ModifiersCheckingProcedure(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "<init>"));
            }
            this.trace = trace;
        }

        public void checkParameterHasNoValOrVar(@NotNull JetParameter parameter, @NotNull DiagnosticFactory1<PsiElement, JetKeywordToken> diagnosticFactory) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkParameterHasNoValOrVar"));
            }
            if (diagnosticFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkParameterHasNoValOrVar"));
            }
            PsiElement valOrVar = parameter.getValOrVarKeyword();
            if (valOrVar != null) {
                this.trace.report(diagnosticFactory.on(valOrVar, (JetKeywordToken)valOrVar.getNode().getElementType()));
            }
        }

        public void checkModifiersForDeclaration(@NotNull JetDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForDeclaration"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForDeclaration"));
            }
            this.checkNestedClassAllowed(modifierListOwner, descriptor);
            ModifierCheckerCore.INSTANCE$.check(modifierListOwner, this.trace, descriptor);
            this.checkTypeParametersModifiers(modifierListOwner);
            AnnotationUseSiteTargetChecker.INSTANCE$.check(modifierListOwner, descriptor, this.trace);
            this.runDeclarationCheckers(modifierListOwner, descriptor);
            ClassDescriptor classDescriptor = descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null;
            ModifiersChecker.this.annotationChecker.check(modifierListOwner, this.trace, classDescriptor);
        }

        public void checkModifiersForLocalDeclaration(@NotNull JetDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForLocalDeclaration"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForLocalDeclaration"));
            }
            AnnotationUseSiteTargetChecker.INSTANCE$.check(modifierListOwner, descriptor, this.trace);
            this.runDeclarationCheckers(modifierListOwner, descriptor);
            ModifiersChecker.this.annotationChecker.check(modifierListOwner, this.trace, descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null);
            ModifierCheckerCore.INSTANCE$.check(modifierListOwner, this.trace, descriptor);
        }

        private void checkNestedClassAllowed(@NotNull JetModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkNestedClassAllowed"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkNestedClassAllowed"));
            }
            if (modifierListOwner.hasModifier(JetTokens.INNER_KEYWORD)) {
                return;
            }
            if (modifierListOwner instanceof JetClass && !(modifierListOwner instanceof JetEnumEntry)) {
                boolean localEnumError;
                JetClass aClass = (JetClass)modifierListOwner;
                boolean bl = localEnumError = aClass.isLocal() && aClass.isEnum();
                if (!localEnumError && ModifiersChecker.isIllegalNestedClass(descriptor)) {
                    this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(aClass));
                }
            }
        }

        @NotNull
        public Map<JetModifierKeywordToken, PsiElement> getTokensCorrespondingToModifiers(@NotNull JetModifierList modifierList, @NotNull Collection<JetModifierKeywordToken> possibleModifiers) {
            if (modifierList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "getTokensCorrespondingToModifiers"));
            }
            if (possibleModifiers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleModifiers", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "getTokensCorrespondingToModifiers"));
            }
            HashMap<JetModifierKeywordToken, PsiElement> tokens = Maps.newHashMap();
            for (JetModifierKeywordToken modifier : possibleModifiers) {
                if (!modifierList.hasModifier(modifier)) continue;
                tokens.put(modifier, modifierList.getModifier(modifier));
            }
            HashMap<JetModifierKeywordToken, PsiElement> hashMap = tokens;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "getTokensCorrespondingToModifiers"));
            }
            return hashMap;
        }

        private void runDeclarationCheckers(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "runDeclarationCheckers"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "runDeclarationCheckers"));
            }
            for (DeclarationChecker checker : ModifiersChecker.this.declarationCheckers) {
                checker.check(declaration, descriptor, this.trace, this.trace.getBindingContext());
            }
        }

        public void checkTypeParametersModifiers(@NotNull JetModifierListOwner modifierListOwner) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkTypeParametersModifiers"));
            }
            if (!(modifierListOwner instanceof JetTypeParameterListOwner)) {
                return;
            }
            List<JetTypeParameter> typeParameters = ((JetTypeParameterListOwner)modifierListOwner).getTypeParameters();
            for (JetTypeParameter typeParameter : typeParameters) {
                ModifierCheckerCore.INSTANCE$.check(typeParameter, this.trace, null);
            }
        }
    }

    private static enum InnerModifierCheckResult {
        ALLOWED,
        ILLEGAL_POSITION,
        IN_TRAIT,
        IN_OBJECT;

    }
}

