/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.context.TypeLazinessToken;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetDynamicType;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFunctionType;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProjectionKind;
import org.jetbrains.kotlin.psi.JetSelfType;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.PlatformTypesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.TypeResolver$Companion$WhenMappings;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"6\u0012)aA+\u001f9f%\u0016\u001cx\u000e\u001c<fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\u0013C:tw\u000e^1uS>t'+Z:pYZ,'O\u0003\nB]:|G/\u0019;j_:\u0014Vm]8mm\u0016\u0014(bG9vC2Lg-[3e\u000bb\u0004(/Z:tS>t'+Z:pYZ,'OC\u000eRk\u0006d\u0017NZ5fI\u0016C\bO]3tg&|gNU3t_24XM\u001d\u0006\u0011[>$W\u000f\\3EKN\u001c'/\u001b9u_JT\u0001#T8ek2,G)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006!M2,\u00070\u001b2mKRK\b/Z\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\bK]8wS\u0012,'O\u0003\u0011GY\u0016D\u0018N\u00197f)f\u0004XmQ1qC\nLG.\u001b;jKN\u0004&o\u001c<jI\u0016\u0014(BD:u_J\fw-Z'b]\u0006<WM\u001d\u0006\u000f'R|'/Y4f\u001b\u0006t\u0017mZ3s\u0015\u001d\u0019Ho\u001c:bO\u0016TQ\u0002\\1{S:,7o\u001d+pW\u0016t'\"\u0005+za\u0016d\u0015M_5oKN\u001cHk\\6f]*91m\u001c8uKb$(\u0002\u00063z]\u0006l\u0017n\u0019+za\u0016\u001c8+\u001a;uS:<7O\u0003\u000bEs:\fW.[2UsB,7oU3ui&twm\u001d\u0006\u0006if\u0004Xm\u001d\u0006\u0011[>$\u0017NZ5feN\u001c\u0005.Z2lKJT\u0001#T8eS\u001aLWM]:DQ\u0016\u001c7.\u001a:\u000b[QK\b/\u001a*fg>dg/\u001a:%\r2,\u00070\u001b2mKRK\b/Z\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\bK]8wS\u0012,'OC\re_J+7o\u001c7wKB{7o]5cYf\u0014\u0015M]3UsB,'\"A2\u000b+QK\b/\u001a*fg>dW\u000f^5p]\u000e{g\u000e^3yi*iA/\u001f9f%\u00164WM]3oG\u0016T\u0001CS3u)f\u0004XMU3gKJ,gnY3\u000b\u0007A\u001c\u0018N\u0003\tQ_N\u001c\u0018N\u00197z\u0005\u0006\u0014X\rV=qK*Ar-\u001a;TG>\u0004XMR8s)f\u0004X\rU1sC6,G/\u001a:\u000b/QL\b/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(b\u0006+za\u0016\u0004\u0016M]1nKR,'\u000fR3tGJL\u0007\u000f^8s\u0015!QU\r^*d_B,'BB:d_B,7O\u0003\u0007sKN|GN^3DY\u0006\u001c8OC\u0003tG>\u0004XM\u0003\u0007MKbL7-\u00197TG>\u0004XM\u0003\u0005vg\u0016\u0014H+\u001f9f\u0015-QU\r^+tKJ$\u0016\u0010]3\u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b)\rc\u0017m]:jM&,'\u000fR3tGJL\u0007\u000f^8s\u0015]\u0011Xm]8mm\u0016\u0004vn]:jE2L()\u0019:f)f\u0004XMC\u0006sKN|GN^3UsB,'b\u0002&fiRK\b/\u001a\u0006\fG\",7m\u001b\"pk:$7OC\u0004C_>dW-\u00198\u000b%I,7o\u001c7wKRK\b/Z#mK6,g\u000e\u001e\u0006\fC:tw\u000e^1uS>t7OC\u0006B]:|G/\u0019;j_:\u001c(b\u0003;za\u0016,E.Z7f]RTaBS3u)f\u0004X-\u00127f[\u0016tGO\u0003\fsKN|GN^3UsB,\u0007K]8kK\u000e$\u0018n\u001c8t\u0015-\u0019wN\\:ueV\u001cGo\u001c:\u000b\u001fQK\b/Z\"p]N$(/^2u_JT\u0001#\u0019:hk6,g\u000e^#mK6,g\u000e^:\u000b\t1K7\u000f\u001e\u0006\u0012\u0015\u0016$H+\u001f9f!J|'.Z2uS>t'B\u0004+za\u0016\u0004&o\u001c6fGRLwN\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'\"C\"p[B\fg.[8oU\u000fQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0002\t\u00061\u0001Qa\u0001C\u0002\u0011\u0011a\u0001!B\u0002\u0005\u0004!)A\u0002A\u0003\u0003\t\u0005Ai!B\u0002\u0005\n!1A\u0002A\u0003\u0004\t\tAy\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\"C\u0003\u0004\t\u0019A\t\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001RC\u0003\u0004\t\u001dA!\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001\u0002D\u0003\u0004\t!A9\u0002\u0004\u0001\u0006\u0007\u0011\r\u0001\"\u0004\u0007\u0001\u000b\t!\u0019\u0001\u0003\u0003\u0006\u0005\u0011\r\u0001\"B\u0003\u0003\t\u0013Aa!\u0002\u0002\u0005\u0004!mQA\u0001\u0003\u0007\u0011#)!\u0001B\u0004\t\u0015\u0015\u0011A\u0001\u0003E\f\u000b\t!\u0019\u0001C\u0007\u0006\u0007\u0011\r\u0001b\u0004\u0007\u0001\u000b\t!\u0011\u0001#\t\u0006\u0007\u0011q\u0001\u0002\u0005\u0007\u0001\u000b\r!\u0019\u0001C\t\r\u0001\u0015\u0011A1\u0001\u0005\u0012\u000b\t!\u0019\u0001C\b\u0006\u0005\u0011q\u0001\u0002E\u0003\u0004\t\u0013A)\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001rE\u0003\u0004\tGA1\u0003\u0004\u0001\u0006\u0005\u0011\r\u0002bE\u0003\u0003\t\u0013A)#B\u0002\u0005$!)B\u0002A\u0003\u0004\t9Aa\u0003\u0004\u0001\u0006\u0007\u0011\r\u0001b\u0006\u0007\u0001\u000b\r!I\u0001c\f\r\u0001\u0015\u0011A\u0011\u0002E\u0018\u000b\t!\u0019\u0003C\u000b\u0006\u0005\u0011q\u0001BF\u0003\u0003\t\u0007Aq#B\u0002\u0005\u0011!IB\u0002A\u0003\u0003\t!A\u0011$B\u0002\u0005\u0006!QB\u0002A\u0003\u0003\t\u0013A1$B\u0002\u00053!]B\u0002A\u0003\u0004\t9AI\u0004\u0004\u0001\u0006\u0005\u0011I\u0002rG\u0003\u0003\t9AI$B\u0002\u0005\u0011!qB\u0002A\u0003\u0004\t\u000bAq\u0004\u0004\u0001\u0006\u0007\u0011q\u0001r\b\u0007\u0001\u000b\r!\u0001\u0002\u0003\u0011\r\u0001\u0015\t\u0001\u0012I\u0003\u0003\twA\u0011%\u0002\u0002\u0005=!yRA\u0001\u0003\t\u0011y!1\u0001\u0004\u0002\u0011De\u0019Q!\u0001\u0005\u00041\ri\u00121i\u0004.\u0019\u0011\tG\u0001g\u0002\"\u0007\u0015\t\u0001r\u0001M\u0004+\u000e!Qa\u0001C\u0004\u0013\u0005A\u0019\"\f\u0007\u0005C\u0012A2\"I\u0002\u0006\u0003!E\u0001\u0014C+\u0004\t\u0015\u0019AaC\u0005\u0002\u00113iC\u0002B1\u00051\u001d\t3!B\u0001\t\fa-Qk\u0001\u0003\u0006\u0007\u00119\u0011\"\u0001\u0005\f[1!\u0011\r\u0002M\nC\r)\u0011\u0001c\u0004\u0019\u0010U\u001bA!B\u0002\u0005\u0014%\t\u0001\u0002D\u0017\r\t\u0005$\u0001\u0014D\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005V\u0007\u0011)1\u0001\"\u0007\n\u0003!iQ\u0006\u0004\u0003b\ta-\u0011eA\u0003\u0002\u0011\u0015AR!V\u0002\u0005\u000b\r!Y!C\u0001\t\u00165bA!\u0019\u0003\u0019\n\u0005\u001aQ!\u0001\u0005\u00051\u0011)6\u0001B\u0003\u0004\t\u0013I\u0011\u0001\u0003\u0006.\u0019\u0011\tG\u0001\u0007\u0005\"\u0007\u0015\t\u0001R\u0002M\u0007+\u000e!Qa\u0001\u0003\t\u0013\u0005A9\"l\u0010\u0005\u0003aqQt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u001cam\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001rD\u0007\u0004\u000b\u0005Ai\u0002'\bQ\u0007\u0003\t3!B\u0001\t\u001fay\u0011kA\u0004\u0005\u001d%\t\u0001rD\u0007\u0002\u0011Ai\u0011\u0001#\t.@\u0011\t\u00014EO\b\t\u0001Ai\"D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0001u=A\u0001\u0001\u0005\u0013\u001b\r)\u0011\u0001C\t\u0019#A\u001b\t!I\u0002\u0006\u0003!\u0011\u0002DE)\u0004\u000f\u0011\r\u0012\"\u0001E\u0013\u001b\u0005A\u0001#D\u0001\t'5ZCa\u0001\r\u0015;\u001f!\u0001\u0001#\u000b\u000e\u0007\u0015\t\u0001r\u0005M\u0014!\u000e\u0001Qt\u0002\u0003\u0001\u0011Wi1!B\u0001\t)a!\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001RF\u0007\u0004\u000b\u0005AI\u0003'\u000bQ\u0007\u0005\tC!B\u0001\t+1\u0005\u0001$F)\u0004\u0013\u0011!\u0012\"\u0001E\u0016\u001b\u0005Aa#D\u0001\t.5\t\u0001bFW \t\rA\u0002$h\u0004\u0005\u0001!uQbA\u0003\u0002\u00117AZ\u0002U\u0002\u0001;\u001f!\u0001\u0001c\b\u000e\u0007\u0015\t\u0001R\u0004M\u000f!\u000e\u0005\u0011eA\u0003\u0002\u0011=Ar\"U\u0002\b\taI\u0011\u0001c\b\u000e\u0003!\u0001R\"\u0001E\u0011[\u007f!\u0011\u0001'\r\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005AY\u0002g\u0007Q\u0007\u0001iz\u0001\u0002\u0001\t 5\u0019Q!\u0001E\u000f1;\u00016\u0011A\u0011\u0004\u000b\u0005Ay\u0003g\fR\u0007\u001d!\t$C\u0001\t15\t\u0001\u0002E\u0007\u0002\u0011CiK\u0007B\u0002\u00192u=A\u0001\u0001E\u0015\u001b\r)\u0011\u0001c\n\u0019(A\u001b\u0001!h\u0004\u0005\u0001!}QbA\u0003\u0002\u0011;Aj\u0002UB\u0001;\u001f!\u0001\u0001#\f\u000e\u0007\u0015\t\u0001\u0012\u0006M\u0015!\u000e\tQt\u0002\u0003\u0001\u0011gi1!B\u0001\t2aE\u0002ka\u0001\"\u0007\u0015\t\u0001r\u0006M\u0018#\u000eYA\u0011G\u0005\u0002\u0011ai\u0011\u0001\u0003\f\u000e\u0003!\u0005R\"\u0001\u0005\u0018\u001b\u0005!\t!L\u0016\u0005\u0003aURt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u001cam\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bG\u0007\u0004\u000b\u0005A\u0019\u0004g\rQ\u0007\u0003i\n\u0002\u0002\u0001\t95!Q!\u0001\u0005\u001b\u0019\u0003A\"\u0004U\u0002\u0002C\r)\u0011\u0001C\b\u0019\u001fE\u001b\u0011\u0002\"\u000e\n\u0003!}Q\"\u0001\u0005\u0011\u001b\u0005A)$D\u0001\t75\"D!\u0001\r\u001e;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u00012\u0004M\u000e!\u000e\u0001Qt\u0002\u0003\u0001\u0011wi1!B\u0001\t8a]\u0002k!\u0001\u001e\u001a\u0011\u0001\u0001RH\u0007\t\u000b\u0005AA$\u0003\u0003\n\u0007\u0015\t\u0001\u0012\bM\u001d1q\u00016!A\u0011\t\u000b\u0005AA$\u0003\u0003\n\u0007\u0015\t\u0001\"\b\r\u001e1q\t6!\u0003\u0003\u001e\u0013\u0005Ai$D\u0001\t!5\t\u0001bH\u0007\u0002\u0011{)\f\u001dA\u0003`\u0002\u0011\u0019\u000f\u0001G\u0002\u001e\u0010\u0011\u0001\u0001rA\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0011AO\b\t\u0001AY!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0003u=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0019!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0003;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0015Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0012aE\u0001kA\u0002\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u000f\t3!B\u0001\t\u0005a\u0011\u0011kA\n\u0005\u0007%\tA\u0001A\u0007\u0002\u0011'i\u0011\u0001\u0003\u0006\u000e\u0003!UQ\"\u0001\u0005\f\u001b\u0005A9\"D\u0001\t\u00195\t\u0001\u0012D\u0007\u0002\u00115\u0001"})
public final class TypeResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    private final AnnotationResolver annotationResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final ModuleDescriptor moduleDescriptor;
    private final FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final StorageManager storageManager;
    private final TypeLazinessToken lazinessToken;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final ModifiersChecker modifiersChecker;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(TypeResolver.class);
        Companion companion = Companion = new Companion(null);
    }

    @NotNull
    public final JetType resolveType(@NotNull LexicalScope scope2, @NotNull JetTypeReference typeReference, @NotNull BindingTrace trace, boolean checkBounds) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        return this.resolveType(new TypeResolutionContext(scope2, trace, checkBounds, false), typeReference);
    }

    private final JetType resolveType(TypeResolutionContext c, JetTypeReference typeReference) {
        KotlinPackage.assert(!c.allowBareTypes, "Use resolvePossiblyBareType() when bare types are allowed");
        JetType jetType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        Intrinsics.checkExpressionValueIsNotNull(jetType, "resolvePossiblyBareType(\u2026eference).getActualType()");
        return jetType;
    }

    @NotNull
    public final PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull JetTypeReference typeReference) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeReference, "typeReference");
        JetType cachedType = (JetType)c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(cachedType)");
            return possiblyBareType;
        }
        JetType debugType = CodeFragmentUtilKt.getDebugTypeInfo(typeReference);
        if (debugType != null) {
            c.trace.record(BindingContext.TYPE, typeReference, debugType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(debugType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(debugType)");
            return possiblyBareType;
        }
        if (!c.allowBareTypes && !c.forceResolveLazyTypes && this.lazinessToken.isLazy()) {
            @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.LOCAL_CLASS, data={"5\u0006)\u0019D+\u001f9f%\u0016\u001cx\u000e\u001c<fe\u0012\u0012Xm]8mm\u0016\u0004vn]:jE2L()\u0019:f)f\u0004X\r\n'buf\\u\u000e\u001e7j]RK\b/\u001a\u0006\u000f\t\u0016dWmZ1uS:<G+\u001f9f\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\"\u0002;za\u0016\u001c(B\u0003'buf,e\u000e^5us*9!/Z:pYZ,'\u0002\u00027bufTa\u0001P5oSRt$\u0002\u0004+za\u0016\u0014Vm]8mm\u0016\u0014(\"\u0006+za\u0016\u0014Vm]8mkRLwN\\\"p]R,\u0007\u0010\u001e\u0006\u0004aNL'\u0002\u0005&fiRK\b/\u001a*fM\u0016\u0014XM\\2f\u0015%yF-\u001a7fO\u0006$XM\u0003\tO_RtU\u000f\u001c7MCjLh+\u00197vK*91\u000f^8sC\u001e,'b\u0002&fiRK\b/\u001a\u0006\b\u001d>$h*\u001e7m\u0015-\tgN\\8uCRLwN\\:\u000b/\u0019|'oY3SKN|GN^3BY2\u001cuN\u001c;f]R\u001c(\u0002B+oSRT1bZ3u\t\u0016dWmZ1uK2\r!\u0002\u0002\t\u00011\tQ!\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0003\t\u0007A9!\u0002\u0002\u0005\u0007!!Qa\u0001C\u0004\u0011\ra\u0001!\u0002\u0002\u0005\u0007!)QA\u0001\u0003\u0004\u0011\u0017)!\u0001b\u0001\t\r\u0015\u0011A1\u0002E\u0007\u000b\t!\u0019\u0001\u0003\u0005\u0006\u0007\u00115\u0001r\u0002\u0007\u0001\u000b\r!!\u0001#\u0005\r\u0001\u0015\u0011A!\u0001E\n\u000b\r!\u0001\u0002C\u0005\r\u0001\u0015\u0011AQ\u0002E\b\u000b\u0005A!!B\u0002\u0005\u0014!UA\u0002A\u0003\u0003\t\tA\t\u0002B\u0003\r\u0001e\u0019Q!\u0001E\u00031\u000bI2!B\u0001\t\ta!Qv\u0005\u0003b\ta9\u0011UC\u0003\u0002\u0011\u001dIi!c\u0003\u0006\u0003!=\u0001tB)\u0004\u0003\u0011E\u0001dB+\u0004\t\u0015\u0019AaB\u0005\u0002\u0011%i+\u0002B\u0006\u0019\u0015\u0005\u001aQ!\u0001\u0005\u000b1)\t6a\u0001\u0003\u000b\u0013\u0005!\u0001!L\u0007\u0005\u0015aY\u00115B\u0003\u0002\u0011\u001fAz!U\u0002\u0002\t#\t6a\u0001\u0003\f\u0013\u0005A)\"\u000e\n\u0006#\u0011\u0019\u000f\u0001'\u0003\"\u0007\u0015\t\u0001\u0002\u0001\r\u0001#\u000eIA\u0011B\u0005\u0002\t\u0001i\u0011\u0001#\u0003\u000e\u0003!)Q\"\u0001\u0005\u0007"})
            public final class LazyKotlinType
            extends DelegatingType
            implements LazyEntity {
                public static final /* synthetic */ KClass $kotlinClass;
                private final NotNullLazyValue<JetType> _delegate;
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ JetTypeReference $typeReference;

                static {
                    $kotlinClass = Reflection.createKotlinClass(LazyKotlinType.class);
                }

                @NotNull
                protected JetType getDelegate() {
                    return (JetType)this._delegate.invoke();
                }

                public void forceResolveAllContents() {
                    ForceResolveUtil.forceResolveAllContents(this.getConstructor());
                    Iterable $receiver = this.getArguments();
                    for (T element : $receiver) {
                        TypeProjection it = (TypeProjection)element;
                        ForceResolveUtil.forceResolveAllContents(it.getType());
                    }
                }

                public LazyKotlinType(TypeResolver $outer, TypeResolutionContext $captured_local_variable$1, JetTypeReference $captured_local_variable$2) {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$typeReference = $captured_local_variable$2;
                    this._delegate = TypeResolver.access$getStorageManager$1($outer).createLazyValue((Function0)new Function0<JetType>(this){
                        final /* synthetic */ LazyKotlinType this$0;

                        @NotNull
                        public final JetType invoke() {
                            return TypeResolver.access$doResolvePossiblyBareType$2(this.this$0.this$0, this.this$0.$c, this.this$0.$typeReference).getActualType();
                        }
                        {
                            this.this$0 = lazyKotlinType;
                            super(0);
                        }
                    });
                }
            }
            LazyKotlinType lazyKotlinType = new LazyKotlinType(this, c, typeReference);
            c.trace.record(BindingContext.TYPE, typeReference, lazyKotlinType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(lazyKotlinType);
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType, "type(lazyKotlinType)");
            return possiblyBareType;
        }
        PossiblyBareType type2 = this.doResolvePossiblyBareType(c, typeReference);
        if (!type2.isBare()) {
            c.trace.record(BindingContext.TYPE, typeReference, type2.getActualType());
        }
        return type2;
    }

    private final PossiblyBareType doResolvePossiblyBareType(TypeResolutionContext c, JetTypeReference typeReference) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(c.scope, typeReference.getAnnotationEntries(), c.trace);
        JetTypeElement typeElement = typeReference.getTypeElement();
        Annotations annotations3 = annotations2;
        Intrinsics.checkExpressionValueIsNotNull(annotations3, "annotations");
        PossiblyBareType type2 = this.resolveTypeElement(c, annotations3, typeElement);
        c.trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, typeReference, ScopeUtilsKt.asJetScope(c.scope));
        if (!type2.isBare()) {
            for (TypeProjection argument : type2.getActualType().getArguments()) {
                ForceResolveUtil.forceResolveAllContents(argument.getType());
            }
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    private final PossiblyBareType resolveTypeElement(TypeResolutionContext c, Annotations annotations2, JetTypeElement typeElement) {
        PossiblyBareType possiblyBareType;
        Unit unit;
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        JetTypeElement jetTypeElement = typeElement;
        if (jetTypeElement != null) {
            jetTypeElement.accept(new JetVisitorVoid(this, c, (Ref.ObjectRef)result2, annotations2){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ Ref.ObjectRef $result;
                final /* synthetic */ Annotations $annotations;

                static {
                    $kotlinClass = Reflection.createKotlinClass(resolveTypeElement.1.class);
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitUserType(@NotNull JetUserType type2) {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    LexicalScope lexicalScope = this.$c.scope;
                    Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "c.scope");
                    BindingTrace bindingTrace = this.$c.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
                    ClassifierDescriptor classifierDescriptor = this.this$0.resolveClass(lexicalScope, type2, bindingTrace);
                    if (classifierDescriptor == null) {
                        TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorTy\u2026o type\").getConstructor()");
                        List<JetTypeProjection> list = type2.getTypeArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list, "type.getTypeArguments()");
                        List<TypeProjection> arguments2 = TypeResolver.access$resolveTypeProjections$3(this.this$0, this.$c, typeConstructor2, list);
                        this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(DebugTextUtilKt.getDebugText(type2), arguments2));
                        return;
                    }
                    JetSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                    String referencedName = type2.getReferencedName();
                    if (referenceExpression == null || referencedName == null) {
                        return;
                    }
                    this.$c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifierDescriptor);
                    ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                    if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
                        DeclarationDescriptor containing;
                        PossiblyBareType possiblyBareType;
                        JetScope scopeForTypeParameter = TypeResolver.access$getScopeForTypeParameter$4(this.this$0, this.$c, (TypeParameterDescriptor)classifierDescriptor);
                        if (scopeForTypeParameter instanceof ErrorUtils.ErrorScope) {
                            possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorType("?"));
                        } else {
                            TypeConstructor typeConstructor3 = ((TypeParameterDescriptor)classifierDescriptor).getTypeConstructor();
                            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "classifierDescriptor.getTypeConstructor()");
                            possiblyBareType = PossiblyBareType.type(JetTypeImpl.Companion.create(this.$annotations, typeConstructor3, TypeUtils.hasNullableLowerBound((TypeParameterDescriptor)classifierDescriptor), KotlinPackage.<T>listOf(), scopeForTypeParameter));
                        }
                        this.$result.element = possiblyBareType;
                        TypeConstructor typeConstructor4 = ErrorUtils.createErrorType("No type").getConstructor();
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "ErrorUtils.createErrorTy\u2026o type\").getConstructor()");
                        List<JetTypeProjection> list = type2.getTypeArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list, "type.getTypeArguments()");
                        List<TypeProjection> arguments3 = TypeResolver.access$resolveTypeProjections$3(this.this$0, this.$c, typeConstructor4, list);
                        if (!arguments3.isEmpty()) {
                            this.$c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((JetElement)((PsiElement)type2.getTypeArgumentList()), 0));
                        }
                        if ((containing = ((TypeParameterDescriptor)classifierDescriptor).getContainingDeclaration()) instanceof ClassDescriptor) {
                            DescriptorResolver.checkHasOuterClassInstance(this.$c.scope, this.$c.trace, referenceExpression, (ClassDescriptor)containing);
                        }
                    } else if (classifierDescriptor2 instanceof ClassDescriptor) {
                        TypeConstructor typeConstructor5;
                        TypeConstructor typeConstructor6 = typeConstructor5 = ((ClassDescriptor)classifierDescriptor).getTypeConstructor();
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor6, "typeConstructor");
                        List<JetTypeProjection> list = type2.getTypeArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list, "type.getTypeArguments()");
                        List<TypeProjection> arguments4 = TypeResolver.access$resolveTypeProjections$3(this.this$0, this.$c, typeConstructor6, list);
                        List<TypeParameterDescriptor> parameters2 = typeConstructor5.getParameters();
                        int expectedArgumentCount = parameters2.size();
                        int actualArgumentCount = arguments4.size();
                        if (ErrorUtils.isError(classifierDescriptor)) {
                            this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments("[Error type: " + typeConstructor5 + "]", arguments4));
                        } else if (actualArgumentCount != expectedArgumentCount) {
                            if (actualArgumentCount == 0) {
                                if (this.$c.allowBareTypes) {
                                    this.$result.element = PossiblyBareType.bare(typeConstructor5, false);
                                    return;
                                }
                                this.$c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((JetElement)((PsiElement)type2), expectedArgumentCount));
                            } else {
                                this.$c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((JetElement)((PsiElement)type2.getTypeArgumentList()), expectedArgumentCount));
                            }
                            this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments("" + typeConstructor5, arguments4));
                        } else {
                            if (Intrinsics.areEqual(Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().asSingleFqName().toUnsafe(), DescriptorUtils.getFqName(classifierDescriptor)) && ((ClassDescriptor)classifierDescriptor).getTypeConstructor().getParameters().size() == 2) {
                                JetType jetType = arguments4.get(0).getType();
                                Intrinsics.checkExpressionValueIsNotNull(jetType, "arguments[0].getType()");
                                JetType jetType2 = arguments4.get(1).getType();
                                Intrinsics.checkExpressionValueIsNotNull(jetType2, "arguments[1].getType()");
                                this.$result.element = PossiblyBareType.type(DelegatingFlexibleType.Companion.create(jetType, jetType2, TypeResolver.access$getFlexibleTypeCapabilitiesProvider$5(this.this$0).getCapabilities()));
                                return;
                            }
                            JetTypeImpl resultingType = JetTypeImpl.Companion.create(this.$annotations, (ClassDescriptor)classifierDescriptor, false, arguments4);
                            this.$result.element = PossiblyBareType.type(resultingType);
                            if (this.$c.checkBounds) {
                                int n;
                                TypeSubstitutor substitutor2 = TypeSubstitutor.create(resultingType);
                                IntRange intRange = KotlinPackage.getIndices((Collection)parameters2);
                                int n2 = ((Number)intRange.getStart()).intValue();
                                if (n2 <= (n = ((Number)intRange.getEnd()).intValue())) {
                                    while (true) {
                                        void i;
                                        TypeParameterDescriptor parameter = parameters2.get((int)i);
                                        JetType argument = arguments4.get((int)i).getType();
                                        JetTypeReference typeReference = type2.getTypeArguments().get((int)i).getTypeReference();
                                        if (typeReference != null) {
                                            DescriptorResolver.checkBounds(typeReference, argument, parameter, substitutor2, this.$c.trace);
                                        }
                                        if (i == n) break;
                                        ++i;
                                    }
                                }
                            }
                        }
                    }
                }

                public void visitNullableType(@NotNull JetNullableType nullableType) {
                    Intrinsics.checkParameterIsNotNull(nullableType, "nullableType");
                    JetTypeElement innerType = nullableType.getInnerType();
                    PossiblyBareType baseType = TypeResolver.access$resolveTypeElement$6(this.this$0, this.$c, this.$annotations, innerType);
                    if (baseType.isNullable() || innerType instanceof JetNullableType || innerType instanceof JetDynamicType) {
                        this.$c.trace.report(Errors.REDUNDANT_NULLABLE.on((JetNullableType)((PsiElement)nullableType)));
                    } else if (this.$c.checkBounds && !baseType.isBare() && TypeUtils.hasNullableSuperType(baseType.getActualType())) {
                        this.$c.trace.report(Errors.BASE_WITH_NULLABLE_UPPER_BOUND.on((JetNullableType)((PsiElement)nullableType), baseType.getActualType()));
                    }
                    this.$result.element = baseType.makeNullable();
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitFunctionType(@NotNull JetFunctionType type2) {
                    JetType jetType;
                    void destination;
                    void $receiver;
                    void $receiver2;
                    JetType jetType2;
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    JetTypeReference receiverTypeRef = type2.getReceiverTypeReference();
                    if (receiverTypeRef == null) {
                        jetType2 = null;
                    } else {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        jetType2 = TypeResolver.access$resolveType$0(this.this$0, typeResolutionContext, receiverTypeRef);
                    }
                    JetType receiverType = jetType2;
                    Iterable iterable = type2.getParameters();
                    void var6_5 = $receiver2;
                    Collection collection = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
                    for (T item : $receiver) {
                        void it;
                        JetParameter jetParameter = (JetParameter)item;
                        void var11_10 = destination;
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        JetTypeReference jetTypeReference = it.getTypeReference();
                        if (jetTypeReference == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull(jetTypeReference, "it.getTypeReference()!!");
                        JetType jetType3 = TypeResolver.access$resolveType$0(this.this$0, typeResolutionContext, jetTypeReference);
                        var11_10.add(jetType3);
                    }
                    List parameterTypes = (List)destination;
                    JetTypeReference returnTypeRef = type2.getReturnTypeReference();
                    if (returnTypeRef != null) {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                        jetType = TypeResolver.access$resolveType$0(this.this$0, typeResolutionContext, returnTypeRef);
                    } else {
                        JetType jetType4 = TypeResolver.access$getModuleDescriptor$7(this.this$0).getBuiltIns().getUnitType();
                        jetType = jetType4;
                        Intrinsics.checkExpressionValueIsNotNull(jetType4, "moduleDescriptor.builtIns.getUnitType()");
                    }
                    JetType returnType2 = jetType;
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getModuleDescriptor$7(this.this$0).getBuiltIns().getFunctionType(this.$annotations, receiverType, parameterTypes, returnType2));
                }

                public void visitDynamicType(@NotNull JetDynamicType type2) {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    this.$result.element = PossiblyBareType.type(DynamicType.INSTANCE$);
                    if (!TypeResolver.access$getDynamicTypesSettings$8(this.this$0).getDynamicTypesAllowed()) {
                        this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Dynamic types are not supported in this context"));
                    }
                }

                public void visitSelfType(@NotNull JetSelfType type2) {
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(type2, "Self-types are not supported"));
                }

                public void visitJetElement(@NotNull JetElement element) {
                    Intrinsics.checkParameterIsNotNull(element, "element");
                    this.$c.trace.report(Errors.UNSUPPORTED.on(element, "Self-types are not supported yet"));
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    this.$annotations = $captured_local_variable$3;
                }
            });
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        if ((possiblyBareType = (PossiblyBareType)result2.element) == null) {
            Object object = typeElement;
            if (object == null || (object = DebugTextUtilKt.getDebugText((JetElement)object)) == null) {
                object = "No type element";
            }
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(ErrorUtils.createErrorType((String)object));
            possiblyBareType = possiblyBareType2;
            Intrinsics.checkExpressionValueIsNotNull(possiblyBareType2, "type(ErrorUtils.createEr\u2026() ?: \"No type element\"))");
        }
        return possiblyBareType;
    }

    private final JetScope getScopeForTypeParameter(TypeResolutionContext c, TypeParameterDescriptor typeParameterDescriptor) {
        if (c.checkBounds) {
            JetScope jetScope = typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
            Intrinsics.checkExpressionValueIsNotNull(jetScope, "typeParameterDescriptor.\u2026AsType().getMemberScope()");
            return jetScope;
        }
        return new LazyScopeAdapter(LockBasedStorageManager.NO_LOCKS.createLazyValue((Function0)new Function0<JetScope>(typeParameterDescriptor){
            final /* synthetic */ TypeParameterDescriptor $typeParameterDescriptor;

            @NotNull
            public final JetScope invoke() {
                return this.$typeParameterDescriptor.getUpperBoundsAsType().getMemberScope();
            }
            {
                this.$typeParameterDescriptor = typeParameterDescriptor;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjection> resolveTypeProjections(TypeResolutionContext c, TypeConstructor constructor, List<? extends JetTypeProjection> argumentElements) {
        void destination;
        void $receiver;
        void $receiver2;
        Iterable iterable = argumentElements;
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
        int index2 = 0;
        for (Object item : $receiver) {
            TypeProjection typeProjection;
            void i;
            void argumentElement;
            int n = index2++;
            JetTypeProjection jetTypeProjection = (JetTypeProjection)item;
            int n2 = n;
            void var16_16 = destination;
            JetProjectionKind projectionKind = argumentElement.getProjectionKind();
            JetModifierListOwner jetModifierListOwner = (JetModifierListOwner)argumentElement;
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
            ModifierCheckerCore.INSTANCE$.check(jetModifierListOwner, bindingTrace, null);
            if (Intrinsics.areEqual((Object)projectionKind, (Object)JetProjectionKind.STAR)) {
                List<TypeParameterDescriptor> parameters2 = constructor.getParameters();
                if (parameters2.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = parameters2.get((int)i);
                    TypeProjection typeProjection2 = TypeUtils.makeStarProjection(parameterDescriptor);
                    typeProjection = typeProjection2;
                    Intrinsics.checkExpressionValueIsNotNull(typeProjection2, "TypeUtils.makeStarProjection(parameterDescriptor)");
                } else {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*"));
                }
            } else {
                TypeResolutionContext typeResolutionContext = c.noBareTypes();
                Intrinsics.checkExpressionValueIsNotNull(typeResolutionContext, "c.noBareTypes()");
                JetTypeReference jetTypeReference = argumentElement.getTypeReference();
                if (jetTypeReference == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(jetTypeReference, "argumentElement.getTypeReference()!!");
                JetType type2 = this.resolveType(typeResolutionContext, jetTypeReference);
                JetProjectionKind jetProjectionKind = projectionKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)jetProjectionKind, "projectionKind");
                Variance kind = Companion.resolveProjectionKind(jetProjectionKind);
                if (constructor.getParameters().size() > i) {
                    TypeParameterDescriptor parameterDescriptor = constructor.getParameters().get((int)i);
                    if (Intrinsics.areEqual((Object)kind, (Object)Variance.INVARIANT) ^ true && Intrinsics.areEqual((Object)parameterDescriptor.getVariance(), (Object)Variance.INVARIANT) ^ true) {
                        if (Intrinsics.areEqual((Object)kind, (Object)parameterDescriptor.getVariance())) {
                            c.trace.report(Errors.REDUNDANT_PROJECTION.on((JetTypeProjection)((PsiElement)argumentElement), constructor.getDeclarationDescriptor()));
                        } else {
                            c.trace.report(Errors.CONFLICTING_PROJECTION.on((JetTypeProjection)((PsiElement)argumentElement), constructor.getDeclarationDescriptor()));
                        }
                    }
                }
                typeProjection = new TypeProjectionImpl(kind, type2);
            }
            TypeProjection typeProjection3 = typeProjection;
            var16_16.add(typeProjection3);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassifierDescriptor resolveClass(@NotNull LexicalScope scope2, @NotNull JetUserType userType, @NotNull BindingTrace trace) {
        Object v3;
        block6: {
            void $receiver;
            Intrinsics.checkParameterIsNotNull(scope2, "scope");
            Intrinsics.checkParameterIsNotNull(userType, "userType");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            if (userType.getQualifier() != null) {
                JetUserType jetUserType = userType.getQualifier();
                if (jetUserType == null) {
                    Intrinsics.throwNpe();
                }
                for (JetTypeProjection typeArgument : jetUserType.getTypeArguments()) {
                    JetType jetType;
                    if (typeArgument.getTypeReference() != null) {
                        void $receiver2;
                        JetTypeReference it;
                        JetTypeReference jetTypeReference = it = (JetTypeReference)$receiver2;
                        Intrinsics.checkExpressionValueIsNotNull(jetTypeReference, "it");
                        jetType = ForceResolveUtil.forceResolveAllContents(this.resolveType(scope2, jetTypeReference, trace, true));
                        continue;
                    }
                    jetType = null;
                }
            }
            Iterable iterable = this.qualifiedExpressionResolver.lookupDescriptorsForUserType(userType, ScopeUtilsKt.asJetScope(scope2), trace, true);
            for (Object element : $receiver) {
                if (!(element instanceof ClassifierDescriptor)) continue;
                v3 = element;
                break block6;
            }
            v3 = null;
        }
        ClassifierDescriptor classifierDescriptor = v3;
        if (classifierDescriptor != null) {
            PlatformTypesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(this.moduleDescriptor, trace, userType, classifierDescriptor);
        }
        return classifierDescriptor;
    }

    public TypeResolver(@NotNull AnnotationResolver annotationResolver, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider, @NotNull StorageManager storageManager, @NotNull TypeLazinessToken lazinessToken, @NotNull DynamicTypesSettings dynamicTypesSettings, @NotNull ModifiersChecker modifiersChecker) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(qualifiedExpressionResolver, "qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(flexibleTypeCapabilitiesProvider, "flexibleTypeCapabilitiesProvider");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(lazinessToken, "lazinessToken");
        Intrinsics.checkParameterIsNotNull(dynamicTypesSettings, "dynamicTypesSettings");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        this.annotationResolver = annotationResolver;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.flexibleTypeCapabilitiesProvider = flexibleTypeCapabilitiesProvider;
        this.storageManager = storageManager;
        this.lazinessToken = lazinessToken;
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.modifiersChecker = modifiersChecker;
    }

    @NotNull
    public static final /* synthetic */ StorageManager access$getStorageManager$1(TypeResolver $this) {
        return $this.storageManager;
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$doResolvePossiblyBareType$2(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull JetTypeReference typeReference) {
        return $this.doResolvePossiblyBareType(c, typeReference);
    }

    @NotNull
    public static final /* synthetic */ List<TypeProjection> access$resolveTypeProjections$3(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull TypeConstructor constructor, @NotNull List<? extends JetTypeProjection> argumentElements) {
        return $this.resolveTypeProjections(c, constructor, argumentElements);
    }

    @NotNull
    public static final /* synthetic */ JetScope access$getScopeForTypeParameter$4(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
        return $this.getScopeForTypeParameter(c, typeParameterDescriptor);
    }

    @NotNull
    public static final /* synthetic */ FlexibleTypeCapabilitiesProvider access$getFlexibleTypeCapabilitiesProvider$5(TypeResolver $this) {
        return $this.flexibleTypeCapabilitiesProvider;
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$resolveTypeElement$6(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @Nullable JetTypeElement typeElement) {
        return $this.resolveTypeElement(c, annotations2, typeElement);
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$7(TypeResolver $this) {
        return $this.moduleDescriptor;
    }

    @NotNull
    public static final /* synthetic */ DynamicTypesSettings access$getDynamicTypesSettings$8(TypeResolver $this) {
        return $this.dynamicTypesSettings;
    }

    @platformStatic
    @NotNull
    public static final Variance resolveProjectionKind(@NotNull JetProjectionKind projectionKind) {
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        return Companion.resolveProjectionKind(projectionKind);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0011\u0004)\u0001c\t\\3yS\ndW\rV=qK\u000e\u000b\u0007/\u00192jY&$\u0018.Z:Qe>4\u0018\u000eZ3s\u00151!\u0016\u0010]3SKN|GN^3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\bhKR\u001c\u0015\r]1cS2LG/[3t\u0015a1E.\u001a=jE2,G+\u001f9f\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u0006\u0006if\u0004Xm\u001d$\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0019A1\u0001E\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A!\u0001\u0005\u0006\u000b\r!A\u0001#\u0003\r\u0001\u0015\u0011A\u0001\u0002E\u0005\t-a)!G\u0002\u0006\u0003!\u001d\u0001tAW\u000b\t-AB!I\u0002\u0006\u0003!%\u0001\u0014B)\u0004\u0007\u0011!\u0011\"\u0001\u0005\u0006k1)1\u0002Br\u00011\u000f\t3!B\u0001\t\u0006a\u0015\u0011kA\u0002\u0005\b%\tA\u0001\u0001"})
    public static class FlexibleTypeCapabilitiesProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(FlexibleTypeCapabilitiesProvider.class);
        }

        @NotNull
        public FlexibleTypeCapabilities getCapabilities() {
            return FlexibleTypeCapabilities.NONE.INSTANCE$;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0010\u0004)I1i\\7qC:LwN\u001c\u0006\r)f\u0004XMU3t_24XM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*9!/Z:pYZ,'bA!os*)\"/Z:pYZ,\u0007K]8kK\u000e$\u0018n\u001c8LS:$'B\u00049s_*,7\r^5p].Kg\u000e\u001a\u0006\u0012\u0015\u0016$\bK]8kK\u000e$\u0018n\u001c8LS:$'b\u00019tS*Aa+\u0019:jC:\u001cWMC\u0003usB,7O\u0017\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0003\u0006\u0007\u0011!\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0004\u0006\u0007\u0011)\u00012\u0002\u0007\u0001\u000b\t!Q\u0001c\u0003\u0006\u0005\u0011!\u0001\u0012\u0002\u0003D\u00041\u0015\u0011dA\u0003\u0002\u0011\u000fA:!L\u000b\u0005\ba\u001dQt\u0002\u0003\u0001\u0011\u0011i1!B\u0001\t\na%\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e)AqA\u0005\u0002\u0011\u0019i\u0011\u0001#\u00046\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @platformStatic
        @NotNull
        public final Variance resolveProjectionKind(@NotNull JetProjectionKind projectionKind) {
            Variance variance;
            Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
            switch (TypeResolver$Companion$WhenMappings.$EnumSwitchMapping$0[projectionKind.ordinal()]) {
                case 1: {
                    variance = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Illegal projection kind:" + (Object)((Object)projectionKind));
                }
            }
            return variance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

