/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.Lists;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"p\u000e)Ar-\u001a;FM\u001a,7\r^5wK\u0016C\b/Z2uK\u0012$\u0016\u0010]3\u000b'A\f'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b1Y\u000bG.^3QCJ\fW.\u001a;fe\u0012+7o\u0019:jaR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015-!Wm]2sSB$xN]:\u000b\u0011\u0005\u0014x-^7f]RTQBV1mk\u0016\f%oZ;nK:$(b\u00019tS*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(BE\"bY2\u0014Vm]8mm\u0016\u0014X\u000b^5m\u0017RTQcZ3u\u000bJ\f7/\u001a3SK\u000e,\u0017N^3s)f\u0004XMC\u000esK\u000e,\u0017N^3s!\u0006\u0014\u0018-\\3uKJ$Um]2sSB$xN\u001d\u0006\u001c%\u0016\u001cW-\u001b<feB\u000b'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0015\u0011,7o\u0019:jaR|'O\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(bI4fiB\u000b'/Y7fi\u0016\u0014\u0018I]4v[\u0016tGo](g\u0007\u0006dG.\u00192mKRK\b/\u001a\u0006\u0005if\u0004XM\u0003\u0003MSN$(B\u0004+za\u0016\u0004&o\u001c6fGRLwN\u001c\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TAA[1wC*!Q\u000f^5m\u0015a9W\r\u001e*fiV\u0014h\u000eV=qK\u001a{'oQ1mY\u0006\u0014G.\u001a\u0006\b\u001d>$h*\u001e7m\u0015-\tgN\\8uCRLwN\\:\u000b-\u001d,GoU;qKJ\u001c\u0015\r\u001c7FqB\u0014Xm]:j_:TAaY1mY*!1)\u00197m\u0015IQU\r^*va\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8\u000b7!\f7/\u00168l]><hNR;oGRLwN\u001c)be\u0006lW\r^3s\u0015\u001d\u0011un\u001c7fC:TA\u0003[1t+:\\gn\\<o%\u0016$XO\u001d8UsB,'\"K5t\u0013:4xn[3DC2dwJ\\#yaJ,7o]5p]^KG\u000f\u001b\"pi\"\u0014VmY3jm\u0016\u00148O\u0003\fjg&sgo\\6f\u0007\u0006dGn\u00148WCJL\u0017M\u00197f\u0015aI7o\u0014:Pm\u0016\u0014(/\u001b3fgNKh\u000e\u001e5fg&TX\r\u001a\u0006\u0019\u0007\u0006dG.\u00192mK6+WNY3s\t\u0016\u001c8M]5qi>\u0014(B\u0007:fa2\f7-\u001a*fiV\u0014h\u000eV=qK\nKXK\\6o_^t'\u0002\u0006:fa2\f7-\u001a+za\u0016\f%oZ;nK:$8O\u0003\u0007oK^\f%oZ;nK:$8OC\u0006KKR$\u0016\u0010]3J[Bd'\"\u00065bg&sg-\u001a:sK\u0012\u0014V\r^;s]RK\b/\u001a\u0006\u0011G>t7\u000f\u001e:bS:$8+_:uK6T\u0001cQ8ogR\u0014\u0018-\u001b8u'f\u001cH/Z7\u000b\u000fI,7o\u001c7wK*)1-\u00197mg*I\u0011N\u001c4fe\u0016t7-\u001a\u0006)Q\u0006\u001c(+\u001a;ve:$\u0016\u0010]3EKB,g\u000eZ3oi>sWK\\5oM\u0016\u0014(/\u001a3QCJ\fWn\u001d~\u0002\u0015\t\u00012A\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\u0002!\u0015QA\u0001\u0003\u0002\u0011\r)1\u0001b\u0001\t\u00031\u0001QA\u0001\u0003\u0002\u0011\u0013)1\u0001\"\u0002\t\t1\u0001QA\u0001\u0003\u0002\u0011\u0017)1\u0001b\u0002\t\u000b1\u0001QA\u0001C\u0004\u0011\u0015)!\u0001b\u0001\t\u0003\u0015\u0011AQ\u0001\u0005\u0005\u000b\r!\u0019\u0001c\u0004\r\u0001\u0015\u0019A1\u0001E\t\u0019\u0001)!\u0001b\u0001\t\u0010\u0015\u0011A1\u0001E\t\u000b\u0005A)!B\u0002\u0005\u0011!QA\u0002A\u0003\u0004\t\u000fA)\u0002\u0004\u0001\u0006\u0003!]QA\u0001C\n\u00111)!\u0001\u0002\u0006\t\u0015\u0015\u0011A\u0011\u0001E\u000e\u000b\r!1\u0002C\u0007\r\u0001\u0015\u0019AQ\u0001\u0005\u0010\u0019\u0001)1\u0001\"\u0002\t 1\u0001QA\u0001C\u0003\u0011?)!\u0001\"\u0002\t\u001f\u0015\u0019A\u0001\u0003E\u0011\u0019\u0001)1\u0001b\u0001\t'1\u0001QA\u0001C\u0002\u0011M)1\u0001b\u0002\t+1\u0001QA\u0001C\u0004\u0011U)!\u0001B\u0001\t/\u0015\u0011A\u0011\u0005E\u0018\u000b\t!\u0011\u0003\u0003\r\u0006\u0007\u0011\r\u0002R\u0006\u0007\u0001\u000b\t!\u0019\u0003#\f\u0006C\u0011\u0019\u0001\u0004AO\b\t\u0001A\t!D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0001u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\t!I\u0002\u0006\u0003!!\u0001\u0004B)\u0004\u000f\u0011\u0001\u0011\"\u0001E\u0005\u001b\u0005AQ!D\u0001\t\fa\u001ba!B\u0011\u0005\u0007a5Qt\u0002\u0003\u0001\u0011\u001di1!B\u0001\t\ra1\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0003\t3!B\u0001\t\ta!\u0011kA\u0004\u0005\u000e%\t\u0001\u0012B\u0007\u0002\u0011\u001di\u0011\u0001c\u0004Y\u0007\u0019)\u0019\u0005B\u0001\u0019\u0013u=A\u0001\u0001E\n\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!\t\b\u0006\u0003!E\u0011BC\u0005\n\u000b\u0005A\u0011\u0002E\u0006\u0016\t\u0015\t\u0001\"\u0003G\u00011%A\u0012\u0002'\u0005R\u0007\u0015!\u0011\"C\u0001\t\u00165\t\u0001\u0012\u0002-\u0004\r\u0015IB!\u0001M\r;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001\u00115B\u0003\u0002\u0011\u0011AB!U\u0002\u0002\t/\t6!\u0002C\r\u0013\u0005AI!D\u0001\t\na\u001ba!b\f\u0005\u0007aqQt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u0019aa\u0001k\u0001\u0001\"\t\u0015\t\u0001\u0012\u0004G\u000113\t6!\u0002\u0003\u000f\u0013\u0005AQ\"D\u0001\t\u001ca\u001ba!\"\f\u0005\u0007a\u0001Rt\u0002\u0003\u0001\u0011'i1!B\u0001\t\ta!\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0004\r\u000f#\u000e)A\u0001E\u0005\u0002\t\u0003i\u0011\u0001#\u0003Y\u0007\u0019)i\u0003B\u0002\u0019#u=A\u0001\u0001E\n\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!I\u0002\u0006\u0003!q\u0001DD)\u0004\u000b\u0011\t\u0012\"\u0001C\u0001\u001b\u0005AI\u0001W\u0002\u0007\u000b[!1\u0001g\t\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005AA\u0002\u0007\u0007Q\u0007\u0001\t3!B\u0001\t\u001daq\u0011kA\u0003\u0005$%\tA\u0011A\u0007\u0002\u00117A6ABC\u0017\t\rA\"#h\u0004\u0005\u0001!uQbA\u0003\u0002\u00111AB\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\b\u0019\u001dE\u001bQ\u0001\u0002\n\n\u0003\u0011\u0005Q\"\u0001E\u000e1\u000e1QQ\u0006\u0003\u00041Kiz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001E\u000f1;\u00016\u0001A\u0011\u0004\u000b\u0005Aa\u0002\u0007\bR\u0007\u0015!)#C\u0001\u0005\u00025\t\u0001b\u0004-\u0004\r\u00155Ba\u0001M\u0014;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0011AB!U\u0002\u0006\tOI\u0011\u0001#\u0003\u000e\u0003!%\u0001l\u0001\u0004\u0006M\u0011\t\u0001\u0004FO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001ueA\u0001\u0001E\u0015\u001b!)\u0011\u0001#\u0005\n\t%\u0019Q!\u0001\u0005\n1%A\n\u0002UB\u0001C\r)\u0011\u0001c\b\u0019 E\u001bq\u0001\u0002\u000b\n\u0003!\u0001R\"\u0001E\u0005\u001b\u0005A)\u0002W\u0002\u0007\u000bs!1!F\u0002\u0006\u0003!5\u0001T\u0002M\u0016;\u001f!\u0001\u0001\u0003\f\u000e\u0007\u0015\t\u0001B\u0005\r\u0013!\u000e\u0005\u0011eA\u0003\u0002\u00119Ab\"U\u0002\b\tWI\u0011\u0001\"\u0001\u000e\u0003!=Q\"\u0001E\u00131\u000e1Q\u0011\b\u0003\u0002+\r)\u0011\u0001#\u0004\u0019\u000eaERt\u0002\u0003\u0001\u0011Yi1!B\u0001\t%a\u0011\u0002k!\u0001\"\u0007\u0015\t\u0001B\u0004\r\u000f#\u000e9A\u0011G\u0005\u0002\t\u0003i\u0011\u0001c\u0004\u000e\u0003!\u0015\u0002l\u0001\u0004"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull JetType type2) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean value = ReflectionTypes.Companion.isCallableType(type2);
            if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
                String message = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            Iterable $receiver = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            for (Object element : $receiver) {
                TypeProjection it = (TypeProjection)element;
                if (!(TypeUtils.containsSpecialType(it.getType(), TypeUtils.DONT_CARE) || ErrorUtils.containsUninferredParameter(it.getType()))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean value = ReflectionTypes.Companion.isCallableType(type2);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final JetType replaceReturnTypeByUnknown(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean value = ReflectionTypes.Companion.isCallableType(type2);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ArrayList<TypeProjectionImpl> newArguments = Lists.newArrayList();
        newArguments.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, TypeUtils.DONT_CARE));
        List list = newArguments;
        Intrinsics.checkExpressionValueIsNotNull(list, "newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, list);
    }

    @NotNull
    public static final JetTypeImpl replaceTypeArguments(@NotNull JetType type2, @NotNull List<? extends TypeProjection> newArguments) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(newArguments, "newArguments");
        Annotations annotations2 = type2.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "type.getAnnotations()");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.getConstructor()");
        boolean bl = type2.isMarkedNullable();
        JetScope jetScope = type2.getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "type.getMemberScope()");
        return JetTypeImpl.Companion.create(annotations2, typeConstructor2, bl, newArguments, jetScope);
    }

    @NotNull
    public static final List<TypeProjection> getParameterArgumentsOfCallableType(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return KotlinPackage.dropLast(type2.getArguments(), 1);
    }

    @NotNull
    public static final JetType getReturnTypeForCallable(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return KotlinPackage.last(type2.getArguments()).getType();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean hasReturnTypeDependentOnUninferredParams(CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        boolean bl;
        block3: {
            void $receiver2;
            Iterable receiver;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
            JetType jetType = $receiver.getReturnType();
            if (jetType == null) {
                return false;
            }
            JetType returnType2 = jetType;
            ConstraintSystem constraintSystem2 = constraintSystem;
            if (constraintSystem2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
            }
            ConstraintSystemImpl constraintSystemImpl = (ConstraintSystemImpl)constraintSystem2;
            ConstraintSystemImpl $receiver3 = (ConstraintSystemImpl)((Object)receiver);
            List nestedTypeVariables = ConstraintSystemImpl.getNestedTypeVariables$default($receiver3, returnType2, false, 1);
            receiver = nestedTypeVariables;
            for (Object element : $receiver2) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element;
                if (!(((ConstraintSystemImpl)constraintSystem).getTypeBounds(it).getValue() == null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($receiver, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    @NotNull
    public static final JetType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(receiverParameterDescriptor, "receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        JetType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor.getTypeParameters()) {
            if (!Intrinsics.areEqual(typeParameter.getTypeConstructor(), receiverType.getConstructor())) continue;
            receiverType = typeParameter.getUpperBoundsAsType();
        }
        List fakeTypeArguments = ContainerUtil.newSmartList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        Annotations annotations2 = receiverType.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "receiverType.getAnnotations()");
        TypeConstructor typeConstructor2 = receiverType.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "receiverType.getConstructor()");
        boolean bl = receiverType.isMarkedNullable();
        List list = fakeTypeArguments;
        Intrinsics.checkExpressionValueIsNotNull(list, "fakeTypeArguments");
        JetScope jetScope = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return JetTypeImpl.Companion.create(annotations2, typeConstructor2, bl, list, jetScope);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            boolean bl;
            block3: {
                Iterable $receiver = descriptor.getOverriddenDescriptors();
                for (Object element : $receiver) {
                    CallableMemberDescriptor it;
                    CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element;
                    Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                    if (CallResolverUtilKt.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        JetExpression expression = ((ExpressionReceiver)receiverValue).getExpression();
        return expression instanceof JetSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver().exists() && call.getDispatchReceiver().exists();
    }

    @Nullable
    public static final JetSuperExpression getSuperCallExpression(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        ReceiverValue receiverValue = call.getExplicitReceiver();
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
        JetExpression jetExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(jetExpression instanceof JetSuperExpression)) {
            jetExpression = null;
        }
        return (JetSuperExpression)jetExpression;
    }

    @NotNull
    public static final JetType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                JetType jetType = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull(jetType, "DONT_CARE");
                return jetType;
            }
            JetType jetType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "parameterDescriptor.getType()");
            return jetType;
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            return varargElementType;
        }
        JetType jetType = parameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType, "parameterDescriptor.getType()");
        return jetType;
    }
}

