/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.lang.ref.WeakReference;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.InlineChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"[\u0006)!\u0012J\u001c7j]\u0016\u001c\u0005.Z2lKJ<&/\u00199qKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0015\u0019\u0017\r\u001c7t\u0015!\u0019\u0007.Z2lKJ\u001c(bC\"bY2\u001c\u0005.Z2lKJTa\u0001P5oSRt$\"D2iK\u000e\\WM]:DC\u000eDWMC\u0007XK\u0006\\'+\u001a4fe\u0016t7-\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'b\u0001:fM*QQ*\u001e;bE2,W*\u00199\u000b+\u0011+7\r\\1sCRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015\u00051%BE\"bY2\f'\r\\3EKN\u001c'/\u001b9u_JTQa\u00195fG.TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQ!\\8eK2TqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u0003V]&$(BC4fi\u000eCWmY6fe*QA-Z:de&\u0004Ho\u001c:\u000b1MKW\u000e\u001d7f\rVt7\r^5p]\u0012+7o\u0019:jaR|'On\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\t\u00012B\u0003\u0003\t\u0011Aa!\u0002\u0002\u0005\n!5Qa\u0001\u0003\u0006\u0011\u0015a\u0001!B\u0001\t\u0004\u0015\u0019AA\u0002\u0005\b\u0019\u0001)!\u0001B\u0001\t\u0011\u0015\u0019Aa\u0002E\b\u0019\u0001)!\u0001B\u0003\t\u000b\u0015\u0019Aa\u0002\u0005\n\u0019\u0001)!\u0001\u0002\u0002\t\u0017\u0015\u0019A!\u0003E\u000b\u0019\u0001)!\u0001\u0002\u0002\t\u0018\u0015\u0019AA\u0003\u0005\r\u0019\u0001)1\u0001\u0002\u0004\t\u001a1\u0001QA\u0001\u0003\n\u0011+)!\u0001\u0002\u0006\t\u0019\u0015\u0019Aa\u0002\u0005\u000f\u0019\u0001)!\u0001\"\u0002\t\b\u0015\u0011Aa\u0002\u0005\u000f\t\ra1!G\u0002\u0006\u0003!\u001d\u0001tA\u0017\u001d\t\u0005g\u0001\u0014B\u0011\u0014\u000b\u0005AY!\u0003\b\n\u001b\u0015\t\u0001RB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\u0019\u0010%!\u0011bA\u0003\u0002\u0011\u000fA:\u0001'\u0004\r\u0002a-Qk\u0001\u0003\u0006\u0007\u0011%\u0011\"\u0001\u0005\t[3\"1\"\u0005\u0004\u0005\u0001!EQcA\u0003\u0002\u0011#A\n\u0002g\u0005\u001e\u001c\u0011\u0001\u0001BC\u0007\n\u000b\u0005A\u0019\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\u001a\u0002U\u0002\u0001;\u001f!\u0001\u0001c\u0006\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\u0005\u0011eA\u0003\u0002\u0011-A2\"U\u0002\b\t'I\u0011\u0001\u0002\u0001\u000e\u0003!]Q\"\u0001\u0005\r[U!\u0011\u0001G\u0007\u001e\u0010\u0011\u0001\u00012D\u0007\u0004\u000b\u0005AI\u0002'\u0007Q\u0007\u0001\t3!B\u0001\t\ba\u001d\u0011kA\u0003\u0005\u001b%\t\u0001\"D\u0007\u0002\u00117)D\"B\u0006\u0005G\u0004AB!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u0007\u0011!\u0011\"\u0001\u0003\u0001"})
public final class InlineCheckerWrapper
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private WeakReference<Map<DeclarationDescriptor, CallChecker>> checkersCache;

    static {
        $kotlinClass = Reflection.createKotlinClass(InlineCheckerWrapper.class);
    }

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (context.isAnnotationContext) {
            return;
        }
        for (DeclarationDescriptor parentDescriptor = context.scope.getOwnerDescriptor(); parentDescriptor != null; parentDescriptor = parentDescriptor.getContainingDeclaration()) {
            if (!InlineUtil.isInline(parentDescriptor)) continue;
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            CallChecker checker = this.getChecker((SimpleFunctionDescriptor)declarationDescriptor);
            checker.check(resolvedCall, context);
        }
    }

    private final CallChecker getChecker(SimpleFunctionDescriptor descriptor) {
        Object object;
        WeakReference<Object> weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> map2;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference2 = this.checkersCache;
        if (weakReference2 == null || (weakReference2 = (Map)weakReference2.get()) == null) {
            weakReference2 = map2 = (Map)KotlinPackage.hashMapOf(new Pair[0]);
        }
        if ((weakReference = this.checkersCache) == null) {
            weakReference = new WeakReference<Object>(map2);
        }
        this.checkersCache = weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> $receiver = map2;
        Object value = $receiver.get(descriptor);
        if (value == null && !$receiver.containsKey(descriptor)) {
            InlineChecker answer = new InlineChecker(descriptor);
            $receiver.put(descriptor, answer);
            object = answer;
        } else {
            object = value;
        }
        return (CallChecker)object;
    }
}

