/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFunctionType;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetProjectionKind;
import org.jetbrains.kotlin.psi.JetSelfType;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.jvm.JvmPackage;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

public class TypeTransformingVisitor
extends JetVisitor<JetType, Void> {
    private static boolean strictMode = false;
    private final JetType originalType;
    private final Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters;
    private final TypeUsage typeUsage;

    private TypeTransformingVisitor(JetType originalType, Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, TypeUsage typeUsage) {
        this.originalType = originalType;
        this.typeUsage = typeUsage;
        this.originalToAltTypeParameters = Collections.unmodifiableMap(originalToAltTypeParameters);
    }

    @NotNull
    public static JetType computeType(@NotNull JetTypeElement alternativeTypeElement, @NotNull JetType originalType, @NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, @NotNull TypeUsage typeUsage) {
        if (alternativeTypeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alternativeTypeElement", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (originalToAltTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToAltTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (typeUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeUsage", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        JetType computedType = alternativeTypeElement.accept(new TypeTransformingVisitor(originalType, originalToAltTypeParameters, typeUsage), null);
        assert (computedType != null);
        JetType jetType = computedType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        return jetType;
    }

    @Override
    public JetType visitNullableType(@NotNull JetNullableType nullableType, Void aVoid) {
        if (nullableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullableType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitNullableType"));
        }
        if (!TypeUtils.isNullableType(this.originalType) && this.typeUsage != TypeUsage.TYPE_ARGUMENT) {
            throw new AlternativeSignatureMismatchException("Auto type '%s' is not-null, while type in alternative signature is nullable: '%s'", DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(this.originalType), nullableType.getText());
        }
        JetTypeElement innerType = nullableType.getInnerType();
        assert (innerType != null) : "Syntax error: " + nullableType.getText();
        return TypeUtils.makeNullable(TypeTransformingVisitor.computeType(innerType, this.originalType, this.originalToAltTypeParameters, this.typeUsage));
    }

    @Override
    public JetType visitFunctionType(@NotNull JetFunctionType type2, Void data2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitFunctionType"));
        }
        return this.visitCommonType(type2.getReceiverTypeReference() == null ? KotlinBuiltIns.getInstance().getFunction(type2.getParameters().size()) : KotlinBuiltIns.getInstance().getExtensionFunction(type2.getParameters().size()), (JetTypeElement)type2);
    }

    @Override
    public JetType visitUserType(@NotNull JetUserType type2, Void data2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitUserType"));
        }
        JetUserType qualifier = type2.getQualifier();
        String shortName = type2.getReferenceExpression().getReferencedName();
        String longName = (qualifier == null ? "" : qualifier.getText() + ".") + shortName;
        return this.visitCommonType(longName, (JetTypeElement)type2);
    }

    private JetType visitCommonType(@NotNull ClassDescriptor classDescriptor, @NotNull JetTypeElement type2) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        return this.visitCommonType(DescriptorUtils.getFqNameSafe(classDescriptor).asString(), type2);
    }

    @NotNull
    private JetType visitCommonType(@NotNull String qualifiedName, @NotNull JetTypeElement type2) {
        JetScope memberScope2;
        List<TypeProjection> arguments2;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (this.originalType.isError()) {
            JetType jetType = this.originalType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
            }
            return jetType;
        }
        TypeConstructor originalTypeConstructor = this.originalType.getConstructor();
        ClassifierDescriptor declarationDescriptor = originalTypeConstructor.getDeclarationDescriptor();
        assert (declarationDescriptor != null);
        FqNameUnsafe originalClassFqName = DescriptorUtils.getFqName(declarationDescriptor);
        ClassDescriptor classFromLibrary = TypeTransformingVisitor.getAutoTypeAnalogWithinBuiltins(originalClassFqName, qualifiedName);
        if (!TypeTransformingVisitor.isSameName(qualifiedName, originalClassFqName.asString()) && classFromLibrary == null) {
            throw new AlternativeSignatureMismatchException("Alternative signature type mismatch, expected: %s, actual: %s", qualifiedName, originalClassFqName);
        }
        TypeConstructor typeConstructor2 = classFromLibrary != null ? classFromLibrary.getTypeConstructor() : originalTypeConstructor;
        ClassifierDescriptor typeConstructorClassifier = typeConstructor2.getDeclarationDescriptor();
        if (typeConstructorClassifier instanceof TypeParameterDescriptor && this.originalToAltTypeParameters.containsKey(typeConstructorClassifier)) {
            typeConstructor2 = this.originalToAltTypeParameters.get(typeConstructorClassifier).getTypeConstructor();
        }
        if ((arguments2 = this.originalType.getArguments()).size() != type2.getTypeArgumentsAsTypes().size()) {
            if (JvmPackage.getPLATFORM_TYPES()) {
                JetType jetType = this.originalType;
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
                }
                return jetType;
            }
            throw new AlternativeSignatureMismatchException("'%s' type in method signature has %d type arguments, while '%s' in alternative signature has %d of them", DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(this.originalType), arguments2.size(), type2.getText(), type2.getTypeArgumentsAsTypes().size());
        }
        ArrayList<TypeProjection> altArguments = new ArrayList<TypeProjection>();
        int size = arguments2.size();
        for (int i = 0; i < size; ++i) {
            altArguments.add(this.getAltArgument(type2, typeConstructor2, i, arguments2.get(i)));
        }
        if (typeConstructorClassifier instanceof TypeParameterDescriptor) {
            memberScope2 = ((TypeParameterDescriptor)typeConstructorClassifier).getUpperBoundsAsType().getMemberScope();
        } else if (typeConstructorClassifier instanceof ClassDescriptor) {
            memberScope2 = ((ClassDescriptor)typeConstructorClassifier).getMemberScope(altArguments);
        } else {
            throw new AssertionError((Object)("Unexpected class of type constructor classifier " + (typeConstructorClassifier == null ? "null" : typeConstructorClassifier.getClass().getName())));
        }
        JetTypeImpl jetTypeImpl = JetTypeImpl.create(this.originalType.getAnnotations(), typeConstructor2, false, altArguments, memberScope2);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        return jetTypeImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private TypeProjection getAltArgument(@NotNull JetTypeElement type2, @NotNull TypeConstructor typeConstructor2, int i, @NotNull TypeProjection originalArgument) {
        Variance altProjectionKind;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        if (originalArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalArgument", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        JetTypeReference typeReference = type2.getTypeArgumentsAsTypes().get(i);
        if (typeReference == null) {
            assert (type2 instanceof JetUserType && ((JetUserType)type2).getTypeArguments().get(i).getProjectionKind() == JetProjectionKind.STAR);
            TypeProjection typeProjection = originalArgument;
            if (typeProjection != null) return typeProjection;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        JetTypeElement argumentAlternativeTypeElement = typeReference.getTypeElement();
        assert (argumentAlternativeTypeElement != null);
        TypeParameterDescriptor parameter = typeConstructor2.getParameters().get(i);
        JetType alternativeArgumentType = TypeTransformingVisitor.computeType(argumentAlternativeTypeElement, originalArgument.getType(), this.originalToAltTypeParameters, TypeUsage.TYPE_ARGUMENT);
        Variance projectionKind = originalArgument.getProjectionKind();
        if (type2 instanceof JetUserType) {
            JetTypeProjection typeProjection = ((JetUserType)type2).getTypeArguments().get(i);
            altProjectionKind = TypeResolver.resolveProjectionKind(typeProjection.getProjectionKind());
            if (altProjectionKind != projectionKind && projectionKind != Variance.INVARIANT && !JvmPackage.getPLATFORM_TYPES()) {
                throw new AlternativeSignatureMismatchException("Projection kind mismatch, actual: %s, in alternative signature: %s", new Object[]{projectionKind, altProjectionKind});
            }
            if (altProjectionKind != Variance.INVARIANT && parameter.getVariance() != Variance.INVARIANT) {
                if (altProjectionKind != parameter.getVariance()) throw new AlternativeSignatureMismatchException("Projection kind '%s' is conflicting with variance of %s", new Object[]{altProjectionKind, DescriptorUtils.getFqName(typeConstructor2.getDeclarationDescriptor())});
                if (strictMode) {
                    throw new AlternativeSignatureMismatchException("Projection kind '%s' is redundant", new Object[]{altProjectionKind, DescriptorUtils.getFqName(typeConstructor2.getDeclarationDescriptor())});
                }
                altProjectionKind = projectionKind;
            }
        } else {
            altProjectionKind = projectionKind;
        }
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(altProjectionKind, alternativeArgumentType);
        if (typeProjectionImpl != null) return typeProjectionImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
    }

    @Nullable
    private static ClassDescriptor getAutoTypeAnalogWithinBuiltins(@NotNull FqNameUnsafe originalClassFqName, @NotNull String qualifiedName) {
        if (originalClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalClassFqName", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAutoTypeAnalogWithinBuiltins"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAutoTypeAnalogWithinBuiltins"));
        }
        ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(originalClassFqName);
        if (javaClassId == null) {
            return null;
        }
        Collection<ClassDescriptor> descriptors = JavaToKotlinClassMap.INSTANCE.mapPlatformClass(javaClassId.asSingleFqName());
        for (ClassDescriptor descriptor : descriptors) {
            String fqName2 = DescriptorUtils.getFqName(descriptor).asString();
            if (!TypeTransformingVisitor.isSameName(qualifiedName, fqName2)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public JetType visitSelfType(@NotNull JetSelfType type2, Void data2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitSelfType"));
        }
        throw new UnsupportedOperationException("Self-types are not supported yet");
    }

    private static boolean isSameName(String qualifiedName, String fullyQualifiedName) {
        return fullyQualifiedName.equals(qualifiedName) || fullyQualifiedName.endsWith("." + qualifiedName);
    }

    public static void setStrictMode(boolean strictMode) {
        TypeTransformingVisitor.strictMode = strictMode;
    }
}

