/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\b\b)A\"J^7OC6,\u0017I\u001c8pi\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TqA]3t_24XMC\u0002km6T\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0013\t\u0016\u001cG.\u0019:bi&|gn\u00115fG.,'O\u0003\u0004=S:LGO\u0010\u0006\u0006G\",7m\u001b\u0006\fI\u0016\u001cG.\u0019:bi&|gN\u0003\bKKR$Um\u00197be\u0006$\u0018n\u001c8\u000b\u0007A\u001c\u0018N\u0003\u0006eKN\u001c'/\u001b9u_JTQ\u0003R3dY\u0006\u0014\u0018\r^5p]\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(\u0002\u00053jC\u001etwn\u001d;jG\"{G\u000eZ3s\u00159!\u0015.Y4o_N$\u0018nY*j].T1\u0002Z5bO:|7\u000f^5dg*q!-\u001b8eS:<7i\u001c8uKb$(B\u0004\"j]\u0012LgnZ\"p]R,\u0007\u0010\u001e\u0006\u0005+:LGO\u0003\tdQ\u0016\u001c7\u000eR3dY\u0006\u0014\u0018\r^5p]*Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b)\u0005sgn\u001c;bi&|g\u000eR3tGJL\u0007\u000f^8s\u0015-\tgN\\8uCRLwN\\:\u000b'%\u001c(+\u001a8b[\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8\u000b%\u0019+hn\u0019;j_:$Um]2sSB$xN\u001d\u0006\b\u0005>|G.Z1oe\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Qa\u0001C\u0002\u0011\u000fa\u0001!\u0002\u0002\u0005\u0003!1Qa\u0001\u0003\u0005\u0011\u0017a\u0001!\u0002\u0002\u0005\u0003!=Qa\u0001\u0003\u0006\u0011\u001da\u0001!\u0002\u0002\u0005\u0003!IQa\u0001\u0003\u0007\u0011#a\u0001!B\u0002\u0005\u0004!QA\u0002A\u0003\u0002\u0011\u0007)1\u0001b\u0004\t\u00161\u0001QA\u0001\u0003\u0005\u0011\u0017)!\u0001B\u0003\t\u000f\u0015\u0011AA\u0002E\t\u000b\t!\u0019\u0001\u0003\u0006\u0006\u0005\u0011)\u0001\u0012D\u0003\u0004\t+AA\u0002\u0004\u0001\u0006\u0005\u0011U\u0001\u0002D\u0003\u0004\t\u0015AY\u0002\u0004\u0001\u0006\u0007\u0011=\u0001B\u0004\u0007\u0001\u000b\t!Q\u0001c\u0007\u0005\u00071\u0019\u0011dA\u0003\u0002\u0011\u000fA:!,\u001b\u0005\u0017a%Qt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\na%\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001E\u00071\u001b\u00016!AO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0004\u0005\u001aQ!\u0001\u0005\t1!\t6a\u0003C\u0005\u0013\u0005!\u0001!D\u0001\t\u00125\t\u0001\"C\u0007\u0002\u0011'i\u0011\u0001\u0003\u0006.U\u0011\t\u0001dCO\b\t\u0001Ai!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0001u=A\u0001\u0001E\f\u001b\r)\u0011\u0001C\u0006\u0019\u0017A\u001b\t!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0002C\r)\u0011\u0001\u0003\u0005\u0019\u0011E\u001b\u0011\u0002B\u0006\n\u0003\u0011\u0001Q\"\u0001\u0005\n\u001b\u0005A9\"D\u0001\t\u00145*B!\u0001\r\u000e;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0001\u0011eA\u0003\u0002\u00113AJ\"U\u0002\u0006\t5I\u0011\u0001\"\u0001\u000e\u0003!iQ\u0007D\u0003\f\t\r\b\u0001\u0004B\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\r!A!C\u0001\u0005\u0001\u0001"})
public final class JvmNameAnnotationChecker
implements DeclarationChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JvmNameAnnotationChecker.class);
    }

    @Override
    public void check(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        AnnotationDescriptor platformNameAnnotation = DescriptorUtils.getJvmNameAnnotation(descriptor);
        if (platformNameAnnotation != null) {
            this.checkDeclaration(descriptor, platformNameAnnotation, diagnosticHolder);
        }
    }

    private final void checkDeclaration(DeclarationDescriptor descriptor, AnnotationDescriptor annotation2, DiagnosticSink diagnosticHolder) {
        DeclarationDescriptor callableMemberDescriptor;
        String value;
        JetAnnotationEntry jetAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
        if (jetAnnotationEntry == null) {
            return;
        }
        JetAnnotationEntry annotationEntry = jetAnnotationEntry;
        if (descriptor instanceof FunctionDescriptor && !this.isRenamableFunction((FunctionDescriptor)descriptor)) {
            diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
        }
        if ((value = DescriptorUtils.getJvmName(descriptor)) == null || !Name.isValidIdentifier(value)) {
            diagnosticHolder.report(ErrorsJvm.ILLEGAL_JVM_NAME.on((JetAnnotationEntry)((PsiElement)annotationEntry)));
        }
        if (descriptor instanceof CallableMemberDescriptor && (DescriptorUtils.isOverride((CallableMemberDescriptor)(callableMemberDescriptor = descriptor)) || ((CallableMemberDescriptor)callableMemberDescriptor).getModality().isOverridable())) {
            diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
        }
    }

    private final boolean isRenamableFunction(FunctionDescriptor descriptor) {
        DeclarationDescriptor containingDescriptor = descriptor.getContainingDeclaration();
        return containingDescriptor instanceof PackageFragmentDescriptor || containingDescriptor instanceof ClassDescriptor;
    }
}

