/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DecapitalizedAnnotationScopeKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\r\u000e)IB)\u001a9sK\u000e\fG/\u001a3Ts6\u0014w\u000e\u001c,bY&$\u0017\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u000bm\u0006d\u0017\u000eZ1uS>t'\u0002F*z[\n|G.V:bO\u00164\u0016\r\\5eCR|'O\u0003\u0004=S:LGO\u0010\u0006\u0010\u0015\u00063\u0016i\u0018#F!J+5)\u0011+F\t*1a)\u001d(b[\u0016TAA\\1nK*9\u0002KU(Q\u000bJ#\u0016lX*F)~{\u0005+\u0012*B)&{ej\u0015\u0006\t)>\\WM\\*fi*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1\u0001]:j\u0015\u0011!(/Z3\u000b\u000f9{GOT;mY*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015q\u0019\u0007.Z2l\t\u0016\u001c\u0017\r]5uC2L'0\u001a3B]:|G/\u0019;j_:Tq!\u001a7f[\u0016tGO\u0003\u0006Qg&,E.Z7f]RT\u0001\u0003^1sO\u0016$H)Z:de&\u0004Ho\u001c:\u000b+\u0011+7\r\\1sCRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015\u0015!(/Y2f\u00151\u0011\u0015N\u001c3j]\u001e$&/Y2f\u0015\u0011)f.\u001b;\u000b7\r\u0014X-\u0019;f\t\u0016\u0004(/Z2bi&|g\u000eR5bO:|7\u000f^5d\u0015)!Wm]2sSB$xN\u001d\u0006\u000bI\u0016\u0004(/Z2bi\u0016$'\u0002F!o]>$\u0018\r^5p]\u0012+7o\u0019:jaR|'O\u0003\u0006ES\u0006<gn\\:uS\u000eT1\u0002Z5bO:|7\u000f^5dg*A\u0002O]8qKJ$\u0018pR3ui\u0016\u0014xk\u001c:lCJ|WO\u001c3\u000b%A\u0014x\u000e]3sif$Um]2sSB$xN\u001d\u0006\u0013!J|\u0007/\u001a:us\u0012+7o\u0019:jaR|'O\u0003\u0006fqB\u0014Xm]:j_:T\u0001#\u001e8xe\u0006\u00048+[7qY\u0016t\u0015-\\3\u000b/)+GoU5na2,g*Y7f\u000bb\u0004(/Z:tS>t'\u0002\u0004<bY&$\u0017\r^3DC2d'BE\"bY2\f'\r\\3EKN\u001c'/\u001b9u_JT\u0011C^1mS\u0012\fG/\u001a+za\u0016,6/Y4f\u0015Q\u0019E.Y:tS\u001aLWM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*yr-\u001a;EK\u000ed\u0017M]3e\t\u0016\u0004(/Z2bi\u0016$\u0017I\u001c8pi\u0006$\u0018n\u001c8\u000b\rQ\f'oZ3u\u0015]\teN\\8uCRLwN\\+tKNKG/\u001a+be\u001e,GO\u0003\u000fgS:$\u0017I\u001c8pi\u0006$\u0018n\u001c8t/&$\bn\\;u)\u0006\u0014x-\u001a;\u000b\u000f\t{w\u000e\\3b]*9r-\u001a;EKB\u0014XmY1uK\u0012\feN\\8uCRLwN\u001c\u0006\u0005!\u0006L'\u000f/\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0004\u0019\u0001)!\u0001B\u0001\t\u000b\u0015\u0019Aq\u0001E\u0005\u0019\u0001)!\u0001b\u0002\t\n\u0015\t\u0001RB\u0003\u0003\t\u0015Aq!\u0002\u0002\u0005\f!=QA\u0001\u0003\u0007\u0011!)1\u0001\"\u0004\t\r1\u0001QA\u0001C\u0001\u0011%)1\u0001b\u0004\t\u00121\u0001QA\u0001C\u0007\u0011\u0019)1\u0001\u0002\u0004\t\u00161\u0001QA\u0001\u0003\u0002\u00111)1\u0001b\u0005\t\u00181\u0001Qa\u0001C\u0002\u00115a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0003E\u000e\u0019\u0001)!\u0001\u0002\u0004\t\u0016\u0015\u0011A1\u0003E\f\u000b\t!\u0019\u0001C\u0007\u0006\u0005\u0011M\u0001\"C\u0003\u0004\t7Ay\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012E\u0003\u0004\t;A\u0001\u0003\u0004\u0001\u0006\u0005\u0011u\u0001\u0002E\u0003\u0003\t7Ay\"B\u0002\u0005\u0014!\u0011B\u0002A\u0003\u0003\t'A!#\u0002\u0002\u0005\u0003!=Qa\u0001C\u0012\u0011Oa\u0001!\u0002\u0002\u0005$!\u001dRa\u0001C\n\u0011Sa\u0001!\u0002\u0002\u0005\u0014!%Ra\u0001C\n\u0011Wa\u0001!\u0002\u0002\u0005\u0014!-Ra\u0001C\u000e\u0011]a\u0001!B\u0002\u0005\u0017!AB\u0002A\u0003\u0003\t7Aq#B\u0002\u0005\u0017!IB\u0002A\u0003\u0003\t-A\u0011\u0004B\u0002\r\u0006e\u0019Q!\u0001\u0005\u00041\riC\u0002B1\u00051\u0011\t3!B\u0001\t\ta!Qk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001E\u0005[;!\u0011\r\u0002M\u0006C\u0017)\u0011\u0001C\u0004\u0019\u000fE\u001b\u0011\u0001\u0002\u0005V\u0007\u0011)1\u0001b\u0003\n\u0003!EQF\u000b\u0003\u00021'iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001\u0005\n1%\u00016\u0001AO\b\t\u0001A1\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0002u=A\u0001\u0001E\r\u001b\r)\u0011\u0001#\u0006\u0019\u0016A\u001b\u0011!I\u0002\u0006\u0003!]\u0001tC)\u0004\u0013\u0011M\u0011\"\u0001\u0003\u0001\u001b\u0005AA\"D\u0001\t\u001a5\t\u0001\"D\u0017+\t\u0005Ab\"h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0001;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\u0005Qt\u0002\u0003\u0001\u0011=i1!B\u0001\t\u001daq\u0001kA\u0001\"\u0007\u0015\t\u0001b\u0004\r\u0010#\u000eIAAD\u0005\u0002\u0011?i\u0011\u0001\u0003\u0007\u000e\u0003!eQ\"\u0001\u0005\u0011[)\"1\u0001G\t\u001e\u0010\u0011\u0001\u00012E\u0007\u0004\u000b\u0005A\t\u0003'\tQ\u0007\u0001iz\u0001\u0002\u0001\t\u001a5\u0019Q!\u0001E\u000b1+\u00016\u0011AO\b\t\u0001A)#D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0003\u0005\u001aQ!\u0001E\f1/\t6!\u0003\u0003\u0012\u0013\u0005!\u0001!D\u0001\t#5\t\u0001\"D\u0007\u0002\u00111ic\u0003B\u0001\u0019'u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\u0001!\t\u0003\u0006\u0003!\u0011B\u0012\u0001\r\u0013#\u000e)AaE\u0005\u0002\u0011Ki\u0011\u0001\u0003\u0007.U\u0011Y\u0001\u0004FO\b\t\u0001A1\"D\u0002\u0006\u0003!\u0019\u0002d\u0005)\u0004\u0001u=A\u0001\u0001E\r\u001b\r)\u0011\u0001#\u0006\u0019\u0016A\u001b\t!h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0002C\r)\u0011\u0001c\u0006\u0019\u0018E\u001b\u0011\u0002\u0002\u000b\n\u0003\u0011\u0001Q\"\u0001E\u0014\u001b\u0005AQ\"D\u0001\t\u00195RCa\u0003\r\u0016;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u0001\u0002\u0006\r\u0015!\u000e\u0001Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\u0016aU\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0005\t3!B\u0001\t\u0018a]\u0011kA\u0005\u0005+%\tA\u0001A\u0007\u0002\u0011Si\u0011\u0001C\u0007\u000e\u0003!aQv\n\u0003\u0002+\r)\u0011\u0001\u0003\u0006\u0019\u0015a1R\u0014\u0003\u0003\u0002\u0011[iA!B\u0001\t+1\u0005\u0001$\u0006)\u0004\u0002u=A!\u0001E\u0018\u001b\r)\u0011\u0001c\u000b\u0019,A\u001b\u0011!\t\u0003\u0006\u0003!qA\u0012\u0001\r\u000f#\u000eIAAF\u0005\u0002\u0011Ai\u0011\u0001#\u0007\u000e\u0003!1R\"\u0001C\u0001[o!\u0011!F\u0002\u0006\u0003!Q\u0001D\u0003M\u0019C9)\u0011\u0001#\f\n\t%\u0019Q!\u0001\u0005\u000f19IA!C\u0002\u0006\u0003!Q\u0001D\u0003G\u00011[\t6!\u0002C\u0019\u0013\u0005Aq#D\u0001\t\u001aUbQa\u0003\u0003d\u0002a\u001d\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u0004\t\u000fI\u0011\u0001\u0002\u0001"})
public final class DeprecatedSymbolValidator
implements SymbolUsageValidator {
    public static final /* synthetic */ KClass $kotlinClass;
    private final FqName JAVA_DEPRECATED = new FqName(Deprecated.class.getName());
    private final TokenSet PROPERTY_SET_OPERATIONS = TokenSet.create(JetTokens.EQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ, JetTokens.PLUSPLUS, JetTokens.MINUSMINUS);

    static {
        $kotlinClass = Reflection.createKotlinClass(DeprecatedSymbolValidator.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateCall(@NotNull CallableDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated = this.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        } else if (targetDescriptor instanceof PropertyDescriptor) {
            this.propertyGetterWorkaround((PropertyDescriptor)targetDescriptor, trace, element);
        } else {
            this.checkDecapitalizedAnnotation(element, targetDescriptor, trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateTypeUsage(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        JetDelegatorToSuperCall superExpression;
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        JetAnnotationEntry annotationEntry = JetStubbedPsiUtil.getPsiOrStubParent(element, JetAnnotationEntry.class, true);
        if (annotationEntry != null) {
            JetConstructorCalleeExpression jetConstructorCalleeExpression = annotationEntry.getCalleeExpression();
            if (jetConstructorCalleeExpression == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual(jetConstructorCalleeExpression.getConstructorReferenceExpression(), element)) {
                return;
            }
        }
        if ((superExpression = JetStubbedPsiUtil.getPsiOrStubParent(element, JetDelegatorToSuperCall.class, true)) != null && Intrinsics.areEqual(superExpression.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated = this.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        } else {
            this.checkDecapitalizedAnnotation(element, targetDescriptor, trace);
        }
    }

    private final void checkDecapitalizedAnnotation(PsiElement element, DeclarationDescriptor targetDescriptor, BindingTrace trace) {
        DeclarationDescriptor declarationDescriptor = targetDescriptor;
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor instanceof ConstructorDescriptor ? (DeclarationDescriptor)((ConstructorDescriptor)targetDescriptor).getContainingDeclaration() : targetDescriptor;
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor2;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor effectiveTargetDescriptor = classDescriptor;
        FqNameUnsafe unsafeFqName = DescriptorUtilsKt.getFqNameUnsafe(effectiveTargetDescriptor);
        if (!unsafeFqName.isSafe()) {
            return;
        }
        JetSimpleNameExpression jetSimpleNameExpression = this.unwrapSimpleName(element);
        if (jetSimpleNameExpression == null) {
            return;
        }
        JetSimpleNameExpression simpleName = jetSimpleNameExpression;
        if (DecapitalizedAnnotationScopeKt.getDECAPITALIZED_DEPRECATED_ANNOTATIONS().contains(unsafeFqName.toSafe()) && DecapitalizedAnnotationScopeKt.getDECAPITALIZED_SHORT_NAMES().contains(simpleName.getReferencedName())) {
            trace.report(Errors.DEPRECATED_DECAPITALIZED_ANNOTATION.on((JetSimpleNameExpression)((PsiElement)simpleName), effectiveTargetDescriptor));
        }
    }

    private final JetSimpleNameExpression unwrapSimpleName(PsiElement element) {
        JetSimpleNameExpression jetSimpleNameExpression;
        PsiElement psiElement = element;
        if (psiElement instanceof JetConstructorCalleeExpression) {
            JetTypeReference jetTypeReference = ((JetConstructorCalleeExpression)element).getTypeReference();
            JetTypeElement jetTypeElement = jetTypeReference != null ? jetTypeReference.getTypeElement() : null;
            if (!(jetTypeElement instanceof JetUserType)) {
                jetTypeElement = null;
            }
            JetUserType jetUserType = (JetUserType)jetTypeElement;
            jetSimpleNameExpression = jetUserType != null ? jetUserType.getReferenceExpression() : null;
        } else {
            jetSimpleNameExpression = psiElement instanceof JetSimpleNameExpression ? (JetSimpleNameExpression)element : (JetSimpleNameExpression)null;
        }
        return jetSimpleNameExpression;
    }

    private final Pair<AnnotationDescriptor, DeclarationDescriptor> getDeprecatedAnnotation(DeclarationDescriptor $receiver) {
        AnnotationDescriptor ownAnnotation = DeprecatedSymbolValidator.getDeclaredDeprecatedAnnotation$default(this, $receiver, AnnotationUseSiteTarget.Companion.getAssociatedUseSiteTarget($receiver), false, 2);
        if (ownAnnotation != null) {
            return KotlinPackage.to(ownAnnotation, $receiver);
        }
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            AnnotationDescriptor classAnnotation = DeprecatedSymbolValidator.getDeclaredDeprecatedAnnotation$default(this, classDescriptor, null, false, 3);
            if (classAnnotation != null) {
                return KotlinPackage.to(classAnnotation, classDescriptor);
            }
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            AnnotationDescriptor classAnnotation;
            ClassDescriptor classDescriptor;
            AnnotationUseSiteTarget target;
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            AnnotationDescriptor accessorAnnotation = this.getDeclaredDeprecatedAnnotation(propertyDescriptor, target = $receiver instanceof PropertyGetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_GETTER : AnnotationUseSiteTarget.PROPERTY_SETTER, false);
            if (accessorAnnotation != null) {
                return KotlinPackage.to(accessorAnnotation, $receiver);
            }
            DeclarationDescriptor declarationDescriptor2 = ((PropertyAccessorDescriptor)$receiver).getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            if ((classDescriptor = (ClassDescriptor)declarationDescriptor2) != null && classDescriptor.isCompanionObject() && (classAnnotation = DeprecatedSymbolValidator.getDeclaredDeprecatedAnnotation$default(this, classDescriptor, null, false, 3)) != null) {
                return KotlinPackage.to(classAnnotation, classDescriptor);
            }
        }
        return null;
    }

    private final AnnotationDescriptor getDeclaredDeprecatedAnnotation(DeclarationDescriptor $receiver, AnnotationUseSiteTarget target, boolean findAnnotationsWithoutTarget) {
        if (findAnnotationsWithoutTarget) {
            AnnotationDescriptor annotations2;
            Annotations annotations3 = $receiver.getAnnotations();
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
            AnnotationDescriptor annotationDescriptor = annotations3.findAnnotation(fqName2);
            if (annotationDescriptor == null) {
                annotationDescriptor = annotations2 = $receiver.getAnnotations().findAnnotation(this.JAVA_DEPRECATED);
            }
            if (annotations2 != null) {
                return annotations2;
            }
        }
        if (target != null) {
            Annotations annotations4 = $receiver.getAnnotations();
            Intrinsics.checkExpressionValueIsNotNull(annotations4, "annotations");
            FqName fqName3 = KotlinBuiltIns.FQ_NAMES.deprecated;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "KotlinBuiltIns.FQ_NAMES.deprecated");
            AnnotationDescriptor annotationDescriptor = Annotations.Companion.findUseSiteTargetedAnnotation(annotations4, target, fqName3);
            if (annotationDescriptor == null) {
                Annotations annotations5 = $receiver.getAnnotations();
                Intrinsics.checkExpressionValueIsNotNull(annotations5, "annotations");
                annotationDescriptor = Annotations.Companion.findUseSiteTargetedAnnotation(annotations5, target, this.JAVA_DEPRECATED);
            }
            return annotationDescriptor;
        }
        return null;
    }

    static /* synthetic */ AnnotationDescriptor getDeclaredDeprecatedAnnotation$default(DeprecatedSymbolValidator deprecatedSymbolValidator, DeclarationDescriptor declarationDescriptor, AnnotationUseSiteTarget annotationUseSiteTarget, boolean bl, int n) {
        if ((n & 1) != 0) {
            annotationUseSiteTarget = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return deprecatedSymbolValidator.getDeclaredDeprecatedAnnotation(declarationDescriptor, annotationUseSiteTarget, bl);
    }

    private final Diagnostic createDeprecationDiagnostic(PsiElement element, DeclarationDescriptor descriptor, AnnotationDescriptor deprecated) {
        String message;
        Object object = AnnotationUtilKt.argumentValue(deprecated, "value");
        if (!(object instanceof String)) {
            object = null;
        }
        return (message = (String)object) == null ? Errors.DEPRECATED_SYMBOL.on(element, descriptor.getOriginal()) : Errors.DEPRECATED_SYMBOL_WITH_MESSAGE.on(element, descriptor.getOriginal(), message);
    }

    /*
     * WARNING - void declaration
     */
    public final void propertyGetterWorkaround(@NotNull PropertyDescriptor propertyDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement expression) {
        Unit unit;
        JetUnaryExpression unaryExpression;
        Object expr;
        IElementType operation;
        Intrinsics.checkParameterIsNotNull(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, JetBinaryExpression.class);
        if (binaryExpression != null) {
            JetExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression) && (operation = binaryExpression.getOperationToken()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
                return;
            }
            JetReferenceExpression[] jetReferenceExpressions = (JetReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, JetReferenceExpression.class);
            if (jetReferenceExpressions != null) {
                for (int i = 0; i < jetReferenceExpressions.length; ++i) {
                    IElementType operation2;
                    expr = jetReferenceExpressions[i];
                    if (!Intrinsics.areEqual(expr, expression) || (operation2 = binaryExpression.getOperationToken()) == null || !this.PROPERTY_SET_OPERATIONS.contains(operation2)) continue;
                    return;
                }
            }
        }
        if ((unaryExpression = PsiTreeUtil.getParentOfType(expression, JetUnaryExpression.class)) != null && (operation = unaryExpression.getOperationReference().getReferencedNameElementType()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
            return;
        }
        JetCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, JetCallableReferenceExpression.class);
        if (callableExpression != null && Intrinsics.areEqual(callableExpression.getCallableReference(), expression)) {
            return;
        }
        PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
        if (propertyGetterDescriptor != null) {
            void $receiver;
            expr = propertyGetterDescriptor;
            PropertyGetterDescriptor it = (PropertyGetterDescriptor)$receiver;
            CallableDescriptor callableDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "it");
            this.validateCall(callableDescriptor, trace, expression);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }
}

