/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.Collection;

public class CompilerPathsEx
extends CompilerPaths {
    public static void visitFiles(Collection<VirtualFile> directories, final FileVisitor visitor) {
        for (final VirtualFile outputDir : directories) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    String path2 = outputDir.getPath();
                    visitor.accept(outputDir, path2, path2);
                }
            });
        }
    }

    public static String[] getOutputPaths(Module[] modules) {
        OrderedSet outputPaths = new OrderedSet();
        for (Module module : modules) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension;
            CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension = !module.isDisposed() ? CompilerModuleExtension.getInstance(module) : null;
            if (compilerModuleExtension == null) continue;
            String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathUrl).replace('/', File.separatorChar));
            }
            if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) == null) continue;
            outputPaths.add(VirtualFileManager.extractPath(outputPathForTestsUrl).replace('/', File.separatorChar));
        }
        return ArrayUtil.toStringArray((Collection)outputPaths);
    }

    public static class FileVisitor {
        protected void accept(VirtualFile file, String fileRoot, String filePath) {
            if (file.isDirectory()) {
                this.acceptDirectory(file, fileRoot, filePath);
            } else {
                this.acceptFile(file, fileRoot, filePath);
            }
        }

        protected void acceptFile(VirtualFile file, String fileRoot, String filePath) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptDirectory(VirtualFile file, String fileRoot, String filePath) {
            VirtualFile[] children;
            ProgressManager.checkCanceled();
            for (VirtualFile child : children = file.getChildren()) {
                String _filePath;
                String name = child.getName();
                StringBuilder buf = StringBuilderSpinAllocator.alloc();
                try {
                    buf.append(filePath).append("/").append(name);
                    _filePath = buf.toString();
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                }
                this.accept(child, fileRoot, _filePath);
            }
        }
    }
}

