/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.gradle.api.Nullable;
import org.gradle.model.internal.type.ClassTypeWrapper;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.TypeWrapper;

class ParameterizedTypeWrapper
implements ParameterizedType,
TypeWrapper {
    private final TypeWrapper[] actualTypeArguments;
    private final ClassTypeWrapper rawType;
    private final TypeWrapper ownerType;
    private final int hashCode;

    public ParameterizedTypeWrapper(TypeWrapper[] actualTypeArguments, ClassTypeWrapper rawType, @Nullable TypeWrapper ownerType, int hashCode) {
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
        this.ownerType = ownerType;
        this.hashCode = hashCode;
    }

    public Type[] getActualTypeArguments() {
        return ModelType.unwrap(this.actualTypeArguments);
    }

    public Type getRawType() {
        return this.rawType.unwrap();
    }

    public Type getOwnerType() {
        return this.ownerType == null ? null : this.ownerType.unwrap();
    }

    public Type unwrap() {
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)o;
            if (this == that) {
                return true;
            }
            Type ownerType = this.getOwnerType();
            Type rawType = this.getRawType();
            Type thatOwner = that.getOwnerType();
            Type thatRawType = that.getRawType();
            return (ownerType == null ? thatOwner == null : ownerType.equals(thatOwner)) && (rawType == null ? thatRawType == null : rawType.equals(thatRawType)) && Arrays.equals(this.getActualTypeArguments(), that.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getRepresentation(true);
    }

    public String getRepresentation(boolean full) {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            sb.append(this.ownerType.getRepresentation(full));
            sb.append('.');
            sb.append(((Class)this.rawType.unwrap()).getSimpleName());
        } else {
            sb.append(this.rawType.getRepresentation(full));
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            sb.append("<");
            boolean first = true;
            for (TypeWrapper t : this.actualTypeArguments) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(t.getRepresentation(full));
                first = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }
}

